import React from "react";
import {
  BrowserRouter as Router,
  Switch,
  Route,
  Redirect
} from "react-router-dom";
import Home from '../container/Menu/Home'
import Login from '../container/Auth/Login'
import Register from '../container/Auth/Register'
import Screen404 from '../container/Auth/Screen404'
import ForgotPassword from '../container/Auth/ForgotPassword'
import ResetPassword from '../container/Auth/ResetPassword'
import SetPassword from '../container/Auth/SetPassword'
import EmailVerification from "../container/Auth/EmailVerification";
import Constant from "../library/Constant";
import ShadowScreen from "../container/ShadowScreen";
import Maintenance from "../container/Auth/Maintenance";
import MaintenanceMode from "../container/GeneralSetting/MaintenanceMode";

export default function BasicExample() {
  
  return (
    <Router basename={process.env.REACT_APP_URL_MAIN_FE}>
      <Switch>
        <Route exact path="/">
          <Redirect
            to={{
              pathname: "/home/beranda",
            }}
          />
        </Route>
        <Route path="/login" component={Login}/>
        <Route path="/forgot-password" component={ForgotPassword} />
        <Route path="/reset-password/:id" component={ResetPassword} />
        <Route path="/set-password/:id" component={SetPassword} />
        <Route path="/email-verification" component={EmailVerification} />
        <Route path="/register" component={Register}/>
        <Route path="/cronjob/:type" component={ShadowScreen}/>
        <Route path="/maintenance" component={Maintenance}/>
        <PrivateRoute path="/home">
          <Home/>
        </PrivateRoute>
        <Route path="*">
          <Screen404 />
        </Route>
      </Switch>
    </Router>
  );
}

function PrivateRoute({ children, ...rest }) {
  console.log(rest);
  const logged = localStorage.getItem(Constant.TOKEN) !== null ? true : false
  
  return (
    <Route
      {...rest}
      render={({ location }) =>
        logged ? (
          children
        ) : (
          <Redirect
            to={{
              pathname: "/login",
              state: { from: location }
            }}
          />
        )
      }
    />
  );
}