import React, { Component } from 'react';
import Images from '../../assets/Images';
import { Button, Typography } from '@material-ui/core';
import { Link } from 'react-router-dom';

class EmailVerification extends Component {
    constructor(props) {
        super(props)
        this.state = {
            username: ''
        }
    }

    componentDidMount() {

    }

    handleChange(e) {
      let data = this.state
      this.setState({...data, [e.target.name] : e.target.value})
    }
    
    render() {
        return (
          <div style={{ flex: 1, display: 'flex', backgroundColor: '#263b80', height: '100vh', justifyContent: 'center', alignItems: 'center' }}>
              <div style={{paddingTop: 20, paddingRight: 24, paddingLeft: 24, display: 'flex', flexDirection: 'column', width: 378, height: 300, borderRadius: 12, boxShadow: '0 2 4 0 rgba(0, 0, 0, 0.2)', backgroundColor: '#ffffff', justifyContent: 'center', alignItems: 'center' }}>
                <img src={Images.berhasil} />

                <Typography style={{textAlign: 'center', fontSize: 14, marginTop: 24, color: '#4b4b4b', fontFamily: 'Nunito Sans, sans-serif'}} >We sent a recovery link to you. Please check your email.</Typography>

                <Link to={{pathname: '/login'}} style={{textDecoration: 'none'}}>
                  <Button variant="contained" style={{ marginTop: 24, marginBottom: 20,  width: 250, height: 30, borderRadius: 4 , backgroundColor: '#51c6ea', color: '#ffffff'}}>
                    <Typography style={{fontSize: 12, fontFamily: 'Nunito Sans, sans-serif'}}>Back To Login</Typography>
                  </Button>
                </Link>
                
              </div>
          </div>
        );
      }
}

export default EmailVerification;