import React, { Component } from 'react';
import Images from '../../assets/Images';

class Maintenance extends Component {
    constructor(props) {
        super(props)
        this.state = {
            width: 0,
            height: 0
        }
    }

    getWindowDimensions() {
        const { innerWidth: width, innerHeight: height } = window;
        this.setState({
            width,
            height
        })
    }

    render() {
        return (
            <div style={{ flex: 1, display: 'flex' }}>
                <div style={{ width: '50%', display: 'grid' }}>
                    <img src={Images.meeting} style={{ objectFit: 'fill', width: '100%', height: '100%' }} alt={'TIA 4.0'}/>
                </div>
                <div style={{ width: '50%', height: '100vh', backgroundColor: '#4B0082', display: 'flex', justifyContent: 'center', alignItems: 'left', flexDirection: 'column', padding: '5vh'}}>
                    <p style={{fontSize: '1rem'}}>
                        <span style={{color: 'white', fontWeight:'bold'}}>
                            TIA 4.0 is down for Maintenance!<br/>
                            Thank you for your patience, we expect to be back shortly.<br/>
                            <br/>
                            We apologize for any inconvenience.<br/>
                            For more information, please contact our email : <a style={{color: 'white'}} href={'mailto:tia4.0@triputra-group.com'}>tia4.0@triputra-group.com</a>.
                        </span>
                    </p>
                </div>
            </div >
        );
    }
}

export default Maintenance;