import React, { Component } from 'react';
import Images from '../assets/Images';

export default class PopUpInformation extends Component {

    constructor(props) {
        super(props)
        this.state = {
            notes : false,
            notesMessage : ""
        }
    }
    namaJudul(){
        if (this.props.reportName == "MASTER_BUDGET"){
            return "Master Budget"
        } else if (this.props.reportName == "MONTHLY_REPORT"){
            return "Monthly Report"
        } else if (this.props.reportName == "OUTLOOK_Q1"){
            return "Outlook Q1"
        } else if (this.props.reportName == "OUTLOOK_Q2"){
            return "Outlook Q2"
        } else if (this.props.reportName == "OUTLOOK_Q3"){
            return "Outlook Q3"
        } else if (this.props.reportName == "OUTLOOK_PA"){
            return "Outlook PA"
        }
    }

    minValue(){
        if (this.props.reportName == "MASTER_BUDGET"){
            return "1 Jan 2023"
        } else if (this.props.reportName == "OUTLOOK_Q1"){
            return "1 Apr 2023"
        } else if (this.props.reportName == "OUTLOOK_Q2"){
            return "1 Jul 2023"
        } else if (this.props.reportName == "OUTLOOK_Q3"){
            return "1 Oct 2023"
        } else if (this.props.reportName == "OUTLOOK_PA"){
            return "1 Nov 2023"
        }
    }

    maxValue(){
        if (this.props.reportName == "MASTER_BUDGET"){
            return "31 Dec 2023"
        } else if (this.props.reportName == "OUTLOOK_Q1"){
            return "30 Apr 2023"
        } else if (this.props.reportName == "OUTLOOK_Q2"){
            return "30 Jul 2023"
        } else if (this.props.reportName == "OUTLOOK_Q3"){
            return "31 Oct 2023"
        } else if (this.props.reportName == "OUTLOOK_PA"){
            return "30 Nov 2023"
        }
    }

    componentDidMount(){
        if (this.props.reportName == "OUTLOOK_Q1"){
            this.setState({
                notes: true,
                notesMessage: "Q1 is until 7 Jun 2023;"
            })
        } else if (this.props.reportName == "OUTLOOK_Q2"){
            this.setState({
                notes: true,
                notesMessage: "Q2 is until 30 Aug 2023;"
            })
        } else if (this.props.reportName == "OUTLOOK_Q3"){
            this.setState({
                notes: true,
                notesMessage: "Q3 is until 30 Nov 2023;"
            })
        } else {
            this.setState({
                notes: false
            })
        }
    }

    reportName(){
        if (this.props.reportName == "MASTER_BUDGET"){
            return "Master Budget"
        } else if (this.props.reportName == "OUTLOOK_Q1"){
            return "Rolling Outlook"
        } else if (this.props.reportName == "OUTLOOK_Q2"){
            return "Rolling Outlook"
        } else if (this.props.reportName == "OUTLOOK_Q3"){
            return "Rolling Outlook"
        } else if (this.props.reportName == "OUTLOOK_PA"){
            return "Outlook PA"
        }
    }

    notesMessage (){
        return this.state.notesMessage
    }

    render() {
        if (this.props.reportName == "MONTHLY_REPORT"){
            return (
                <div className="test app-popup-show">
                    <div className="popup-content border-radius" style={{ background: '#FFF27D', borderRadius: 10, width: 530, height: 520 }}>
                        <div style={{ margin: 30 }}>
                            <div style={{ display: 'grid', justifyContent: 'center', marginTop: 20, paddingBottom: 20 }}>
                                <div style={{ justifyContent: 'center', fontSize: 20, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                    <b>Format max-min value</b> Monthly Report:
                                </div>
                            </div>
                            <div className="border-top grid grid-2x" >
                                <div className="column-1" style={{ alignSelf: 'center', width: 70 }}>
                                    <img src={Images.information}
                                         style={{
                                             resizeMode: 'repeat',
                                             height: 70,
                                             width: 70,
                                         }}/>
                                </div>
                                <div className="column-2" style={{ display: 'grid', justifyContent: 'center', marginTop: 20, marginLeft: 20, paddingBottom: 20, width: 400 }}>
                                    <div style={{ justifyContent: 'center', fontSize: 12, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                        Please enter the date in the following format: <b>'dd MMM YYYY.'</b>
                                    </div>
                                    <div style={{ justifyContent: 'center', fontSize: 12, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                        For example, 1 Jan 2023.
                                    </div>
                                    <div className="grid grid-3x" style={{marginTop: 10}}>
                                        <div className="column-1" style={{ justifyContent: 'center', fontSize: 14, width: 40, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Jan:
                                        </div>
                                        <div className="column-2" style={{ justifyContent: 'center', fontSize: 14, width: 175, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Min Value : 1 Jan 2023
                                        </div>
                                        <div className="column-3" style={{ justifyContent: 'center', fontSize: 14, width: 175, color: '#1D2995', paddingBottom: 5, fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Max Value : 31 Jan 2023
                                        </div>
                                    </div>
                                    <div className="grid grid-3x" >
                                        <div className="column-1" style={{ justifyContent: 'center', fontSize: 14, width: 40, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Feb:
                                        </div>
                                        <div className="column-2" style={{ justifyContent: 'center', fontSize: 14, width: 175, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Min Value : 1 Feb 2023
                                        </div>
                                        <div className="column-3" style={{ justifyContent: 'center', fontSize: 14, width: 175, color: '#1D2995', paddingBottom: 5, fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Max Value : 29 Feb 2023
                                        </div>
                                    </div>
                                    <div className="grid grid-3x" >
                                        <div className="column-1" style={{ justifyContent: 'center', fontSize: 14, width: 40, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Mar:
                                        </div>
                                        <div className="column-2" style={{ justifyContent: 'center', fontSize: 14, width: 175, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Min Value : 1 Mar 2023
                                        </div>
                                        <div className="column-3" style={{ justifyContent: 'center', fontSize: 14, width: 175, color: '#1D2995', paddingBottom: 5, fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Max Value : 31 Mar 2023
                                        </div>
                                    </div>
                                    <div className="grid grid-3x" >
                                        <div className="column-1" style={{ justifyContent: 'center', fontSize: 14, width: 40, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Apr:
                                        </div>
                                        <div className="column-2" style={{ justifyContent: 'center', fontSize: 14, width: 175, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Min Value : 1 Apr 2023
                                        </div>
                                        <div className="column-3" style={{ justifyContent: 'center', fontSize: 14, width: 175, color: '#1D2995', paddingBottom: 5, fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Max Value : 30 Apr 2023
                                        </div>
                                    </div>
                                    <div className="grid grid-3x" >
                                        <div className="column-1" style={{ justifyContent: 'center', fontSize: 14, width: 40, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                            May:
                                        </div>
                                        <div className="column-2" style={{ justifyContent: 'center', fontSize: 14, width: 175, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Min Value : 1 May 2023
                                        </div>
                                        <div className="column-3" style={{ justifyContent: 'center', fontSize: 14, width: 175, color: '#1D2995', paddingBottom: 5, fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Max Value : 31 May 2023
                                        </div>
                                    </div>
                                    <div className="grid grid-3x" >
                                        <div className="column-1" style={{ justifyContent: 'center', fontSize: 14, width: 40, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Jun:
                                        </div>
                                        <div className="column-2" style={{ justifyContent: 'center', fontSize: 14, width: 175, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Min Value : 1 Jun 2023
                                        </div>
                                        <div className="column-3" style={{ justifyContent: 'center', fontSize: 14, width: 175, color: '#1D2995', paddingBottom: 5, fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Max Value : 30 Jun 2023
                                        </div>
                                    </div>
                                    <div className="grid grid-3x" >
                                        <div className="column-1" style={{ justifyContent: 'center', fontSize: 14, width: 40, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Jul:
                                        </div>
                                        <div className="column-2" style={{ justifyContent: 'center', fontSize: 14, width: 175, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Min Value : 1 Jul 2023
                                        </div>
                                        <div className="column-3" style={{ justifyContent: 'center', fontSize: 14, width: 175, color: '#1D2995', paddingBottom: 5, fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Max Value : 31 Jul 2023
                                        </div>
                                    </div>
                                    <div className="grid grid-3x" >
                                        <div className="column-1" style={{ justifyContent: 'center', fontSize: 14, width: 40, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Aug:
                                        </div>
                                        <div className="column-2" style={{ justifyContent: 'center', fontSize: 14, width: 175, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Min Value : 1 Aug 2023
                                        </div>
                                        <div className="column-3" style={{ justifyContent: 'center', fontSize: 14, width: 175, color: '#1D2995', paddingBottom: 5, fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Max Value : 31 Aug 2023
                                        </div>
                                    </div>
                                    <div className="grid grid-3x" >
                                        <div className="column-1" style={{ justifyContent: 'center', fontSize: 14, width: 40, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Sep:
                                        </div>
                                        <div className="column-2" style={{ justifyContent: 'center', fontSize: 14, width: 175, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Min Value : 1 Sep 2023
                                        </div>
                                        <div className="column-3" style={{ justifyContent: 'center', fontSize: 14, width: 175, color: '#1D2995', paddingBottom: 5, fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Max Value : 30 Sep 2023
                                        </div>
                                    </div>
                                    <div className="grid grid-3x" >
                                        <div className="column-1" style={{ justifyContent: 'center', fontSize: 14, width: 40, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Oct:
                                        </div>
                                        <div className="column-2" style={{ justifyContent: 'center', fontSize: 14, width: 175, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Min Value : 1 Oct 2023
                                        </div>
                                        <div className="column-3" style={{ justifyContent: 'center', fontSize: 14, width: 175, color: '#1D2995', paddingBottom: 5, fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Max Value : 31 Oct 2023
                                        </div>
                                    </div>
                                    <div className="grid grid-3x" >
                                        <div className="column-1" style={{ justifyContent: 'center', fontSize: 14, width: 40, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Nov:
                                        </div>
                                        <div className="column-2" style={{ justifyContent: 'center', fontSize: 14, width: 175, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Min Value : 1 Nov 2023
                                        </div>
                                        <div className="column-3" style={{ justifyContent: 'center', fontSize: 14, width: 175, color: '#1D2995', paddingBottom: 5, fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Max Value : 30 Nov 2023
                                        </div>
                                    </div>
                                    <div className="grid grid-3x" >
                                        <div className="column-1" style={{ justifyContent: 'center', fontSize: 14, width: 40, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Dec:
                                        </div>
                                        <div className="column-2" style={{ justifyContent: 'center', fontSize: 14, width: 175, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Min Value : 1 Dec 2023
                                        </div>
                                        <div className="column-3" style={{ justifyContent: 'center', fontSize: 14, width: 175, color: '#1D2995', paddingBottom: 5, fontFamily: 'Nunito Sans, sans-serif' }}>
                                            Max Value : 31 Dec 2023
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div style={{ display: 'flex', justifyContent: 'flex-end', paddingRight: 20}}>
                                <button
                                    type="button"
                                    onClick={() => this.props.onClickClose()}
                                >
                                    <div style={{ width: 102, height: 30, border: 'solid 1px #354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                        <span style={{ color: '#354960', fontSize: 11 }}>Ok</span>
                                    </div>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            );
        }else {
            return (
                <div className="test app-popup-show">
                    <div className="popup-content border-radius" style={{ background: '#FFF27D', borderRadius: 10, width: 460, height: (this.props.reportName == "MASTER_BUDGET") || (this.props.reportName=="OUTLOOK_PA") ? 250 : 300 }}>
                        <div style={{ margin: 15 }}>
                            <div style={{ display: 'grid', justifyContent: 'center', marginTop: 20, paddingBottom: 20 }}>
                                <div style={{ justifyContent: 'center', fontSize: 20, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                    <b>Format max-min value</b> <span>{this.reportName()}</span> :
                                </div>
                            </div>
                            <div className="border-top grid grid-2x" >
                                <div className="column-1" style={{ alignSelf: 'center', width: 70 }}>
                                    <img src={Images.information}
                                         style={{
                                             resizeMode: 'repeat',
                                             height: 70,
                                             width: 70,
                                         }}/>
                                </div>
                                <div className="column-2" style={{ display: 'grid', justifyContent: 'center', marginTop: 20, paddingBottom: 20, width: 350 }}>
                                    <div style={{ justifyContent: 'center', fontSize: 12, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                        Please enter the date in the following format: <b>'dd MMM YYYY.'</b>
                                    </div>
                                    <div style={{ justifyContent: 'center', fontSize: 12, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                        For example, 1 Jan 2023.
                                    </div>
                                    <div style={{ justifyContent: 'center', fontSize: 14, marginTop: 10, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                        Min Value : <span>{this.minValue()}</span>
                                    </div>
                                    <div style={{ justifyContent: 'center', fontSize: 14, color: '#1D2995',  fontFamily: 'Nunito Sans, sans-serif' }}>
                                        Max Value : <span>{this.maxValue()}</span>
                                    </div>
                                    {this.state.notes &&
                                    <div style={{ justifyContent: 'center', fontSize: 12, color: '#1D2995', paddingTop: 5, fontFamily: 'Nunito Sans, sans-serif' }}>
                                        Note: The actual maximum value <span>{this.notesMessage()}</span>
                                    </div>
                                    }
                                    {this.state.notes &&
                                    <div style={{ justifyContent: 'center', fontSize: 12, color: '#1D2995', fontFamily: 'Nunito Sans, sans-serif' }}>
                                        however, you can select any date within this range for the rolling outlook.
                                    </div>
                                    }
                                </div>
                            </div>
                            <div style={{ display: 'flex', justifyContent: 'flex-end', paddingRight: 20}}>
                                <button
                                    type="button"
                                    onClick={() => this.props.onClickClose()}
                                >
                                    <div style={{ width: 102, height: 30, border: 'solid 1px #354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                        <span style={{ color: '#354960', fontSize: 11 }}>Ok</span>
                                    </div>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            );
        }
    }
}
