import { createMuiTheme, FormControlLabel, Snackbar, MuiThemeProvider, Paper, TableCell, Tooltip, Typography, withStyles } from '@material-ui/core'
import MUIDataTable from 'mui-datatables'
import React, { Component } from 'react'
import ReactTooltip from 'react-tooltip';
import Images from '../../assets/Images';
import api from '../../api';
import NumberFormat from 'react-number-format';
import { PropagateLoader } from 'react-spinners';
import UploadFile from "../../library/Upload";
import { ExcelRenderer } from 'react-excel-renderer';
import Constant from '../../library/Constant';
import * as R from 'ramda';
import { Alert } from '@material-ui/lab';
import { fixNumber } from '../../library/Utils';

const LightTooltip = withStyles((theme) => ({
    tooltip: {
        backgroundColor: theme.palette.common.white,
        color: 'rgba(0, 0, 0, 0.87)',
        boxShadow: theme.shadows[1],
        fontSize: 11,
    },
}))(Tooltip);

var ct = require("../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable3());

const options = ct.customOptionsFixedColumn();

const style = {
    position: "sticky",
    left: 0,
    zIndex: 101,
    background: "white",
};
const style2 = {
    position: "sticky",
    background: "white",
    zIndex: 100
};

export default class BalanceSheetRO extends Component {
    constructor(props) {
        super(props)
        this.state = {
            dataTable: [],
            loading: true,
            get_for: "view",
            viewOnly: true,
            updateBy: [],
            editable: false,
            handleDoubleClick: 0,
            saveDraft: true,
            minValue: 0,
            maxValue: 0,
            alert: false,
            tipeAlert: '',
            messageAlert: '',
            visibleUpload: false,
            visibleBSRO: true,
            kansas: 0,
            defaultCurrencyUpload: this.props.defaultCurrency,
            visibleAlertSave: false
        }
        this.fileHandler = this.fileHandler.bind(this);
    }

    componentDidMount() {
        console.log(this.props);
        // this.getItemHierarki()
        this.getLatestUpdate()
        this.getSettingControl()
        this.handleViewOnly()
    }

    handleViewOnly() {
        let checkApprover = false
        let checkLastStatus = false
        let checkStatus = false
        let checkPrevRev = false

        if (this.props.isApprover) {
            checkApprover = true
        } else {
            checkApprover = false
        }

        if (this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') {
            checkLastStatus = true
        } else {
            checkLastStatus = false
        }

        if (this.props.prevRevision) {
            checkPrevRev = true
        } else {
            checkPrevRev = false
        }

        if (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') {
            checkStatus = true
        } else {
            checkStatus = false
        }
        // console.log(this.props.isApprover);
        // console.log(this.props.lastStatus);
        // console.log(this.props.prevRevision);
        // console.log(this.props.status);

        // console.log(!checkApprover);
        // console.log(checkLastStatus);
        // console.log(checkStatus);
        // console.log(checkPrevRev);
        this.setState({ viewOnly: !checkApprover && checkLastStatus && checkStatus && checkPrevRev })
    }

    getSettingControl() {
        let body = {
            group: 'THRESHOLD_CONTROL',
            company_id: this.props.company.company_id,
            type: 'BALANCE_SHEET',
            currency_id: this.props.defaultCurrency.id,
        }

        api.create().getAllSettingByType(body).then(response => {
            console.log(response);
            if (response.data) {
                if (response.data.status === 'success') {
                    this.setState({
                        minValue: response.data.data[0] ? response.data.data[0].min_value : null,
                        maxValue: response.data.data[0] ? response.data.data[0].max_value : null,
                    }, () => {
                        this.getItemHierarki()
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    getLatestUpdate() {
        let payload = {
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "rolling_outlook_id": this.props.rollingOutlookID,
            "quartal": this.props.quarter
        }
        api.create().getRollingOutlookLastUpdate(payload).then(response => {
            console.log(response);
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        updateBy: response.data.data.detail === null ? [] : response.data.data.detail,
                        notes: response.data.data.notes_update === null ? "" : response.data.data.notes_update
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    getItemHierarki() {
        this.setState({ loading: true, judulColumn: null })
        let payload = {
            "company_id": this.props.company.company_id,
            "get_for": this.state.get_for,
            "months": 0,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "quartal": this.props.quarter,
            "rolling_outlook_id": this.props.rollingOutlookID,
            "currency_id": this.props.defaultCurrency.id
        }
        api.create().getRollingOutlookBS(payload).then(response => {
            // console.log(response);
            this.props.refresh()
            let dataTable = []
            if (response.data) {
                if (response.data.status == 'success') {
                    let res = response.data.data
                    const handlePushChild = (item) => {
                        let indexIDzz = dataTable.findIndex((val) => val[1] === item.id)
                        if (indexIDzz === -1) {
                            dataTable.push([
                                item.type_report_id,
                                item.id,
                                item.parent,
                                item.formula,
                                item.level,
                                item.description,
                                item.balance_sheet.total_last_year === "" ? "0" : item.balance_sheet.total_last_year,
                                this.props.status === 'CLOSED' ? Number(item.balance_sheet.january) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.balance_sheet.january, formula: item.balance_sheet.january_formula } : Number(item.balance_sheet.january),
                                this.props.status === 'CLOSED' ? Number(item.balance_sheet.february) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.balance_sheet.february, formula: item.balance_sheet.february_formula } : Number(item.balance_sheet.february),
                                this.props.status === 'CLOSED' ? Number(item.balance_sheet.march) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.balance_sheet.march, formula: item.balance_sheet.march_formula } : Number(item.balance_sheet.march),
                                this.props.status === 'CLOSED' ? Number(item.balance_sheet.april) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.balance_sheet.april, formula: item.balance_sheet.april_formula } : Number(item.balance_sheet.april),
                                this.props.status === 'CLOSED' ? Number(item.balance_sheet.may) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.balance_sheet.may, formula: item.balance_sheet.may_formula } : Number(item.balance_sheet.may),
                                this.props.status === 'CLOSED' ? Number(item.balance_sheet.june) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.balance_sheet.june, formula: item.balance_sheet.june_formula } : Number(item.balance_sheet.june),
                                this.props.status === 'CLOSED' ? Number(item.balance_sheet.july) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.balance_sheet.july, formula: item.balance_sheet.july_formula } : Number(item.balance_sheet.july),
                                this.props.status === 'CLOSED' ? Number(item.balance_sheet.august) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.balance_sheet.august, formula: item.balance_sheet.august_formula } : Number(item.balance_sheet.august),
                                this.props.status === 'CLOSED' ? Number(item.balance_sheet.september) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.balance_sheet.september, formula: item.balance_sheet.september_formula } : Number(item.balance_sheet.september),
                                this.props.status === 'CLOSED' ? Number(item.balance_sheet.october) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.balance_sheet.october, formula: item.balance_sheet.october_formula } : Number(item.balance_sheet.october),
                                this.props.status === 'CLOSED' ? Number(item.balance_sheet.november) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.balance_sheet.november, formula: item.balance_sheet.november_formula } : Number(item.balance_sheet.november),
                                this.props.status === 'CLOSED' ? Number(item.balance_sheet.december) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.balance_sheet.december, formula: item.balance_sheet.december_formula } : Number(item.balance_sheet.december),
                                item.balance_sheet.total_current_year === "" ? "0" : Number(item.balance_sheet.total_current_year),
                                item.order,
                                item.condition_it_should_be,
                                item.condition_if_wrong,
                                item.balance_sheet.forecast_formula == null ? [] : item.balance_sheet.forecast_formula
                            ])
                        }
                        if (item.children !== null) {
                            if (item.children.length > 0) {
                                item.children.map((items, indexs) => {
                                    handlePushChild(items)
                                })
                            }
                        }
                    }
                    res.map((item, index) => {
                        dataTable.push([
                            item.type_report_id,
                            item.id,
                            item.parent,
                            item.formula,
                            item.level,
                            item.description,
                            item.balance_sheet.total_last_year === "" ? "0" : item.balance_sheet.total_last_year,
                            this.props.status === 'CLOSED' ? Number(item.balance_sheet.january) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.balance_sheet.january, formula: item.balance_sheet.january_formula } : Number(item.balance_sheet.january),
                            this.props.status === 'CLOSED' ? Number(item.balance_sheet.february) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.balance_sheet.february, formula: item.balance_sheet.february_formula } : Number(item.balance_sheet.february),
                            this.props.status === 'CLOSED' ? Number(item.balance_sheet.march) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.balance_sheet.march, formula: item.balance_sheet.march_formula } : Number(item.balance_sheet.march),
                            this.props.status === 'CLOSED' ? Number(item.balance_sheet.april) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.balance_sheet.april, formula: item.balance_sheet.april_formula } : Number(item.balance_sheet.april),
                            this.props.status === 'CLOSED' ? Number(item.balance_sheet.may) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.balance_sheet.may, formula: item.balance_sheet.may_formula } : Number(item.balance_sheet.may),
                            this.props.status === 'CLOSED' ? Number(item.balance_sheet.june) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.balance_sheet.june, formula: item.balance_sheet.june_formula } : Number(item.balance_sheet.june),
                            this.props.status === 'CLOSED' ? Number(item.balance_sheet.july) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.balance_sheet.july, formula: item.balance_sheet.july_formula } : Number(item.balance_sheet.july),
                            this.props.status === 'CLOSED' ? Number(item.balance_sheet.august) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.balance_sheet.august, formula: item.balance_sheet.august_formula } : Number(item.balance_sheet.august),
                            this.props.status === 'CLOSED' ? Number(item.balance_sheet.september) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.balance_sheet.september, formula: item.balance_sheet.september_formula } : Number(item.balance_sheet.september),
                            this.props.status === 'CLOSED' ? Number(item.balance_sheet.october) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.balance_sheet.october, formula: item.balance_sheet.october_formula } : Number(item.balance_sheet.october),
                            this.props.status === 'CLOSED' ? Number(item.balance_sheet.november) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.balance_sheet.november, formula: item.balance_sheet.november_formula } : Number(item.balance_sheet.november),
                            this.props.status === 'CLOSED' ? Number(item.balance_sheet.december) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.balance_sheet.december, formula: item.balance_sheet.december_formula } : Number(item.balance_sheet.december),
                            item.balance_sheet.total_current_year === "" ? "0" : Number(item.balance_sheet.total_current_year),
                            item.order,
                            item.condition_it_should_be,
                            item.condition_if_wrong,
                            item.balance_sheet.forecast_formula == null ? [] : item.balance_sheet.forecast_formula
                        ])
                        if (item.children !== null) {
                            if (item.children.length > 0) {
                                item.children.map((items, indexs) => {
                                    handlePushChild(items)
                                })
                            }
                        }
                    })
                    // console.log(dataTable)
                    this.setState({ dataTable, loading: false, buttonError: true, editable: true })
                } else {
                    this.setState({ loading: false, alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ dataTable, loading: false, buttonError: true, editable: true })
            }
        })
    }

    downloadTemplate = async () => {
        // alert('Coming Soon ...')
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/balance_sheet/rolling_outlook/download_template?report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&quartal=${this.props.quarter}&&currency_id=${this.props.defaultCurrency.id}`
        )
        res = await res.blob()
        console.log(`${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/balance_sheet/rolling_outlook/download_template?report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&quartal=${this.props.quarter}&&currency_id=${this.props.defaultCurrency.id}`)
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Template Rolling Outlook Balance Sheet.xlsx';
            a.click();
        }
        setTimeout(() => {
            this.setState({ loading: false })
        }, 500);
    }

    async downloadAllData() {
        // alert('Coming Soon ...')
        let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/balance_sheet/rolling_outlook/export_rolling_outlook?rolling_outlook_id=${this.props.rollingOutlookID}&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}&&quartal=${this.props.quarter}`
        console.log(url);
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/balance_sheet/rolling_outlook/export_rolling_outlook?rolling_outlook_id=${this.props.rollingOutlookID === null ? "" : this.props.rollingOutlookID}&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}&&quartal=${this.props.quarter}`
        )
        res = await res.blob()
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Rolling Outlook Balance Sheet.xlsx';
            a.click();
        }
        setTimeout(() => {
            this.setState({ loading: false })
        }, 500);
    }

    handleGetFor(type) {
        console.log(type)
        this.setState({ get_for: type }, () => {
            // this.getSettingControl()
            this.getLatestUpdate()
            this.getItemHierarki()
        })
    }


    backToRollingOutlook(type) {
        this.setState({ loading: true })
        let data = []
        if (this.props.defaultCurrency.id == 2) {
            this.state.dataTable.map(i => {
                data.push({
                    "item_report_id": i[1],
                    "total_december_last_year": String(Number(i[6])),
                    "january": i[7].value !== undefined ? String(Number(i[7].value)) : String(Number(i[7])),
                    "february": i[8].value !== undefined ? String(Number(i[8].value)) : String(Number(i[8])),
                    "march": i[9].value !== undefined ? String(Number(i[9].value)) : String(Number(i[9])),
                    "april": i[10].value !== undefined ? String(Number(i[10].value)) : String(Number(i[10])),
                    "may": i[11].value !== undefined ? String(Number(i[11].value)) : String(Number(i[11])),
                    "june": i[12].value !== undefined ? String(Number(i[12].value)) : String(Number(i[12])),
                    "july": i[13].value !== undefined ? String(Number(i[13].value)) : String(Number(i[13])),
                    "august": i[14].value !== undefined ? String(Number(i[14].value)) : String(Number(i[14])),
                    "september": i[15].value !== undefined ? String(Number(i[15].value)) : String(Number(i[15])),
                    "october": i[16].value !== undefined ? String(Number(i[16].value)) : String(Number(i[16])),
                    "november": i[17].value !== undefined ? String(Number(i[17].value)) : String(Number(i[17])),
                    "december": i[18].value !== undefined ? String(Number(i[18].value)) : String(Number(i[18])),
                    "total_december_year": String(Number(i[19]))
                })
            })
        } else {
            this.state.dataTable.map(i => {
                data.push({
                    "item_report_id": i[1],
                    "total_december_last_year": String(fixNumber(Number(i[6]), 1)),
                    "january": i[7].value !== undefined ? String(fixNumber(Number(i[7].value), 1)) : String(fixNumber(Number(i[7]), 1)),
                    "february": i[8].value !== undefined ? String(fixNumber(Number(i[8].value), 1)) : String(fixNumber(Number(i[8]), 1)),
                    "march": i[9].value !== undefined ? String(fixNumber(Number(i[9].value), 1)) : String(fixNumber(Number(i[9]), 1)),
                    "april": i[10].value !== undefined ? String(fixNumber(Number(i[10].value), 1)) : String(fixNumber(Number(i[10]), 1)),
                    "may": i[11].value !== undefined ? String(fixNumber(Number(i[11].value), 1)) : String(fixNumber(Number(i[11]), 1)),
                    "june": i[12].value !== undefined ? String(fixNumber(Number(i[12].value), 1)) : String(fixNumber(Number(i[12]), 1)),
                    "july": i[13].value !== undefined ? String(fixNumber(Number(i[13].value), 1)) : String(fixNumber(Number(i[13]), 1)),
                    "august": i[14].value !== undefined ? String(fixNumber(Number(i[14].value), 1)) : String(fixNumber(Number(i[14]), 1)),
                    "september": i[15].value !== undefined ? String(fixNumber(Number(i[15].value), 1)) : String(fixNumber(Number(i[15]), 1)),
                    "october": i[16].value !== undefined ? String(fixNumber(Number(i[16].value), 1)) : String(fixNumber(Number(i[16]), 1)),
                    "november": i[17].value !== undefined ? String(fixNumber(Number(i[17].value), 1)) : String(fixNumber(Number(i[17]), 1)),
                    "december": i[18].value !== undefined ? String(fixNumber(Number(i[18].value), 1)) : String(fixNumber(Number(i[18]), 1)),
                    "total_december_year": String(fixNumber(Number(i[19]), 1))
                })
            })
        }

        let payload = {
            "rolling_outlook_id": this.props.rollingOutlookID,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "quartal": this.props.quarter,
            "status": type,
            "currency_id": this.props.defaultCurrency.id,
            "balance_sheet": data
        }
        console.log(payload);
        api.create('UPLOAD').createRollingOutlookBS(payload).then(response => {
            console.log(payload);
            console.log(response);
            // console.log(JSON.stringify(payload))
            if (response.data) {
                if (response.data.status === "success") {
                    if (type == 'submitted') {
                        this.props.onClickClose()
                        this.props.refresh('BS')
                        // let bodyRatioRO = {
                        //     "report": 'ratio',
                        //     "rollingOutlookId": this.props.rollingOutlookID,
                        //     "periode": this.props.periode,
                        //     "companyId": this.props.company.company_id,
                        //     "quartal": this.props.quarter
                        // }
                        // api.create().triggerRatioRO(bodyRatioRO).then((res) => {
                        //     console.log(res)
                        //     this.setState({ loading: false })
                        // })
                    } else {
                        this.props.onClickClose()
                        this.props.refresh()
                    }
                } else {
                    if (response.data?.message == "Please Set Up Rate Currency First") {
                        this.setState({ visibleAlertSave: true, loading: false })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false, handleDoubleClick: 0 }, () => {
                            document.body.style.overflow = 'unset';
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                            this.props.onClickClose()
                            this.props.refresh()
                        })
                    }
                }
                // else {
                //     this.setState({ loading: false, handleDoubleClick: 0 }, () => {
                //         // this.props.saveToMonthlyReport()
                //         this.props.onClickClose()
                //         this.props.refresh()
                //     })
                // } 
            } else {
                this.setState({ loading: false, handleDoubleClick: 0 })
            }
        })
    }
    handleValidate() {
        let err = false
        let kansas = this.state.kansas
        let dataTable = this.state.dataTable
        // console.log(this.state.dataTable)
        dataTable.map((i, index) => {
            if (String(i[5]) == "Control (should be nil)") {
                this.setState({ loading: true })
                let n = 0
                for (n = (this.props.quarter == 'q1' ? 10 : (this.props.quarter == 'q2' ? 13 : 16)); n <= 18; n++) {
                    if (this.props.defaultCurrency.id == 1) {
                        if ((fixNumber(Number(i[n]), 2) < Number(this.state.minValue) || fixNumber(Number(i[n]), 1) > Number(this.state.maxValue))) {
                            err = true
                        }
                    } else {
                        if ((Number(i[n]) < Number(this.state.minValue) || Number(i[n]) > Number(this.state.maxValue))) {
                            err = true
                        }
                    }

                }
            }
        })
        console.log(err)
        if (err === false) {
            this.setState({ loading: false, buttonError: false, editable: false, saveDraft: false })
            if (kansas == 0) {
                this.setState({ kansas: 1, loading: true }, () => {
                    this.handleValidate()
                })
            } else {
                this.setState({ kansas: 0 })
            }
        } else {
            this.setState({ loading: false, buttonError: true, editable: true, saveDraft: true })
            if (kansas == 0) {
                this.setState({ kansas: 1, loading: true }, () => {
                    this.handleValidate()
                })
            } else {
                this.setState({ kansas: 0 })
            }
        }
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    fileHandler = (event) => {
        let fileObj = event
        ExcelRenderer(fileObj, (err, resp) => {
            // console.log(resp)
            if (err) {
                console.log(err);
            }
            else {
                let isi = resp.rows.slice(3)
                console.log(isi);
                let payload = []
                let reg = /^[-+]?(?:[0-9]+,)*[0-9]+(?:\.[0-9]+)?$/;
                isi.map((i, index) => {
                    if (i.length > 0) {
                        payload.push({
                            orders: i[0] === undefined ? "" : String(i[0]).trim(),
                            item_report_id: i[1] === undefined ? "" : String(i[1]).trim(),
                            item_report: i[2] === undefined ? "" : String(i[2]).trim(),
                            "january": i[4] === undefined ? "0" : reg.test(String(i[4])) === false ? "0" : String(i[4]).trim(),
                            "february": i[5] === undefined ? "0" : reg.test(String(i[5])) === false ? "0" : String(i[5]).trim(),
                            "march": i[6] === undefined ? "0" : reg.test(String(i[6])) === false ? "0" : String(i[6]).trim(),
                            "april": i[7] === undefined ? "0" : reg.test(String(i[7])) === false ? "0" : String(i[7]).trim(),
                            "may": i[8] === undefined ? "0" : reg.test(String(i[8])) === false ? "0" : String(i[8]).trim(),
                            "june": i[9] === undefined ? "0" : reg.test(String(i[9])) === false ? "0" : String(i[9]).trim(),
                            "july": i[10] === undefined ? "0" : reg.test(String(i[10])) === false ? "0" : String(i[10]).trim(),
                            "august": i[11] === undefined ? "0" : reg.test(String(i[11])) === false ? "0" : String(i[11]).trim(),
                            "september": i[12] === undefined ? "0" : reg.test(String(i[12])) === false ? "0" : String(i[12]).trim(),
                            "october": i[13] === undefined ? "0" : reg.test(String(i[13])) === false ? "0" : String(i[13]).trim(),
                            "november": i[14] === undefined ? "0" : reg.test(String(i[14])) === false ? "0" : String(i[14]).trim(),
                            "december": i[15] === undefined ? "0" : reg.test(String(i[15])) === false ? "0" : String(i[15]).trim(),
                            "total_december_year": i[16] === undefined ? "0" : reg.test(String(i[16])) === false ? "0" : String(i[16]).trim(),
                        })
                    }
                })
                console.log(payload);
                let body = {
                    company_id: this.props.company.company_id,
                    periode: this.props.periode,
                    report_id: this.props.report_id,
                    balance_sheet: payload,
                    rolling_outlook_id: this.props.rollingOutlookID,
                    quartal: this.props.quarter,
                    status: 'submitted'
                }
                console.log(body)
                this.setState({ payload: body, judul: resp.rows[1][0], judulColumn: resp.rows[0][0] })
            }
        });
    }

    checkUpload() {
        let payload = {
            ...this.state.payload,
            currency_id: this.state.defaultCurrencyUpload?.id
        }
        api.create().checkImportRollingOutlookBS(payload).then(response => {
            this.props.refresh()
            if (response.data) {
                if (response.data.status === 'success') {
                    this.setState({ visibleUpload: false, visibleBSRO: false, loading: true })
                    let err = false
                    let dataTable = response.data.data.map((item, index) => {
                        // if (item.type_report_id === 3) {
                        //     if (item.mtd_vs_mb == "" &&  Number(item.percent_act_vs_mb) < this.state.minValue || Number(item.percent_act_vs_mb) > this.state.maxValue) {
                        //         err = true
                        //     }
                        // }
                        return [
                            item.type_report_id,
                            item.item_report_id,
                            item.parent,
                            item.formula,
                            item.level,
                            item.item_report,
                            item.total_december_last_year === "" ? "0" : item.total_december_last_year,
                            item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.january, formula: item.january_formula } : Number(item.january),
                            item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.february, formula: item.february_formula } : Number(item.february),
                            item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.march, formula: item.march_formula } : Number(item.march),
                            item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.april, formula: item.april_formula } : Number(item.april),
                            item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.may, formula: item.may_formula } : Number(item.may),
                            item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.june, formula: item.june_formula } : Number(item.june),
                            item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.july, formula: item.july_formula } : Number(item.july),
                            item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.august, formula: item.august_formula } : Number(item.august),
                            item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.september, formula: item.september_formula } : Number(item.september),
                            item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.october, formula: item.october_formula } : Number(item.october),
                            item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.november, formula: item.november_formula } : Number(item.november),
                            item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.december, formula: item.december_formula } : Number(item.december),
                            item.total_december_year === "" ? "0" : Number(item.total_december_year),
                            item.order,
                            item.condition_it_should_be,
                            item.condition_if_wrong,
                            item.forecast_formula == null ? [] : item.forecast_formula
                        ]
                    })
                    console.log(dataTable)
                    this.setState({ dataTable, dataLoaded: true, loading: false, buttonError: true, isUpload: true }, () => {
                        // this.state.dataTable.map(item => {
                        // if (item[24].length > 0) {
                        //     // console.log('masuk')
                        //     this.setState({ buttonError: true, errorPreview: true })
                        // }
                        // })
                        // console.log(this.state.buttonError)
                    })
                }
            }
        })
    }

    uploadBSRO(type) {
        let data = []
        if (this.state.defaultCurrencyUpload?.id == 2) {
            this.state.dataTable.map(i => {
                data.push({
                    "item_report_id": i[1],
                    "total_december_last_year": String(Number(i[6])),
                    "january": i[7].value !== undefined ? String(Number(i[7].value)) : String(Number(i[7])),
                    "february": i[8].value !== undefined ? String(Number(i[8].value)) : String(Number(i[8])),
                    "march": i[9].value !== undefined ? String(Number(i[9].value)) : String(Number(i[9])),
                    "april": i[10].value !== undefined ? String(Number(i[10].value)) : String(Number(i[10])),
                    "may": i[11].value !== undefined ? String(Number(i[11].value)) : String(Number(i[11])),
                    "june": i[12].value !== undefined ? String(Number(i[12].value)) : String(Number(i[12])),
                    "july": i[13].value !== undefined ? String(Number(i[13].value)) : String(Number(i[13])),
                    "august": i[14].value !== undefined ? String(Number(i[14].value)) : String(Number(i[14])),
                    "september": i[15].value !== undefined ? String(Number(i[15].value)) : String(Number(i[15])),
                    "october": i[16].value !== undefined ? String(Number(i[16].value)) : String(Number(i[16])),
                    "november": i[17].value !== undefined ? String(Number(i[17].value)) : String(Number(i[17])),
                    "december": i[18].value !== undefined ? String(Number(i[18].value)) : String(Number(i[18])),
                    "total_december_year": String(Number(i[19]))
                })
            })
        } else {
            this.state.dataTable.map(i => {
                data.push({
                    "item_report_id": i[1],
                    "total_december_last_year": String(fixNumber(Number(i[6]), 1)),
                    "january": i[7].value !== undefined ? String(fixNumber(Number(i[7].value), 1)) : String(fixNumber(Number(i[7]), 1)),
                    "february": i[8].value !== undefined ? String(fixNumber(Number(i[8].value), 1)) : String(fixNumber(Number(i[8]), 1)),
                    "march": i[9].value !== undefined ? String(fixNumber(Number(i[9].value), 1)) : String(fixNumber(Number(i[9]), 1)),
                    "april": i[10].value !== undefined ? String(fixNumber(Number(i[10].value), 1)) : String(fixNumber(Number(i[10]), 1)),
                    "may": i[11].value !== undefined ? String(fixNumber(Number(i[11].value), 1)) : String(fixNumber(Number(i[11]), 1)),
                    "june": i[12].value !== undefined ? String(fixNumber(Number(i[12].value), 1)) : String(fixNumber(Number(i[12]), 1)),
                    "july": i[13].value !== undefined ? String(fixNumber(Number(i[13].value), 1)) : String(fixNumber(Number(i[13]), 1)),
                    "august": i[14].value !== undefined ? String(fixNumber(Number(i[14].value), 1)) : String(fixNumber(Number(i[14]), 1)),
                    "september": i[15].value !== undefined ? String(fixNumber(Number(i[15].value), 1)) : String(fixNumber(Number(i[15]), 1)),
                    "october": i[16].value !== undefined ? String(fixNumber(Number(i[16].value), 1)) : String(fixNumber(Number(i[16]), 1)),
                    "november": i[17].value !== undefined ? String(fixNumber(Number(i[17].value), 1)) : String(fixNumber(Number(i[17]), 1)),
                    "december": i[18].value !== undefined ? String(fixNumber(Number(i[18].value), 1)) : String(fixNumber(Number(i[18]), 1)),
                    "total_december_year": String(fixNumber(Number(i[19]), 1))
                })
            })
        }

        let payload = {
            "rolling_outlook_id": this.props.rollingOutlookID,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "quartal": this.props.quarter,
            "status": type,
            "currency_id": this.state.defaultCurrencyUpload?.id,
            "balance_sheet": data
        }
        api.create('UPLOAD').importRollingOutlookBS(payload).then(response => {
            console.log(payload);
            console.log(response);
            // console.log(JSON.stringify(payload))
            if (response.data) {
                if (response.data.status === "success") {
                    if (type == 'submitted') {
                        this.props.onClickClose()
                        this.props.refresh('BS')
                        // let bodyRatioRO = {
                        //     "report": 'ratio',
                        //     "rollingOutlookId": this.props.rollingOutlookID,
                        //     "periode": this.props.periode,
                        //     "companyId": this.props.company.company_id,
                        //     "quartal": this.props.quarter
                        // }
                        // api.create().triggerRatioRO(bodyRatioRO).then((res) => {
                        //     console.log(res)
                        //     this.setState({ loading: false })
                        // })
                    } else {
                        this.props.onClickClose()
                        this.props.refresh()
                    }
                } else {
                    if (response.data?.message == "Please Set Up Rate Currency First") {
                        this.setState({ visibleAlertSave: true, loading: false })
                    } else {
                        this.setState({ loading: false, handleDoubleClick: 0 }, () => {
                            // this.props.saveToMonthlyReport()
                            this.props.onClickClose()
                            this.props.refresh()
                        })
                    }
                }
            } else {
                this.setState({ loading: false, handleDoubleClick: 0 })
            }
        })
    }

    render() {
        let dataTable2 = this.state.dataTable

        const handleChange = (value, tableMeta, type) => {
            let val = String(value).split(",").join("")
            if (type === "actual") {
                console.log('masuk')
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
            } else {
                console.log('masuk2')
                let indexParent = dataTable2.findIndex((val) => val[1] === dataTable2[tableMeta.rowIndex][2])
                if (indexParent > 0) {
                    // console.log(indexParent)
                    let a = 0
                    if (type == 'r/e') {
                        // console.log('masuk8')
                        a = dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].value = Number(val)
                    } else {
                        // console.log('masuk9')
                        a = dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
                    }
                    let jagain = dataTable2[indexParent][tableMeta.columnIndex]
                    a = dataTable2[indexParent][tableMeta.columnIndex] = jagain === undefined ? (0 + Number(val)) : Number(jagain + Number(val))
                    // if (this.props.defaultCurrency.id == 1) {
                    //     a = dataTable2[indexParent][tableMeta.columnIndex] = jagain === undefined ? fixNumber((0 + Number(val)), 1) : fixNumber(Number(jagain + Number(val)), 1)
                    // } else {

                    // }

                } else {
                    // console.log('masuk3')
                    if (type == 'r/e') {
                        // console.log('masuk4')
                        dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].value = Number(val)
                    } else {
                        // console.log('masuk5')
                        dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
                    }
                }
            }
        }

        const handleValue = (data) => {
            let total = 0
            dataTable2.map((item, index) => {
                if (data.rowData[1] === item[2]) {
                    let itemVal = item[data.columnIndex].value !== undefined ? Number(item[data.columnIndex].value) : Number(item[data.columnIndex])
                    total = item[data.columnIndex] === undefined ? Number(total) + 0 : Number(total) + itemVal
                }
            })
            //  if (data.rowData[5] === "Acc. Depreciation & Amortization" && data.columnIndex == 17) {
            //     console.log(total)
            // }
            let indexParent = dataTable2.findIndex((val) => val[1] === dataTable2[data.rowIndex][2])
            let a = dataTable2[data.rowIndex][data.columnIndex] = Number(total)
            // console.log(indexParent);
            return a
        }

        const handleValidation = (data, tableMeta) => {
            let a = handleValueFormula(data, tableMeta)
            return a
        }

        const handleTotal = (tableMeta) => {
            let total = 0
            tableMeta.rowData.map((item, index) => {
                if (String(tableMeta.rowData[5]).toLocaleLowerCase() == "r/e (cummulative)") {
                    total = String(Number(tableMeta.rowData[7]).toFixed(1))
                    dataTable2[tableMeta.rowIndex][19] = total
                } else if (String(tableMeta.rowData[5]).toLocaleLowerCase() == "profit (loss) mtd") {
                    if (index >= 7 && index <= 18) {
                        total += Number(item.value)
                    }
                } else if (index == 18) {
                    total = isNaN(item) ? Number(item.value) : Number(item)
                }
            })
            dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = total
            return total
        }

        const handleForecast = (tableMeta, periode, column) => {
            let total = 0
            // console.log(tableMeta.rowData)

            // console.log( dataTable2[tableMeta.rowIndex][23])
            // console.log(total)
            // dataTable2[tableMeta.rowIndex][column] = total
            if (column == 19 && String(tableMeta.rowData[5]).toLocaleLowerCase() == "r/e (cummulative)") {
                total = tableMeta.rowData[7].value
                dataTable2[tableMeta.rowIndex][column] = tableMeta.rowData[7].value
            } else {
                total = handleValueFormula(dataTable2[tableMeta.rowIndex][column], tableMeta, column, periode, dataTable2[tableMeta.rowIndex][23])
            }
            // console.log(total)
            return total
        }

        const handleValueFormula = (value, tableMeta, colIdx, periode, forecast) => {
            let splitFormula = String(tableMeta.rowData[3]).split(/([()@])/)
            let baru = []
            let anjay = []

            splitFormula.map((item, index) => {
                let items = String(item).substr(Number(String(item).length) - 1, 1)
                let re = /^[a-zA-Z0-9_]+$/;
                if (item !== "") {
                    if (!re.test(items)) {
                        if (String(item).substr(Number(String(item).length) - 1, 1) === ']') {
                            baru.push(String(item))
                        } else {
                            baru.push(String(item).substr(0, Number(String(item).length) - 1))
                            baru.push(String(item).substr(Number(String(item).length) - 1, 1))
                        }
                    } else {
                        baru.push(String(item))
                    }
                }
            })

            baru.map((item, index) => {
                if (item == '-' || item == '+' || item == '/' || item == '*') {
                    anjay.push(item)
                } else {
                    if (String(item).includes('#')) {
                        if (forecast !== undefined) {
                            let forecastt = 0
                            forecast.map((items, index) => {
                                if (items.periode == periode) {
                                    forecastt += Number(items.value)
                                }
                            })
                            anjay.push(forecastt)
                        } else if (String(item).includes('[M-1]')) {
                            let tst = String(item).replace('[M-1]', '')
                            let data = tableMeta.columnIndex == 7 ? 18 : tableMeta.columnIndex - 1
                            let period = data == 18 ? Number(this.props.periode) - 1 : this.props.periode
                            // console.log(tableMeta.columnIndex)
                            let indexID = tableMeta.rowData[data].formula.findIndex((val) => val.item_formula == String(`@${tst}`) && val.periode == period)
                            // console.log(indexID)
                            if (indexID !== -1) {
                                let valuezz = tableMeta.rowData[data].formula[indexID].value
                                // baru.push(valuezz)
                                anjay.push(valuezz == "" ? 0 : valuezz)
                                // console.log(valuezz)
                            }
                        } else {
                            let indexID = value.formula.findIndex((val) => val.item_formula == String(`@${item}`) && val.periode == Number(this.props.periode))
                            // console.log(indexID)
                            if (indexID !== -1) {
                                // console.log(value.formula[indexID].value)
                                let valuezz = value.formula[indexID].value
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            }
                        }
                    } else if (String(item).includes('[M-1]')) {
                        let tst = String(item).replace('[M-1]', '')
                        if (tableMeta.columnIndex === 7) {
                            let indexID = dataTable2.findIndex((val) => val[20] == tst)
                            if (indexID !== -1) {
                                let valuezz = dataTable2[indexID][6]
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            }
                        } else {
                            let data = tableMeta.columnIndex - 1
                            let indexID = dataTable2.findIndex((val) => val[20] == tst)
                            if (indexID !== -1) {
                                let valuezz = dataTable2[indexID][data].value !== undefined ? dataTable2[indexID][data].value : dataTable2[indexID][data]
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            }
                            // console.log(tst, data, tableMeta.rowData[data]);
                        }
                    } else {
                        let indexID = dataTable2.findIndex((val) => val[20] == item)
                        // console.log(dataTable2[indexID])
                        if (indexID !== -1) {
                            let valuezz = dataTable2[indexID][tableMeta.columnIndex].value == undefined ? dataTable2[indexID][tableMeta.columnIndex] : dataTable2[indexID][tableMeta.columnIndex].value
                            anjay.push(valuezz == "" ? 0 : valuezz)
                        } else {
                            if (item === '(-1)') {
                                anjay.push(-1)
                            }
                            // console.log(item);

                        }
                    }
                }
            })

            let total = 0
            let opt = ""
            anjay.map((item, index) => {
                if (item == "+") {
                    opt = "tambah"
                } else if (item == "-") {
                    opt = "kurang"
                } else if (item == "*") {
                    opt = "kali"
                } else if (item == "/") {
                    opt = "bagi"
                } else {
                    item = item == "" ? 0 : item
                    if (opt == "tambah") {
                        total = Number(total) + Number(item)
                    } else if (opt == "kurang") {
                        total = Number(total) - Number(item)
                    } else if (opt == "kali") {
                        total = Number(total) * Number(item)
                    } else if (opt == "bagi") {
                        total = Number(total) / Number(item) == NaN ? 0 : Number(total) / Number(item)
                    } else {
                        total += Number(item)
                    }
                }
            })
            total = R.equals(total, NaN) ? "0.0" : total
            // console.log(dataTable2[tableMeta.rowIndex][22])
            // console.log(tableMeta.rowData[5])
            // if (tableMeta.rowData[5] == 'R/E (Cummulative)' && tableMeta.columnIndex == 10) {
            //     console.log(baru)
            //     console.log(anjay)
            //     console.log(total)
            // }

            if (dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].value == undefined) {
                // console.log([tableMeta.rowIndex][tableMeta.columnIndex])
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = total
            } else {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].value = total
            }

            return total
        }
        let columns = [
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "Account",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 102, backgroundColor: '#1c71b8', width: 300, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style }),
                    customBodyRender: (val, tableMeta) => {
                        return (
                            <div style={{ width: 300 }}>
                                {tableMeta.rowData[0] === null ?
                                    tableMeta.rowData[4] == 0 ?
                                        <LightTooltip title={"Report Items Not Registered"} arrow>
                                            <span style={{ fontSize: 12, fontWeight: 'bold', color: 'red' }}>{String(val).toUpperCase()}</span>
                                        </LightTooltip> :
                                        <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                            <LightTooltip title={"Report Items Not Registered"} arrow>
                                                <span style={{ fontSize: 12, color: 'red' }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                            </LightTooltip>
                                        </div>
                                    :
                                    tableMeta.rowData[4] == 0 ?
                                        <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                        :
                                        <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                            <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                        </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: `31 Dec ${Number(this.props.periode) - 1} Actual`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(val), 1) : Number(val) == 0 ? "0.0" : Number(val)}
                                        />
                                        :
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(val), 1) : Number(val) == 0 ? "0.0" : Number(val)}
                                                    />
                                                }
                                            />
                                        </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: `Jan ${this.props.periode} Actual`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            value={fixNumber(Number(val.value == undefined ? val : val.value), 1) == 0 ? "0.0" : fixNumber(Number(val.value == undefined ? val : val.value), 1)}
                                        />
                                        :
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        // value={String(tableMeta.rowData[5]).toLocaleLowerCase() == "profit (loss) mtd" ? Number(val.value).toFixed(1) : Number(val).toFixed(1)}
                                                        value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(val.value == undefined ? val : val.value), 1) : Number(val.value == undefined ? val : val.value) == 0 ? "0.0" : Number(val.value == undefined ? val : val.value)}
                                                        disabled={true}
                                                    />
                                                }
                                            />
                                        </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: `Feb ${this.props.periode} Actual`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            // value={String(tableMeta.rowData[5]).toLocaleLowerCase() == "profit (loss) mtd" ? Number(val.value).toFixed(1) : Number(val).toFixed(1)}
                                            value={fixNumber(Number(val.value == undefined ? val : val.value), 1) == 0 ? "0.0" : fixNumber(Number(val.value == undefined ? val : val.value), 1)}
                                        />
                                        :
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        // value={String(tableMeta.rowData[5]).toLocaleLowerCase() == "profit (loss) mtd" ? Number(val.value).toFixed(1) : Number(val).toFixed(1)}
                                                        value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(val.value == undefined ? val : val.value), 1) : Number(val.value == undefined ? val : val.value) == 0 ? "0.0" : Number(val.value == undefined ? val : val.value)}
                                                        disabled={true}
                                                    />
                                                }
                                            />
                                        </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: `Mar ${this.props.periode} Actual`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            // value={String(tableMeta.rowData[5]).toLocaleLowerCase() == "profit (loss) mtd" ? Number(val.value).toFixed(1) : Number(val).toFixed(1)}
                                            value={fixNumber(Number(val.value == undefined ? val : val.value), 1) == 0 ? "0.0" : fixNumber(Number(val.value == undefined ? val : val.value), 1)}
                                        />
                                        :
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={val}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        // value={String(tableMeta.rowData[5]).toLocaleLowerCase() == "profit (loss) mtd" ? Number(val.value).toFixed(1) : Number(val).toFixed(1)}
                                                        value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(val.value == undefined ? val : val.value), 1) : Number(val.value == undefined ? val : val.value) == 0 ? "0.0" : Number(val.value == undefined ? val : val.value)}
                                                        disabled={true}
                                                    />
                                                }
                                            />
                                        </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: this.props.quarter == 'q2' || this.props.quarter == 'q3' ? `Apr ${this.props.periode} Actual` : `Apr ${this.props.periode}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            // value={String(tableMeta.rowData[5]).toLocaleLowerCase() == "profit (loss) mtd" ? Number(val.value).toFixed(1) : Number(val).toFixed(1)}
                                            value={fixNumber(Number(val.value == undefined ? val : val.value), 1) == 0 ? "0.0" : fixNumber(Number(val.value == undefined ? val : val.value), 1)}
                                        />
                                        :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValue(tableMeta)), 1) : Number(handleValue(tableMeta)) == 0 ? "0.0" : Number(handleValue(tableMeta))}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 3 ?
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.quarter == 'q1' ? "#5198ea" : '#555252', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                // disabled={this.props.isApprover? true : (this.state.get_for == 'view'? true : false)}
                                                                disabled={this.props.quarter == 'q1' ? false : true}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(val), 1) : Number(val) == 0 ? "0.0" : Number(val)}
                                                                // value={this.props.defaultCurrency.id == 1 ? (this.props.quarter == 'q2' || this.props.quarter == 'q3' ? (val == "" ? "" : fixNumber(Number(val), 1)) : fixNumber(Number(val), 1)) : (this.props.quarter == 'q2' || this.props.quarter == 'q3' ? (val == "" ? "" : Number(val) == 0 ? "0.0" : Number(val)) : Number(val) == 0 ? "0.0" : Number(val))}
                                                                onBlur={(event) => {
                                                                    handleChange(event.target.value, tableMeta)
                                                                }}
                                                            />
                                                        }
                                                    />
                                                </div> :
                                                tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.defaultCurrency.id == 1 ? (this.props.quarter == 'q2' || this.props.quarter == 'q3' ? (val == "" ? "" : Number(handleValueFormula(val, tableMeta)).toFixed(1)) : Number(handleValueFormula(val, tableMeta)).toFixed(1)) : (this.props.quarter == 'q2' || this.props.quarter == 'q3' ? (val == "" ? "" : Number(handleValueFormula(val, tableMeta)) == 0 ? "0.0" : Number(handleValueFormula(val, tableMeta))) : Number(handleValueFormula(val, tableMeta)) == 0 ? "0.0" : Number(handleValueFormula(val, tableMeta)))}
                                                                />
                                                            }
                                                        />
                                                    </div> :
                                                    tableMeta.rowData[0] === 7 ?
                                                        this.props.quarter === 'q2' || this.props.quarter === 'q3' ? null :
                                                            this.props.defaultCurrency.id == 1 ?
                                                                (fixNumber(Number(handleValidation(val, tableMeta)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValidation(val, tableMeta)), 1) <= Number(this.state.maxValue)) ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{
                                                                            fontSize: 12,
                                                                            textAlign: 'right',
                                                                            borderColor: 'transparent',
                                                                            margin: 0,
                                                                            width: 96,
                                                                            backgroundColor: 'transparent'
                                                                        }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValidation(val, tableMeta)), 1)}
                                                                    /> :
                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[21]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{
                                                                                fontSize: 12,
                                                                                textAlign: 'right',
                                                                                borderColor: 'transparent',
                                                                                margin: 0,
                                                                                width: 96,
                                                                                backgroundColor: 'transparent',
                                                                                color: 'red'
                                                                            }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValidation(val, tableMeta)), 1)}
                                                                        />
                                                                    </LightTooltip>
                                                                :
                                                                (Number(handleValidation(val, tableMeta)) >= Number(this.state.minValue) && Number(handleValidation(val, tableMeta)) <= Number(this.state.maxValue)) ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{
                                                                            fontSize: 12,
                                                                            textAlign: 'right',
                                                                            borderColor: 'transparent',
                                                                            margin: 0,
                                                                            width: 96,
                                                                            backgroundColor: 'transparent'
                                                                        }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={Number(handleValidation(val, tableMeta))}
                                                                    /> :
                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[21]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{
                                                                                fontSize: 12,
                                                                                textAlign: 'right',
                                                                                borderColor: 'transparent',
                                                                                margin: 0,
                                                                                width: 96,
                                                                                backgroundColor: 'transparent',
                                                                                color: 'red'
                                                                            }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={Number(handleValidation(val, tableMeta))}
                                                                        />
                                                                    </LightTooltip>
                                                        :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={val}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(val), 1) : Number(val) == 0 ? "0.0" : Number(val)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: this.props.quarter == 'q2' || this.props.quarter == 'q3' ? `May ${this.props.periode} Actual` : `May ${this.props.periode}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            // value={String(tableMeta.rowData[5]).toLocaleLowerCase() == "profit (loss) mtd" ? Number(val.value).toFixed(1) : Number(val).toFixed(1)}
                                            value={fixNumber(Number(val.value == undefined ? val : val.value), 1) == 0 ? "0.0" : fixNumber(Number(val.value == undefined ? val : val.value), 1)}
                                        />
                                        :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValue(tableMeta)), 1) : Number(handleValue(tableMeta)) == 0 ? "0.0" : Number(handleValue(tableMeta))}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 3 ?
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.quarter == 'q1' ? "#5198ea" : '#555252', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                // disabled={this.props.isApprover? true : (this.state.get_for == 'view'? true : false)}
                                                                disabled={this.props.quarter == 'q1' ? false : true}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(val), 1) : Number(val) == 0 ? "0.0" : Number(val)}
                                                                onBlur={(event) => {
                                                                    handleChange(event.target.value, tableMeta)
                                                                }}
                                                            />
                                                        }
                                                    />
                                                </div> :
                                                tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(val, tableMeta)), 1) : Number(handleValueFormula(val, tableMeta)) == 0 ? "0.0" : Number(handleValueFormula(val, tableMeta))}
                                                                />
                                                            }
                                                        />
                                                    </div> :
                                                    tableMeta.rowData[0] === 7 ?
                                                        this.props.quarter === 'q2' || this.props.quarter === 'q3' ? null :
                                                            this.props.defaultCurrency.id == 1 ?
                                                                (fixNumber(Number(handleValidation(val, tableMeta)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValidation(val, tableMeta)), 1) <= Number(this.state.maxValue)) ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{
                                                                            fontSize: 12,
                                                                            textAlign: 'right',
                                                                            borderColor: 'transparent',
                                                                            margin: 0,
                                                                            width: 96,
                                                                            backgroundColor: 'transparent'
                                                                        }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValidation(val, tableMeta)), 1)}
                                                                    /> :
                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[21]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{
                                                                                fontSize: 12,
                                                                                textAlign: 'right',
                                                                                borderColor: 'transparent',
                                                                                margin: 0,
                                                                                width: 96,
                                                                                backgroundColor: 'transparent',
                                                                                color: 'red'
                                                                            }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValidation(val, tableMeta)), 1)}
                                                                        />
                                                                    </LightTooltip>
                                                                :
                                                                (Number(handleValidation(val, tableMeta)) >= Number(this.state.minValue) && Number(handleValidation(val, tableMeta)) <= Number(this.state.maxValue)) ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{
                                                                            fontSize: 12,
                                                                            textAlign: 'right',
                                                                            borderColor: 'transparent',
                                                                            margin: 0,
                                                                            width: 96,
                                                                            backgroundColor: 'transparent'
                                                                        }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValidation(val, tableMeta)), 12)}
                                                                    /> :
                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[21]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{
                                                                                fontSize: 12,
                                                                                textAlign: 'right',
                                                                                borderColor: 'transparent',
                                                                                margin: 0,
                                                                                width: 96,
                                                                                backgroundColor: 'transparent',
                                                                                color: 'red'
                                                                            }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValidation(val, tableMeta)), 12)}
                                                                        />
                                                                    </LightTooltip>
                                                        :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={val}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(val), 1) : Number(val) == 0 ? "0.0" : Number(val)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: this.props.quarter == 'q2' || this.props.quarter == 'q3' ? `Jun ${this.props.periode} Actual` : `Jun ${this.props.periode}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            // value={String(tableMeta.rowData[5]).toLocaleLowerCase() == "profit (loss) mtd" ? Number(val.value).toFixed(1) : Number(val).toFixed(1)}
                                            value={fixNumber(Number(val.value == undefined ? val : val.value), 1) == 0 ? "0.0" : fixNumber(Number(val.value == undefined ? val : val.value), 1)}
                                        />
                                        :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValue(tableMeta)), 1) : Number(handleValue(tableMeta)) == 0 ? "0.0" : Number(handleValue(tableMeta))}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 3 ?
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.quarter == 'q1' ? "#5198ea" : '#555252', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                // disabled={this.props.isApprover? true : (this.state.get_for == 'view'? true : false)}
                                                                disabled={this.props.quarter == 'q1' ? false : true}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(val), 1) : Number(val) == 0 ? "0.0" : Number(val)}
                                                                onBlur={(event) => {
                                                                    handleChange(event.target.value, tableMeta)
                                                                }}
                                                            />
                                                        }
                                                    />
                                                </div> :
                                                tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(val, tableMeta)), 1) : Number(handleValueFormula(val, tableMeta)) == 0 ? "0.0" : Number(handleValueFormula(val, tableMeta))}
                                                                />
                                                            }
                                                        />
                                                    </div> :
                                                    tableMeta.rowData[0] === 7 ?
                                                        this.props.quarter === 'q2' || this.props.quarter === 'q3' ? null :
                                                            this.props.defaultCurrency.id == 1 ?
                                                                (fixNumber(Number(handleValidation(val, tableMeta)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValidation(val, tableMeta)), 1) <= Number(this.state.maxValue)) ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{
                                                                            fontSize: 12,
                                                                            textAlign: 'right',
                                                                            borderColor: 'transparent',
                                                                            margin: 0,
                                                                            width: 96,
                                                                            backgroundColor: 'transparent'
                                                                        }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValidation(val, tableMeta)), 1)}
                                                                    /> :
                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[21]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{
                                                                                fontSize: 12,
                                                                                textAlign: 'right',
                                                                                borderColor: 'transparent',
                                                                                margin: 0,
                                                                                width: 96,
                                                                                backgroundColor: 'transparent',
                                                                                color: 'red'
                                                                            }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValidation(val, tableMeta)), 1)}
                                                                        />
                                                                    </LightTooltip>
                                                                :
                                                                (Number(handleValidation(val, tableMeta)) >= Number(this.state.minValue) && Number(handleValidation(val, tableMeta)) <= Number(this.state.maxValue)) ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{
                                                                            fontSize: 12,
                                                                            textAlign: 'right',
                                                                            borderColor: 'transparent',
                                                                            margin: 0,
                                                                            width: 96,
                                                                            backgroundColor: 'transparent'
                                                                        }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValidation(val, tableMeta)), 12)}
                                                                    /> :
                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[21]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{
                                                                                fontSize: 12,
                                                                                textAlign: 'right',
                                                                                borderColor: 'transparent',
                                                                                margin: 0,
                                                                                width: 96,
                                                                                backgroundColor: 'transparent',
                                                                                color: 'red'
                                                                            }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValidation(val, tableMeta)), 12)}
                                                                        />
                                                                    </LightTooltip>
                                                        :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={val}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(val), 1) : Number(val) == 0 ? "0.0" : Number(val)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: this.props.quarter == 'q3' ? `Jul ${this.props.periode} Actual` : `Jul ${this.props.periode}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            // value={String(tableMeta.rowData[5]).toLocaleLowerCase() == "profit (loss) mtd" ? Number(val.value).toFixed(1) : Number(val).toFixed(1)}
                                            value={fixNumber(Number(val.value == undefined ? val : val.value), 1) == 0 ? "0.0" : fixNumber(Number(val.value == undefined ? val : val.value), 1)}
                                        />
                                        :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValue(tableMeta)), 1) : Number(handleValue(tableMeta)) == 0 ? "0.0" : Number(handleValue(tableMeta))}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 3 ?
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.quarter == 'q1' || this.props.quarter == 'q2' ? "#5198ea" : '#555252', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                // disabled={this.props.isApprover? true : (this.state.get_for == 'view'? true : false)}
                                                                disabled={this.props.quarter == 'q1' || this.props.quarter == 'q2' ? false : true}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(val), 1) : Number(val) == 0 ? "0.0" : Number(val)}
                                                                onBlur={(event) => {
                                                                    handleChange(event.target.value, tableMeta)
                                                                }}
                                                            />
                                                        }
                                                    />
                                                </div> :
                                                tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(val, tableMeta)), 1) : Number(handleValueFormula(val, tableMeta)) == 0 ? "0.0" : Number(handleValueFormula(val, tableMeta))}
                                                                />
                                                            }
                                                        />
                                                    </div> :
                                                    tableMeta.rowData[0] === 7 ?
                                                        this.props.quarter === 'q3' ? null :
                                                            this.props.defaultCurrency.id == 1 ?
                                                                (fixNumber(Number(handleValidation(val, tableMeta)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValidation(val, tableMeta)), 1) <= Number(this.state.maxValue)) ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{
                                                                            fontSize: 12,
                                                                            textAlign: 'right',
                                                                            borderColor: 'transparent',
                                                                            margin: 0,
                                                                            width: 96,
                                                                            backgroundColor: 'transparent'
                                                                        }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValidation(val, tableMeta)), 1)}
                                                                    /> :
                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[21]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{
                                                                                fontSize: 12,
                                                                                textAlign: 'right',
                                                                                borderColor: 'transparent',
                                                                                margin: 0,
                                                                                width: 96,
                                                                                backgroundColor: 'transparent',
                                                                                color: 'red'
                                                                            }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValidation(val, tableMeta)), 1)}
                                                                        />
                                                                    </LightTooltip>
                                                                :
                                                                (Number(handleValidation(val, tableMeta)) >= Number(this.state.minValue) && Number(handleValidation(val, tableMeta)) <= Number(this.state.maxValue)) ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{
                                                                            fontSize: 12,
                                                                            textAlign: 'right',
                                                                            borderColor: 'transparent',
                                                                            margin: 0,
                                                                            width: 96,
                                                                            backgroundColor: 'transparent'
                                                                        }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValidation(val, tableMeta)), 12)}
                                                                    /> :
                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[21]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{
                                                                                fontSize: 12,
                                                                                textAlign: 'right',
                                                                                borderColor: 'transparent',
                                                                                margin: 0,
                                                                                width: 96,
                                                                                backgroundColor: 'transparent',
                                                                                color: 'red'
                                                                            }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValidation(val, tableMeta)), 12)}
                                                                        />
                                                                    </LightTooltip>
                                                        :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={val}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(val), 1) : Number(val) == 0 ? "0.0" : Number(val)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: this.props.quarter == 'q3' ? `Aug ${this.props.periode} Actual` : `Aug ${this.props.periode}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            // value={String(tableMeta.rowData[5]).toLocaleLowerCase() == "profit (loss) mtd" ? Number(val.value).toFixed(1) : Number(val).toFixed(1)}
                                            value={fixNumber(Number(val.value == undefined ? val : val.value), 1) == 0 ? "0.0" : fixNumber(Number(val.value == undefined ? val : val.value), 1)}
                                        />
                                        :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValue(tableMeta)), 1) : Number(handleValue(tableMeta)) == 0 ? "0.0" : Number(handleValue(tableMeta))}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 3 ?
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.quarter == 'q1' || this.props.quarter == 'q2' ? "#5198ea" : '#555252', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                // disabled={this.props.isApprover? true : (this.state.get_for == 'view'? true : false)}
                                                                disabled={this.props.quarter == 'q1' || this.props.quarter == 'q2' ? false : true}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(val), 1) : Number(val) == 0 ? "0.0" : Number(val)}
                                                                onBlur={(event) => {
                                                                    handleChange(event.target.value, tableMeta)
                                                                }}
                                                            />
                                                        }
                                                    />
                                                </div> :
                                                tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(val, tableMeta)), 1) : Number(handleValueFormula(val, tableMeta)) == 0 ? "0.0" : Number(handleValueFormula(val, tableMeta))}
                                                                />
                                                            }
                                                        />
                                                    </div> :
                                                    tableMeta.rowData[0] === 7 ?
                                                        this.props.quarter === 'q3' ? null :
                                                            this.props.defaultCurrency.id == 1 ?
                                                                (fixNumber(Number(handleValidation(val, tableMeta)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValidation(val, tableMeta)), 1) <= Number(this.state.maxValue)) ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{
                                                                            fontSize: 12,
                                                                            textAlign: 'right',
                                                                            borderColor: 'transparent',
                                                                            margin: 0,
                                                                            width: 96,
                                                                            backgroundColor: 'transparent'
                                                                        }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValidation(val, tableMeta)), 1)}
                                                                    /> :
                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[21]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{
                                                                                fontSize: 12,
                                                                                textAlign: 'right',
                                                                                borderColor: 'transparent',
                                                                                margin: 0,
                                                                                width: 96,
                                                                                backgroundColor: 'transparent',
                                                                                color: 'red'
                                                                            }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValidation(val, tableMeta)), 1)}
                                                                        />
                                                                    </LightTooltip>
                                                                :
                                                                (Number(handleValidation(val, tableMeta)) >= Number(this.state.minValue) && Number(handleValidation(val, tableMeta)) <= Number(this.state.maxValue)) ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{
                                                                            fontSize: 12,
                                                                            textAlign: 'right',
                                                                            borderColor: 'transparent',
                                                                            margin: 0,
                                                                            width: 96,
                                                                            backgroundColor: 'transparent'
                                                                        }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValidation(val, tableMeta)), 12)}
                                                                    /> :
                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[21]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{
                                                                                fontSize: 12,
                                                                                textAlign: 'right',
                                                                                borderColor: 'transparent',
                                                                                margin: 0,
                                                                                width: 96,
                                                                                backgroundColor: 'transparent',
                                                                                color: 'red'
                                                                            }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValidation(val, tableMeta)), 12)}
                                                                        />
                                                                    </LightTooltip>
                                                        :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={val}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(val), 1) : Number(val) == 0 ? "0.0" : Number(val)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: this.props.quarter == 'q3' ? `Sep ${this.props.periode} Actual` : `Sep ${this.props.periode}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            // value={String(tableMeta.rowData[5]).toLocaleLowerCase() == "profit (loss) mtd" ? Number(val.value).toFixed(1) : Number(val).toFixed(1)}
                                            value={fixNumber(Number(val.value == undefined ? val : val.value), 1) == 0 ? "0.0" : fixNumber(Number(val.value == undefined ? val : val.value), 1)}
                                        />
                                        :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValue(tableMeta)), 1) : Number(handleValue(tableMeta)) == 0 ? "0.0" : Number(handleValue(tableMeta))}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 3 ?
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: this.props.quarter == 'q1' || this.props.quarter == 'q2' ? "#5198ea" : '#555252', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                // disabled={this.props.isApprover? true : (this.state.get_for == 'view'? true : false)}
                                                                disabled={this.props.quarter == 'q1' || this.props.quarter == 'q2' ? false : true}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(val), 1) : Number(val) == 0 ? "0.0" : Number(val)}
                                                                onBlur={(event) => {
                                                                    handleChange(event.target.value, tableMeta)
                                                                }}
                                                            />
                                                        }
                                                    />
                                                </div> :
                                                tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(val, tableMeta)), 1) : Number(handleValueFormula(val, tableMeta)) == 0 ? "0.0" : Number(handleValueFormula(val, tableMeta))}
                                                                />
                                                            }
                                                        />
                                                    </div> :
                                                    tableMeta.rowData[0] === 7 ?
                                                        this.props.quarter === 'q3' ? null :
                                                            this.props.defaultCurrency.id == 1 ?
                                                                (fixNumber(Number(handleValidation(val, tableMeta)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValidation(val, tableMeta)), 1) <= Number(this.state.maxValue)) ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{
                                                                            fontSize: 12,
                                                                            textAlign: 'right',
                                                                            borderColor: 'transparent',
                                                                            margin: 0,
                                                                            width: 96,
                                                                            backgroundColor: 'transparent'
                                                                        }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValidation(val, tableMeta)), 1)}
                                                                    /> :
                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[21]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{
                                                                                fontSize: 12,
                                                                                textAlign: 'right',
                                                                                borderColor: 'transparent',
                                                                                margin: 0,
                                                                                width: 96,
                                                                                backgroundColor: 'transparent',
                                                                                color: 'red'
                                                                            }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValidation(val, tableMeta)), 1)}
                                                                        />
                                                                    </LightTooltip>
                                                                :
                                                                (Number(handleValidation(val, tableMeta)) >= Number(this.state.minValue) && Number(handleValidation(val, tableMeta)) <= Number(this.state.maxValue)) ?
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{
                                                                            fontSize: 12,
                                                                            textAlign: 'right',
                                                                            borderColor: 'transparent',
                                                                            margin: 0,
                                                                            width: 96,
                                                                            backgroundColor: 'transparent'
                                                                        }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValidation(val, tableMeta)), 12)}
                                                                    /> :
                                                                    <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[21]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                        <NumberFormat
                                                                            thousandSeparator={true}
                                                                            style={{
                                                                                fontSize: 12,
                                                                                textAlign: 'right',
                                                                                borderColor: 'transparent',
                                                                                margin: 0,
                                                                                width: 96,
                                                                                backgroundColor: 'transparent',
                                                                                color: 'red'
                                                                            }}
                                                                            type="text"
                                                                            placeholder=""
                                                                            disabled={true}
                                                                            value={fixNumber(Number(handleValidation(val, tableMeta)), 12)}
                                                                        />
                                                                    </LightTooltip>
                                                        :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={val}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(val), 1) : Number(val) == 0 ? "0.0" : Number(val)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: `Oct ${this.props.periode}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            // value={String(tableMeta.rowData[5]).toLocaleLowerCase() == "profit (loss) mtd" ? Number(val.value).toFixed(1) : Number(val).toFixed(1)}
                                            value={fixNumber(Number(val.value == undefined ? val : val.value), 1) == 0 ? "0.0" : fixNumber(Number(val.value == undefined ? val : val.value), 1)}
                                        />
                                        :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValue(tableMeta)), 1) : Number(handleValue(tableMeta)) == 0 ? "0.0" : Number(handleValue(tableMeta))}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 3 ?
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                // disabled={this.props.isApprover? true : (this.state.get_for == 'view'? true : false)}
                                                                disabled={false}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(val), 1) : Number(val) == 0 ? "0.0" : Number(val)}
                                                                onBlur={(event) => {
                                                                    handleChange(event.target.value, tableMeta)
                                                                }}
                                                            />
                                                        }
                                                    />
                                                </div> :
                                                tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(val, tableMeta)), 1) : Number(handleValueFormula(val, tableMeta)) == 0 ? "0.0" : Number(handleValueFormula(val, tableMeta))}
                                                                />
                                                            }
                                                        />
                                                    </div> :
                                                    tableMeta.rowData[0] === 7 ?
                                                        this.props.defaultCurrency.id == 1 ?
                                                            (fixNumber(Number(handleValidation(val, tableMeta)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValidation(val, tableMeta)), 1) <= Number(this.state.maxValue)) ?
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{
                                                                        fontSize: 12,
                                                                        textAlign: 'right',
                                                                        borderColor: 'transparent',
                                                                        margin: 0,
                                                                        width: 96,
                                                                        backgroundColor: 'transparent'
                                                                    }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={fixNumber(Number(handleValidation(val, tableMeta)), 1)}
                                                                /> :
                                                                <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[21]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{
                                                                            fontSize: 12,
                                                                            textAlign: 'right',
                                                                            borderColor: 'transparent',
                                                                            margin: 0,
                                                                            width: 96,
                                                                            backgroundColor: 'transparent',
                                                                            color: 'red'
                                                                        }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValidation(val, tableMeta)), 1)}
                                                                    />
                                                                </LightTooltip>
                                                            :
                                                            (Number(handleValidation(val, tableMeta)) >= Number(this.state.minValue) && Number(handleValidation(val, tableMeta)) <= Number(this.state.maxValue)) ?
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{
                                                                        fontSize: 12,
                                                                        textAlign: 'right',
                                                                        borderColor: 'transparent',
                                                                        margin: 0,
                                                                        width: 96,
                                                                        backgroundColor: 'transparent'
                                                                    }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={fixNumber(Number(handleValidation(val, tableMeta)), 12)}
                                                                /> :
                                                                <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[21]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{
                                                                            fontSize: 12,
                                                                            textAlign: 'right',
                                                                            borderColor: 'transparent',
                                                                            margin: 0,
                                                                            width: 96,
                                                                            backgroundColor: 'transparent',
                                                                            color: 'red'
                                                                        }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValidation(val, tableMeta)), 12)}
                                                                    />
                                                                </LightTooltip>
                                                        :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={val}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(val), 1) : Number(val) == 0 ? "0.0" : Number(val)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: `Nov ${this.props.periode}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            // value={String(tableMeta.rowData[5]).toLocaleLowerCase() == "profit (loss) mtd" ? Number(val.value).toFixed(1) : Number(val).toFixed(1)}
                                            value={fixNumber(Number(val.value == undefined ? val : val.value), 1) == 0 ? "0.0" : fixNumber(Number(val.value == undefined ? val : val.value), 1)}
                                        />
                                        :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValue(tableMeta)), 1) : Number(handleValue(tableMeta)) == 0 ? "0.0" : Number(handleValue(tableMeta))}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 3 ?
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                // disabled={this.props.isApprover? true : (this.state.get_for == 'view'? true : false)}
                                                                disabled={false}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(val), 1) : Number(val) == 0 ? "0.0" : Number(val)}
                                                                onBlur={(event) => {
                                                                    handleChange(event.target.value, tableMeta)
                                                                }}
                                                            />
                                                        }
                                                    />
                                                </div> :
                                                tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(val, tableMeta)), 1) : Number(handleValueFormula(val, tableMeta)) == 0 ? "0.0" : Number(handleValueFormula(val, tableMeta))}
                                                                />
                                                            }
                                                        />
                                                    </div> :
                                                    tableMeta.rowData[0] === 7 ?
                                                        this.props.defaultCurrency.id == 1 ?
                                                            (fixNumber(Number(handleValidation(val, tableMeta)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValidation(val, tableMeta)), 1) <= Number(this.state.maxValue)) ?
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{
                                                                        fontSize: 12,
                                                                        textAlign: 'right',
                                                                        borderColor: 'transparent',
                                                                        margin: 0,
                                                                        width: 96,
                                                                        backgroundColor: 'transparent'
                                                                    }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={fixNumber(Number(handleValidation(val, tableMeta)), 1)}
                                                                /> :
                                                                <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[21]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{
                                                                            fontSize: 12,
                                                                            textAlign: 'right',
                                                                            borderColor: 'transparent',
                                                                            margin: 0,
                                                                            width: 96,
                                                                            backgroundColor: 'transparent',
                                                                            color: 'red'
                                                                        }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValidation(val, tableMeta)), 1)}
                                                                    />
                                                                </LightTooltip>
                                                            :
                                                            (Number(handleValidation(val, tableMeta)) >= Number(this.state.minValue) && Number(handleValidation(val, tableMeta)) <= Number(this.state.maxValue)) ?
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{
                                                                        fontSize: 12,
                                                                        textAlign: 'right',
                                                                        borderColor: 'transparent',
                                                                        margin: 0,
                                                                        width: 96,
                                                                        backgroundColor: 'transparent'
                                                                    }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={fixNumber(Number(handleValidation(val, tableMeta)), 12)}
                                                                /> :
                                                                <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[21]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{
                                                                            fontSize: 12,
                                                                            textAlign: 'right',
                                                                            borderColor: 'transparent',
                                                                            margin: 0,
                                                                            width: 96,
                                                                            backgroundColor: 'transparent',
                                                                            color: 'red'
                                                                        }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValidation(val, tableMeta)), 12)}
                                                                    />
                                                                </LightTooltip>
                                                        :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={val}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(val), 1) : Number(val) == 0 ? "0.0" : Number(val)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: `Dec ${this.props.periode}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            // value={String(tableMeta.rowData[5]).toLocaleLowerCase() == "profit (loss) mtd" ? Number(val.value).toFixed(1) : Number(val).toFixed(1)}
                                            value={fixNumber(Number(val.value == undefined ? val : val.value), 1) == 0 ? "0.0" : fixNumber(Number(val.value == undefined ? val : val.value), 1)}
                                        />
                                        :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValue(tableMeta)), 1) : Number(handleValue(tableMeta)) == 0 ? "0.0" : Number(handleValue(tableMeta))}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 3 ?
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                // disabled={this.props.isApprover? true : (this.state.get_for == 'view'? true : false)}
                                                                disabled={false}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(val), 1) : Number(val) == 0 ? "0.0" : Number(val)}
                                                                onBlur={(event) => {
                                                                    handleChange(event.target.value, tableMeta)
                                                                }}
                                                            />
                                                        }
                                                    />
                                                </div> :
                                                tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(val, tableMeta)), 1) : Number(handleValueFormula(val, tableMeta)) == 0 ? "0.0" : Number(handleValueFormula(val, tableMeta))}
                                                                />
                                                            }
                                                        />
                                                    </div> :
                                                    tableMeta.rowData[0] === 7 ?
                                                        this.props.defaultCurrency.id == 1 ?
                                                            (fixNumber(Number(handleValidation(val, tableMeta)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValidation(val, tableMeta)), 1) <= Number(this.state.maxValue)) ?
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{
                                                                        fontSize: 12,
                                                                        textAlign: 'right',
                                                                        borderColor: 'transparent',
                                                                        margin: 0,
                                                                        width: 96,
                                                                        backgroundColor: 'transparent'
                                                                    }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={fixNumber(Number(handleValidation(val, tableMeta)), 1)}
                                                                /> :
                                                                <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[21]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{
                                                                            fontSize: 12,
                                                                            textAlign: 'right',
                                                                            borderColor: 'transparent',
                                                                            margin: 0,
                                                                            width: 96,
                                                                            backgroundColor: 'transparent',
                                                                            color: 'red'
                                                                        }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValidation(val, tableMeta)), 1)}
                                                                    />
                                                                </LightTooltip>
                                                            :
                                                            (Number(handleValidation(val, tableMeta)) >= Number(this.state.minValue) && Number(handleValidation(val, tableMeta)) <= Number(this.state.maxValue)) ?
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{
                                                                        fontSize: 12,
                                                                        textAlign: 'right',
                                                                        borderColor: 'transparent',
                                                                        margin: 0,
                                                                        width: 96,
                                                                        backgroundColor: 'transparent'
                                                                    }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={fixNumber(Number(handleValidation(val, tableMeta)), 12)}
                                                                /> :
                                                                <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[21]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{
                                                                            fontSize: 12,
                                                                            textAlign: 'right',
                                                                            borderColor: 'transparent',
                                                                            margin: 0,
                                                                            width: 96,
                                                                            backgroundColor: 'transparent',
                                                                            color: 'red'
                                                                        }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValidation(val, tableMeta)), 12)}
                                                                    />
                                                                </LightTooltip>
                                                        :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={val}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(val), 1) : Number(val) == 0 ? "0.0" : Number(val)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: `31 Dec ${this.props.periode} Total Outlook`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderRight: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                    null :
                                    this.state.get_for == 'view' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            disabled={true}
                                            value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(val), 1) : Number(val) == 0 ? "0.0" : fixNumber(Number(val), 1)}
                                        />
                                        :
                                        tableMeta.rowData[0] === 2 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValue(tableMeta)), 1) : Number(handleValue(tableMeta)) == 0 ? "0.0" : Number(handleValue(tableMeta))}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 3 ?
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={val}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                // disabled={this.props.isApprover? true : (this.state.get_for == 'view'? true : false)}
                                                                disabled={false}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(val), 1) : Number(val) == 0 ? "0.0" : Number(val)}
                                                                onBlur={(event) => {
                                                                    handleChange(event.target.value, tableMeta)
                                                                }}
                                                            />
                                                        }
                                                    />
                                                </div> :
                                                tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={val}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.defaultCurrency.id == 1 ? (fixNumber(Number(handleForecast(tableMeta, `${Number(this.props.periode)}`, 19)), 1)) : (Number(handleForecast(tableMeta, `${Number(this.props.periode)}`, 19)) == 0 ? "0.0" : Number(handleForecast(tableMeta, `${Number(this.props.periode)}`, 19)))}
                                                                // value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(val), 1) : Number(val) == 0 ? "0.0" : Number(val)}
                                                                />
                                                            }
                                                        />
                                                    </div> :
                                                    tableMeta.rowData[0] === 7 ?
                                                        this.props.defaultCurrency.id == 1 ?
                                                            (fixNumber(Number(handleValidation(val, tableMeta)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValidation(val, tableMeta)), 1) <= Number(this.state.maxValue)) ?
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{
                                                                        fontSize: 12,
                                                                        textAlign: 'right',
                                                                        borderColor: 'transparent',
                                                                        margin: 0,
                                                                        width: 96,
                                                                        backgroundColor: 'transparent'
                                                                    }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={fixNumber(Number(handleValidation(val, tableMeta)), 1)}
                                                                /> :
                                                                <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[21]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{
                                                                            fontSize: 12,
                                                                            textAlign: 'right',
                                                                            borderColor: 'transparent',
                                                                            margin: 0,
                                                                            width: 96,
                                                                            backgroundColor: 'transparent',
                                                                            color: 'red'
                                                                        }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValidation(val, tableMeta)), 1)}
                                                                    />
                                                                </LightTooltip>
                                                            :
                                                            (Number(handleValidation(val, tableMeta)) >= Number(this.state.minValue) && Number(handleValidation(val, tableMeta)) <= Number(this.state.maxValue)) ?
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{
                                                                        fontSize: 12,
                                                                        textAlign: 'right',
                                                                        borderColor: 'transparent',
                                                                        margin: 0,
                                                                        width: 96,
                                                                        backgroundColor: 'transparent'
                                                                    }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={fixNumber(Number(handleValidation(val, tableMeta)), 12)}
                                                                /> :
                                                                <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[21]}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{
                                                                            fontSize: 12,
                                                                            textAlign: 'right',
                                                                            borderColor: 'transparent',
                                                                            margin: 0,
                                                                            width: 96,
                                                                            backgroundColor: 'transparent',
                                                                            color: 'red'
                                                                        }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={fixNumber(Number(handleValidation(val, tableMeta)), 12)}
                                                                    />
                                                                </LightTooltip>
                                                        :
                                                        <div style={{ flex: 1 }}>
                                                            <FormControlLabel
                                                                style={{ margin: 0 }}
                                                                value={val}
                                                                control={
                                                                    <NumberFormat
                                                                        thousandSeparator={true}
                                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                        type="text"
                                                                        placeholder=""
                                                                        disabled={true}
                                                                        value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(val), 1) : Number(val) == 0 ? "0.0" : Number(val)}
                                                                    />
                                                                }
                                                            />
                                                        </div>
                                }
                            </div>
                        )
                    }
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            }
        ]

        const loadingComponent = (
            <div style={{ position: 'fixed', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)' }}>
                <PropagateLoader
                    // css={override}
                    size={20}
                    color={"#274B80"}
                    loading={this.state.loading}
                />
            </div>
        );

        return (
            <div style={{ height: this.props.height, backgroundColor: '#f8f8f8', marginBottom: 100, minHeight: 1000 }}>
                {this.state.loading && loadingComponent}
                <div className={"main-color"} style={{ height: 78, flex: 1, display: 'flex', alignItems: 'center', paddingLeft: 20 }}>
                    <Typography style={{ fontSize: '16px', color: 'white' }}>Rolling Outlook & Revision CAT</Typography>
                </div>
                <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                    <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                        {this.state.messageAlert}
                    </Alert>
                </Snackbar>
                <div style={{ flex: 1, padding: 20, width: '100%' }}>
                    {this.state.visibleBSRO ? <Paper style={{ paddingTop: 10, paddingBottom: 20 }}>
                        <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                            <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Rolling Outlook - Balance Sheet</Typography>
                        </div>
                        <div style={{ padding: 20 }}>
                            <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                                <div>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {this.props.periode} {String(this.props.quarter).toLocaleUpperCase()} (rev.{this.props.revision})</Typography>
                                    {this.props.defaultCurrency.id === 1 ?
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                        :
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in USD thousand</Typography>
                                    }
                                </div>
                                <div style={{ width: '50%' }}>
                                    {this.props.isApprover === true || this.state.get_for == 'view' ?
                                        null
                                        // <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                        //     <a data-tip={'Download'} data-for="download">
                                        //         <button
                                        //             style={{
                                        //                 backgroundColor: 'transparent',
                                        //                 cursor: 'pointer',
                                        //                 borderColor: 'transparent',
                                        //                 margin: 5
                                        //             }}
                                        //             onClick={() =>
                                        //                 this.setState({ loading: true }, () => {
                                        //                     this.downloadAllData()
                                        //                 })}
                                        //         >
                                        //             <img src={Images.download} />
                                        //         </button>
                                        //     </a>
                                        //     <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" />
                                        // </div>
                                        :
                                        <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                            <a data-tip={'Download Template'} data-for="template">
                                                <button
                                                    style={{
                                                        backgroundColor: 'transparent',
                                                        cursor: 'pointer',
                                                        borderColor: 'transparent',
                                                        margin: 5
                                                    }}
                                                    onClick={() => this.setState({ loading: true }, () => {
                                                        this.downloadTemplate()
                                                    })}
                                                >
                                                    <img src={Images.template} />
                                                </button>
                                            </a>
                                            <ReactTooltip border={true} id="template" place="bottom" type="light" effect="solid" />
                                            <a data-tip={'Upload'} data-for="upload">
                                                <button
                                                    style={{
                                                        backgroundColor: 'transparent',
                                                        cursor: 'pointer',
                                                        borderColor: 'transparent',
                                                        margin: 5
                                                    }}
                                                    onClick={() => this.setState({ loading: true }, () => {
                                                        setTimeout(() => {
                                                            this.setState({
                                                                loading: false,
                                                                visibleUpload: true
                                                            })
                                                        }, 300);
                                                    })}
                                                >
                                                    <img src={Images.upload} />
                                                </button>
                                            </a>
                                            <ReactTooltip border={true} id="upload" place="bottom" type="light" effect="solid" />
                                            {/* <a data-tip={'Download'} data-for="download">
                                                <button
                                                    style={{
                                                        backgroundColor: 'transparent',
                                                        cursor: 'pointer',
                                                        borderColor: 'transparent',
                                                        margin: 5
                                                    }}
                                                    onClick={() =>
                                                        this.setState({ loading: true }, () => {
                                                            setTimeout(() => {
                                                                this.downloadAllData()
                                                            }, 100);
                                                        })}
                                                >
                                                    <img src={Images.download} />
                                                </button>
                                            </a>
                                            <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" /> */}
                                        </div>
                                    }
                                </div>
                            </div>

                            <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                {!this.state.loading && (
                                    <MuiThemeProvider theme={getMuiTheme()}>
                                        <MUIDataTable
                                            data={dataTable2}
                                            columns={columns}
                                            options={options}
                                        />
                                    </MuiThemeProvider>
                                )}
                            </div>

                            <div style={{ display: 'flex' }}>
                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 20 }}>Last Updated by : </Typography>
                                <div style={{ marginLeft: 10, overflowY: 'scroll', height: this.state.updateBy.length < 2 ? 25 : 75, marginTop: 10 }}>
                                    {
                                        this.state.updateBy.length > 0 ? this.state.updateBy.reverse().map((item, index) => {
                                            return (
                                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>{item.latest_update}</Typography>
                                            )
                                        }) :
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>-</Typography>
                                    }
                                </div>
                            </div>
                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Notes : {this.state.notes}</Typography>

                        </div>
                        <div className="grid grid-2x" style={{ padding: 20 }}>
                            <div className="col-1" style={{ paddingLeft: 0 }}>
                                <button
                                    type="button"
                                    onClick={() => this.setState({ loading: true }, () => {
                                        setTimeout(() => {
                                            this.props.onClickClose()
                                        }, 100);
                                    })}
                                    style={{
                                        backgroundColor: 'transparent',
                                        cursor: 'pointer',
                                        borderColor: 'transparent',
                                        outline: 'none',
                                    }}
                                >
                                    <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                        <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                    </div>
                                </button>
                            </div>
                            {this.props.isApprover === true ?
                                <div className="col-2">
                                </div> :
                                <div className="" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%', paddingRight: 5 }}>
                                    {this.state.get_for == 'view' && this.state.viewOnly &&
                                        <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                // marginRight: 20
                                            }}
                                            onClick={() => {
                                                this.setState({ loading: true }, () => {
                                                    this.handleGetFor('edit')
                                                })
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Edit</Typography>
                                            </div>
                                        </button>
                                    }
                                    {this.state.get_for == 'edit' && <button
                                        className="button"
                                        type="button"
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none',
                                            marginRight: 20
                                        }}
                                        onClick={() => {
                                            this.setState({ loading: true, dataTable: dataTable2 }, () => {
                                                setTimeout(() => {
                                                    this.handleValidate()
                                                }, 100);
                                            })
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                            <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                        </div>
                                    </button>}
                                    {this.state.get_for === 'edit' && <button
                                        className="button"
                                        type="button"
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none',
                                            marginRight: 20
                                        }}
                                        onClick={() =>
                                            this.state.saveDraft ?
                                                this.setState({ alert: true, messageAlert: 'Data Incomplete !', tipeAlert: 'error' })
                                                :
                                                this.state.handleDoubleClick == 1 ? null :
                                                    this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                        this.backToRollingOutlook('draft')
                                                    })
                                        }
                                    >
                                        <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                        </div>
                                    </button>}
                                    {this.state.get_for === 'edit' && <button
                                        type="button"
                                        // disabled={this.state.buttonError}
                                        onClick={() =>
                                            this.state.buttonError ?
                                                this.setState({ alert: true, messageAlert: 'Data incomplete !', tipeAlert: 'error' })
                                                :
                                                this.state.handleDoubleClick == 1 ? null :
                                                    this.setState({ handleDoubleClick: 1 }, () => {
                                                        this.backToRollingOutlook('submitted')
                                                    })}
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none',
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                        </div>
                                    </button>}
                                </div>
                            }
                        </div>
                    </Paper> :
                        <Paper style={{ paddingTop: 10, paddingBottom: 20 }}>
                            <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                                <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Rolling Outlook - Balance Sheet</Typography>
                            </div>
                            <div style={{ padding: 20 }}>
                                <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                                    <div>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {this.props.periode} {String(this.props.quarter).toLocaleUpperCase()} (rev.{this.props.revision})</Typography>
                                        {this.props.defaultCurrency.id === 1 ?
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                            :
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in USD thousand</Typography>
                                        }
                                    </div>
                                    <div style={{ width: '50%' }} />
                                    {/* </div> */}
                                </div>

                                <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                    {!this.state.loading && (
                                        <MuiThemeProvider theme={getMuiTheme()}>
                                            <MUIDataTable
                                                data={dataTable2}
                                                columns={columns}
                                                options={options}
                                            />
                                        </MuiThemeProvider>
                                    )}
                                </div>

                            </div>
                            <div className="grid grid-2x" style={{ padding: 20 }}>
                                <div className="col-1" style={{ paddingLeft: 0 }}>
                                    <button
                                        type="button"
                                        onClick={() => this.setState({ loading: true }, () => {
                                            setTimeout(() => {
                                                this.setState({ visibleBSRO: true, visibleUpload: false }, () => {
                                                    this.handleGetFor('edit')
                                                })
                                            }, 100);
                                        })}
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none',
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                        </div>
                                    </button>
                                </div>
                                {this.props.isApprover === true ?
                                    <div className="col-2">
                                    </div> :
                                    <div className="" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%', paddingRight: 5 }}>
                                        {this.state.get_for == 'edit' && <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() => {
                                                this.setState({ loading: true, dataTable: dataTable2 }, () => {
                                                    setTimeout(() => {
                                                        this.handleValidate()
                                                    }, 100);
                                                })
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                            </div>
                                        </button>}
                                        {this.state.get_for === 'edit' && <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() =>
                                                this.state.saveDraft ?
                                                    this.setState({ alert: true, messageAlert: 'Data Incomplete !', tipeAlert: 'error' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                            this.uploadBSRO('draft')
                                                        })
                                            }
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                            </div>
                                        </button>}
                                        {this.state.get_for === 'edit' && <button
                                            type="button"
                                            // disabled={this.state.buttonError}
                                            onClick={() =>
                                                this.state.buttonError ?
                                                    this.setState({ alert: true, messageAlert: 'Data incomplete !', tipeAlert: 'error' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1 }, () => {
                                                            this.uploadBSRO('submitted')
                                                        })}
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                            </div>
                                        </button>}
                                    </div>
                                }
                            </div>
                        </Paper>}
                </div>
                {this.state.visibleUpload && (
                    <div className="test app-popup-show">
                        <div className="popup-content background-white border-radius" style={{ borderRadius: 8, width: 679 }}>
                            <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                    <div className="popup-title">
                                        <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Upload File</span>
                                    </div>
                                </div>
                                <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        className="btn btn-circle btn-white"
                                        onClick={() => this.setState({ visibleUpload: false })}
                                    >
                                        <img src={Images.close} />
                                    </button>
                                </div>
                            </div>
                            <div style={{ padding: '25px 30px' }}>
                                <UploadFile
                                    type={this.state.uploadStatus}
                                    percentage={this.state.percentage}
                                    result={this.state.result}
                                    acceptedFiles={["xlsx"]}
                                    onHandle={(dt) => {
                                        this.fileHandler(dt)
                                        this.setState({ uploadStatus: 'idle', percentage: '0' })
                                    }}
                                    onUpload={() => {
                                        String(this.state.judulColumn).includes("TEMPLATE") && String(this.state.judulColumn).includes("UPLOAD") && String(this.state.judul).includes("ROLLING") && String(this.state.judul).includes("OUTLOOK") && String(this.state.judul).includes("BALANCE") && String(this.state.judul).includes("SHEET") ?
                                            this.checkUpload() :
                                            this.setState({ alert: true, messageAlert: "Invalid Template", tipeAlert: 'warning' })
                                    }}
                                />
                            </div>
                            <div style={{ padding: '0px 30px 29px', fontSize: 17, color: 'red' }}><b>Warning:</b> Valid currency for uploading data in <b>{this.props.defaultCurrency.id == 1 ? "IDR mn" : "thousand USD"}</b></div>
                        </div>
                    </div>
                )}

                {this.state.visibleAlertSave && (
                    <div className="test app-popup-show">
                        <div className="popup-content border-radius" style={{ background: '#FFF27D', borderRadius: 10, width: 715, height: 238 }}>
                            <div style={{ margin: 30 }}>
                                <div style={{ display: 'flex', marginTop: 76, marginBottom: 43 }}>
                                    <div style={{ alignSelf: 'center', marginRight: 25 }}>
                                        <img src={Images.warning} />
                                    </div>
                                    <div style={{ justifyContent: 'center', fontSize: 20, color: '#1D2995', marginTop: 10 }}>
                                        <b>Rate Currency USD</b> pada periode yang dipilih <b>belum</b> diatur.<br /> Silahkan menghubungi Superadmin
                                    </div>
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'flex-end' }}>
                                    <button
                                        className="button"
                                        type="button"
                                        style={{
                                            background: '#F6F7F9',
                                            cursor: 'pointer',
                                            border: '1px solid #3549609e',
                                            outline: 'none',
                                            marginRight: 20,
                                            borderRadius: 9
                                        }}
                                        onClick={() => this.setState({ visibleAlertSave: false, handleDoubleClick: 0, loading: false })}
                                    >
                                        <div style={{ backgroundColor: '#fff', width: 105, height: 30, borderRadius: 9, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #3549609e' }}>
                                            <Typography style={{ fontSize: '15px', color: '#354960', textAlign: 'center' }}>Close</Typography>
                                        </div>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                )}
            </div>
        )
    }
}
