import React, { Component } from 'react';
import Images from '../../assets/Images';
import { TextField, InputAdornment, Button, Typography, IconButton, Snackbar } from '@material-ui/core';
import Visibility from '@material-ui/icons/Visibility';
import VisibilityOff from '@material-ui/icons/VisibilityOff';
import MuiAlert from '@material-ui/lab/Alert';
import { withStyles } from '@material-ui/core/styles';
import api from '../../api';

const Alert = withStyles({
})((props) => <MuiAlert elevation={6} variant="filled" {...props} />);

class ResetPassword extends Component {
  constructor(props) {
    super(props)
    this.state = {
      password: '',
      confirmPassword: '',
      showPass: false,
      showPass2: false,
      errorPassword: false,
      errorConfirmPassword: false,
      msgPassword: 'Consists of 8 Characters with a Combination of Numbers',
      msgConfirmPassword: 'Consists of 8 Characters with a Combination of Numbers',
      userId: 0,
      alert: false,
      tipeAlert: '',
      messageAlert: ''
    }
  }

  componentDidMount() {
    // console.log(this.props.match.params.id)
    let userId = this.props.match.params.id
    this.setState({ userId })
    this.checkExpiredLink(userId)
    // console.log(this.props)
  }

  checkExpiredLink(userId) {
    api.create().isResetPassword(userId).then((response) => {
      if (response.data) {
        if (response.data.status == 'success') {
          // 
        } else {
          this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
            setTimeout(() => {
                this.props.history.push('/login')
              }, 1500);
          })
        }
      } else {
        this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
      }
    })
  }

  isRegex(value) {
    // const re = /^(?=.*[0-9])(?=.*[a-zA-Z])([a-zA-Z0-9]+)$/;
    const re = /^(?=.*?[A-Z])(?=.*?[a-z])(?=.*?[0-9])(?=.*?([^\w\s]|[_])).{8,}$/
    // const re = /^(?=.*[A-Za-z])(?=.*\d)(?=.*[@$!%*#_?&])[A-Za-z\d@$!%*#?&]{1,}$/;
    return re.test(String(value));
    // return value
  }

  isEmail(email) {
    const re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    return re.test(String(email).toLowerCase());
  }

  validateReset() {
    if (this.state.password.trim() == "") {
      this.setState({ errorPassword: true, msgPassword: 'New Password Cannot be Empty' })
    } else if (this.state.password.length < 8) {
      this.setState({ errorPassword: true, msgPassword: 'Invalid password. Minimum length : 8' })
    } else if (this.isEmail(this.state.password)) {
      this.setState({ errorPassword: true, msgPassword: 'Invalid password. Should not be same as Email Address' })
    } else if (!this.isRegex(this.state.password)) {
      this.setState({ errorPassword: true, msgPassword: 'Invalid password. Must using combination of characters, letters and numbers' })
    } else if (this.state.confirmPassword.trim() == "") {
      this.setState({ errorConfirmPassword: true, msgConfirmPassword: 'Repeat Password Cannot be Empty' })
    } else if (this.state.password !== this.state.confirmPassword) {
      this.setState({ errorConfirmPassword: true, msgConfirmPassword: 'The password and password confirmation do not match' })
    } else {
      this.confirmPassword()
      // console.log(this.state.password)
      // console.log(this.state.confirmPassword)
    }
  }

  confirmPassword() {
    let payload = {
      "password": this.state.password,
      "confirm_password": this.state.confirmPassword,
      "user_id": this.state.userId
    }
    api.create().resetPassword(payload).then((response) => {
      if (response.data) {
        if (response.ok) {
          if (response.data.status === 'success') {
            this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'success' }, () => {
              setTimeout(() => {
                this.props.history.push('/login')
              }, 1000);
            })
          } else {
            this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' })
          }
        } else {
          this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
        }
      } else {
        this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
      }
    })
  }

  closeAlert() {
    this.setState({ alert: false })
  }

  handleChange(e) {
    let data = this.state
    this.setState({ ...data, [e.target.name]: e.target.value })
    if (e.target.name == "password") {
      this.setState({ errorPassword: false, msgPassword: 'Consists of 8 Characters with a Combination of Numbers' })
    } else if (e.target.name == "confirmPassword") {
      this.setState({ errorConfirmPassword: false, msgConfirmPassword: 'Consists of 8 Characters with a Combination of Numbers' })
    }
  }

  render() {
    return (
      <div style={{ flex: 1, display: 'flex', backgroundColor: '#263b80', height: '100vh', justifyContent: 'center', alignItems: 'center' }}>
        <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
          <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
            {this.state.messageAlert}
          </Alert>
        </Snackbar>
        <div style={{ padding: 56, display: 'flex', flexDirection: 'column', width: 378, height: 415, borderRadius: 12, boxShadow: '0 2 4 0 rgba(0, 0, 0, 0.2)', backgroundColor: '#ffffff', justifyContent: 'center', alignItems: 'center' }}>
        <img src={Images.triputraBlack} style={{ height: 59, width: 175, alignSelf: 'center'}} />

          <TextField
            label={<Typography style={{ fontSize: 12, fontFamily: 'Nunito Sans, sans-serif' }}>New password *</Typography>}
            id="password"
            type={this.state.showPass ? 'text' : 'password'}
            name={"password"}
            value={this.state.password}
            onChange={(password) => {
              this.handleChange(password)
            }}
            variant="outlined"
            error={this.state.errorPassword}
            style={{ width: 250, height: 51, marginTop: 32 }}
            helperText={<Typography style={{ fontSize: 9, marginTop: 4, fontFamily: 'Nunito Sans, sans-serif' }}>{this.state.msgPassword}</Typography>}
            InputProps={{
              endAdornment: <InputAdornment position="end">
                <IconButton
                  aria-label="toggle password visibility"
                  style={{ color: '#4b4b4b', opacity: 0.5 }}
                  onClick={() => this.setState({ showPass: !this.state.showPass })}
                  edge="end"
                >
                  {this.state.showPass ? <Visibility style={{ fontSize: 18 }} /> : <VisibilityOff style={{ fontSize: 18 }} />}
                </IconButton>
              </InputAdornment>,
            }}
          />

          <TextField
            label={<Typography style={{ fontSize: 12, fontFamily: 'Nunito Sans, sans-serif' }}>Repeat New Password *</Typography>}
            id="confirmPassword"
            type={this.state.showPass2 ? 'text' : 'password'}
            name={"confirmPassword"}
            value={this.state.confirmPassword}
            onChange={(confirmPassword) => {
              this.handleChange(confirmPassword)
            }}
            variant="outlined"
            error={this.state.errorConfirmPassword}
            style={{ width: 250, height: 51, marginTop: 45 }}
            helperText={<Typography style={{ fontSize: 9, marginTop: 4, fontFamily: 'Nunito Sans, sans-serif' }}>{this.state.msgConfirmPassword}</Typography>}
            InputProps={{
              endAdornment: <InputAdornment position="end">
                <IconButton
                  aria-label="toggle password visibility"
                  style={{ color: '#4b4b4b', opacity: 0.5 }}
                  onClick={() => this.setState({ showPass2: !this.state.showPass2 })}
                  edge="end"
                >
                  {this.state.showPass2 ? <Visibility style={{ fontSize: 18 }} /> : <VisibilityOff style={{ fontSize: 18 }} />}
                </IconButton>
              </InputAdornment>,
            }}
          />

          <Button name="submit" variant="contained" disabled={this.state.password.trim() == '' && this.state.confirmPassword.trim() == '' ? true : false} onClick={() => this.validateReset()} style={{ marginTop: 60, width: '100%', height: 35, borderRadius: 4, color: this.state.password.trim() == '' && this.state.confirmPassword.trim() == '' ? '#4b4b4b' : '#fff', backgroundColor: this.state.password.trim() == '' && this.state.confirmPassword.trim() == '' ? '#d8d8d8' : '#51c6ea' }}>
            <Typography style={{ fontSize: 12, fontFamily: 'Nunito Sans, sans-serif' }}>Reset Password</Typography>
          </Button>
        </div>
      </div>
    );
  }
}

export default ResetPassword;