import React, { Component } from 'react';
import { Typography, Paper, createMuiTheme, MuiThemeProvider, TableCell, FormControlLabel, TextField, Input, Snackbar, withStyles, Tooltip } from '@material-ui/core';
import MUIDataTable from 'mui-datatables';
import NumberFormat from 'react-number-format';
import api from '../../api';
import AddIcon from '@material-ui/icons/Add';
import { values } from 'ramda';
import PropagateLoader from "react-spinners/PropagateLoader"
import Images from '../../assets/Images';
import ReactTooltip from 'react-tooltip';
import UploadFile from "../../library/Upload";
import { ExcelRenderer } from 'react-excel-renderer';
// import { Alert } from '@material-ui/lab';
import Constant from '../../library/Constant';
import MuiAlert from '@material-ui/lab/Alert';
import { fixNumber, titleCase } from '../../library/Utils';

var ct = require("../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable3());

const Alert = withStyles({
})((props) => <MuiAlert elevation={6} variant="filled" {...props} />);

const options = ct.customOptionsFixedColumn();
const style = {
    position: "sticky",
    left: 0,
    zIndex: 101,
    background: "white",
};
const style2 = {
    position: "sticky",
    background: "white",
    zIndex: 100
};

const LightTooltip = withStyles((theme) => ({
    tooltip: {
        backgroundColor: theme.palette.common.white,
        color: 'rgba(0, 0, 0, 0.87)',
        boxShadow: theme.shadows[1],
        fontSize: 11,
    },
}))(Tooltip);

export default class BalanceSheet extends Component {
    constructor(props) {
        super(props)
        this.state = {
            dataTable: [
                // ["TOTAL ASSETS", "11,247,249", "10,702,196"],
                // ["TOTAL CURRENT ASSETS", "2,647,647", "2,058,898"],
                // ["Cash & Cash Equivalent", "1,464,571", "729,743"],
                // ["Cash & Bank Balance", "938,707", "265,584"],
                // ["Time & Call Deposit", "525,864", "464,159"],
                // ["BI Deposit", "", ""],
                // ["Marketable Securities", "150,250", "154,500"],
                // ["Notes Receivable", "", ""],
                // ["Accounts Receivable", "172,031", "97,112"],
                // ["Trade Receivables - Third Party", "142,668", "77,480"],
            ],
            visibleOI: true,
            disabledSave: true,
            editable: true,
            emptyData: false,
            updateBy: [],
            notesUpdate: '-',
            templateNull: true,
            defaultCurrencyUpload: this.props.defaultCurrency,
            visibleAlertSave: false,
            alert: false,
            tipeAlert: '',
            messageAlert: '',
        }
        this.handleValue = this.handleValue.bind(this)
        this.fileHandler = this.fileHandler.bind(this);
    }

    getLatestUpdate() {
        let payload = {
            "operating_indicator_id": this.props.data.operatingIndID,
            "report_id": this.props.data.report_id,
            "company_id": this.props.data.company.company_id,
            "periode": this.props.data.periode,
        }
        api.create().getLastestUpdateOI(payload).then(response => {
            // console.log(response.data)
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        updateBy: response.data.data.detail === null ? [] : response.data.data.detail,
                        notesUpdate: response.data.data.notes_update === null ? '-' : response.data.data.notes_update
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    componentDidMount() {
        // this.getItemHierarki()
        this.getDataDetail()
        this.getLatestUpdate()
        // // console.log(this.props);
    }

    getDataDetail() {
        // this.setState({ loading: true })
        let payload = {
            "operating_indicator_id": this.props.data.operatingIndID,
            "report_id": this.props.data.report_id,
            "company_id": this.props.data.company.company_id,
            "periode": this.props.data.periode,
            "currency_id": this.props.defaultCurrency.id,
        }
        console.log(payload)
        api.create().getOperatingIndDetail(payload).then(response => {
            console.log(response)
            let dataTable = []
            let res = response.data.data
            // // // console.log(res) 
            const handlePushChild = (item) => {
                let indexIDzz = dataTable.findIndex((val) => val[1] === item.id)
                if (indexIDzz === -1) {
                    dataTable.push([
                        item.type_report_id,
                        item.id,
                        item.parent,
                        item.formula,
                        item.level,
                        item.description,
                        item.uom,
                        item.master_budget.total_actual_before == "" ? item.master_budget.total_actual_before : String(item.master_budget.total_actual_before).indexOf(".") == -1 ? Number(item.master_budget.total_actual_before) : Number(item.master_budget.total_actual_before),
                        item.master_budget.january == "" ? item.master_budget.january : String(item.master_budget.january).indexOf(".") == -1 ? Number(item.master_budget.january) : Number(item.master_budget.january),
                        item.master_budget.february == "" ? item.master_budget.february : String(item.master_budget.february).indexOf(".") == -1 ? Number(item.master_budget.february) : Number(item.master_budget.february),
                        item.master_budget.march == "" ? item.master_budget.march : String(item.master_budget.march).indexOf(".") == -1 ? Number(item.master_budget.march) : Number(item.master_budget.march),
                        item.master_budget.april == "" ? item.master_budget.april : String(item.master_budget.april).indexOf(".") == -1 ? Number(item.master_budget.april) : Number(item.master_budget.april),
                        item.master_budget.may == "" ? item.master_budget.may : String(item.master_budget.may).indexOf(".") == -1 ? Number(item.master_budget.may) : Number(item.master_budget.may),
                        item.master_budget.june == "" ? item.master_budget.june : String(item.master_budget.june).indexOf(".") == -1 ? Number(item.master_budget.june) : Number(item.master_budget.june),
                        item.master_budget.july == "" ? item.master_budget.july : String(item.master_budget.july).indexOf(".") == -1 ? Number(item.master_budget.july) : Number(item.master_budget.july),
                        item.master_budget.august == "" ? item.master_budget.august : String(item.master_budget.august).indexOf(".") == -1 ? Number(item.master_budget.august) : Number(item.master_budget.august),
                        item.master_budget.september == "" ? item.master_budget.september : String(item.master_budget.september).indexOf(".") == -1 ? Number(item.master_budget.september) : Number(item.master_budget.september),
                        item.master_budget.october == "" ? item.master_budget.october : String(item.master_budget.october).indexOf(".") == -1 ? Number(item.master_budget.october) : Number(item.master_budget.october),
                        item.master_budget.november == "" ? item.master_budget.november : String(item.master_budget.november).indexOf(".") == -1 ? Number(item.master_budget.november) : Number(item.master_budget.november),
                        item.master_budget.december == "" ? item.master_budget.december : String(item.master_budget.december).indexOf(".") == -1 ? Number(item.master_budget.december) : Number(item.master_budget.december),
                        item.master_budget.total_current_year == "" ? item.master_budget.total_current_year : String(item.master_budget.total_current_year).indexOf(".") == -1 ? Number(item.master_budget.total_current_year) : Number(item.master_budget.total_current_year),
                        item.master_budget.total_next_year == "" ? item.master_budget.total_next_year : String(item.master_budget.total_next_year).indexOf(".") == -1 ? Number(item.master_budget.total_next_year) : Number(item.master_budget.total_next_year),
                        item.master_budget.total_more_year == "" ? item.master_budget.total_more_year : String(item.master_budget.total_more_year).indexOf(".") == -1 ? Number(item.master_budget.total_more_year) : Number(item.master_budget.total_more_year),
                        item.order
                    ])
                }
                if (item.children !== null) {
                    if (item.children.length > 0) {
                        item.children.map((items, indexs) => {
                            handlePushChild(items)
                        })
                    }
                }
            }
            res.map((item, index) => {
                dataTable.push([
                    item.type_report_id,
                    item.id,
                    item.parent,
                    item.formula,
                    item.level,
                    item.description,
                    item.uom,
                    item.master_budget.total_actual_before == "" ? item.master_budget.total_actual_before : String(item.master_budget.total_actual_before).indexOf(".") == -1 ? Number(item.master_budget.total_actual_before) : Number(item.master_budget.total_actual_before),
                    item.master_budget.january == "" ? item.master_budget.january : String(item.master_budget.january).indexOf(".") == -1 ? Number(item.master_budget.january) : Number(item.master_budget.january),
                    item.master_budget.february == "" ? item.master_budget.february : String(item.master_budget.february).indexOf(".") == -1 ? Number(item.master_budget.february) : Number(item.master_budget.february),
                    item.master_budget.march == "" ? item.master_budget.march : String(item.master_budget.march).indexOf(".") == -1 ? Number(item.master_budget.march) : Number(item.master_budget.march),
                    item.master_budget.april == "" ? item.master_budget.april : String(item.master_budget.april).indexOf(".") == -1 ? Number(item.master_budget.april) : Number(item.master_budget.april),
                    item.master_budget.may == "" ? item.master_budget.may : String(item.master_budget.may).indexOf(".") == -1 ? Number(item.master_budget.may) : Number(item.master_budget.may),
                    item.master_budget.june == "" ? item.master_budget.june : String(item.master_budget.june).indexOf(".") == -1 ? Number(item.master_budget.june) : Number(item.master_budget.june),
                    item.master_budget.july == "" ? item.master_budget.july : String(item.master_budget.july).indexOf(".") == -1 ? Number(item.master_budget.july) : Number(item.master_budget.july),
                    item.master_budget.august == "" ? item.master_budget.august : String(item.master_budget.august).indexOf(".") == -1 ? Number(item.master_budget.august) : Number(item.master_budget.august),
                    item.master_budget.september == "" ? item.master_budget.september : String(item.master_budget.september).indexOf(".") == -1 ? Number(item.master_budget.september) : Number(item.master_budget.september),
                    item.master_budget.october == "" ? item.master_budget.october : String(item.master_budget.october).indexOf(".") == -1 ? Number(item.master_budget.october) : Number(item.master_budget.october),
                    item.master_budget.november == "" ? item.master_budget.november : String(item.master_budget.november).indexOf(".") == -1 ? Number(item.master_budget.november) : Number(item.master_budget.november),
                    item.master_budget.december == "" ? item.master_budget.december : String(item.master_budget.december).indexOf(".") == -1 ? Number(item.master_budget.december) : Number(item.master_budget.december),
                    item.master_budget.total_current_year == "" ? item.master_budget.total_current_year : String(item.master_budget.total_current_year).indexOf(".") == -1 ? Number(item.master_budget.total_current_year) : Number(item.master_budget.total_current_year),
                    item.master_budget.total_next_year == "" ? item.master_budget.total_next_year : String(item.master_budget.total_next_year).indexOf(".") == -1 ? Number(item.master_budget.total_next_year) : Number(item.master_budget.total_next_year),
                    item.master_budget.total_more_year == "" ? item.master_budget.total_more_year : String(item.master_budget.total_more_year).indexOf(".") == -1 ? Number(item.master_budget.total_more_year) : Number(item.master_budget.total_more_year),
                    item.order
                ])
                if (item.children !== null) {
                    if (item.children.length > 0) {
                        item.children.map((items, indexs) => {
                            handlePushChild(items)
                        })
                    }
                }
            })
            this.setState({ dataTable, loading: false }, () => {
                if (this.state.dataTable.length == 0) {
                    this.setState({ emptyData: true })
                }
            })
            console.log(dataTable);
        })

    }

    createData(type) {
        let payloadMB = []
        if (this.props.defaultCurrency.id == 2) {
            this.state.dataTable.map((item, index) => {
                payloadMB.push({
                    "item_report_id": item[1],
                    "total_actual_before": String(Number(item[7])),
                    "january": String(Number(item[8])),
                    "february": String(Number(item[9])),
                    "march": String(Number(item[10])),
                    "april": String(Number(item[11])),
                    "may": String(Number(item[12])),
                    "june": String(Number(item[13])),
                    "july": String(Number(item[14])),
                    "august": String(Number(item[15])),
                    "september": String(Number(item[16])),
                    "october": String(Number(item[17])),
                    "november": String(Number(item[18])),
                    "december": String(Number(item[19])),
                    "total_current_year": String(Number(item[20])),
                    "total_next_year": String(Number(item[21])),
                    "total_more_year": String(Number(item[22])),
                })
            })
        } else {
            this.state.dataTable.map((item, index) => {
                payloadMB.push({
                    "item_report_id": item[1],
                    "total_actual_before": String(fixNumber(Number(item[7]), 1)),
                    "january": String(fixNumber(Number(item[8]), 1)),
                    "february": String(fixNumber(Number(item[9]), 1)),
                    "march": String(fixNumber(Number(item[10]), 1)),
                    "april": String(fixNumber(Number(item[11]), 1)),
                    "may": String(fixNumber(Number(item[12]), 1)),
                    "june": String(fixNumber(Number(item[13]), 1)),
                    "july": String(fixNumber(Number(item[14]), 1)),
                    "august": String(fixNumber(Number(item[15]), 1)),
                    "september": String(fixNumber(Number(item[16]), 1)),
                    "october": String(fixNumber(Number(item[17]), 1)),
                    "november": String(fixNumber(Number(item[18]), 1)),
                    "december": String(fixNumber(Number(item[19]), 1)),
                    "total_current_year": String(fixNumber(Number(item[20]), 1)),
                    "total_next_year": String(fixNumber(Number(item[21]), 1)),
                    "total_more_year": String(fixNumber(Number(item[22]), 1)),
                })
            })
        }

        let payload = {
            "operating_indicator_id": this.props.data.operatingIndID,
            "report_id": this.props.data.report_id,
            "company_id": this.props.data.company.company_id,
            "periode": this.props.data.periode,
            "currency_id": this.props.defaultCurrency.id,
            "status": type,
            "master_budget": payloadMB
        }
        console.log(payload);
        // // console.log('=========================')
        // console.log(JSON.stringify(payload))
        this.props.saveOperatingInd(payload)
        this.setState({ loading: false })
        // this.props.onClickClose()
    }

    handleValue(data) {
        let total = 0
        this.state.dataTable.map((item, index) => {
            if (data.rowData[1] == item[2]) {
                total = item[data.columnIndex] == undefined ? (Number(total) + 0) : (Number(total) + Number(item[data.columnIndex]))
            }
        })
        let indexParent = this.state.dataTable.findIndex((val) => val[1] == this.state.dataTable[data.rowIndex][2])
        let a = this.state.dataTable[data.rowIndex][data.columnIndex] = total
        // // // console.log(indexParent);
        return a
    }

    handleChange(value, tableMeta) {
        let val = String(value).split(",").join("")
        let data = this.state.dataTable
        let indexParent = data.findIndex((val) => val[1] == data[tableMeta.rowIndex][2])
        if (indexParent > 0) {
            let a = data[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
            let jagain = data[indexParent][tableMeta.columnIndex]
            a = data[indexParent][tableMeta.columnIndex] = jagain == undefined ? (0 + Number(val)) : (jagain + Number(val))
        } else {
            data[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
        }
    }


    downloadTemplate = async () => {
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/operating_indicator/master_budget/download_template?report_id=${this.props.data.report_id}&&company_id=${this.props.data.company.company_id}&&year=${this.props.data.periode}&&currency_id=${this.props.defaultCurrency.id}`
        )
        res = await res.blob()
        // // console.log(res)
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Template Master Budget Operating Indicator.xlsx';
            a.click();
        }
    }

    async downloadAllData() {
        // // // console.log('masuk')
        let bram = [this.props.data.operatingIndID, this.props.report_id, this.props.data.company.company_id, this.props.data.periode]
        // // console.log(bram)
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/operating_indicator/master_budget/export_master_budget?operating_indicator_id=${this.props.data.operatingIndID == null ? "" : this.props.data.operatingIndID}&&report_id=${this.props.data.report_id}&&company_id=${this.props.data.company.company_id}&&year=${this.props.data.periode}`
        )

        res = await res.blob()
        // // console.log(res)
        this.setState({ loading: false })
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Master Budget Operating Indicator.xlsx';
            a.click();
        }
    }

    fileHandler = (event) => {
        let fileObj = event
        ExcelRenderer(fileObj, (err, resp) => {
            // // // console.log(resp)
            if (err) {
                // // console.log(err);
            }
            else {
                let isi = resp.rows.slice(3)
                // // console.log(isi);
                let payload = []
                let reg = /^[-+]?(?:[0-9]+,)*[0-9]+(?:\.[0-9]+)?$/;
                isi.map((i, index) => {
                    if (i.length > 0) {
                        payload.push({
                            order: i[0] === undefined ? "0" : String(i[0]).trim(),
                            item_report_id: i[1] === undefined ? "0" : String(i[1]).trim(),
                            item_report: i[2] === undefined ? "0" : String(i[2]).trim(),
                            uom: i[3] === undefined ? "" : String(i[3]).trim(),
                            // total_actual_before: i[4] === undefined ? "0" : reg.test(String(i[4])) === false ? "0" : String(i[4]).trim(),
                            january: i[4] === undefined ? "0" : reg.test(String(i[4])) === false ? "0" : String(i[4]).trim(),
                            february: i[5] === undefined ? "0" : reg.test(String(i[5])) === false ? "0" : String(i[5]).trim(),
                            march: i[6] === undefined ? "0" : reg.test(String(i[6])) === false ? "0" : String(i[6]).trim(),
                            april: i[7] === undefined ? "0" : reg.test(String(i[7])) === false ? "0" : String(i[7]).trim(),
                            may: i[8] === undefined ? "0" : reg.test(String(i[8])) === false ? "0" : String(i[8]).trim(),
                            june: i[9] === undefined ? "0" : reg.test(String(i[9])) === false ? "0" : String(i[9]).trim(),
                            july: i[10] === undefined ? "0" : reg.test(String(i[10])) === false ? "0" : String(i[10]).trim(),
                            august: i[11] === undefined ? "0" : reg.test(String(i[11])) === false ? "0" : String(i[11]).trim(),
                            september: i[12] === undefined ? "0" : reg.test(String(i[12])) === false ? "0" : String(i[12]).trim(),
                            october: i[13] === undefined ? "0" : reg.test(String(i[13])) === false ? "0" : String(i[13]).trim(),
                            november: i[14] === undefined ? "0" : reg.test(String(i[14])) === false ? "0" : String(i[14]).trim(),
                            december: i[15] === undefined ? "0" : reg.test(String(i[15])) === false ? "0" : String(i[15]).trim(),
                            total_current_year: i[16] === undefined ? "0" : reg.test(String(i[16])) === false ? "0" : String(i[16]).trim(),
                            total_next_year: i[17] === undefined ? "0" : reg.test(String(i[17])) === false ? "0" : String(i[17]).trim(),
                            total_more_year: i[18] === undefined ? "0" : reg.test(String(i[18])) === false ? "0" : String(i[18]).trim(),
                        })
                    }
                })
                let body = {
                    company_id: this.props.data.company.company_id,
                    periode: this.props.data.periode,
                    report_id: this.props.data.report_id,
                    master_budget: payload,
                    status: 'submitted'
                }
                console.log(body)
                this.setState({ payload: body, buttonError: false, judul: resp.rows[1][0] })
            }
        });
    }

    checkUpload() {
        let payload = {
            ...this.state.payload,
            currency_id: this.state.defaultCurrencyUpload?.id
        }
        // // console.log(JSON.stringify(this.state.payload))
        api.create().checkUploadOperatingInd(payload).then(response => {
            // // // console.log(JSON.stringify(this.state.payload));
            // // console.log('===============')
            console.log(response)
            if (response.data) {
                if (response.data.status === 'success') {
                    this.setState({ visibleUpload: false, visibleOI: false, loading: true })
                    let total = 0
                    let dataTable = response.data.data.map((item, index) => {
                        if (item.type_report_id != null) {
                            total += 1
                        }
                        return [
                            item.type_report_id,
                            item.item_report_id,
                            item.parent,
                            item.formula,
                            item.level,
                            item.item_report,
                            item.uom,
                            item.total_actual_before,
                            item.january,
                            item.february,
                            item.march,
                            item.april,
                            item.may,
                            item.june,
                            item.july,
                            item.august,
                            item.september,
                            item.october,
                            item.november,
                            item.december,
                            item.total_current_year,
                            item.total_next_year,
                            item.total_more_year,
                            item.order,
                            item.error
                        ]
                    })
                    this.setState({ dataTable, dataLoaded: true, loading: false, templateNull: total > 0 ? true : false })
                }
            }
        })
    }

    uploadOI(type) {
        let data = []
        // // console.log(this.state.dataTable)
        if (this.props.defaultCurrency.id == 2) {
            this.state.dataTable.map(i => {
                data.push({
                    "item_report_id": i[1],
                    "item_report": String(i[5]),
                    "total_actual_before": String(Number(i[7] == null ? "0" : i[7])),
                    "january": String(Number(i[8])),
                    "february": String(Number(i[9])),
                    "march": String(Number(i[10])),
                    "april": String(Number(i[11])),
                    "may": String(Number(i[12])),
                    "june": String(Number(i[13])),
                    "july": String(Number(i[14])),
                    "august": String(Number(i[15])),
                    "september": String(Number(i[16])),
                    "october": String(Number(i[17])),
                    "november": String(Number(i[18])),
                    "december": String(Number(i[19])),
                    "total_current_year": String(Number(i[20])),
                    "total_next_year": String(Number(i[21])),
                    "total_more_year": String(Number(i[22])),
                })
            })
        } else {
            this.state.dataTable.map(i => {
                data.push({
                    "item_report_id": i[1],
                    "item_report": String(i[5]),
                    "total_actual_before": String(fixNumber(Number(i[7] == null ? "0" : i[7]), 1)),
                    "january": String(fixNumber(Number(i[8]), 1)),
                    "february": String(fixNumber(Number(i[9]), 1)),
                    "march": String(fixNumber(Number(i[10]), 1)),
                    "april": String(fixNumber(Number(i[11]), 1)),
                    "may": String(fixNumber(Number(i[12]), 1)),
                    "june": String(fixNumber(Number(i[13]), 1)),
                    "july": String(fixNumber(Number(i[14]), 1)),
                    "august": String(fixNumber(Number(i[15]), 1)),
                    "september": String(fixNumber(Number(i[16]), 1)),
                    "october": String(fixNumber(Number(i[17]), 1)),
                    "november": String(fixNumber(Number(i[18]), 1)),
                    "december": String(fixNumber(Number(i[19]), 1)),
                    "total_current_year": String(fixNumber(Number(i[20]), 1)),
                    "total_next_year": String(fixNumber(Number(i[21]), 1)),
                    "total_more_year": String(fixNumber(Number(i[22]), 1)),
                })
            })
        }

        let body = {
            company_id: this.props.data.company.company_id,
            operating_indicator_id: this.props.data.operatingIndID,
            periode: this.props.data.periode,
            report_id: this.props.data.report_id,
            currency_id: this.props.defaultCurrency.id,
            status: type,
            master_budget: data
        }
        // // console.log(data);
        // // console.log(JSON.stringify(body))
        api.create('UPLOAD').uploadOperatingInd(body).then(response => {
            console.log(response);
            this.setState({ loading: false })
            if (response.data) {
                if (response.data.status === "success") {
                    this.props.onClickClose()
                    this.props.getReport()
                } else {
                    console.log(response.data.message);
                    if (response.data.message == "Please Set Up Rate Currency First") {
                        this.setState({ visibleAlertSave: true, loading: false })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error', loading: false })
                    }
                    // alert(response.data.status)
                }
            } else {
                alert(response.problem)
            }
        })
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    render() {
        let dataTable2 = this.state.dataTable
        const handleChange = (value, tableMeta) => {
            let val = String(value).split(",").join("")
            let total = 0
            dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
            // dataTable2[tableMeta.rowIndex].map((item,index) => {
            //     if (index >= 8 && index <= 19) {
            //         let valItem = item == undefined || item == ""? 0 : item
            //         total += Number(valItem)
            //     }
            // })
            // dataTable2[tableMeta.rowIndex][20] = total 
            // // console.log(dataTable2[tableMeta.rowIndex])
        }

        const handleValue = (value, tableMeta) => {
            let val = String(value).split(",").join("")
            let total = 0
            dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
            dataTable2[tableMeta.rowIndex].map((item, index) => {
                if (index >= 8 && index <= 19) {
                    let valItem = item == undefined || item == "" ? 0 : item
                    total += Number(valItem)
                }
            })
            dataTable2[tableMeta.rowIndex][20] = total
            return total
        }

        const handleParent = (tableMeta) => {
            // // console.log(tableMeta)
            let total = 0

            dataTable2.map((item, index) => {
                if (item[2] == tableMeta.rowData[1]) {
                    // // console.log(total)
                    // // console.log(item[tableMeta.columnIndex])
                    total += Number(item[tableMeta.columnIndex])
                }
            })

            dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = total
            return total
        }

        const handleFormula = (tableMeta) => {
            let arrayFormula = tableMeta.rowData[3].match(/[a-zA-Z]+|[0-9]+|[-!$%^&*()_+|~=`{}\[\]:";'<>?,.\/]+(?:\.[0-9]+@|)/g)
            let arrayFormulaConvert = []
            // // // console.log(arrayFormula)
            let opet = ""
            let tambahan = false
            arrayFormula.map((item, indexs) => {
                if (item == 'X') {
                    tambahan = true
                } else if (item == '-' || item == '+' || item == '/' || item == '*') {
                    arrayFormulaConvert.push(item)
                } else {
                    let indexID = dataTable2.findIndex((val) => val[23] == item)
                    if (tambahan) {
                        if (item == '-' || item == '+' || item == '/' || item == '*') {
                            opet = item
                        } else {
                            arrayFormulaConvert.push(opet == '' ? Number(item) : Number(String(opet + String(item))))
                            tambahan = false
                            opet = ""
                        }
                    } else {
                        if (indexID !== -1) {
                            let valuezz = dataTable2[indexID][tableMeta.columnIndex]
                            // // // console.log(dataTable2[indexID])
                            arrayFormulaConvert.push(valuezz == "" ? 0 : valuezz)
                        }
                    }
                }
            })
            // // console.log(arrayFormula)
            // // console.log(arrayFormulaConvert)
            let array = arrayFormulaConvert
            let total = 0
            let opt = ""
            array.map((item, index) => {
                if (item == "+") {
                    opt = "tambah"
                } else if (item == "-") {
                    opt = "kurang"
                } else if (item == "*") {
                    opt = "kali"
                } else if (item == "/") {
                    opt = "bagi"
                } else {
                    if (opt == "tambah") {
                        total = Number(total) + Number(item)
                    } else if (opt == "kurang") {
                        total = Number(total) - Number(item)
                    } else if (opt == "kali") {
                        total = Number(total) * Number(item)
                    } else if (opt == "bagi") {
                        total = Number(total) / Number(item)
                    } else {
                        total += Number(item)
                    }
                }
            })
            let a = dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(total)
            return a

        }
        const columns = [{
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "Account",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 102, backgroundColor: '#1c71b8', width: 300 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style }),
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ width: 300 }}>
                            {tableMeta.rowData[0] === null ?
                                tableMeta.rowData[1] !== null ?
                                    tableMeta.rowData[4] == 0 ?
                                        <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                        :
                                        <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                            <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                        </div> :
                                    tableMeta.rowData[4] == 0 ?
                                        <LightTooltip title={"Report Items Not Registered"} arrow>
                                            <span style={{ fontSize: 12, fontWeight: 'bold', color: 'red' }}>{String(val).toUpperCase()}</span>
                                        </LightTooltip> :
                                        <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                            <LightTooltip title={"Report Items Not Registered"} arrow>
                                                <span style={{ fontSize: 12, color: 'red' }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                            </LightTooltip>
                                        </div>
                                :
                                tableMeta.rowData[4] == 0 ?
                                    <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                    :
                                    <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                        <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                    </div>

                                // tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === null ?
                                //     null
                                //     :
                                //     tableMeta.rowData[22] ?
                                //         tableMeta.rowData[22].length > 0 ?
                                //             tableMeta.rowData[22][0].field === 'item' ?
                                //                 tableMeta.rowData[4] == 0 ?
                                //                     <a data-tip={tableMeta.rowData[22][0].message} data-for="account">
                                //                         <span style={{ fontSize: 12, fontWeight: 'bold', color: 'red' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                //                     </a>
                                //                     :
                                //                     <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                //                         <a data-tip={tableMeta.rowData[22][0].message} data-for="account">
                                //                             <span style={{ fontSize: 12, color: 'red' }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                //                         </a>
                                //                     </div>
                                //                 :
                                //                 tableMeta.rowData[4] == 0 ?
                                //                     <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                //                     :
                                //                     <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                //                         <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                //                     </div>
                                //             :
                                //             tableMeta.rowData[4] == 0 ?
                                //                 <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                //                 :
                                //                 <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                //                     <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                //                 </div>
                                //         :
                                //         tableMeta.rowData[4] == 0 ?
                                //             <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                //             :
                                //             <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                //                 <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                //             </div>
                            }
                            {/* <ReactTooltip border={true} id="account" place="bottom" type="light" effect="solid" /> */}
                        </div>
                    )
                }
            }
        }, {
            name: "UOM",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96 }}>
                        <Typography style={{ color: 'black', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === null ?
                                null
                                :
                                <FormControlLabel
                                    style={{ margin: 0 }}
                                    // value={value}
                                    control={
                                        <Input
                                            disableUnderline={true}
                                            style={{ fontSize: 12, textAlign: 'center', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent', marginTop: -10 }}
                                            type="text"
                                            placeholder=""
                                            defaultValue={value}
                                            // color={"#5198ea"}
                                            value={value}
                                            disabled={true}
                                        // onBlur={(event) => {
                                        //     // // console.log(event.target.value)
                                        //     // updateValue(event.target.value)
                                        //     handleChangeText(event.target.value, tableMeta)
                                        //     // // console.log(dataTable2)
                                        // }}
                                        />
                                    }
                                />}
                        </div>
                    )
                }
            }
        }, {
            name: `31 Dec ${Number(this.props.data.periode) - 1} Actual`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96 }}>
                        <Typography style={{ color: 'black', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === null ?
                                null
                                :
                                <NumberFormat
                                    thousandSeparator={true}
                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                    type="text"
                                    placeholder=""
                                    disabled={true}
                                    // decimalScale={1}
                                    value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                />}
                        </div>
                    )
                }
            }
        }, {
            name: `Jan ${this.props.data.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === null ?
                                null
                                :
                                tableMeta.rowData[0] == 2 ?
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    value={fixNumber(Number(handleParent(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta)), 1)}
                                                    disabled={true}
                                                // decimalScale={1}
                                                />
                                            }
                                        />
                                    </div>
                                    :
                                    (tableMeta.rowData[0] == 5 || tableMeta.rowData[0] == 6 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(handleFormula(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(tableMeta)), 1)}
                                                        disabled={true}
                                                        // decimalScale={1}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>
                                        :
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        // decimalScale={1}
                                                        disabled={!this.props.permission.create || !this.props.permission.edit || !this.props.isSubmit}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>)
                            }
                        </div>
                    )
                }
            }
        }
            , {
            name: `Feb ${this.props.data.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === null ?
                                null
                                :
                                tableMeta.rowData[0] == 2 ?
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    value={fixNumber(Number(handleParent(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta)), 1)}
                                                    disabled={true}
                                                // decimalScale={1}
                                                />
                                            }
                                        />
                                    </div>
                                    :
                                    (tableMeta.rowData[0] == 5 || tableMeta.rowData[0] == 6 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(handleFormula(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(tableMeta)), 1)}
                                                        disabled={true}
                                                        // decimalScale={1}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>
                                        :
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        // decimalScale={1}
                                                        disabled={!this.props.permission.create || !this.props.permission.edit || !this.props.isSubmit}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>)
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Mar ${this.props.data.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === null ?
                                null
                                :
                                tableMeta.rowData[0] == 2 ?
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    value={fixNumber(Number(handleParent(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta)), 1)}
                                                    disabled={true}
                                                // decimalScale={1}
                                                />
                                            }
                                        />
                                    </div>
                                    :
                                    (tableMeta.rowData[0] == 5 || tableMeta.rowData[0] == 6 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(handleFormula(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(tableMeta)), 1)}
                                                        disabled={true}
                                                        // decimalScale={1}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>
                                        :
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        // decimalScale={1}
                                                        disabled={!this.props.permission.create || !this.props.permission.edit || !this.props.isSubmit}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>)
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Apr ${this.props.data.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === null ?
                                null
                                :
                                tableMeta.rowData[0] == 2 ?
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    value={fixNumber(Number(handleParent(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta)), 1)}
                                                    disabled={true}
                                                // decimalScale={1}
                                                />
                                            }
                                        />
                                    </div>
                                    :
                                    (tableMeta.rowData[0] == 5 || tableMeta.rowData[0] == 6 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(handleFormula(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(tableMeta)), 1)}
                                                        disabled={true}
                                                        // decimalScale={1}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>
                                        :
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        // decimalScale={1}
                                                        disabled={!this.props.permission.create || !this.props.permission.edit || !this.props.isSubmit}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>)
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `May ${this.props.data.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === null ?
                                null
                                :
                                tableMeta.rowData[0] == 2 ?
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    value={fixNumber(Number(handleParent(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta)), 1)}
                                                    disabled={true}
                                                // decimalScale={1}
                                                />
                                            }
                                        />
                                    </div>
                                    :
                                    (tableMeta.rowData[0] == 5 || tableMeta.rowData[0] == 6 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(handleFormula(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(tableMeta)), 1)}
                                                        disabled={true}
                                                        // decimalScale={1}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>
                                        :
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        // decimalScale={1}
                                                        disabled={!this.props.permission.create || !this.props.permission.edit || !this.props.isSubmit}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>)
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Jun ${this.props.data.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === null ?
                                null
                                :
                                tableMeta.rowData[0] == 2 ?
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    value={fixNumber(Number(handleParent(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta)), 1)}
                                                    disabled={true}
                                                // decimalScale={1}
                                                />
                                            }
                                        />
                                    </div>
                                    :
                                    (tableMeta.rowData[0] == 5 || tableMeta.rowData[0] == 6 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(handleFormula(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(tableMeta)), 1)}
                                                        disabled={true}
                                                        // decimalScale={1}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>
                                        :
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        // decimalScale={1}
                                                        disabled={!this.props.permission.create || !this.props.permission.edit || !this.props.isSubmit}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>)
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Jul ${this.props.data.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === null ?
                                null
                                :
                                tableMeta.rowData[0] == 2 ?
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    value={fixNumber(Number(handleParent(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta)), 1)}
                                                    disabled={true}
                                                // decimalScale={1}
                                                />
                                            }
                                        />
                                    </div>
                                    :
                                    (tableMeta.rowData[0] == 5 || tableMeta.rowData[0] == 6 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(handleFormula(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(tableMeta)), 1)}
                                                        disabled={true}
                                                        // decimalScale={1}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>
                                        :
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        // decimalScale={1}
                                                        disabled={!this.props.permission.create || !this.props.permission.edit || !this.props.isSubmit}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>)
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Aug ${this.props.data.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === null ?
                                null
                                :
                                tableMeta.rowData[0] == 2 ?
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    value={fixNumber(Number(handleParent(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta)), 1)}
                                                    disabled={true}
                                                // decimalScale={1}
                                                />
                                            }
                                        />
                                    </div>
                                    :
                                    (tableMeta.rowData[0] == 5 || tableMeta.rowData[0] == 6 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(handleFormula(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(tableMeta)), 1)}
                                                        disabled={true}
                                                        // decimalScale={1}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>
                                        :
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        // decimalScale={1}
                                                        disabled={!this.props.permission.create || !this.props.permission.edit || !this.props.isSubmit}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>)
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Sep ${this.props.data.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === null ?
                                null
                                :
                                tableMeta.rowData[0] == 2 ?
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    value={fixNumber(Number(handleParent(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta)), 1)}
                                                    disabled={true}
                                                // decimalScale={1}
                                                />
                                            }
                                        />
                                    </div>
                                    :
                                    (tableMeta.rowData[0] == 5 || tableMeta.rowData[0] == 6 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(handleFormula(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(tableMeta)), 1)}
                                                        disabled={true}
                                                        // decimalScale={1}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>
                                        :
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        // decimalScale={1}
                                                        disabled={!this.props.permission.create || !this.props.permission.edit || !this.props.isSubmit}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>)
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Oct ${this.props.data.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === null ?
                                null
                                :
                                tableMeta.rowData[0] == 2 ?
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    value={fixNumber(Number(handleParent(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta)), 1)}
                                                    disabled={true}
                                                // decimalScale={1}
                                                />
                                            }
                                        />
                                    </div>
                                    :
                                    (tableMeta.rowData[0] == 5 || tableMeta.rowData[0] == 6 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(handleFormula(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(tableMeta)), 1)}
                                                        disabled={true}
                                                        // decimalScale={1}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>
                                        :
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        // decimalScale={1}
                                                        disabled={!this.props.permission.create || !this.props.permission.edit || !this.props.isSubmit}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>)
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Nov ${this.props.data.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === null ?
                                null
                                :
                                tableMeta.rowData[0] == 2 ?
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    value={fixNumber(Number(handleParent(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta)), 1)}
                                                    disabled={true}
                                                // decimalScale={1}
                                                />
                                            }
                                        />
                                    </div>
                                    :
                                    (tableMeta.rowData[0] == 5 || tableMeta.rowData[0] == 6 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(handleFormula(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(tableMeta)), 1)}
                                                        disabled={true}
                                                        // decimalScale={1}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>
                                        :
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        // decimalScale={1}
                                                        disabled={!this.props.permission.create || !this.props.permission.edit || !this.props.isSubmit}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>)
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Dec ${this.props.data.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === null ?
                                null
                                :
                                tableMeta.rowData[0] == 2 ?
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    value={fixNumber(Number(handleParent(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta)), 1)}
                                                    disabled={true}
                                                // decimalScale={1}
                                                />
                                            }
                                        />
                                    </div>
                                    :
                                    (tableMeta.rowData[0] == 5 || tableMeta.rowData[0] == 6 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(handleFormula(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(tableMeta)), 1)}
                                                        disabled={true}
                                                        // decimalScale={1}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>
                                        :
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        // decimalScale={1}
                                                        disabled={!this.props.permission.create || !this.props.permission.edit || !this.props.isSubmit}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>)
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `31 Dec ${this.props.data.periode}\nTotal`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96 }}>
                        <Typography style={{ color: 'black', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === null ?
                                null
                                :
                                tableMeta.rowData[0] == 2 ?
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    value={fixNumber(Number(handleParent(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta)), 1)}
                                                    disabled={true}
                                                // decimalScale={1}
                                                />
                                            }
                                        />
                                    </div>
                                    :
                                    (tableMeta.rowData[0] == 5 || tableMeta.rowData[0] == 6 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(handleFormula(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(tableMeta)), 1)}
                                                        disabled={true}
                                                        // decimalScale={1}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>
                                        :
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        // decimalScale={1}
                                                        disabled={!this.props.permission.create || !this.props.permission.edit || !this.props.isSubmit}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>)
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `31 Dec ${Number(this.props.data.periode) + 1}\nTotal`,
            // name: `31 Dec 2023\nTotal`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96 }}>
                        <Typography style={{ color: 'black', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === null ?
                                null
                                :
                                tableMeta.rowData[0] == 2 ?
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    value={fixNumber(Number(handleParent(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta)), 1)}
                                                    disabled={true}
                                                // decimalScale={1}
                                                />
                                            }
                                        />
                                    </div>
                                    :
                                    (tableMeta.rowData[0] == 5 || tableMeta.rowData[0] == 6 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(handleFormula(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(tableMeta)), 1)}
                                                        disabled={true}
                                                        // decimalScale={1}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>
                                        :
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        // decimalScale={1}
                                                        disabled={!this.props.permission.create || !this.props.permission.edit || !this.props.isSubmit}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>)
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `31 Dec ${Number(this.props.data.periode) + 2}\nTotal`,
            // name: `31 Dec 2024\nTotal`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96 }}>
                        <Typography style={{ color: 'black', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === null ?
                                null
                                :
                                tableMeta.rowData[0] == 2 ?
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    value={fixNumber(Number(handleParent(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleParent(tableMeta)), 1)}
                                                    disabled={true}
                                                // decimalScale={1}
                                                />
                                            }
                                        />
                                    </div>
                                    :
                                    (tableMeta.rowData[0] == 5 || tableMeta.rowData[0] == 6 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(handleFormula(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleFormula(tableMeta)), 1)}
                                                        disabled={true}
                                                        // decimalScale={1}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>
                                        :
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        // decimalScale={1}
                                                        disabled={!this.props.permission.create || !this.props.permission.edit || !this.props.isSubmit}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>)
                            }
                        </div>
                    )
                }
            }
        },
        {
            name: "",
            options: {
                display: false
            }
        }
        ]
        const loadingComponent = (
            <div style={{ position: 'absolute', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)' }}>
                <PropagateLoader
                    // css={override}
                    size={20}
                    color={"#274B80"}
                    loading={this.state.loading}
                />
            </div>
        );

        return (
            <div style={{ height: this.props.height, backgroundColor: '#f8f8f8', marginBottom: 100, minHeight: 1000 }}>
                <div className={"main-color"} style={{ height: 78, flex: 1, display: 'flex', alignItems: 'center', paddingLeft: 20 }}>
                    <Typography style={{ fontSize: '16px', color: 'white' }}>Master Budget Submission</Typography>
                </div>
                <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                    <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                        {this.state.messageAlert}
                    </Alert>
                </Snackbar>
                <div style={{ flex: 1, padding: 20, width: '100%' }}>
                    {this.state.visibleOI === true ?
                        <Paper style={{ paddingTop: 10, paddingBottom: 20 }}>
                            <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                                <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Master Budget - Operating Indicator</Typography>
                            </div>
                            <div style={{ padding: 20 }}>
                                {!this.state.emptyData && <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                                    <div>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.data.company.company_name}</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {this.props.data.periode}</Typography>
                                        {/* <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography> */}
                                        {this.props.defaultCurrency.id === 1 ?
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                            :
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in USD thousand</Typography>
                                        }
                                    </div>
                                    <div style={{ width: '50%' }}>
                                        <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                            {(this.props.permission.create || this.props.permission.edit) && this.props.isSubmit && <a data-tip={'Download Template'} data-for="template">
                                                <button
                                                    style={{
                                                        backgroundColor: 'transparent',
                                                        cursor: 'pointer',
                                                        borderColor: 'transparent',
                                                        margin: 5
                                                    }}
                                                    onClick={() => this.downloadTemplate()}
                                                >
                                                    <img src={Images.template} />
                                                </button>
                                            </a>}
                                            <ReactTooltip border={true} id="template" place="bottom" type="light" effect="solid" />
                                            {(this.props.permission.create || this.props.permission.edit) && this.props.isSubmit && <a data-tip={'Upload'} data-for="upload">
                                                <button
                                                    style={{
                                                        backgroundColor: 'transparent',
                                                        cursor: 'pointer',
                                                        borderColor: 'transparent',
                                                        margin: 5
                                                    }}
                                                    onClick={() => this.setState({ visibleUpload: true, editable: true })}
                                                >
                                                    <img src={Images.upload} />
                                                </button>
                                            </a>}
                                            <ReactTooltip border={true} id="upload" place="bottom" type="light" effect="solid" />
                                            {/* <a data-tip={'Download'} data-for="download">
                                                <button
                                                    style={{
                                                        backgroundColor: 'transparent',
                                                        cursor: 'pointer',
                                                        borderColor: 'transparent',
                                                        margin: 5
                                                    }}
                                                    onClick={() => this.downloadAllData()}
                                                >
                                                    <img src={Images.download} />
                                                </button>
                                            </a>
                                            <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" /> */}
                                        </div>
                                    </div>
                                </div>}

                                <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                    {this.state.loading && loadingComponent}
                                    <MuiThemeProvider theme={getMuiTheme()}>
                                        <MUIDataTable
                                            data={dataTable2}
                                            columns={columns}
                                            options={options}
                                        />
                                    </MuiThemeProvider>
                                    <div style={{ color: '#000', marginTop: 10, fontSize: 12 }}>(*) There may be discrepancies in amount due to rounding</div>
                                </div>
                                <div style={{ display: 'flex' }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 20 }}>Last Updated by : </Typography>
                                    <div style={{ marginLeft: 10, overflowY: 'scroll', height: this.state.updateBy.length < 2 ? 25 : 75, marginTop: 10 }}>
                                        {
                                            this.state.updateBy.length > 0 ? this.state.updateBy.reverse().map((item, index) => {
                                                return (
                                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>{item.latest_update}</Typography>
                                                )
                                            }) :
                                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>-</Typography>
                                        }
                                    </div>
                                </div>
                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10 }}>Notes : {this.state.notesUpdate}</Typography>
                            </div>
                            <div className="grid grid-2x">
                                <div className="col-1">
                                    <button
                                        className="button"
                                        type="button"
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                        }}
                                        onClick={() => {
                                            this.props.onClickClose()
                                            this.props.getReport()
                                        }
                                        }
                                    >
                                        <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                        </div>
                                    </button>
                                </div>
                                {!this.state.emptyData && (this.props.permission.create || this.props.permission.edit) && this.props.isSubmit && <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%' }}>
                                    <button
                                        type="button"
                                        onClick={() =>
                                            this.setState({ loading: true, editable: false }, () => {
                                                setTimeout(() => {
                                                    this.setState({ loading: false, buttonError: false })
                                                }, 100);
                                            })
                                        }
                                        style={{ marginRight: 20 }}
                                    >
                                        <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                            <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                        </div>
                                    </button>
                                    <button
                                        className="button"
                                        type="button"
                                        disabled={this.state.editable}
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: this.state.editable === true ? 'default' : 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none',
                                            marginRight: 20
                                        }}
                                        onClick={() => this.setState({ loading: true }, () => {
                                            setTimeout(() => {
                                                this.createData("draft")
                                            }, 100);
                                        })}
                                    >
                                        <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                        </div>
                                    </button>
                                    <button
                                        type="button"
                                        disabled={this.state.editable}
                                        onClick={() => this.setState({ loading: true }, () => {
                                            setTimeout(() => {
                                                this.createData("submitted")
                                            }, 100);
                                        })}
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: this.state.editable === true ? 'default' : 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none',
                                            marginRight: 20
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                        </div>
                                    </button>
                                </div>}
                            </div>
                        </Paper>
                        :
                        <Paper style={{ paddingTop: 10, paddingBottom: 20 }}>
                            <div>
                                <div style={{ padding: 25 }}>
                                    <div>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.data.company.company_name}</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {this.props.data.periode}</Typography>
                                        {/* <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography> */}
                                        {this.props.defaultCurrency.id === 1 ?
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                            :
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in USD thousand</Typography>
                                        }
                                    </div>
                                    {this.state.dataLoaded && (
                                        <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                            {this.state.loading && loadingComponent}
                                            <MuiThemeProvider theme={getMuiTheme()}>
                                                <MUIDataTable
                                                    data={dataTable2}
                                                    columns={columns}
                                                    options={options}
                                                />
                                            </MuiThemeProvider>
                                        </div>
                                    )}
                                </div>
                                <div className="grid grid-2x">
                                    <div className="col-1">
                                        <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                            }}
                                            onClick={() =>
                                                this.setState({ loading: true, visibleOI: true }, () => {
                                                    setTimeout(() => {
                                                        this.getDataDetail()
                                                    }, 100)
                                                })}
                                        >
                                            <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                            </div>
                                        </button>
                                    </div>
                                    {!this.state.emptyData && this.state.templateNull && <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%' }}>
                                        <button
                                            type="button"
                                            onClick={() =>
                                                this.setState({ loading: true, editable: false }, () => {
                                                    setTimeout(() => {
                                                        this.setState({ loading: false, buttonError: false })
                                                    }, 100);
                                                })
                                            }
                                            style={{ marginRight: 20 }}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                            </div>
                                        </button>
                                        <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: this.state.editable === true ? 'default' : 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            disabled={this.state.editable}
                                            onClick={() =>
                                                this.state.editable === true ?
                                                    null : this.setState({ loading: true }, () => {
                                                        setTimeout(() => {
                                                            this.uploadOI("draft")
                                                        }, 100);
                                                    })}
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                            </div>
                                        </button>
                                        <button
                                            type="button"
                                            onClick={() =>
                                                this.state.editable === true ?
                                                    null :
                                                    this.setState({ loading: true }, () => {
                                                        setTimeout(() => {
                                                            this.uploadOI("submitted")
                                                        }, 100);
                                                    })}
                                            disabled={this.state.editable}
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: this.state.editable === true ? 'default' : 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                            </div>
                                        </button>
                                    </div>}
                                </div>
                            </div>
                        </Paper>}
                </div>

                {this.state.visibleUpload && (
                    <div className="test app-popup-show">
                        <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                            <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                    <div className="popup-title">
                                        <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Upload File</span>
                                    </div>
                                </div>
                                <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        className="btn btn-circle btn-white"
                                        onClick={() => this.setState({ visibleUpload: false })}
                                    >
                                        <img src={Images.close} />
                                    </button>
                                </div>
                            </div>
                            <div style={{ padding: '25px 30px' }}>
                                <UploadFile
                                    type={this.state.uploadStatus}
                                    percentage={this.state.percentage}
                                    result={this.state.result}
                                    acceptedFiles={["xlsx"]}
                                    onHandle={(dt) => {
                                        this.fileHandler(dt)
                                        this.setState({ uploadStatus: 'idle', percentage: '0' })
                                    }}
                                    onUpload={() => {
                                        this.state.judul === "MASTER BUDGET - OPERATING INDICATOR" ?
                                            this.checkUpload() :
                                            this.setState({ alert: true, messageAlert: "Invalid Template", tipeAlert: 'warning' })
                                    }}
                                />
                            </div>
                            <div style={{ padding: '0px 30px 29px', fontSize: 17, color: 'red' }}><b>Warning:</b> Valid currency for uploading data in <b>{this.props.defaultCurrency.id == 1 ? "IDR mn" : "thousand USD"}</b></div>
                        </div>
                    </div>
                )}

                {this.state.visibleAlertSave && (
                    <div className="test app-popup-show">
                        <div className="popup-content border-radius" style={{ background: '#FFF27D', borderRadius: 10, width: 715, height: 238 }}>
                            <div style={{ margin: 30 }}>
                                <div style={{ display: 'flex', marginTop: 76, marginBottom: 43 }}>
                                    <div style={{ alignSelf: 'center', marginRight: 25 }}>
                                        <img src={Images.warning} />
                                    </div>
                                    <div style={{ justifyContent: 'center', fontSize: 20, color: '#1D2995', marginTop: 10 }}>
                                        <b>Rate Currency USD</b> pada periode yang dipilih <b>belum</b> diatur.<br /> Silahkan menghubungi Superadmin
                                    </div>
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'flex-end' }}>
                                    <button
                                        className="button"
                                        type="button"
                                        style={{
                                            background: '#F6F7F9',
                                            cursor: 'pointer',
                                            border: '1px solid #3549609e',
                                            outline: 'none',
                                            marginRight: 20,
                                            borderRadius: 9
                                        }}
                                        onClick={() => this.setState({ visibleAlertSave: false, loading: false })}
                                    >
                                        <div style={{ backgroundColor: '#fff', width: 105, height: 30, borderRadius: 9, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #3549609e' }}>
                                            <Typography style={{ fontSize: '15px', color: '#354960', textAlign: 'center' }}>Close</Typography>
                                        </div>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                )}
            </div>
        );
    }
}