import React, { Component } from 'react';
import OverlayLoader from './OverlayLoader';

class ContentContainer extends Component {
  render() {
    const {
      children,
      isLoading = false,
      backgroundColor = '#f8f8f8',
      flex = 1,
      padding = 0,
      style = {},
      loaderProps = {},
      ...restProps
    } = this.props;

    const containerStyle = {
      flex: flex,
      backgroundColor: backgroundColor,
      padding: padding,
      minHeight: '100px', // minimal height agar loader visible
      ...style,
    };

    return (
      <div style={containerStyle} {...restProps}>
        {isLoading && (
          <OverlayLoader isLoading={isLoading} {...loaderProps} />
        )}
        {children}
      </div>
    );
  }
}

export default ContentContainer;