import React, { Component } from 'react';
import { Typography, Paper, createMuiTheme, MuiThemeProvider, TableCell, FormControlLabel, TextField, Input, Tooltip, withStyles, Snackbar } from '@material-ui/core';
import MUIDataTable from 'mui-datatables';
import NumberFormat from 'react-number-format';
import api from '../../api';
import PropagateLoader from "react-spinners/PropagateLoader"
import Images from '../../assets/Images';
import ReactTooltip from 'react-tooltip';
import UploadFile from "../../library/Upload";
import { ExcelRenderer } from 'react-excel-renderer';
import { Alert, Autocomplete } from '@material-ui/lab';
import Constant from '../../library/Constant';
import * as R from 'ramda'
import { fixNumber, titleCase } from '../../library/Utils';

const LightTooltip = withStyles((theme) => ({
    tooltip: {
        backgroundColor: theme.palette.common.white,
        color: 'rgba(0, 0, 0, 0.87)',
        boxShadow: theme.shadows[1],
        fontSize: 11,
    },
}))(Tooltip);

var ct = require("../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable3());

const options = ct.customOptionsFixedColumn();
const style = {
    position: "sticky",
    left: 0,
    background: "white",
    zIndex: 101,
};
const style2 = {
    position: "sticky",
    background: "white",
    zIndex: 100
};

export default class FixedAssetsMovement extends Component {
    constructor(props) {
        super(props)
        this.state = {
            dataTable: [],
            visibleFixedAssetsMovement: true,
            disabledSave: true,
            editable: false,
            buttonError: false,
            judulColumn: null,
            updateBy: [],
            handleDoubleClick: 0,
            defaultCurrencyUpload: this.props.defaultCurrency,
            visibleAlertSave: false,
        }
        this.handleValue = this.handleValue.bind(this)
        this.fileHandler = this.fileHandler.bind(this);
    }

    componentDidMount() {
        this.getItemHierarki()
        this.getLatestUpdate()
    }

    getLatestUpdate() {
        let payload = {
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "submission_id": this.props.submissionID,
            "currency_id": this.props.defaultCurrency.id
        }
        api.create().getLastestUpdateMB(payload).then(response => {
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        updateBy: response.data.data.detail === null ? [] : response.data.data.detail
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, typeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    getItemHierarki() {
        this.setState({ loading: true })
        let payload = {
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "submission_id": this.props.submissionID,
            "currency_id": this.props.defaultCurrency.id
        }
        api.create().getDetailReportMB(payload).then(response => {
            console.log(response);
            let dataTable = []
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        let res = response.data.data
                        const handlePushChild = (item) => {
                            let indexIDzz = dataTable.findIndex((val) => val[1] === item.id)
                            if (indexIDzz === -1) {
                                dataTable.push([
                                    item.type_report_id,
                                    item.id,
                                    item.parent,
                                    item.formula,
                                    item.level,
                                    item.description,
                                    item.fixed_asset_movement.total_actual_before === null ? "0" : item.fixed_asset_movement.total_actual_before === "" ? "0" : item.fixed_asset_movement.total_actual_before,
                                    this.props.status === 'CLOSED' ? Number(item.fixed_asset_movement.january) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.fixed_asset_movement.january, formula: item.fixed_asset_movement.january_formula } : Number(item.fixed_asset_movement.january),
                                    this.props.status === 'CLOSED' ? Number(item.fixed_asset_movement.february) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.fixed_asset_movement.february, formula: item.fixed_asset_movement.february_formula } : Number(item.fixed_asset_movement.february),
                                    this.props.status === 'CLOSED' ? Number(item.fixed_asset_movement.march) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.fixed_asset_movement.march, formula: item.fixed_asset_movement.march_formula } : Number(item.fixed_asset_movement.march),
                                    this.props.status === 'CLOSED' ? Number(item.fixed_asset_movement.april) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.fixed_asset_movement.april, formula: item.fixed_asset_movement.april_formula } : Number(item.fixed_asset_movement.april),
                                    this.props.status === 'CLOSED' ? Number(item.fixed_asset_movement.may) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.fixed_asset_movement.may, formula: item.fixed_asset_movement.may_formula } : Number(item.fixed_asset_movement.may),
                                    this.props.status === 'CLOSED' ? Number(item.fixed_asset_movement.june) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.fixed_asset_movement.june, formula: item.fixed_asset_movement.june_formula } : Number(item.fixed_asset_movement.june),
                                    this.props.status === 'CLOSED' ? Number(item.fixed_asset_movement.july) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.fixed_asset_movement.july, formula: item.fixed_asset_movement.july_formula } : Number(item.fixed_asset_movement.july),
                                    this.props.status === 'CLOSED' ? Number(item.fixed_asset_movement.august) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.fixed_asset_movement.august, formula: item.fixed_asset_movement.august_formula } : Number(item.fixed_asset_movement.august),
                                    this.props.status === 'CLOSED' ? Number(item.fixed_asset_movement.september) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.fixed_asset_movement.september, formula: item.fixed_asset_movement.september_formula } : Number(item.fixed_asset_movement.september),
                                    this.props.status === 'CLOSED' ? Number(item.fixed_asset_movement.october) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.fixed_asset_movement.october, formula: item.fixed_asset_movement.october_formula } : Number(item.fixed_asset_movement.october),
                                    this.props.status === 'CLOSED' ? Number(item.fixed_asset_movement.november) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.fixed_asset_movement.november, formula: item.fixed_asset_movement.november_formula } : Number(item.fixed_asset_movement.november),
                                    this.props.status === 'CLOSED' ? Number(item.fixed_asset_movement.december) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.fixed_asset_movement.december, formula: item.fixed_asset_movement.december_formula } : Number(item.fixed_asset_movement.december),
                                    Number(item.fixed_asset_movement.total_current_year),
                                    Number(item.fixed_asset_movement.total_next_year),
                                    Number(item.fixed_asset_movement.total_more_year),
                                    item.order,
                                    item.fixed_asset_movement.forecast_formula,
                                    item.fixed_asset_movement.before_formula
                                ])
                            }
                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        }
                        res.map((item, index) => {
                            dataTable.push([
                                item.type_report_id,
                                item.id,
                                item.parent,
                                item.formula,
                                item.level,
                                item.description,
                                item.fixed_asset_movement.total_actual_before === null ? "0" : item.fixed_asset_movement.total_actual_before === "" ? "0" : item.fixed_asset_movement.total_actual_before,
                                this.props.status === 'CLOSED' ? Number(item.fixed_asset_movement.january) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.fixed_asset_movement.january, formula: item.fixed_asset_movement.january_formula } : Number(item.fixed_asset_movement.january),
                                this.props.status === 'CLOSED' ? Number(item.fixed_asset_movement.february) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.fixed_asset_movement.february, formula: item.fixed_asset_movement.february_formula } : Number(item.fixed_asset_movement.february),
                                this.props.status === 'CLOSED' ? Number(item.fixed_asset_movement.march) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.fixed_asset_movement.march, formula: item.fixed_asset_movement.march_formula } : Number(item.fixed_asset_movement.march),
                                this.props.status === 'CLOSED' ? Number(item.fixed_asset_movement.april) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.fixed_asset_movement.april, formula: item.fixed_asset_movement.april_formula } : Number(item.fixed_asset_movement.april),
                                this.props.status === 'CLOSED' ? Number(item.fixed_asset_movement.may) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.fixed_asset_movement.may, formula: item.fixed_asset_movement.may_formula } : Number(item.fixed_asset_movement.may),
                                this.props.status === 'CLOSED' ? Number(item.fixed_asset_movement.june) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.fixed_asset_movement.june, formula: item.fixed_asset_movement.june_formula } : Number(item.fixed_asset_movement.june),
                                this.props.status === 'CLOSED' ? Number(item.fixed_asset_movement.july) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.fixed_asset_movement.july, formula: item.fixed_asset_movement.july_formula } : Number(item.fixed_asset_movement.july),
                                this.props.status === 'CLOSED' ? Number(item.fixed_asset_movement.august) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.fixed_asset_movement.august, formula: item.fixed_asset_movement.august_formula } : Number(item.fixed_asset_movement.august),
                                this.props.status === 'CLOSED' ? Number(item.fixed_asset_movement.september) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.fixed_asset_movement.september, formula: item.fixed_asset_movement.september_formula } : Number(item.fixed_asset_movement.september),
                                this.props.status === 'CLOSED' ? Number(item.fixed_asset_movement.october) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.fixed_asset_movement.october, formula: item.fixed_asset_movement.october_formula } : Number(item.fixed_asset_movement.october),
                                this.props.status === 'CLOSED' ? Number(item.fixed_asset_movement.november) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.fixed_asset_movement.november, formula: item.fixed_asset_movement.november_formula } : Number(item.fixed_asset_movement.november),
                                this.props.status === 'CLOSED' ? Number(item.fixed_asset_movement.december) : item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.fixed_asset_movement.december, formula: item.fixed_asset_movement.december_formula } : Number(item.fixed_asset_movement.december),
                                Number(item.fixed_asset_movement.total_current_year),
                                Number(item.fixed_asset_movement.total_next_year),
                                Number(item.fixed_asset_movement.total_more_year),
                                item.order,
                                item.fixed_asset_movement.forecast_formula,
                                item.fixed_asset_movement.before_formula
                            ])
                            if (item.children !== null) {
                                if (item.children.length > 0) {
                                    item.children.map((items, indexs) => {
                                        handlePushChild(items)
                                    })
                                }
                            }
                        })
                        console.log(dataTable)
                        this.setState({ dataTable, loading: false, buttonError: true, editable: true })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error', loading: false })
                }
            } else {
                this.setState({ alert: true, messageAlert: 'Connection Timeout, please check your Connection', tipeAlert: 'error', loading: false })
            }
        })
    }

    handleValue(data) {
        let total = 0
        this.state.dataTable.map((item, index) => {
            if (data.rowData[1] == item[2]) {
                total = item[data.columnIndex] == undefined ? (Number(total) + 0) : (Number(total) + Number(item[data.columnIndex]))
            }
        })
        let indexParent = this.state.dataTable.findIndex((val) => val[1] == this.state.dataTable[data.rowIndex][2])
        let a = this.state.dataTable[data.rowIndex][data.columnIndex] = total
        // // console.log(indexParent);
        return a
    }

    handleChange(value, tableMeta) {
        let val = String(value).split(",").join("")
        let data = this.state.dataTable
        let indexParent = data.findIndex((val) => val[1] == data[tableMeta.rowIndex][2])
        if (indexParent > 0) {
            // // console.log(indexParent)
            let a = data[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
            let jagain = data[indexParent][tableMeta.columnIndex]
            a = data[indexParent][tableMeta.columnIndex] = jagain == undefined ? (0 + Number(val)) : (jagain + Number(val))
        } else {
            data[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
        }
    }

    backToMasterBudget(type) {
        console.log("masuk sini");
        let data = []
        if (this.props.defaultCurrency.id == 2) {
            this.state.dataTable.map(i => {
                data.push({
                    item_report_id: i[1],
                    total_actual_before: String(Number(i[6])),
                    january: i[0] === 5 || i[0] === 6 ? String(Number(i[7].value)) : String(Number(i[7])),
                    february: i[0] === 5 || i[0] === 6 ? String(Number(i[8].value)) : String(Number(i[8])),
                    march: i[0] === 5 || i[0] === 6 ? String(Number(i[9].value)) : String(Number(i[9])),
                    april: i[0] === 5 || i[0] === 6 ? String(Number(i[10].value)) : String(Number(i[10])),
                    may: i[0] === 5 || i[0] === 6 ? String(Number(i[11].value)) : String(Number(i[11])),
                    june: i[0] === 5 || i[0] === 6 ? String(Number(i[12].value)) : String(Number(i[12])),
                    july: i[0] === 5 || i[0] === 6 ? String(Number(i[13].value)) : String(Number(i[13])),
                    august: i[0] === 5 || i[0] === 6 ? String(Number(i[14].value)) : String(Number(i[14])),
                    september: i[0] === 5 || i[0] === 6 ? String(Number(i[15].value)) : String(Number(i[15])),
                    october: i[0] === 5 || i[0] === 6 ? String(Number(i[16].value)) : String(Number(i[16])),
                    november: i[0] === 5 || i[0] === 6 ? String(Number(i[17].value)) : String(Number(i[17])),
                    december: i[0] === 5 || i[0] === 6 ? String(Number(i[18].value)) : String(Number(i[18])),
                    total_current_year: String(Number(i[19])),
                    total_next_year: String(Number(i[20])),
                    total_more_year: String(Number(i[21]))
                })
            })
        } else {
            this.state.dataTable.map(i => {
                data.push({
                    item_report_id: i[1],
                    total_actual_before: String(fixNumber(Number(i[6]), 1)),
                    january: i[0] === 5 || i[0] === 6 ? String(fixNumber(Number(i[7].value), 1)) : String(fixNumber(Number(i[7]), 1)),
                    february: i[0] === 5 || i[0] === 6 ? String(fixNumber(Number(i[8].value), 1)) : String(fixNumber(Number(i[8]), 1)),
                    march: i[0] === 5 || i[0] === 6 ? String(fixNumber(Number(i[9].value), 1)) : String(fixNumber(Number(i[9]), 1)),
                    april: i[0] === 5 || i[0] === 6 ? String(fixNumber(Number(i[10].value), 1)) : String(fixNumber(Number(i[10]), 1)),
                    may: i[0] === 5 || i[0] === 6 ? String(fixNumber(Number(i[11].value), 1)) : String(fixNumber(Number(i[11]), 1)),
                    june: i[0] === 5 || i[0] === 6 ? String(fixNumber(Number(i[12].value), 1)) : String(fixNumber(Number(i[12]), 1)),
                    july: i[0] === 5 || i[0] === 6 ? String(fixNumber(Number(i[13].value), 1)) : String(fixNumber(Number(i[13]), 1)),
                    august: i[0] === 5 || i[0] === 6 ? String(fixNumber(Number(i[14].value), 1)) : String(fixNumber(Number(i[14]), 1)),
                    september: i[0] === 5 || i[0] === 6 ? String(fixNumber(Number(i[15].value), 1)) : String(fixNumber(Number(i[15]), 1)),
                    october: i[0] === 5 || i[0] === 6 ? String(fixNumber(Number(i[16].value), 1)) : String(fixNumber(Number(i[16]), 1)),
                    november: i[0] === 5 || i[0] === 6 ? String(fixNumber(Number(i[17].value), 1)) : String(fixNumber(Number(i[17]), 1)),
                    december: i[0] === 5 || i[0] === 6 ? String(fixNumber(Number(i[18].value), 1)) : String(fixNumber(Number(i[18]), 1)),
                    total_current_year: String(fixNumber(Number(i[19]), 1)),
                    total_next_year: String(fixNumber(Number(i[20]), 1)),
                    total_more_year: String(fixNumber(Number(i[21]), 1))
                })
            })
        }
        
        let payload = {
            "submission_id": this.props.submissionID,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "currency_id": this.props.defaultCurrency.id,
            "status": type,
            "fixed_asset_movement": data
        }
        // // console.log(data);
        if (type == 'submitted') {
            this.props.saveToMasterBudget(payload, 'FAM')
        } else {
            this.props.saveToMasterBudget(payload, 'DraftFAM')
        }
        // this.props.onClickClose()
    }

    downloadTemplate = async () => {
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/master_budget/download_template?report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&currency_id=${this.props.defaultCurrency.id}`
        )
        res = await res.blob()
        // // console.log(res)
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Template Master Budget Fixed Assets Movement.xlsx';
            a.click();
        }
    }

    fileHandler = (event) => {
        let fileObj = event
        ExcelRenderer(fileObj, (err, resp) => {
            // // console.log(resp)
            if (err) {
                // console.log(err);
            }
            else {
                let isi = resp.rows.slice(3)
                // // console.log(resp.rows[2]);
                let payload = []
                let reg = /^[-+]?(?:[0-9]+,)*[0-9]+(?:\.[0-9]+)?$/;
                isi.map((i, index) => {
                    if (i.length > 0) {
                        payload.push({
                            item_report_id: i[0] === undefined ? "" : String(i[0]).trim(),
                            item_report: i[1] === undefined ? "" : String(i[1]).trim(),
                            total_actual_before: i[2] === undefined ? "0" : reg.test(String(i[2])) === false ? "0" : String(i[2]).trim(),
                            january: i[3] === undefined ? "0" : reg.test(String(i[3])) === false ? "0" : String(i[3]).trim(),
                            february: i[4] === undefined ? "0" : reg.test(String(i[4])) === false ? "0" : String(i[4]).trim(),
                            march: i[5] === undefined ? "0" : reg.test(String(i[5])) === false ? "0" : String(i[5]).trim(),
                            april: i[6] === undefined ? "0" : reg.test(String(i[6])) === false ? "0" : String(i[6]).trim(),
                            may: i[7] === undefined ? "0" : reg.test(String(i[7])) === false ? "0" : String(i[7]).trim(),
                            june: i[8] === undefined ? "0" : reg.test(String(i[8])) === false ? "0" : String(i[8]).trim(),
                            july: i[9] === undefined ? "0" : reg.test(String(i[9])) === false ? "0" : String(i[9]).trim(),
                            august: i[10] === undefined ? "0" : reg.test(String(i[10])) === false ? "0" : String(i[10]).trim(),
                            september: i[11] === undefined ? "0" : reg.test(String(i[11])) === false ? "0" : String(i[11]).trim(),
                            october: i[12] === undefined ? "0" : reg.test(String(i[12])) === false ? "0" : String(i[12]).trim(),
                            november: i[13] === undefined ? "0" : reg.test(String(i[13])) === false ? "0" : String(i[13]).trim(),
                            december: i[14] === undefined ? "0" : reg.test(String(i[14])) === false ? "0" : String(i[14]).trim(),
                            total_current_year: i[15] === undefined ? "0" : reg.test(String(i[15])) === false ? "0" : String(i[15]).trim(),
                            total_next_year: i[16] === undefined ? "0" : reg.test(String(i[16])) === false ? "0" : String(i[16]).trim(),
                            total_more_year: i[17] === undefined ? "0" : reg.test(String(i[17])) === false ? "0" : String(i[17]).trim()
                        })
                    }
                })
                let body = {
                    company_id: this.props.company.company_id,
                    periode: this.props.periode,
                    report_id: this.props.report_id,
                    fixed_asset_movement: payload,
                    status: 'submitted'
                }
                // // console.log(body)
                this.setState({ payload: body, judul: resp.rows[1][0], judulColumn: resp.rows[2] })
            }
        });
    }

    checkUpload() {
        let payload = {
            ...this.state.payload,
            currency_id: this.state.defaultCurrencyUpload?.id
        }
        api.create().checkUploadMB(payload).then(response => {
            // // console.log(JSON.stringify(this.state.payload));
            // // console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        this.setState({ visibleUpload: false, visibleFixedAssetsMovement: false, loading: true })
                        let dataTable = response.data.data.map((item, index) => {
                            return [
                                item.type_report_id,
                                item.item_report_id,
                                item.parent,
                                item.formula,
                                item.level,
                                item.item_report,
                                item.total_actual_before,
                                item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.january, formula: item.january_formula } : Number(item.january),
                                item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.february, formula: item.february_formula } : Number(item.february),
                                item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.march, formula: item.march_formula } : Number(item.march),
                                item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.april, formula: item.april_formula } : Number(item.april),
                                item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.may, formula: item.may_formula } : Number(item.may),
                                item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.june, formula: item.june_formula } : Number(item.june),
                                item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.july, formula: item.july_formula } : Number(item.july),
                                item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.august, formula: item.august_formula } : Number(item.august),
                                item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.september, formula: item.september_formula } : Number(item.september),
                                item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.october, formula: item.october_formula } : Number(item.october),
                                item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.november, formula: item.november_formula } : Number(item.november),
                                item.type_report_id == 5 || item.type_report_id == 6 ? { value: item.december, formula: item.december_formula } : Number(item.december),
                                Number(item.total_current_year),
                                Number(item.total_next_year),
                                Number(item.total_more_year),
                                item.orders,
                                item.forecast_formula,
                                item.before_formula,
                                item.error
                            ]
                        })
                        this.setState({ dataTable, dataLoaded: true, loading: false, buttonError: false, editable: true }, () => {
                            this.state.dataTable.map(item => {
                                if (item[24].length > 0) {
                                    // // console.log('masuk')
                                    this.setState({ buttonError: true, errorPreview: true, editable: true })
                                }
                            })
                            // // console.log(this.state.dataTable);
                        })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    uploadFAM(type) {
        console.log("masuk ga?");
        let data = []
        if (this.state.defaultCurrencyUpload?.id == 2) {
            this.state.dataTable.map(i => {
                data.push({
                    item_report_id: i[1],
                    total_actual_before: String(Number(i[6])),
                    january: i[0] === 5 || i[0] === 6 ? String(Number(i[7].value)) : String(Number(i[7])),
                    february: i[0] === 5 || i[0] === 6 ? String(Number(i[8].value)) : String(Number(i[8])),
                    march: i[0] === 5 || i[0] === 6 ? String(Number(i[9].value)) : String(Number(i[9])),
                    april: i[0] === 5 || i[0] === 6 ? String(Number(i[10].value)) : String(Number(i[10])),
                    may: i[0] === 5 || i[0] === 6 ? String(Number(i[11].value)) : String(Number(i[11])),
                    june: i[0] === 5 || i[0] === 6 ? String(Number(i[12].value)) : String(Number(i[12])),
                    july: i[0] === 5 || i[0] === 6 ? String(Number(i[13].value)) : String(Number(i[13])),
                    august: i[0] === 5 || i[0] === 6 ? String(Number(i[14].value)) : String(Number(i[14])),
                    september: i[0] === 5 || i[0] === 6 ? String(Number(i[15].value)) : String(Number(i[15])),
                    october: i[0] === 5 || i[0] === 6 ? String(Number(i[16].value)) : String(Number(i[16])),
                    november: i[0] === 5 || i[0] === 6 ? String(Number(i[17].value)) : String(Number(i[17])),
                    december: i[0] === 5 || i[0] === 6 ? String(Number(i[18].value)) : String(Number(i[18])),
                    total_current_year: String(Number(i[19])),
                    total_next_year: String(Number(i[20])),
                    total_more_year: String(Number(i[21]))
                })
            })
        } else {
            this.state.dataTable.map(i => {
                data.push({
                    item_report_id: i[1],
                    total_actual_before: String(fixNumber(Number(i[6]), 1)),
                    january: i[0] === 5 || i[0] === 6 ? String(fixNumber(Number(i[7].value), 1)) : String(fixNumber(Number(i[7]), 1)),
                    february: i[0] === 5 || i[0] === 6 ? String(fixNumber(Number(i[8].value), 1)) : String(fixNumber(Number(i[8]), 1)),
                    march: i[0] === 5 || i[0] === 6 ? String(fixNumber(Number(i[9].value), 1)) : String(fixNumber(Number(i[9]), 1)),
                    april: i[0] === 5 || i[0] === 6 ? String(fixNumber(Number(i[10].value), 1)) : String(fixNumber(Number(i[10]), 1)),
                    may: i[0] === 5 || i[0] === 6 ? String(fixNumber(Number(i[11].value), 1)) : String(fixNumber(Number(i[11]), 1)),
                    june: i[0] === 5 || i[0] === 6 ? String(fixNumber(Number(i[12].value), 1)) : String(fixNumber(Number(i[12]), 1)),
                    july: i[0] === 5 || i[0] === 6 ? String(fixNumber(Number(i[13].value), 1)) : String(fixNumber(Number(i[13]), 1)),
                    august: i[0] === 5 || i[0] === 6 ? String(fixNumber(Number(i[14].value), 1)) : String(fixNumber(Number(i[14]), 1)),
                    september: i[0] === 5 || i[0] === 6 ? String(fixNumber(Number(i[15].value), 1)) : String(fixNumber(Number(i[15]), 1)),
                    october: i[0] === 5 || i[0] === 6 ? String(fixNumber(Number(i[16].value), 1)) : String(fixNumber(Number(i[16]), 1)),
                    november: i[0] === 5 || i[0] === 6 ? String(fixNumber(Number(i[17].value), 1)) : String(fixNumber(Number(i[17]), 1)),
                    december: i[0] === 5 || i[0] === 6 ? String(fixNumber(Number(i[18].value), 1)) : String(fixNumber(Number(i[18]), 1)),
                    total_current_year: String(fixNumber(Number(i[19]), 1)),
                    total_next_year: String(fixNumber(Number(i[20]), 1)),
                    total_more_year: String(fixNumber(Number(i[21]), 1))
                })
            })
        }
        
        let body = {
            submission_id: this.props.submissionID,
            company_id: this.props.company.company_id,
            periode: this.props.periode,
            report_id: this.props.report_id,
            currency_id: this.state.defaultCurrencyUpload?.id,
            fixed_asset_movement: data,
            status: type
        }
        // // console.log(JSON.stringify(body));
        api.create('UPLOAD').uploadMasterBudget(body).then(response => {
            console.log(response);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === "success") {
                        this.props.onClickClose()
                        if (type == 'submitted') {
                            this.props.getReport('FAM')
                        } else {
                            this.props.getReport()
                        }
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                // this.setState({ loading: false })
                // alert(response.problem)
                this.setState({ alert: true, messageAlert: 'Error saving data. Please try again', tipeAlert: 'error', loading: false })
            }
        })
    }

    async downloadAllData() {
        // let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/master_budget/export_master_budget?submission_id=${this.props.submissionID}&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}`
        // // console.log(url);
        let resReal = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/master_budget/export_master_budget?submission_id=${this.props.submissionID}&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}`
        let resNull = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/master_budget/export_master_budget?submission_id=&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}`
        let res = await fetch(
            this.props.submissionID == null ? resNull : resReal
        )
        res = await res.blob()
        this.setState({ loading: false })
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Master Budget Fixed Assets Movement.xlsx';
            a.click();
        }
    }

    handleValidate() {
        let data = []
        // // console.log(this.state.dataTable)
        this.state.dataTable.map(i => {
            data.push({
                item_report_id: i[1],
                total_actual_before: String(i[6]),
                january: i[0] === 3 && i[7] === "" ? "0" : i[0] === 5 || i[0] === 6 ? String(i[7].value) : String(i[7]),
                february: i[0] === 3 && i[8] === "" ? "0" : i[0] === 5 || i[0] === 6 ? String(i[8].value) : String(i[8]),
                march: i[0] === 3 && i[9] === "" ? "0" : i[0] === 5 || i[0] === 6 ? String(i[9].value) : String(i[9]),
                april: i[0] === 3 && i[10] === "" ? "0" : i[0] === 5 || i[0] === 6 ? String(i[10].value) : String(i[10]),
                may: i[0] === 3 && i[11] === "" ? "0" : i[0] === 5 || i[0] === 6 ? String(i[11].value) : String(i[11]),
                june: i[0] === 3 && i[12] === "" ? "0" : i[0] === 5 || i[0] === 6 ? String(i[12].value) : String(i[12]),
                july: i[0] === 3 && i[13] === "" ? "0" : i[0] === 5 || i[0] === 6 ? String(i[13].value) : String(i[13]),
                august: i[0] === 3 && i[14] === "" ? "0" : i[0] === 5 || i[0] === 6 ? String(i[14].value) : String(i[14]),
                september: i[0] === 3 && i[15] === "" ? "0" : i[0] === 5 || i[0] === 6 ? String(i[15].value) : String(i[15]),
                october: i[0] === 3 && i[16] === "" ? "0" : i[0] === 5 || i[0] === 6 ? String(i[16].value) : String(i[16]),
                november: i[0] === 3 && i[17] === "" ? "0" : i[0] === 5 || i[0] === 6 ? String(i[17].value) : String(i[17]),
                december: i[0] === 3 && i[18] === "" ? "0" : i[0] === 5 || i[0] === 6 ? String(i[18].value) : String(i[18]),
                total_current_year: i[0] === 3 && i[19] === "" ? "0" : String(i[19]),
                total_next_year: i[0] === 3 && i[20] === "" ? "0" : String(i[20]),
                total_more_year: i[0] === 3 && i[21] === "" ? "0" : String(i[21])
            })
        })
        // // console.log(JSON.stringify(data))
        let payload = {
            "submission_id": this.props.submissionID,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "currency_id": this.props.defaultCurrency.id,
            "fixed_asset_movement": data,
            "status": "submitted"
        }
        console.log(payload);
        api.create().validateSubmitReport(payload).then((response) => {
            console.log(response)
            if (response.data.data.result) {
                this.setState({ loading: false, buttonError: false, editable: false })
            } else {
                this.setState({ loading: false, buttonError: true, editable: true })
            }
        })
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    render() {
        let dataTable2 = this.state.dataTable
        const handleValueFormula = (value, tableMeta, Bfr) => {
            let splitFormula = String(tableMeta.rowData[3]).split('@')
            let baru = []
            let anjay = []
            splitFormula.map((item, index) => {
                let items = String(item).substr(Number(String(item).length) - 1, 1)
                let re = /^[a-zA-Z0-9_]+$/;
                let asd = ''
                if (item !== "") {
                    if (!re.test(items)) {
                        baru.push(String(item).substr(0, Number(String(item).length) - 1))
                        baru.push(String(item).substr(Number(String(item).length) - 1, 1))
                    } else {
                        baru.push(String(item))
                    }
                }
            })

            // if (tableMeta.columnIndex == 18) {
            //     // console.log(splitFormula)
            //     // console.log(baru)
            // }
            // // console.log(baru)
            let tambahan = false
            let opet = ""
            baru.map((item, index) => {
                if (item == 'X') {
                    tambahan = true
                } else if (item == '-' || item == '+' || item == '/' || item == '*') {
                    anjay.push(item)
                } else {
                    if (String(item).includes('#')) {
                        if (Bfr !== undefined) {
                            let data = 24
                            let period = Number(this.props.periode) - 1
                            anjay.push(0)
                            let indexID = dataTable2[tableMeta.rowIndex][data].findIndex((val) => val.item_formula == String(`@${item}`) && val.periode == period)
                            if (indexID !== -1) {
                                let valuezz = dataTable2[tableMeta.rowIndex][data][indexID].value
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            }
                        } else if (String(item).includes('[M-1]')) {
                            let tst = String(item).replace('[M-1]', '')
                            let data = tableMeta.columnIndex == 7 ? 18 : tableMeta.columnIndex - 1
                            let period = data == 18 ? Number(this.props.periode) - 1 : this.props.periode
                            let indexID = tableMeta.rowData[data].formula.findIndex((val) => val.item_formula == String(`@${tst}`) && val.periode == period)
                            if (indexID !== -1) {
                                let valuezz = tableMeta.rowData[data].formula[indexID].value
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            }
                        } else {
                            let indexID = value.formula.findIndex((val) => val.item_formula == String(`@${item}`) && val.periode == Number(this.props.periode))
                            // // console.log(indexID)
                            if (indexID !== -1) {
                                // // console.log(value.formula[indexID].value)
                                let valuezz = value.formula[indexID].value
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            }
                        }
                    } else {
                        // // console.log(item)
                        let indexID = dataTable2.findIndex((val) => val[22] == item)
                        if (item == 'X-1') {
                            anjay.push(-1)
                        } else if (tambahan) {
                            if (item == '-' || item == '+' || item == '/' || item == '*') {
                                opet = item
                            } else {
                                anjay.push(opet == '' ? Number(item) : Number(String(opet + String(item))))
                                tambahan = false
                                opet = ""
                            }
                        } else {
                            if (indexID !== -1) {
                                let valuezz = dataTable2[indexID][tableMeta.columnIndex].value == undefined ? dataTable2[indexID][tableMeta.columnIndex] : dataTable2[indexID][tableMeta.columnIndex].value
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            } else {
                                if (item === '(-1)') {
                                    anjay.push(-1)
                                }
                                // // console.log(item);
                            }
                        }
                    }
                }
            })
            // // console.log(baru)
            // // console.log(anjay)

            let total = 0
            let opt = ""
            anjay.map((item, index) => {
                if (item == "+") {
                    opt = "tambah"
                } else if (item == "-") {
                    opt = "kurang"
                } else if (item == "*") {
                    opt = "kali"
                } else if (item == "/") {
                    opt = "bagi"
                } else {
                    item = item == "" ? 0 : item
                    if (opt == "tambah") {
                        total = Number(total) + Number(item)
                    } else if (opt == "kurang") {
                        total = Number(total) - Number(item)
                    } else if (opt == "kali") {
                        total = Number(total) * Number(item)
                    } else if (opt == "bagi") {
                        total = Number(total) / Number(item) == NaN ? 0 : Number(total) / Number(item)
                    } else {
                        total += Number(item)
                    }
                }
            })
            total = R.equals(total, NaN) ? "0.0" : total
            // // console.log(dataTable2[tableMeta.rowIndex][22])
            // // console.log(tableMeta.rowData[5])
            // if (tableMeta.rowData[5] == 'Beginning Balance') {
            // console.log(baru)
            // console.log(anjay)
            // console.log(total)
            // }

            if (dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].value == undefined) {
                // // console.log([tableMeta.rowIndex][tableMeta.columnIndex])
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = total
            } else {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].value = total
            }

            return total
        }

        const handleChange = (value, tableMeta, type) => {
            let val = String(value).split(",").join("")
            if (type === "actual") {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
            } else {
                let indexParent = dataTable2.findIndex((val) => val[1] == dataTable2[tableMeta.rowIndex][2])
                if (indexParent > 0) {
                    let a = 0
                    // // console.log(indexParent)
                    if (String(tableMeta.rowData[5]).toLocaleLowerCase() == 'beginning balance') {
                        a = dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].value = Number(val)
                    } else {
                        a = dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
                    }
                    let jagain = dataTable2[indexParent][tableMeta.columnIndex]
                    a = dataTable2[indexParent][tableMeta.columnIndex] = jagain == undefined ? (0 + Number(val)) : (jagain + Number(val))
                } else {
                    if (String(tableMeta.rowData[5]).toLocaleLowerCase() == 'beginning balance') {
                        dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].value = Number(val)
                    } else {
                        dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
                    }
                    // dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
                }
            }
        }
        const handleForecast = (tableMeta, periode) => {
            let total = 0
            if (String(tableMeta.rowData[5]).toLocaleLowerCase() == 'gain/ (loss) on fixed assets' || String(tableMeta.rowData[5]).toLocaleLowerCase() == 'ending balance' || String(tableMeta.rowData[5]).toLocaleLowerCase() == 'beginning balance') {
                if (String(tableMeta.rowData[5]).toLocaleLowerCase() == 'beginning balance') {
                    let indexID = dataTable2.findIndex((val, index) => String(val[5]).toLocaleLowerCase() == 'ending balance' && dataTable2[index - 1][2] == tableMeta.rowData[2])
                    if (indexID !== -1) {
                        // console.log(dataTable2)
                        total = tableMeta.columnIndex == 21 ? dataTable2[indexID][20] : dataTable2[indexID][18].value
                    }
                } else {
                    let indexID = dataTable2[tableMeta.rowIndex][23].findIndex((val) => val.periode == periode)
                    if (indexID !== -1) {
                        total = dataTable2[tableMeta.rowIndex][23][indexID].value
                    }
                }
            } else {
                total = handleValueFormula(tableMeta.columnIndex, tableMeta)
            }
            dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = total
            return total
        }
        const handleTotal = (tableMeta) => {
            let total = 0
            // console.log(tableMeta)            
            // if (tableMeta.rowData[5] == 'Beginning balance') {
            //     console.log(tableMeta.rowData)
            // }
            if (String(tableMeta.rowData[5]).toLocaleLowerCase() == 'ending balance') {
                total = dataTable2[tableMeta.rowIndex][18].value
                dataTable2[tableMeta.rowIndex][19] = total
            } else if (String(tableMeta.rowData[5]).toLocaleLowerCase() == 'beginning balance') {
                total = dataTable2[tableMeta.rowIndex][7].value
                dataTable2[tableMeta.rowIndex][19] = total
            } else {
                dataTable2[tableMeta.rowIndex].map((item, index) => {
                    if (index >= 7 && index <= 18) {
                        let valItem = item.value == undefined ? item == undefined || item == "" ? 0 : item : item.value == "" ? 0 : item.value
                        total += Number(valItem)
                    }
                })
                dataTable2[tableMeta.rowIndex][19] = total
            }
            return total
            // // console.log(total);
        }
        const handleValue = (data) => {
            let total = 0
            dataTable2.map((item, index) => {
                if (data.rowData[1] == item[2]) {
                    total = item[data.columnIndex] == undefined ? (Number(total) + 0) : (Number(total) + Number(item[data.columnIndex]))
                }
            })
            let indexParent = dataTable2.findIndex((val) => val[1] == dataTable2[data.rowIndex][2])
            let a = dataTable2[data.rowIndex][data.columnIndex] = Number(total)
            // // console.log(indexParent);
            return a
        }

        const handleBfr = (value, tableMeta) => {
            let total = 0
            total = handleValueFormula(value, tableMeta, 'before')
            return total
        }

        const handleFormula = (data, tableMeta, month) => {
            let rilFormula = String(tableMeta.rowData[3])
            if (rilFormula.includes("#")) {
                if (this.props.status === "not-yet") {
                    let splitOrder = String(tableMeta.rowData[3]).split('@')
                    for (let index = 0; index < splitOrder.length; index++) {
                        if (splitOrder[index] === "") {
                        } else {
                            if (splitOrder[index].includes('#')) {

                            } else {
                                let splitOperator = splitOrder[index].match(/[a-zA-Z]+|[0-9]+|[-!$%^&*()_+|~=`{}\[\]:";'<>?,.\/]+(?:\.[0-9]+@|)/g)
                                let reg = /^\d+$/
                                splitOperator.map((item) => {
                                    if (reg.test(item) === true) {
                                        let i = dataTable2.findIndex((val) => val[23] == item)
                                        if (i > 0) {
                                            rilFormula = rilFormula.replace(item, dataTable2[i][tableMeta.columnIndex] === "" ? "0" : dataTable2[i][tableMeta.columnIndex])
                                        }
                                    }
                                })
                            }
                        }
                    }
                    let body = {
                        "submission_id": null,
                        "company_id": this.props.company.company_id,
                        "report_id": this.props.report_id,
                        "year": this.props.periode,
                        "month": month,
                        "formula": rilFormula
                    }
                    api.create().countingFormula(body).then(response => {
                        // // console.log(response);
                        if (response.data) {
                            if (response.data.status === "success") {
                                setTimeout(() => {
                                    return response.data.data.result
                                }, 2000);
                            }
                        }
                    })
                } else {
                    let body = {
                        "submission_id": this.props.submissionID,
                        "company_id": this.props.company.company_id,
                        "report_id": this.props.report_id,
                        "year": this.props.periode,
                        "month": month,
                        "formula": rilFormula
                    }
                    api.create().countingFormula(body).then(response => {
                        // // console.log(response)
                        if (response.data) {
                            if (response.data.status === "success") {
                                setTimeout(() => {
                                    return response.data.data.result
                                }, 2000);
                            }
                        }
                    })
                }
            } else {
                let arrayFormula = tableMeta.rowData[3].match(/[a-zA-Z]+|[0-9]+|[-!$%^&*()_+|~=`{}\[\]:";'<>?,.\/]+(?:\.[0-9]+@|)/g)
                let arrayJumlah = []
                arrayFormula.map((item, indexs) => {
                    let index = dataTable2.findIndex((val) => val[1] == item)
                    if (index > 0) {
                        arrayJumlah.push(dataTable2[index][tableMeta.columnIndex])
                    } else {
                        arrayJumlah.push(item)
                    }
                    // if (indexs % 2 !== 0) {
                    //     operator.push(item)
                    // }
                })
                let array = arrayJumlah
                let total = 0
                let opt = ""
                array.map((item, index) => {
                    if (item == "+") {
                        opt = "tambah"
                    } else if (item == "-") {
                        opt = "kurang"
                    } else if (item == "*") {
                        opt = "kali"
                    } else if (item == "/") {
                        opt = "bagi"
                    } else {
                        if (opt == "tambah") {
                            total = Number(total) + Number(item)
                        } else if (opt == "kurang") {
                            total = Number(total) - Number(item)
                        } else if (opt == "kali") {
                            total = Number(total) * Number(item)
                        } else if (opt == "bagi") {
                            total = Number(total) / Number(item)
                        } else {
                            total += item
                        }
                    }
                })
                let a = dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(total)
                return a
            }
        }

        const columns = [{
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "Account",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 102, backgroundColor: '#1c71b8', width: 300 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style }),
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ width: 300 }}>
                            {tableMeta.rowData[25] ?
                                tableMeta.rowData[25].length > 0 ?
                                    <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                        <LightTooltip title={"Report Items Not Registered"} arrow>
                                            <span style={{ fontSize: 12, color: 'red' }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                        </LightTooltip>
                                    </div>
                                    :
                                    tableMeta.rowData[4] == 0 ?
                                        <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                        :
                                        <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                            <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                        </div>
                                :
                                tableMeta.rowData[4] == 0 ?
                                    <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                    :
                                    <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                        <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                    </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `31 Dec ${Number(this.props.periode) - 1} Actual`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96 }}>
                        <Typography style={{ color: 'black', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                null
                                :
                                tableMeta.rowData[0] == 5 || tableMeta.rowData[0] == 6 ?
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                // value={Number(handleBfr(value, tableMeta)).toFixed(1)}
                                                />
                                            }
                                        />
                                    </div>
                                    :
                                    <div style={{ flex: 1 }}>
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={value}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                />
                                            }
                                        />
                                    </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Jan ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {
                                this.props.status === 'CLOSED' ?
                                    tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                        null
                                        :
                                        tableMeta.rowData[0] === 3 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div> :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={this.props.isApprover ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        onBlur={(event) => {
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 5 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={fixNumber(Number(handleValueFormula(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta)), 1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: String(tableMeta.rowData[5]).toLocaleLowerCase() == 'beginning balance' ? "#5198ea" : "black", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={this.props.isApprover ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') && String(tableMeta.rowData[5]).toLocaleLowerCase() == 'beginning balance' ? false : true)}
                                                        value={String(tableMeta.rowData[5]).toLocaleLowerCase() == 'beginning balance' ? (fixNumber(Number(value.value), 1) == 0 ? "0.0" : fixNumber(Number(value.value), 1)) : (fixNumber(Number(handleValueFormula(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta)), 1))}
                                                        onBlur={(event) => {
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                    :
                                                    tableMeta.rowData[0] === 1 ?
                                                        null
                                                        :
                                                        null
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Feb ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {
                                this.props.status === 'CLOSED' ?
                                    tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                        null
                                        :
                                        tableMeta.rowData[0] === 3 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div> :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={this.props.isApprover ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 5 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={fixNumber(Number(handleValueFormula(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta)), 1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta)), 1)}
                                                    />
                                                    :
                                                    tableMeta.rowData[0] === 1 ?
                                                        null
                                                        :
                                                        null
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Mar ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {
                                this.props.status === 'CLOSED' ?
                                    tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                        null
                                        :
                                        tableMeta.rowData[0] === 3 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div> :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={this.props.isApprover ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 5 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={fixNumber(Number(handleValueFormula(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta)), 1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta)), 1)}
                                                    />
                                                    :
                                                    tableMeta.rowData[0] === 1 ?
                                                        null
                                                        :
                                                        null
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Apr ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {
                                this.props.status === 'CLOSED' ?
                                    tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                        null
                                        :
                                        tableMeta.rowData[0] === 3 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div> :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={this.props.isApprover ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 5 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={fixNumber(Number(handleValueFormula(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta)), 1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta)), 1)}
                                                    />
                                                    :
                                                    tableMeta.rowData[0] === 1 ?
                                                        null
                                                        :
                                                        null
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `May ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {
                                this.props.status === 'CLOSED' ?
                                    tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                        null
                                        :
                                        tableMeta.rowData[0] === 3 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div> :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={this.props.isApprover ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 5 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={fixNumber(Number(handleValueFormula(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta)), 1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta)), 1)}
                                                    />
                                                    :
                                                    tableMeta.rowData[0] === 1 ?
                                                        null
                                                        :
                                                        null
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Jun ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {
                                this.props.status === 'CLOSED' ?
                                    tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                        null
                                        :
                                        tableMeta.rowData[0] === 3 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div> :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={this.props.isApprover ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 5 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={fixNumber(Number(handleValueFormula(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta)), 1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta)), 1)}
                                                    />
                                                    :
                                                    tableMeta.rowData[0] === 1 ?
                                                        null
                                                        :
                                                        null
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Jul ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {
                                this.props.status === 'CLOSED' ?
                                    tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                        null
                                        :
                                        tableMeta.rowData[0] === 3 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div> :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={this.props.isApprover ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 5 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={fixNumber(Number(handleValueFormula(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta)), 1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta)), 1)}
                                                    />
                                                    :
                                                    tableMeta.rowData[0] === 1 ?
                                                        null
                                                        :
                                                        null
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Aug ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {
                                this.props.status === 'CLOSED' ?
                                    tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                        null
                                        :
                                        tableMeta.rowData[0] === 3 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div> :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={this.props.isApprover ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 5 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={fixNumber(Number(handleValueFormula(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta)), 1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta)), 1)}
                                                    />
                                                    :
                                                    tableMeta.rowData[0] === 1 ?
                                                        null
                                                        :
                                                        null
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Sep ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {
                                this.props.status === 'CLOSED' ?
                                    tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                        null
                                        :
                                        tableMeta.rowData[0] === 3 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div> :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={this.props.isApprover ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 5 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={fixNumber(Number(handleValueFormula(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta)), 1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta)), 1)}
                                                    />
                                                    :
                                                    tableMeta.rowData[0] === 1 ?
                                                        null
                                                        :
                                                        null
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Oct ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {
                                this.props.status === 'CLOSED' ?
                                    tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                        null
                                        :
                                        tableMeta.rowData[0] === 3 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div> :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={this.props.isApprover ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 5 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={fixNumber(Number(handleValueFormula(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta)), 1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta)), 1)}
                                                    />
                                                    :
                                                    tableMeta.rowData[0] === 1 ?
                                                        null
                                                        :
                                                        null
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Nov ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {
                                this.props.status === 'CLOSED' ?
                                    tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                        null
                                        :
                                        tableMeta.rowData[0] === 3 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div> :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={this.props.isApprover ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 5 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={fixNumber(Number(handleValueFormula(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta)), 1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta)), 1)}
                                                    />
                                                    :
                                                    tableMeta.rowData[0] === 1 ?
                                                        null
                                                        :
                                                        null
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Dec ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {
                                this.props.status === 'CLOSED' ?
                                    tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                        null
                                        :
                                        tableMeta.rowData[0] === 3 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div> :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={this.props.isApprover ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 5 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={fixNumber(Number(handleValueFormula(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta)), 1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={fixNumber(Number(handleValueFormula(value, tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleValueFormula(value, tableMeta)), 1)}
                                                    />
                                                    :
                                                    tableMeta.rowData[0] === 1 ?
                                                        null
                                                        :
                                                        null
                            }
                        </div>
                    )
                }
            }
        }, {
            name: "Current Total",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96 }}>
                        <Typography style={{ color: 'black', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ width: 96, textAlign: 'right' }}>
                            {
                                this.props.status === 'CLOSED' ?
                                    tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 4 ?
                                        null
                                        :
                                        tableMeta.rowData[0] === 3 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(handleTotal(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleTotal(tableMeta)), 1)}
                                                        />
                                                    }
                                                />
                                            </div> :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={fixNumber(Number(handleTotal(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleTotal(tableMeta)), 1)}
                                                    // onBlur={(event) => {
                                                    //     // updateValue(event.target.value)
                                                    //     handleChange(event.target.value, tableMeta)
                                                    //     // // console.log(dataTable2)
                                                    // }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 5 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={fixNumber(Number(handleTotal(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleTotal(tableMeta)), 1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={fixNumber(Number(handleTotal(tableMeta)), 1) == 0 ? "0.0" : fixNumber(Number(handleTotal(tableMeta)), 1)}
                                                    />
                                                    :
                                                    tableMeta.rowData[0] === 1 ?
                                                        null
                                                        :
                                                        null
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `31 Dec ${Number(this.props.periode) + 1} Total`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96 }}>
                        <Typography style={{ color: 'black', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {
                                this.props.status === 'CLOSED' ?
                                    tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                        null
                                        :
                                        tableMeta.rowData[0] === 3 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div> :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={this.props.isApprover ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 5 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={fixNumber(Number(handleForecast(tableMeta, `${Number(this.props.periode) + 1}`)), 1) == 0 ? "0.0" : fixNumber(Number(handleForecast(tableMeta, `${Number(this.props.periode) + 1}`)), 1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={fixNumber(Number(handleForecast(tableMeta, `${Number(this.props.periode) + 1}`)), 1) == 0 ? "0.0" : fixNumber(Number(handleForecast(tableMeta, `${Number(this.props.periode) + 1}`)), 1)}
                                                    />
                                                    :
                                                    tableMeta.rowData[0] === 1 ?
                                                        null
                                                        :
                                                        null
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `31 Dec ${Number(this.props.periode) + 2} Total`,
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 96 }}>
                        <Typography style={{ color: 'black', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div style={{ textAlign: 'right' }}>
                            {
                                this.props.status === 'CLOSED' ?
                                    tableMeta.rowData[0] === 4 || tableMeta.rowData[0] === 1 ?
                                        null
                                        :
                                        tableMeta.rowData[0] === 3 ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div> :
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={value}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                    :
                                    tableMeta.rowData[0] === 3 ?
                                        <div style={{ flex: 1 }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={value}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={this.props.isApprover ? true : ((this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div> :
                                        tableMeta.rowData[0] === 5 ?
                                            <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    disabled={true}
                                                    value={fixNumber(Number(handleForecast(tableMeta, `${Number(this.props.periode) + 2}`)), 1) == 0 ? "0.0" : fixNumber(Number(handleForecast(tableMeta, `${Number(this.props.periode) + 2}`)), 1)}
                                                />
                                            </span>
                                            :
                                            tableMeta.rowData[0] === 4 ?
                                                null
                                                :
                                                tableMeta.rowData[0] === 6 ?
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        disabled={true}
                                                        value={fixNumber(Number(handleForecast(tableMeta, `${Number(this.props.periode) + 2}`)), 1) == 0 ? "0.0" : fixNumber(Number(handleForecast(tableMeta, `${Number(this.props.periode) + 2}`)), 1)}
                                                    />
                                                    :
                                                    tableMeta.rowData[0] === 1 ?
                                                        null
                                                        :
                                                        null
                            }
                        </div>
                    )
                }
            }
        }
        ]
        const loadingComponent = (
            <div style={{ position: 'absolute', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)' }}>
                <PropagateLoader
                    // css={override}
                    size={20}
                    color={"#274B80"}
                    loading={this.state.loading}
                />
            </div>
        );

        return (
            <div style={{ height: this.props.height, backgroundColor: '#f8f8f8', marginBottom: 100, minHeight: 1000 }}>
                <div className={"main-color"} style={{ height: 78, flex: 1, display: 'flex', alignItems: 'center', paddingLeft: 20 }}>
                    <Typography style={{ fontSize: '16px', color: 'white' }}>Master Budget Submission</Typography>
                </div>
                <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                    <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                        {this.state.messageAlert}
                    </Alert>
                </Snackbar>
                {/* {this.state.loading && loadingComponent} */}
                <div style={{ flex: 1, padding: 20, width: '100%' }}>
                    {this.state.visibleFixedAssetsMovement === true ?
                        <Paper style={{ paddingTop: 10, paddingBottom: 20 }}>
                            <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                                <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Master Budget - Fixed Assets Movement</Typography>
                            </div>
                            <div style={{ padding: 20 }}>
                                <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                                    <div>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {this.props.periode} (rev.{this.props.revision})</Typography>
                                        {this.props.defaultCurrency.id === 1 ?
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                            :
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in USD thousand</Typography>
                                        }
                                    </div>
                                    <div style={{ width: '50%' }}>
                                            {this.state.dataTable.length == 0 ? null : this.props.isApprover == true ?
                                                null
                                                // <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                                //     <a data-tip={'Download'} data-for="download">
                                                //         <button
                                                //             style={{
                                                //                 backgroundColor: 'transparent',
                                                //                 cursor: 'pointer',
                                                //                 borderColor: 'transparent',
                                                //                 margin: 5
                                                //             }}
                                                //             onClick={() =>
                                                //                 this.setState({ loading: true }, () => {
                                                //                     setTimeout(() => {
                                                //                         this.downloadAllData()
                                                //                     }, 100);
                                                //                 })}
                                                //         >
                                                //             <img src={Images.download} />
                                                //         </button>
                                                //     </a>
                                                //     <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" />
                                                // </div> 
                                                :
                                                <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                                    {((!this.props.truelyApprover) && (this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === "draft" || this.props.status === 'submitted')) && (
                                                        <div>
                                                            <a data-tip={'Download Template'} data-for="template">
                                                                <button
                                                                    style={{
                                                                        backgroundColor: 'transparent',
                                                                        cursor: 'pointer',
                                                                        borderColor: 'transparent',
                                                                        margin: 5
                                                                    }}
                                                                    onClick={() => this.downloadTemplate()}
                                                                >
                                                                    <img src={Images.template} />
                                                                </button>
                                                            </a>
                                                            <ReactTooltip border={true} id="template" place="bottom" type="light" effect="solid" />
                                                        </div>
                                                    )}
                                                    {((!this.props.truelyApprover) && (this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === "draft" || this.props.status === 'submitted')) && (
                                                        <div>
                                                            <a data-tip={'Upload'} data-for="upload">
                                                                <button
                                                                    style={{
                                                                        backgroundColor: 'transparent',
                                                                        cursor: 'pointer',
                                                                        borderColor: 'transparent',
                                                                        margin: 5
                                                                    }}
                                                                    onClick={() => this.setState({ visibleUpload: true })}
                                                                >
                                                                    <img src={Images.upload} />
                                                                </button>
                                                            </a>
                                                            <ReactTooltip border={true} id="upload" place="bottom" type="light" effect="solid" />
                                                        </div>
                                                    )}
                                                    {/* <a data-tip={'Download'} data-for="download">
                                                    <button
                                                        style={{
                                                            backgroundColor: 'transparent',
                                                            cursor: 'pointer',
                                                            borderColor: 'transparent',
                                                            margin: 5
                                                        }}
                                                        onClick={() =>
                                                            this.setState({ loading: true }, () => {
                                                                setTimeout(() => {
                                                                    this.downloadAllData()
                                                                }, 100);
                                                            })}
                                                    >
                                                        <img src={Images.download} />
                                                    </button>
                                                </a>
                                                <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" /> */}
                                                </div>
                                            }
                                    </div>
                                </div>

                                <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                    {this.state.loading && loadingComponent}
                                    <MuiThemeProvider theme={getMuiTheme()}>
                                        <MUIDataTable
                                            data={dataTable2}
                                            columns={columns}
                                            options={options}
                                        />
                                    </MuiThemeProvider>
                                </div>
                                <div style={{ display: 'flex' }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 20 }}>Last Updated by : </Typography>
                                    <div style={{ marginLeft: 10, overflowY: 'scroll', height: this.state.updateBy.length < 2 ? 25 : 75, marginTop: 10 }}>
                                        {
                                            this.state.updateBy.length > 0 ? this.state.updateBy.reverse().map((item, index) => {
                                                return (
                                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>{item.latest_update}</Typography>
                                                )
                                            }) :
                                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>-</Typography>
                                        }
                                    </div>
                                </div>
                            </div>
                            <div className="grid grid-2x" style={{ marginTop: 20 }}>
                                <div className="col-1">
                                    <button
                                        className="button"
                                        type="button"
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none',
                                            marginRight: 20
                                        }}
                                        onClick={() => this.setState({ loading: true }, () => {
                                            setTimeout(() => {
                                                this.props.onClickClose()
                                            }, 100);
                                        })}
                                    >
                                        <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                        </div>
                                    </button>
                                </div>
                                {this.props.isApprover === true || this.state.dataTable.length == 0 ? null :
                                    (!this.props.truelyApprover) && (this.props.lastStatus === 'SUBMIT' || this.props.lastStatus === 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === "draft" || this.props.status === 'submitted') ?
                                        <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%' }}>
                                            <button
                                                className="button"
                                                type="button"
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: 'pointer',
                                                    borderColor: 'transparent',
                                                    outline: 'none',
                                                    marginRight: 20
                                                }}
                                                onClick={() => {
                                                    this.setState({ loading: true }, () => {
                                                        setTimeout(() => {
                                                            this.handleValidate()
                                                        }, 100);
                                                    })
                                                }}
                                            >
                                                <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                    <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                                </div>
                                            </button>
                                            <button
                                                className="button"
                                                type="button"
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: this.state.editable !== true ? 'pointer' : 'default',
                                                    borderColor: 'transparent',
                                                    outline: 'none',
                                                    marginRight: 20
                                                }}
                                                onClick={() =>
                                                    this.state.editable === true ?
                                                        null :
                                                        this.state.handleDoubleClick == 1 ? null :
                                                            this.setState({ handleDoubleClick: 1 }, () => {
                                                                this.backToMasterBudget('draft')
                                                            })
                                                }
                                            >
                                                <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                    <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                                </div>
                                            </button>
                                            <button
                                                type="button"
                                                disabled={this.state.buttonError}
                                                onClick={() =>
                                                    this.state.buttonError ?
                                                        this.setState({ alert: true, messageAlert: 'Data is not complete !', tipeAlert: 'warning' })
                                                        :
                                                        this.state.handleDoubleClick == 1 ? null :
                                                            this.setState({ handleDoubleClick: 1 }, () => {
                                                                this.backToMasterBudget('submitted')
                                                            })}
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: this.state.buttonError === true ? 'default' : 'pointer',
                                                    borderColor: 'transparent',
                                                    outline: 'none',
                                                }}
                                            >
                                                <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                    <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                                </div>
                                            </button>
                                        </div> : null
                                }
                            </div>
                        </Paper>
                        :
                        <Paper style={{ paddingTop: 10, paddingBottom: 20 }}>
                            <div>
                                <div style={{ padding: 25 }}>
                                    <div>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {this.props.periode}</Typography>
                                        {this.props.defaultCurrency.id === 1 ?
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                            :
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in USD thousand</Typography>
                                        }
                                    </div>
                                    {this.state.dataLoaded && (
                                        <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                            {this.state.loading && loadingComponent}
                                            <MuiThemeProvider theme={getMuiTheme()}>
                                                <MUIDataTable
                                                    data={dataTable2}
                                                    columns={columns}
                                                    options={options}
                                                />
                                            </MuiThemeProvider>
                                        </div>
                                    )}
                                </div>

                                <div className="grid grid-2x" style={{ marginTop: 20 }}>
                                    <div className="col-1">
                                        <button
                                            type="button"
                                            onClick={() => this.setState({ loading: true, visibleFixedAssetsMovement: true }, () => {
                                                setTimeout(() => {
                                                    this.getItemHierarki()
                                                }, 100);
                                            })}
                                            style={{ marginRight: 20 }}
                                        >
                                            <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                            </div>
                                        </button>
                                    </div>
                                    <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%' }}>
                                        <button
                                            className="button"
                                            type="button"
                                            // disabled={this.state.buttonError}
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() => {
                                                this.setState({ loading: true }, () => {
                                                    setTimeout(() => {
                                                        this.setState({ loading: false, buttonError: this.state.errorPreview === true ? true : false, editable: false })
                                                    }, 100);
                                                })
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                            </div>
                                        </button>

                                        <button
                                            className="button"
                                            type="button"
                                            // disabled={this.state.buttonError}
                                            style={{
                                                backgroundColor: 'transparent',
                                                // cursor: this.state.editable === true ? 'default' : 'pointer',
                                                cursor: this.state.editable !== true ? 'pointer' : 'default',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() =>
                                                this.state.editable === true ?
                                                    null : this.setState({ loading: true }, () =>
                                                        this.state.handleDoubleClick == 1 ? null :
                                                            this.setState({ handleDoubleClick: 1 }, () => {
                                                                setTimeout(() => {
                                                                    this.uploadFAM('draft')
                                                                }, 100);
                                                            }))
                                            }
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                            </div>
                                        </button>
                                        <button
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: this.state.editable !== true ? 'pointer' : 'default',
                                                borderColor: 'transparent',
                                                outline: 'none'
                                            }}
                                            onClick={() =>
                                                this.state.editable === true ?
                                                    null : this.setState({ loading: true }, () =>
                                                        this.state.handleDoubleClick == 1 ? null :
                                                            this.setState({ handleDoubleClick: 1 }, () => {
                                                                setTimeout(() => {
                                                                    this.uploadFAM('submitted')
                                                                }, 100);
                                                            })
                                                    )
                                            }
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                            </div>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </Paper>}
                </div>

                {this.state.visibleUpload && (
                    <div className="test app-popup-show">
                        <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                            <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                    <div className="popup-title">
                                        <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Upload File</span>
                                    </div>
                                </div>
                                <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        className="btn btn-circle btn-white"
                                        onClick={() => this.setState({ visibleUpload: false })}
                                    >
                                        <img src={Images.close} />
                                    </button>
                                </div>
                            </div>
                            <div style={{ padding: '25px 30px' }}>
                                <UploadFile
                                    type={this.state.uploadStatus}
                                    percentage={this.state.percentage}
                                    result={this.state.result}
                                    acceptedFiles={["xlsx"]}
                                    onHandle={(dt) => {
                                        this.fileHandler(dt)
                                        this.setState({ uploadStatus: 'idle', percentage: '0' })
                                    }}
                                    onUpload={() => {
                                        String(this.state.judul).includes("MASTER") && String(this.state.judul).includes("BUDGET") && String(this.state.judul).includes("FIXED") && String(this.state.judul).includes("ASSETS") && String(this.state.judul).includes("MOVEMENT") ?
                                            this.checkUpload() :
                                            this.setState({ alert: true, messageAlert: "Invalid Template", tipeAlert: 'warning' })
                                    }}
                                />
                            </div>
                            <div style={{ padding: '0px 30px 29px', fontSize: 17, color: 'red' }}><b>Warning:</b> Valid currency for uploading data in <b>{this.props.defaultCurrency.id == 1 ? "IDR mn" : "thousand USD"}</b></div>

                        </div>
                    </div>
                )}

                {this.state.visibleAlertSave && (
                    <div className="test app-popup-show">
                        <div className="popup-content border-radius" style={{ background: '#FFF27D', borderRadius: 10, width: 715, height: 238 }}>
                            <div style={{ margin: 30 }}>
                                <div style={{ display: 'flex', marginTop: 76, marginBottom: 43 }}>
                                    <div style={{ alignSelf: 'center', marginRight: 25 }}>
                                        <img src={Images.warning} />
                                    </div>
                                    <div style={{ justifyContent: 'center', fontSize: 20, color: '#1D2995', marginTop: 10 }}>
                                        <b>Rate Currency USD</b> pada periode yang dipilih <b>belum</b> diatur.<br /> Silahkan menghubungi Superadmin
                                    </div>
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'flex-end' }}>
                                    <button
                                        className="button"
                                        type="button"
                                        style={{
                                            background: '#F6F7F9',
                                            cursor: 'pointer',
                                            border: '1px solid #3549609e',
                                            outline: 'none',
                                            marginRight: 20,
                                            borderRadius: 9
                                        }}
                                        onClick={() => this.setState({ visibleAlertSave: false, handleDoubleClick: 0, loading: false })}
                                    >
                                        <div style={{ backgroundColor: '#fff', width: 105, height: 30, borderRadius: 9, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #3549609e' }}>
                                            <Typography style={{ fontSize: '15px', color: '#354960', textAlign: 'center' }}>Close</Typography>
                                        </div>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                )}
            </div>
        );
    }
}
