import React, { Component } from 'react';
import { Typography, Paper, createMuiTheme, MuiThemeProvider, TableCell, FormControlLabel, Tooltip, withStyles, Snackbar } from '@material-ui/core';
import MUIDataTable from 'mui-datatables';
import NumberFormat from 'react-number-format';
import api from '../../api';
import PropagateLoader from "react-spinners/PropagateLoader"
import Images from '../../assets/Images';
import ReactTooltip from 'react-tooltip';
import UploadFile from "../../library/Upload";
import { ExcelRenderer } from 'react-excel-renderer';
import { Alert } from '@material-ui/lab';
import * as R from 'ramda';
import Constant from '../../library/Constant';
import { fixNumber, titleCase } from '../../library/Utils';

const LightTooltip = withStyles((theme) => ({
    tooltip: {
        backgroundColor: theme.palette.common.white,
        color: 'rgba(0, 0, 0, 0.87)',
        boxShadow: theme.shadows[1],
        fontSize: 11,
    },
}))(Tooltip);

var ct = require("../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable3());

const options = ct.customOptionsFixedColumn();
const style = {
    position: "sticky",
    left: 0,
    zIndex: 101,
    background: "white",
};
const style2 = {
    position: "sticky",
    background: "white",
    zIndex: 100,
    top: 0
};

export default class TaxPlanningOLPA extends Component {
    constructor(props) {
        super(props)
        this.state = {
            dataTable: [],
            visibleTP: true,
            disabledSave: true,
            editable: false,
            buttonError: false,
            judulColumn: null,
            updateBy: [],
            buttonDraft: true,
            handleDoubleClick: 0,
            get_for: "view",
            viewOnly: true,
            defaultCurrencyUpload: this.props.defaultCurrency,
            visibleAlertSave: false

        }
        this.handleValue = this.handleValue.bind(this)
        this.fileHandler = this.fileHandler.bind(this);
    }

    componentDidMount() {
        // this.getItemHierarki()
        this.getSettingControl()
        this.lastUpdate()
        this.handleViewOnly()
        console.log(this.props)
    }

    handleViewOnly() {
        let checkApprover = false
        let checkLastStatus = false
        let checkStatus = false
        let checkPrevRev = false

        if (this.props.isApprover) {
            checkApprover = true
        } else {
            checkApprover = false
        }

        if (this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') {
            checkLastStatus = true
        } else {
            checkLastStatus = false
        }

        if (this.props.prevRevision) {
            checkPrevRev = true
        } else {
            checkPrevRev = false
        }

        if (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') {
            checkStatus = true
        } else {
            checkStatus = false
        }

        this.setState({ viewOnly: !checkApprover && checkLastStatus && checkStatus && checkPrevRev })
    }

    handleGetFor(type) {
        console.log(type)
        this.setState({ get_for: type }, () => {
            this.getSettingControl()
            this.lastUpdate()
        })
    }

    getSettingControl() {
        let body = {
            group: 'THRESHOLD_CONTROL',
            company_id: this.props.company.company_id,
            type: 'TAX_PLANNING',
            currency_id: this.props.defaultCurrency.id,
        }

        api.create().getAllSettingByType(body).then(response => {
            console.log(response)
            if (response.data) {
                if (response.data.status === 'success') {
                    this.setState({
                        minValue: response.data.data[0] ? response.data.data[0].min_value : null,
                        maxValue: response.data.data[0] ? response.data.data[0].max_value : null,
                    }, () => {
                        this.getItemHierarki()
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    lastUpdate() {
        let payload = {
            "outlook_pa_id": this.props.outlook_pa_id,
            "report_id": this.props.report_id,
            "get_for": this.state.get_for,
            "revision": this.props.revision,
            "periode": this.props.periode,
            "currency_id": this.props.defaultCurrency.id,
            "company_id": this.props.company.company_id
        }
        api.create().getLastestUpdateOLPA(payload).then(response => {
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        updateBy: response.data.data.detail === null ? '-' : response.data.data.detail
                    })
                }
            }
        })
    }

    getItemHierarki() {
        this.setState({ loading: true, judulColumn: null })
        let payload = {
            "outlook_pa_id": this.props.outlook_pa_id,
            "report_id": this.props.report_id,
            "revision": this.props.revision,
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "get_for": this.state.get_for,
            "currency_id": this.props.defaultCurrency.id
        }
        api.create().getDetailReportOLPA(payload).then(response => {
            console.log(payload);
            console.log(response);
            let dataTable = []
            if (response.data) {
                if (response.data.status == 'success') {
                    let res = response.data.data
                    const handlePushChild = (item) => {
                        let indexIDzz = dataTable.findIndex((val) => val[1] === item.id)
                        if (indexIDzz === -1) {
                            dataTable.push([
                                item.type_report_id,
                                item.type_report_tax.value_tbc.type_report_id,
                                item.type_report_tax.value_fc.type_report_id,
                                item.type_report_tax.value_tbf.type_report_id,
                                item.id,
                                item.parent,
                                { tbc: item.formula_tax.value_tbc, fcp: item.formula_tax.value_fc, tbf: item.formula_tax.value_tbf },
                                item.level,
                                item.description,
                                // {
                                //     tbc: item.tax_planning.january.tbc, fcp: item.tax_planning.january.fcp,
                                //     tbf: item.tax_planning.january.tbf === null ? "0" : item.tax_planning.january.tbf === "" ? "0" : item.tax_planning.january.tbf
                                // },
                                // { tbc: item.tax_planning.february.tbc, fcp: item.tax_planning.february.fcp, tbf: item.tax_planning.february.tbf },
                                // { tbc: item.tax_planning.march.tbc, fcp: item.tax_planning.march.fcp, tbf: item.tax_planning.march.tbf },
                                // { tbc: item.tax_planning.april.tbc, fcp: item.tax_planning.april.fcp, tbf: item.tax_planning.april.tbf },
                                // { tbc: item.tax_planning.may.tbc, fcp: item.tax_planning.may.fcp, tbf: item.tax_planning.may.tbf },
                                // { tbc: item.tax_planning.june.tbc, fcp: item.tax_planning.june.fcp, tbf: item.tax_planning.june.tbf },
                                // { tbc: item.tax_planning.july.tbc, fcp: item.tax_planning.july.fcp, tbf: item.tax_planning.july.tbf },
                                // {
                                //     tbc: item.tax_planning.august.tbc === null ? "0" : item.tax_planning.august.tbc === "" ? "0" : item.tax_planning.august.tbc,
                                //     fcp: item.tax_planning.august.fcp, tbf: item.tax_planning.august.tbf
                                // },
                                // { tbc: item.tax_planning.september.tbc, fcp: item.tax_planning.september.fcp, tbf: item.tax_planning.september.tbf },
                                // { tbc: item.tax_planning.october.tbc, fcp: item.tax_planning.october.fcp, tbf: item.tax_planning.october.tbf },
                                // { tbc: this.props.status === 'CLOSED' ? item.tax_planning.november.tbc : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.november.tbc, formula: item.tax_planning.november_formula } : item.tax_planning.november.tbc, fcp: this.props.status === 'CLOSED' ? item.tax_planning.november.fcp : item.type_report_tax.value_fc.type_report_id == 5 || item.type_report_tax.value_fc.type_report_id == 6 || item.type_report_tax.value_fc.type_report_id == 7 ? { value: item.tax_planning.november.fcp, formula: item.tax_planning.november_formula } : item.tax_planning.november.fcp, tbf: this.props.status === 'CLOSED' ? item.tax_planning.november.tbf : item.type_report_tax.value_tbf.type_report_id == 5 || item.type_report_tax.value_tbf.type_report_id == 6 || item.type_report_tax.value_tbf.type_report_id == 7 ? { value: item.tax_planning.november.tbf, formula: item.tax_planning.november_formula } : item.tax_planning.november.tbf },
                                // { tbc: this.props.status === 'CLOSED' ? item.tax_planning.december.tbc : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.december.tbc, formula: item.tax_planning.december_formula } : item.tax_planning.december.tbc, fcp: this.props.status === 'CLOSED' ? item.tax_planning.december.fcp : item.type_report_tax.value_fc.type_report_id == 5 || item.type_report_tax.value_fc.type_report_id == 6 || item.type_report_tax.value_fc.type_report_id == 7 ? { value: item.tax_planning.december.fcp, formula: item.tax_planning.december_formula } : item.tax_planning.december.fcp, tbf: this.props.status === 'CLOSED' ? item.tax_planning.december.tbf : item.type_report_tax.value_tbf.type_report_id == 5 || item.type_report_tax.value_tbf.type_report_id == 6 || item.type_report_tax.value_tbf.type_report_id == 7 ? { value: item.tax_planning.december.tbf, formula: item.tax_planning.december_formula } : item.tax_planning.december.tbf },
                                {
                                    tbc: item.tax_planning.january !== null ? item.tax_planning.january !== "" ? item.tax_planning.january.tbc !== null ? item.tax_planning.january.tbc !== "" ? item.tax_planning.january.tbc : "0" : "0" : "0" : "0",
                                    fcp: item.tax_planning.january !== null ? item.tax_planning.january !== "" ? item.tax_planning.january.fcp !== null ? item.tax_planning.january.fcp !== "" ? item.tax_planning.january.fcp : "0" : "0" : "0" : "0",
                                    tbf: item.tax_planning.january !== null ? item.tax_planning.january !== "" ? item.tax_planning.january.tbf !== null ? item.tax_planning.january.tbf !== "" ? item.tax_planning.january.tbf : "0" : "0" : "0" : "0"
                                },
                                {
                                    tbc: item.tax_planning.february !== null ? item.tax_planning.february !== "" ? item.tax_planning.february.tbc !== null ? item.tax_planning.february.tbc !== "" ? item.tax_planning.february.tbc : "0" : "0" : "0" : "0",
                                    fcp: item.tax_planning.february !== null ? item.tax_planning.february !== "" ? item.tax_planning.february.fcp !== null ? item.tax_planning.february.fcp !== "" ? item.tax_planning.february.fcp : "0" : "0" : "0" : "0",
                                    tbf: item.tax_planning.february !== null ? item.tax_planning.february !== "" ? item.tax_planning.february.tbf !== null ? item.tax_planning.february.tbf !== "" ? item.tax_planning.february.tbf : "0" : "0" : "0" : "0"
                                },
                                {
                                    tbc: item.tax_planning.march !== null ? item.tax_planning.march !== "" ? item.tax_planning.march.tbc !== null ? item.tax_planning.march.tbc !== "" ? item.tax_planning.march.tbc : "0" : "0" : "0" : "0",
                                    fcp: item.tax_planning.march !== null ? item.tax_planning.march !== "" ? item.tax_planning.march.fcp !== null ? item.tax_planning.march.fcp !== "" ? item.tax_planning.march.fcp : "0" : "0" : "0" : "0",
                                    tbf: item.tax_planning.march !== null ? item.tax_planning.march !== "" ? item.tax_planning.march.tbf !== null ? item.tax_planning.march.tbf !== "" ? item.tax_planning.march.tbf : "0" : "0" : "0" : "0"
                                },
                                {
                                    tbc: item.tax_planning.april !== null ? item.tax_planning.april !== "" ? item.tax_planning.april.tbc !== null ? item.tax_planning.april.tbc !== "" ? item.tax_planning.april.tbc : "0" : "0" : "0" : "0",
                                    fcp: item.tax_planning.april !== null ? item.tax_planning.april !== "" ? item.tax_planning.april.fcp !== null ? item.tax_planning.april.fcp !== "" ? item.tax_planning.april.fcp : "0" : "0" : "0" : "0",
                                    tbf: item.tax_planning.april !== null ? item.tax_planning.april !== "" ? item.tax_planning.april.tbf !== null ? item.tax_planning.april.tbf !== "" ? item.tax_planning.april.tbf : "0" : "0" : "0" : "0"
                                },
                                {
                                    tbc: item.tax_planning.may !== null ? item.tax_planning.may !== "" ? item.tax_planning.may.tbc !== null ? item.tax_planning.may.tbc !== "" ? item.tax_planning.may.tbc : "0" : "0" : "0" : "0",
                                    fcp: item.tax_planning.may !== null ? item.tax_planning.may !== "" ? item.tax_planning.may.fcp !== null ? item.tax_planning.may.fcp !== "" ? item.tax_planning.may.fcp : "0" : "0" : "0" : "0",
                                    tbf: item.tax_planning.may !== null ? item.tax_planning.may !== "" ? item.tax_planning.may.tbf !== null ? item.tax_planning.may.tbf !== "" ? item.tax_planning.may.tbf : "0" : "0" : "0" : "0"
                                },
                                {
                                    tbc: item.tax_planning.june !== null ? item.tax_planning.june !== "" ? item.tax_planning.june.tbc !== null ? item.tax_planning.june.tbc !== "" ? item.tax_planning.june.tbc : "0" : "0" : "0" : "0",
                                    fcp: item.tax_planning.june !== null ? item.tax_planning.june !== "" ? item.tax_planning.june.fcp !== null ? item.tax_planning.june.fcp !== "" ? item.tax_planning.june.fcp : "0" : "0" : "0" : "0",
                                    tbf: item.tax_planning.june !== null ? item.tax_planning.june !== "" ? item.tax_planning.june.tbf !== null ? item.tax_planning.june.tbf !== "" ? item.tax_planning.june.tbf : "0" : "0" : "0" : "0"
                                },
                                {
                                    tbc: item.tax_planning.july !== null ? item.tax_planning.july !== "" ? item.tax_planning.july.tbc !== null ? item.tax_planning.july.tbc !== "" ? item.tax_planning.july.tbc : "0" : "0" : "0" : "0",
                                    fcp: item.tax_planning.july !== null ? item.tax_planning.july !== "" ? item.tax_planning.july.fcp !== null ? item.tax_planning.july.fcp !== "" ? item.tax_planning.july.fcp : "0" : "0" : "0" : "0",
                                    tbf: item.tax_planning.july !== null ? item.tax_planning.july !== "" ? item.tax_planning.july.tbf !== null ? item.tax_planning.july.tbf !== "" ? item.tax_planning.july.tbf : "0" : "0" : "0" : "0"
                                },
                                {
                                    tbc: item.tax_planning.august !== null ? item.tax_planning.august !== "" ? item.tax_planning.august.tbc !== null ? item.tax_planning.august.tbc !== "" ? item.tax_planning.august.tbc : "0" : "0" : "0" : "0",
                                    fcp: item.tax_planning.august !== null ? item.tax_planning.august !== "" ? item.tax_planning.august.fcp !== null ? item.tax_planning.august.fcp !== "" ? item.tax_planning.august.fcp : "0" : "0" : "0" : "0",
                                    tbf: item.tax_planning.august !== null ? item.tax_planning.august !== "" ? item.tax_planning.august.tbf !== null ? item.tax_planning.august.tbf !== "" ? item.tax_planning.august.tbf : "0" : "0" : "0" : "0"
                                },
                                {
                                    tbc: item.tax_planning.september !== null ? item.tax_planning.september !== "" ? item.tax_planning.september.tbc !== null ? item.tax_planning.september.tbc !== "" ? item.tax_planning.september.tbc : "0" : "0" : "0" : "0",
                                    fcp: item.tax_planning.september !== null ? item.tax_planning.september !== "" ? item.tax_planning.september.fcp !== null ? item.tax_planning.september.fcp !== "" ? item.tax_planning.september.fcp : "0" : "0" : "0" : "0",
                                    tbf: item.tax_planning.september !== null ? item.tax_planning.september !== "" ? item.tax_planning.september.tbf !== null ? item.tax_planning.september.tbf !== "" ? item.tax_planning.september.tbf : "0" : "0" : "0" : "0"
                                },
                                {
                                    tbc: item.tax_planning.october !== null ? item.tax_planning.october !== "" ? item.tax_planning.october.tbc !== null ? item.tax_planning.october.tbc !== "" ? item.tax_planning.october.tbc : "0" : "0" : "0" : "0",
                                    fcp: item.tax_planning.october !== null ? item.tax_planning.october !== "" ? item.tax_planning.october.fcp !== null ? item.tax_planning.october.fcp !== "" ? item.tax_planning.october.fcp : "0" : "0" : "0" : "0",
                                    tbf: item.tax_planning.october !== null ? item.tax_planning.october !== "" ? item.tax_planning.october.tbf !== null ? item.tax_planning.october.tbf !== "" ? item.tax_planning.october.tbf : "0" : "0" : "0" : "0"
                                },
                                {
                                    tbc: this.props.status === 'CLOSED' ? item.tax_planning.november !== null ? item.tax_planning.november !== "" ? item.tax_planning.november.tbc !== null ? item.tax_planning.november.tbc !== "" ? Number(item.tax_planning.november.tbc).toFixed(1) : "0" : "0" : "0" : "0" : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.november !== null ? item.tax_planning.november !== "" ? item.tax_planning.november.tbc !== null ? item.tax_planning.november.tbc !== "" ? Number(item.tax_planning.november.tbc).toFixed(1) : "0" : "0" : "0" : "0", formula: item.tax_planning.november_formula } : item.tax_planning.november !== null ? item.tax_planning.november !== "" ? item.tax_planning.november.tbc !== null ? item.tax_planning.november.tbc !== "" ? Number(item.tax_planning.november.tbc).toFixed(1) : "0" : "0" : "0" : "0",
                                    fcp: this.props.status === 'CLOSED' ? item.tax_planning.november !== null ? item.tax_planning.november !== "" ? item.tax_planning.november.fcp !== null ? item.tax_planning.november.fcp !== "" ? Number(item.tax_planning.november.fcp).toFixed(1) : "0" : "0" : "0" : "0" : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.november !== null ? item.tax_planning.november !== "" ? item.tax_planning.november.fcp !== null ? item.tax_planning.november.fcp !== "" ? Number(item.tax_planning.november.fcp).toFixed(1) : "0" : "0" : "0" : "0", formula: item.tax_planning.november_formula } : item.tax_planning.november !== null ? item.tax_planning.november !== "" ? item.tax_planning.november.fcp !== null ? item.tax_planning.november.fcp !== "" ? Number(item.tax_planning.november.fcp).toFixed(1) : "0" : "0" : "0" : "0",
                                    tbf: this.props.status === 'CLOSED' ? item.tax_planning.november !== null ? item.tax_planning.november !== "" ? item.tax_planning.november.tbf !== null ? item.tax_planning.november.tbf !== "" ? Number(item.tax_planning.november.tbf).toFixed(1) : "0" : "0" : "0" : "0" : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.november !== null ? item.tax_planning.november !== "" ? item.tax_planning.november.tbf !== null ? item.tax_planning.november.tbf !== "" ? Number(item.tax_planning.november.tbf).toFixed(1) : "0" : "0" : "0" : "0", formula: item.tax_planning.november_formula } : item.tax_planning.november !== null ? item.tax_planning.november !== "" ? item.tax_planning.november.tbf !== null ? item.tax_planning.november.tbf !== "" ? Number(item.tax_planning.november.tbf).toFixed(1) : "0" : "0" : "0" : "0"
                                },
                                {
                                    tbc: this.props.status === 'CLOSED' ? item.tax_planning.december !== null ? item.tax_planning.december !== "" ? item.tax_planning.december.tbc !== null ? item.tax_planning.december.tbc !== "" ? Number(item.tax_planning.december.tbc).toFixed(1) : "0" : "0" : "0" : "0" : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.december !== null ? item.tax_planning.december !== "" ? item.tax_planning.december.tbc !== null ? item.tax_planning.december.tbc !== "" ? Number(item.tax_planning.december.tbc).toFixed(1) : "0" : "0" : "0" : "0", formula: item.tax_planning.december_formula } : item.tax_planning.december !== null ? item.tax_planning.december !== "" ? item.tax_planning.december.tbc !== null ? item.tax_planning.december.tbc !== "" ? Number(item.tax_planning.december.tbc).toFixed(1) : "0" : "0" : "0" : "0",
                                    fcp: this.props.status === 'CLOSED' ? item.tax_planning.december !== null ? item.tax_planning.december !== "" ? item.tax_planning.december.fcp !== null ? item.tax_planning.december.fcp !== "" ? Number(item.tax_planning.december.fcp).toFixed(1) : "0" : "0" : "0" : "0" : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.december !== null ? item.tax_planning.december !== "" ? item.tax_planning.december.fcp !== null ? item.tax_planning.december.fcp !== "" ? Number(item.tax_planning.december.fcp).toFixed(1) : "0" : "0" : "0" : "0", formula: item.tax_planning.december_formula } : item.tax_planning.december !== null ? item.tax_planning.december !== "" ? item.tax_planning.december.fcp !== null ? item.tax_planning.december.fcp !== "" ? Number(item.tax_planning.december.fcp).toFixed(1) : "0" : "0" : "0" : "0",
                                    tbf: this.props.status === 'CLOSED' ? item.tax_planning.december !== null ? item.tax_planning.december !== "" ? item.tax_planning.december.tbf !== null ? item.tax_planning.december.tbf !== "" ? Number(item.tax_planning.december.tbf).toFixed(1) : "0" : "0" : "0" : "0" : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.december !== null ? item.tax_planning.december !== "" ? item.tax_planning.december.tbf !== null ? item.tax_planning.december.tbf !== "" ? Number(item.tax_planning.december.tbf).toFixed(1) : "0" : "0" : "0" : "0", formula: item.tax_planning.december_formula } : item.tax_planning.december !== null ? item.tax_planning.december !== "" ? item.tax_planning.december.tbf !== null ? item.tax_planning.december.tbf !== "" ? Number(item.tax_planning.december.tbf).toFixed(1) : "0" : "0" : "0" : "0"
                                },
                                item.tax_planning.total_current_year,
                                0,
                                0,
                                item.order,
                                { tbc: item.condition_it_should_be, fcp: item.condition_it_should_be, tbf: item.condition_it_should_be },
                                { tbc: item.condition_if_wrong, fcp: item.condition_if_wrong, tbf: item.condition_if_wrong },
                            ])
                        }
                        if (item.children !== null) {
                            if (item.children.length > 0) {
                                item.children.map((items, indexs) => {
                                    handlePushChild(items)
                                })
                            }
                        }
                    }
                    res.map((item, index) => {
                        dataTable.push([
                            item.type_report_id,
                            item.type_report_tax.value_tbc.type_report_id,
                            item.type_report_tax.value_fc.type_report_id,
                            item.type_report_tax.value_tbf.type_report_id,
                            item.id,
                            item.parent,
                            { tbc: item.formula_tax.value_tbc, fcp: item.formula_tax.value_fc, tbf: item.formula_tax.value_tbf },
                            item.level,
                            item.description,
                            // {
                            //     tbc: item.tax_planning.january.tbc, fcp: item.tax_planning.january.fcp,
                            //     tbf: item.tax_planning.january.tbf === null ? "0" : item.tax_planning.january.tbf === "" ? "0" : item.tax_planning.january.tbf
                            // },
                            // { tbc: item.tax_planning.february.tbc, fcp: item.tax_planning.february.fcp, tbf: item.tax_planning.february.tbf },
                            // { tbc: item.tax_planning.march.tbc, fcp: item.tax_planning.march.fcp, tbf: item.tax_planning.march.tbf },
                            // { tbc: item.tax_planning.april.tbc, fcp: item.tax_planning.april.fcp, tbf: item.tax_planning.april.tbf },
                            // { tbc: item.tax_planning.may.tbc, fcp: item.tax_planning.may.fcp, tbf: item.tax_planning.may.tbf },
                            // { tbc: item.tax_planning.june.tbc, fcp: item.tax_planning.june.fcp, tbf: item.tax_planning.june.tbf },
                            // { tbc: item.tax_planning.july.tbc, fcp: item.tax_planning.july.fcp, tbf: item.tax_planning.july.tbf },
                            // {
                            //     tbc: item.tax_planning.august.tbc === null ? "0" : item.tax_planning.august.tbc === "" ? "0" : item.tax_planning.august.tbc,
                            //     fcp: item.tax_planning.august.fcp, tbf: item.tax_planning.august.tbf
                            // },
                            // { tbc: item.tax_planning.september.tbc, fcp: item.tax_planning.september.fcp, tbf: item.tax_planning.september.tbf },
                            // { tbc: item.tax_planning.october.tbc, fcp: item.tax_planning.october.fcp, tbf: item.tax_planning.october.tbf },
                            // { tbc: this.props.status === 'CLOSED' ? item.tax_planning.november.tbc : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.november.tbc, formula: item.tax_planning.november_formula } : item.tax_planning.november.tbc, fcp: this.props.status === 'CLOSED' ? item.tax_planning.november.fcp : item.type_report_tax.value_fc.type_report_id == 5 || item.type_report_tax.value_fc.type_report_id == 6 || item.type_report_tax.value_fc.type_report_id == 7 ? { value: item.tax_planning.november.fcp, formula: item.tax_planning.november_formula } : item.tax_planning.november.fcp, tbf: this.props.status === 'CLOSED' ? item.tax_planning.november.tbf : item.type_report_tax.value_tbf.type_report_id == 5 || item.type_report_tax.value_tbf.type_report_id == 6 || item.type_report_tax.value_tbf.type_report_id == 7 ? { value: item.tax_planning.november.tbf, formula: item.tax_planning.november_formula } : item.tax_planning.november.tbf },
                            // { tbc: this.props.status === 'CLOSED' ? item.tax_planning.december.tbc : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.december.tbc, formula: item.tax_planning.december_formula } : item.tax_planning.december.tbc, fcp: this.props.status === 'CLOSED' ? item.tax_planning.december.fcp : item.type_report_tax.value_fc.type_report_id == 5 || item.type_report_tax.value_fc.type_report_id == 6 || item.type_report_tax.value_fc.type_report_id == 7 ? { value: item.tax_planning.december.fcp, formula: item.tax_planning.december_formula } : item.tax_planning.december.fcp, tbf: this.props.status === 'CLOSED' ? item.tax_planning.december.tbf : item.type_report_tax.value_tbf.type_report_id == 5 || item.type_report_tax.value_tbf.type_report_id == 6 || item.type_report_tax.value_tbf.type_report_id == 7 ? { value: item.tax_planning.december.tbf, formula: item.tax_planning.december_formula } : item.tax_planning.december.tbf },
                            {
                                tbc: item.tax_planning.january !== null ? item.tax_planning.january !== "" ? item.tax_planning.january.tbc !== null ? item.tax_planning.january.tbc !== "" ? item.tax_planning.january.tbc : "0" : "0" : "0" : "0",
                                fcp: item.tax_planning.january !== null ? item.tax_planning.january !== "" ? item.tax_planning.january.fcp !== null ? item.tax_planning.january.fcp !== "" ? item.tax_planning.january.fcp : "0" : "0" : "0" : "0",
                                tbf: item.tax_planning.january !== null ? item.tax_planning.january !== "" ? item.tax_planning.january.tbf !== null ? item.tax_planning.january.tbf !== "" ? item.tax_planning.january.tbf : "0" : "0" : "0" : "0"
                            },
                            {
                                tbc: item.tax_planning.february !== null ? item.tax_planning.february !== "" ? item.tax_planning.february.tbc !== null ? item.tax_planning.february.tbc !== "" ? item.tax_planning.february.tbc : "0" : "0" : "0" : "0",
                                fcp: item.tax_planning.february !== null ? item.tax_planning.february !== "" ? item.tax_planning.february.fcp !== null ? item.tax_planning.february.fcp !== "" ? item.tax_planning.february.fcp : "0" : "0" : "0" : "0",
                                tbf: item.tax_planning.february !== null ? item.tax_planning.february !== "" ? item.tax_planning.february.tbf !== null ? item.tax_planning.february.tbf !== "" ? item.tax_planning.february.tbf : "0" : "0" : "0" : "0"
                            },
                            {
                                tbc: item.tax_planning.march !== null ? item.tax_planning.march !== "" ? item.tax_planning.march.tbc !== null ? item.tax_planning.march.tbc !== "" ? item.tax_planning.march.tbc : "0" : "0" : "0" : "0",
                                fcp: item.tax_planning.march !== null ? item.tax_planning.march !== "" ? item.tax_planning.march.fcp !== null ? item.tax_planning.march.fcp !== "" ? item.tax_planning.march.fcp : "0" : "0" : "0" : "0",
                                tbf: item.tax_planning.march !== null ? item.tax_planning.march !== "" ? item.tax_planning.march.tbf !== null ? item.tax_planning.march.tbf !== "" ? item.tax_planning.march.tbf : "0" : "0" : "0" : "0"
                            },
                            {
                                tbc: item.tax_planning.april !== null ? item.tax_planning.april !== "" ? item.tax_planning.april.tbc !== null ? item.tax_planning.april.tbc !== "" ? item.tax_planning.april.tbc : "0" : "0" : "0" : "0",
                                fcp: item.tax_planning.april !== null ? item.tax_planning.april !== "" ? item.tax_planning.april.fcp !== null ? item.tax_planning.april.fcp !== "" ? item.tax_planning.april.fcp : "0" : "0" : "0" : "0",
                                tbf: item.tax_planning.april !== null ? item.tax_planning.april !== "" ? item.tax_planning.april.tbf !== null ? item.tax_planning.april.tbf !== "" ? item.tax_planning.april.tbf : "0" : "0" : "0" : "0"
                            },
                            {
                                tbc: item.tax_planning.may !== null ? item.tax_planning.may !== "" ? item.tax_planning.may.tbc !== null ? item.tax_planning.may.tbc !== "" ? item.tax_planning.may.tbc : "0" : "0" : "0" : "0",
                                fcp: item.tax_planning.may !== null ? item.tax_planning.may !== "" ? item.tax_planning.may.fcp !== null ? item.tax_planning.may.fcp !== "" ? item.tax_planning.may.fcp : "0" : "0" : "0" : "0",
                                tbf: item.tax_planning.may !== null ? item.tax_planning.may !== "" ? item.tax_planning.may.tbf !== null ? item.tax_planning.may.tbf !== "" ? item.tax_planning.may.tbf : "0" : "0" : "0" : "0"
                            },
                            {
                                tbc: item.tax_planning.june !== null ? item.tax_planning.june !== "" ? item.tax_planning.june.tbc !== null ? item.tax_planning.june.tbc !== "" ? item.tax_planning.june.tbc : "0" : "0" : "0" : "0",
                                fcp: item.tax_planning.june !== null ? item.tax_planning.june !== "" ? item.tax_planning.june.fcp !== null ? item.tax_planning.june.fcp !== "" ? item.tax_planning.june.fcp : "0" : "0" : "0" : "0",
                                tbf: item.tax_planning.june !== null ? item.tax_planning.june !== "" ? item.tax_planning.june.tbf !== null ? item.tax_planning.june.tbf !== "" ? item.tax_planning.june.tbf : "0" : "0" : "0" : "0"
                            },
                            {
                                tbc: item.tax_planning.july !== null ? item.tax_planning.july !== "" ? item.tax_planning.july.tbc !== null ? item.tax_planning.july.tbc !== "" ? item.tax_planning.july.tbc : "0" : "0" : "0" : "0",
                                fcp: item.tax_planning.july !== null ? item.tax_planning.july !== "" ? item.tax_planning.july.fcp !== null ? item.tax_planning.july.fcp !== "" ? item.tax_planning.july.fcp : "0" : "0" : "0" : "0",
                                tbf: item.tax_planning.july !== null ? item.tax_planning.july !== "" ? item.tax_planning.july.tbf !== null ? item.tax_planning.july.tbf !== "" ? item.tax_planning.july.tbf : "0" : "0" : "0" : "0"
                            },
                            {
                                tbc: item.tax_planning.august !== null ? item.tax_planning.august !== "" ? item.tax_planning.august.tbc !== null ? item.tax_planning.august.tbc !== "" ? item.tax_planning.august.tbc : "0" : "0" : "0" : "0",
                                fcp: item.tax_planning.august !== null ? item.tax_planning.august !== "" ? item.tax_planning.august.fcp !== null ? item.tax_planning.august.fcp !== "" ? item.tax_planning.august.fcp : "0" : "0" : "0" : "0",
                                tbf: item.tax_planning.august !== null ? item.tax_planning.august !== "" ? item.tax_planning.august.tbf !== null ? item.tax_planning.august.tbf !== "" ? item.tax_planning.august.tbf : "0" : "0" : "0" : "0"
                            },
                            {
                                tbc: item.tax_planning.september !== null ? item.tax_planning.september !== "" ? item.tax_planning.september.tbc !== null ? item.tax_planning.september.tbc !== "" ? item.tax_planning.september.tbc : "0" : "0" : "0" : "0",
                                fcp: item.tax_planning.september !== null ? item.tax_planning.september !== "" ? item.tax_planning.september.fcp !== null ? item.tax_planning.september.fcp !== "" ? item.tax_planning.september.fcp : "0" : "0" : "0" : "0",
                                tbf: item.tax_planning.september !== null ? item.tax_planning.september !== "" ? item.tax_planning.september.tbf !== null ? item.tax_planning.september.tbf !== "" ? item.tax_planning.september.tbf : "0" : "0" : "0" : "0"
                            },
                            {
                                tbc: item.tax_planning.october !== null ? item.tax_planning.october !== "" ? item.tax_planning.october.tbc !== null ? item.tax_planning.october.tbc !== "" ? item.tax_planning.october.tbc : "0" : "0" : "0" : "0",
                                fcp: item.tax_planning.october !== null ? item.tax_planning.october !== "" ? item.tax_planning.october.fcp !== null ? item.tax_planning.october.fcp !== "" ? item.tax_planning.october.fcp : "0" : "0" : "0" : "0",
                                tbf: item.tax_planning.october !== null ? item.tax_planning.october !== "" ? item.tax_planning.october.tbf !== null ? item.tax_planning.october.tbf !== "" ? item.tax_planning.october.tbf : "0" : "0" : "0" : "0"
                            },
                            {
                                tbc: this.props.status === 'CLOSED' ? item.tax_planning.november !== null ? item.tax_planning.november !== "" ? item.tax_planning.november.tbc !== null ? item.tax_planning.november.tbc !== "" ? Number(item.tax_planning.november.tbc).toFixed(1) : "0" : "0" : "0" : "0" : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.november !== null ? item.tax_planning.november !== "" ? item.tax_planning.november.tbc !== null ? item.tax_planning.november.tbc !== "" ? Number(item.tax_planning.november.tbc).toFixed(1) : "0" : "0" : "0" : "0", formula: item.tax_planning.november_formula } : item.tax_planning.november !== null ? item.tax_planning.november !== "" ? item.tax_planning.november.tbc !== null ? item.tax_planning.november.tbc !== "" ? Number(item.tax_planning.november.tbc).toFixed(1) : "0" : "0" : "0" : "0",
                                fcp: this.props.status === 'CLOSED' ? item.tax_planning.november !== null ? item.tax_planning.november !== "" ? item.tax_planning.november.fcp !== null ? item.tax_planning.november.fcp !== "" ? Number(item.tax_planning.november.fcp).toFixed(1) : "0" : "0" : "0" : "0" : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.november !== null ? item.tax_planning.november !== "" ? item.tax_planning.november.fcp !== null ? item.tax_planning.november.fcp !== "" ? Number(item.tax_planning.november.fcp).toFixed(1) : "0" : "0" : "0" : "0", formula: item.tax_planning.november_formula } : item.tax_planning.november !== null ? item.tax_planning.november !== "" ? item.tax_planning.november.fcp !== null ? item.tax_planning.november.fcp !== "" ? Number(item.tax_planning.november.fcp).toFixed(1) : "0" : "0" : "0" : "0",
                                tbf: this.props.status === 'CLOSED' ? item.tax_planning.november !== null ? item.tax_planning.november !== "" ? item.tax_planning.november.tbf !== null ? item.tax_planning.november.tbf !== "" ? Number(item.tax_planning.november.tbf).toFixed(1) : "0" : "0" : "0" : "0" : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.november !== null ? item.tax_planning.november !== "" ? item.tax_planning.november.tbf !== null ? item.tax_planning.november.tbf !== "" ? Number(item.tax_planning.november.tbf).toFixed(1) : "0" : "0" : "0" : "0", formula: item.tax_planning.november_formula } : item.tax_planning.november !== null ? item.tax_planning.november !== "" ? item.tax_planning.november.tbf !== null ? item.tax_planning.november.tbf !== "" ? Number(item.tax_planning.november.tbf).toFixed(1) : "0" : "0" : "0" : "0"
                            },
                            {
                                tbc: this.props.status === 'CLOSED' ? item.tax_planning.december !== null ? item.tax_planning.december !== "" ? item.tax_planning.december.tbc !== null ? item.tax_planning.december.tbc !== "" ? Number(item.tax_planning.december.tbc).toFixed(1) : "0" : "0" : "0" : "0" : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.december !== null ? item.tax_planning.december !== "" ? item.tax_planning.december.tbc !== null ? item.tax_planning.december.tbc !== "" ? Number(item.tax_planning.december.tbc).toFixed(1) : "0" : "0" : "0" : "0", formula: item.tax_planning.december_formula } : item.tax_planning.december !== null ? item.tax_planning.december !== "" ? item.tax_planning.december.tbc !== null ? item.tax_planning.december.tbc !== "" ? Number(item.tax_planning.december.tbc).toFixed(1) : "0" : "0" : "0" : "0",
                                fcp: this.props.status === 'CLOSED' ? item.tax_planning.december !== null ? item.tax_planning.december !== "" ? item.tax_planning.december.fcp !== null ? item.tax_planning.december.fcp !== "" ? Number(item.tax_planning.december.fcp).toFixed(1) : "0" : "0" : "0" : "0" : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.december !== null ? item.tax_planning.december !== "" ? item.tax_planning.december.fcp !== null ? item.tax_planning.december.fcp !== "" ? Number(item.tax_planning.december.fcp).toFixed(1) : "0" : "0" : "0" : "0", formula: item.tax_planning.december_formula } : item.tax_planning.december !== null ? item.tax_planning.december !== "" ? item.tax_planning.december.fcp !== null ? item.tax_planning.december.fcp !== "" ? Number(item.tax_planning.december.fcp).toFixed(1) : "0" : "0" : "0" : "0",
                                tbf: this.props.status === 'CLOSED' ? item.tax_planning.december !== null ? item.tax_planning.december !== "" ? item.tax_planning.december.tbf !== null ? item.tax_planning.december.tbf !== "" ? Number(item.tax_planning.december.tbf).toFixed(1) : "0" : "0" : "0" : "0" : item.type_report_tax.value_tbc.type_report_id == 5 || item.type_report_tax.value_tbc.type_report_id == 6 || item.type_report_tax.value_tbc.type_report_id == 7 ? { value: item.tax_planning.december !== null ? item.tax_planning.december !== "" ? item.tax_planning.december.tbf !== null ? item.tax_planning.december.tbf !== "" ? Number(item.tax_planning.december.tbf).toFixed(1) : "0" : "0" : "0" : "0", formula: item.tax_planning.december_formula } : item.tax_planning.december !== null ? item.tax_planning.december !== "" ? item.tax_planning.december.tbf !== null ? item.tax_planning.december.tbf !== "" ? Number(item.tax_planning.december.tbf).toFixed(1) : "0" : "0" : "0" : "0"
                            },
                            item.tax_planning.total_current_year,
                            0,
                            0,
                            item.order,
                            { tbc: item.condition_it_should_be, fcp: item.condition_it_should_be, tbf: item.condition_it_should_be },
                            { tbc: item.condition_if_wrong, fcp: item.condition_if_wrong, tbf: item.condition_if_wrong },
                        ])
                        if (item.children !== null) {
                            if (item.children.length > 0) {
                                item.children.map((items, indexs) => {
                                    handlePushChild(items)
                                })
                            }
                        }
                    })
                    this.setState({ dataTable, loading: false, buttonError: false, editable: true })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                this.setState({ dataTable, loading: false, buttonError: true, editable: true })
            }
            console.log(dataTable)
        })
    }

    handleValue(data) {
        let total = 0
        this.state.dataTable.map((item, index) => {
            if (data.rowData[4] == item[5]) {
                total = item[data.columnIndex] == undefined ? (Number(total) + 0) : (Number(total) + Number(item[data.columnIndex]))
            }
        })
        let indexParent = this.state.dataTable.findIndex((val) => val[4] === this.state.dataTable[data.rowIndex][5])
        let a = this.state.dataTable[data.rowIndex][data.columnIndex] = total
        // console.log(indexParent);
        return a
    }

    handleChange(value, tableMeta) {
        let val = String(value).split(",").join("")
        let data = this.state.dataTable
        let indexParent = data.findIndex((val) => val[4] === data[tableMeta.rowIndex][5])
        if (indexParent > 0) {
            // console.log(indexParent)
            let a = data[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
            let jagain = data[indexParent][tableMeta.columnIndex]
            a = data[indexParent][tableMeta.columnIndex] = jagain == undefined ? (0 + Number(val)) : (jagain + Number(val))
        } else {
            data[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
        }
        // this.forceUpdate()
        // console.log(this.state.dataTable)
        // this.setState({
        //     data: a,
        // }, () => console.log(this.state.dataTable))
    }

    backToMasterBudget(type) {
        let data = []
        if (this.props.defaultCurrency.id == 2) {
            this.state.dataTable.map(i => {
                data.push({
                    item_report_id: i[4],
                    january: {
                        tbf: String(Number(i[9].tbf))
                    },
                    february: {
                        // tbc: String(Number(i[10].tbc).toFixed(1)),
                        // fcp: String(Number(i[10].fcp).toFixed(1)),
                        tbf: String(Number(i[10].tbf))
                    },
                    march: {
                        // tbc: String(Number(i[11].tbc)),
                        // fcp: String(Number(i[11].fcp)),
                        tbf: String(Number(i[11].tbf))
                    },
                    april: {
                        // tbc: String(Number(i[12].tbc)),
                        // fcp: String(Number(i[12].fcp)),
                        tbf: String(Number(i[12].tbf))
                    },
                    may: {
                        // tbc: String(Number(i[13].tbc)),
                        // fcp: String(Number(i[13].fcp)),
                        tbf: String(Number(i[13].tbf))
                    },
                    june: {
                        // tbc: String(Number(i[14].tbc)),
                        // fcp: String(Number(i[14].fcp)),
                        tbf: String(Number(i[14].tbf))
                    },
                    july: {
                        // tbc: String(Number(i[15].tbc)),
                        // fcp: String(Number(i[15].fcp)),
                        tbf: String(Number(i[15].tbf))
                    },
                    august: {
                        // tbc: String(Number(i[16].tbc)),
                        // fcp: String(Number(i[16].fcp)),
                        tbf: String(Number(i[16].tbf))
                    },
                    september: {
                        // tbc: String(Number(i[17].tbc)),
                        // fcp: String(Number(i[17].fcp)),
                        tbf: String(Number(i[17].tbf))
                    },
                    october: {
                        // tbc: String(Number(i[18].tbc)),
                        // fcp: String(Number(i[18].fcp)),
                        tbf: String(Number(i[18].tbf))
                    },
                    november: {
                        tbc: i[1] === 3 && i[19].tbc === "" ? "0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[19].tbc.value) : String(i[19].tbc),
                        fcp: i[2] === 3 && i[19].fcp === "" ? "0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[19].fcp.value) : String(i[19].fcp),
                        tbf: i[3] === 3 && i[19].tbf === "" ? "0" : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(i[19].tbf) : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[19].tbf.value) : String(i[19].tbf)
                    },
                    december: {
                        tbc: i[1] === 3 && i[20].tbc === "" ? "0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[20].tbc.value) : String(i[20].tbc),
                        fcp: i[2] === 3 && i[20].fcp === "" ? "0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[20].fcp.value) : String(i[20].fcp),
                        tbf: i[3] === 3 && i[20].tbf === "" ? "0" : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(i[20].tbf) : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[20].tbf.value) : String(i[20].tbf)
                    },
                    total_current_year: String(Number(i[21])),
                })
            })
        } else {
            this.state.dataTable.map(i => {
                data.push({
                    item_report_id: i[4],
                    january: {
                        // tbc: String(Number(i[9].tbc).toFixed(1)),
                        // fcp: String(Number(i[9].fcp).toFixed(1)),
                        tbf: String(fixNumber(Number(i[9].tbf), 1))
                    },
                    february: {
                        // tbc: String(Number(i[10].tbc).toFixed(1)),
                        // fcp: String(Number(i[10].fcp).toFixed(1)),
                        tbf: String(fixNumber(Number(i[10].tbf), 1))
                    },
                    march: {
                        // tbc: String(fixNumber(Number(i[11].tbc), 1)),
                        // fcp: String(fixNumber(Number(i[11].fcp), 1)),
                        tbf: String(fixNumber(Number(i[11].tbf), 1))
                    },
                    april: {
                        // tbc: String(fixNumber(Number(i[12].tbc), 1)),
                        // fcp: String(fixNumber(Number(i[12].fcp), 1)),
                        tbf: String(fixNumber(Number(i[12].tbf), 1))
                    },
                    may: {
                        // tbc: String(fixNumber(Number(i[13].tbc), 1)),
                        // fcp: String(fixNumber(Number(i[13].fcp), 1)),
                        tbf: String(fixNumber(Number(i[13].tbf), 1))
                    },
                    june: {
                        // tbc: String(fixNumber(Number(i[14].tbc), 1)),
                        // fcp: String(fixNumber(Number(i[14].fcp), 1)),
                        tbf: String(fixNumber(Number(i[14].tbf), 1))
                    },
                    july: {
                        // tbc: String(fixNumber(Number(i[15].tbc), 1)),
                        // fcp: String(fixNumber(Number(i[15].fcp), 1)),
                        tbf: String(fixNumber(Number(i[15].tbf), 1))
                    },
                    august: {
                        // tbc: String(fixNumber(Number(i[16].tbc), 1)),
                        // fcp: String(fixNumber(Number(i[16].fcp), 1)),
                        tbf: String(fixNumber(Number(i[16].tbf), 1))
                    },
                    september: {
                        // tbc: String(fixNumber(Number(i[17].tbc), 1)),
                        // fcp: String(fixNumber(Number(i[17].fcp), 1)),
                        tbf: String(fixNumber(Number(i[17].tbf), 1))
                    },
                    october: {
                        // tbc: String(fixNumber(Number(i[18].tbc), 1)),
                        // fcp: String(fixNumber(Number(i[18].fcp), 1)),
                        tbf: String(fixNumber(Number(i[18].tbf), 1))
                    },
                    november: {
                        tbc: i[1] === 3 && i[19].tbc === "" ? "0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[19].tbc.value) : String(i[19].tbc),
                        fcp: i[2] === 3 && i[19].fcp === "" ? "0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[19].fcp.value) : String(i[19].fcp),
                        tbf: i[3] === 3 && i[19].tbf === "" ? "0" : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(i[19].tbf) : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[19].tbf.value) : String(i[19].tbf)
                    },
                    december: {
                        tbc: i[1] === 3 && i[20].tbc === "" ? "0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[20].tbc.value) : String(i[20].tbc),
                        fcp: i[2] === 3 && i[20].fcp === "" ? "0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[20].fcp.value) : String(i[20].fcp),
                        tbf: i[3] === 3 && i[20].tbf === "" ? "0" : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(i[20].tbf) : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[20].tbf.value) : String(i[20].tbf)
                    },
                    total_current_year: String(fixNumber(Number(i[21]), 1)),
                })
            })
        }
        let payload = {
            "outlook_pa_id": this.props.outlook_pa_id,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "status": type,
            "currency_id": this.props.defaultCurrency.id,
            "tax_planning": data
        }
        console.log(payload);
        // console.log(JSON.stringify(payload));
        // this.setState({ loading: false })
        if (type == 'submitted') {
            this.props.saveToOLPA(payload, 'TP')
        } else {
            this.props.saveToOLPA(payload)
        }
        // this.props.saveToOLPA(payload)
        // this.props.onClickClose()
    }

    fileHandler = (event) => {
        let fileObj = event
        ExcelRenderer(fileObj, (err, resp) => {
            console.log(resp)
            if (err) {
                // console.log(err);
            }
            else {
                let isi = resp.rows.slice(4)
                // console.log(resp.rows[2]);
                // console.log(resp.rows);
                let payload = []
                let reg = /^[-+]?(?:[0-9]+,)*[0-9]+(?:\.[0-9]+)?$/;
                isi.map((i, index) => {
                    if (i.length > 0) {
                        payload.push({
                            item_report_id: i[0] === undefined ? "" : String(i[0]).trim(),
                            item_report: i[1] === undefined ? "" : String(i[1]).trim(),
                            january: {
                                // tbc: i[2] === undefined ? "0" : reg.test(String(i[2])) === false ? "0" : String(i[2]).trim(),
                                // fcp: i[3] === undefined ? "0" : reg.test(String(i[3])) === false ? "0" : String(i[3]).trim(),
                                tbf: i[2] === undefined ? "0" : reg.test(String(i[2])) === false ? "0" : String(i[2]).trim(),
                            },
                            february: {
                                // tbc: i[5] === undefined ? "0" : reg.test(String(i[5])) === false ? "0" : String(i[5]).trim(),
                                // fcp: i[6] === undefined ? "0" : reg.test(String(i[6])) === false ? "0" : String(i[6]).trim(),
                                tbf: i[3] === undefined ? "0" : reg.test(String(i[3])) === false ? "0" : String(i[3]).trim(),
                            },
                            march: {
                                // tbc: i[8] === undefined ? "0" : reg.test(String(i[8])) === false ? "0" : String(i[8]).trim(),
                                // fcp: i[9] === undefined ? "0" : reg.test(String(i[9])) === false ? "0" : String(i[9]).trim(),
                                tbf: i[4] === undefined ? "0" : reg.test(String(i[4])) === false ? "0" : String(i[4]).trim(),
                            },
                            april: {
                                // tbc: i[11] === undefined ? "0" : reg.test(String(i[11])) === false ? "0" : String(i[11]).trim(),
                                // fcp: i[12] === undefined ? "0" : reg.test(String(i[12])) === false ? "0" : String(i[12]).trim(),
                                tbf: i[5] === undefined ? "0" : reg.test(String(i[5])) === false ? "0" : String(i[5]).trim(),
                            },
                            may: {
                                // tbc: i[14] === undefined ? "0" : reg.test(String(i[14])) === false ? "0" : String(i[14]).trim(),
                                // fcp: i[15] === undefined ? "0" : reg.test(String(i[15])) === false ? "0" : String(i[15]).trim(),
                                tbf: i[6] === undefined ? "0" : reg.test(String(i[6])) === false ? "0" : String(i[6]).trim(),
                            },
                            june: {
                                // tbc: i[17] === undefined ? "0" : reg.test(String(i[17])) === false ? "0" : String(i[17]).trim(),
                                // fcp: i[18] === undefined ? "0" : reg.test(String(i[18])) === false ? "0" : String(i[18]).trim(),
                                tbf: i[7] === undefined ? "0" : reg.test(String(i[7])) === false ? "0" : String(i[7]).trim(),
                            },
                            july: {
                                // tbc: i[20] === undefined ? "0" : reg.test(String(i[20])) === false ? "0" : String(i[20]).trim(),
                                // fcp: i[21] === undefined ? "0" : reg.test(String(i[21])) === false ? "0" : String(i[21]).trim(),
                                tbf: i[8] === undefined ? "0" : reg.test(String(i[8])) === false ? "0" : String(i[8]).trim(),
                            },
                            august: {
                                // tbc: i[23] === undefined ? "0" : reg.test(String(i[23])) === false ? "0" : String(i[23]).trim(),
                                // fcp: i[24] === undefined ? "0" : reg.test(String(i[24])) === false ? "0" : String(i[24]).trim(),
                                tbf: i[9] === undefined ? "0" : reg.test(String(i[9])) === false ? "0" : String(i[9]).trim(),
                            },
                            september: {
                                // tbc: i[26] === undefined ? "0" : reg.test(String(i[26])) === false ? "0" : String(i[26]).trim(),
                                // fcp: i[27] === undefined ? "0" : reg.test(String(i[27])) === false ? "0" : String(i[27]).trim(),
                                tbf: i[10] === undefined ? "0" : reg.test(String(i[10])) === false ? "0" : String(i[10]).trim(),
                            },
                            october: {
                                // tbc: i[29] === undefined ? "0" : reg.test(String(i[29])) === false ? "0" : String(i[29]).trim(),
                                // fcp: i[30] === undefined ? "0" : reg.test(String(i[30])) === false ? "0" : String(i[30]).trim(),
                                tbf: i[11] === undefined ? "0" : reg.test(String(i[11])) === false ? "0" : String(i[11]).trim(),
                            },
                            november: {
                                tbc: i[12] === undefined ? "0" : reg.test(String(i[12])) === false ? "0" : String(i[12]).trim(),
                                fcp: i[13] === undefined ? "0" : reg.test(String(i[13])) === false ? "0" : String(i[13]).trim(),
                                tbf: i[14] === undefined ? "0" : reg.test(String(i[14])) === false ? "0" : String(i[14]).trim(),
                            },
                            december: {
                                tbc: i[15] === undefined ? "0" : reg.test(String(i[15])) === false ? "0" : String(i[15]).trim(),
                                fcp: i[16] === undefined ? "0" : reg.test(String(i[16])) === false ? "0" : String(i[16]).trim(),
                                tbf: i[17] === undefined ? "0" : reg.test(String(i[17])) === false ? "0" : String(i[17]).trim(),
                            },
                            total_current_year: i[18] === undefined ? "" : String(i[18]).trim(),
                            total_next_year: {
                                tbc: i[19] === undefined ? "0" : reg.test(String(i[19])) === false ? "0" : String(i[19]).trim(),
                                fcp: i[20] === undefined ? "0" : reg.test(String(i[20])) === false ? "0" : String(i[20]).trim(),
                                tbf: i[21] === undefined ? "0" : reg.test(String(i[21])) === false ? "0" : String(i[21]).trim(),
                            },
                            total_more_year: {
                                tbc: i[22] === undefined ? "0" : reg.test(String(i[22])) === false ? "0" : String(i[22]).trim(),
                                fcp: i[23] === undefined ? "0" : reg.test(String(i[23])) === false ? "0" : String(i[23]).trim(),
                                tbf: i[24] === undefined ? "0" : reg.test(String(i[24])) === false ? "0" : String(i[24]).trim(),
                            }
                        })
                    }
                })
                let body = {
                    company_id: this.props.company.company_id,
                    periode: this.props.periode,
                    report_id: this.props.report_id,
                    tax_planning: payload
                }
                this.setState({ payload: body, judul: resp.rows[1][0], judulColumn: resp.rows[2] })
                // console.log(this.state.judulColumn)
            }
        });
    }

    checkUpload() {
        let payload = {
            ...this.state.payload,
            currency_id: this.state.defaultCurrencyUpload?.id
        }
        api.create().checkUploadOLPA(payload).then(response => {
            // console.log(JSON.stringify(this.state.payload));
            console.log(response)
            if (response.data) {
                if (response.data.status === 'success') {
                    this.setState({ visibleUpload: false, visibleTP: false, loading: true })
                    let dataTable = response.data.data.map((item, index) => {
                        return [
                            // item.type_report_id,
                            0,
                            Number(item.type_report_id.tbc),
                            Number(item.type_report_id.fcp),
                            Number(item.type_report_id.tbf),
                            item.item_report_id,
                            item.parent,
                            item.formula,
                            // {tbc: item.formula.tbc, fcp: item.formula.fcp, tbf: item.formula.tbf},
                            item.level,
                            item.item_report,
                            {
                                tbc: 0,
                                fcp: 0,
                                tbf: Number(item.type_report_id.tbf) === 3 && item.january.tbf === "" ? "0" : item.january.tbf
                            },
                            {
                                tbc: 0,
                                fcp: 0,
                                tbf: Number(item.type_report_id.tbf) === 3 && item.february.tbf === "" ? "0" : item.february.tbf
                            },
                            {
                                tbc: 0,
                                fcp: 0,
                                tbf: Number(item.type_report_id.tbf) === 3 && item.march.tbf === "" ? "0" : item.march.tbf
                            },
                            {
                                tbc: 0,
                                fcp: 0,
                                tbf: Number(item.type_report_id.tbf) === 3 && item.april.tbf === "" ? "0" : item.april.tbf
                            },
                            {
                                tbc: 0,
                                fcp: 0,
                                tbf: Number(item.type_report_id.tbf) === 3 && item.may.tbf === "" ? "0" : item.may.tbf
                            },
                            {
                                tbc: 0,
                                fcp: 0,
                                tbf: Number(item.type_report_id.tbf) === 3 && item.june.tbf === "" ? "0" : item.june.tbf
                            },
                            {
                                tbc: 0,
                                fcp: 0,
                                tbf: Number(item.type_report_id.tbf) === 3 && item.july.tbf === "" ? "0" : item.july.tbf
                            },
                            {
                                tbc: 0,
                                fcp: 0,
                                tbf: Number(item.type_report_id.tbf) === 3 && item.august.tbf === "" ? "0" : item.august.tbf
                            },
                            {
                                tbc: 0,
                                fcp: 0,
                                tbf: Number(item.type_report_id.tbf) === 3 && item.september.tbf === "" ? "0" : item.september.tbf
                            },
                            {
                                tbc: 0,
                                fcp: 0,
                                tbf: Number(item.type_report_id.tbf) === 3 && item.october.tbf === "" ? "0" : item.october.tbf
                            },
                            {
                                tbc: Number(item.type_report_id.tbc) === 3 && item.november.tbc === "" ? "0" : (Number(item.type_report_id.tbc) === 5 || Number(item.type_report_id.tbc) === 6 || Number(item.type_report_id.tbc) === 7 ? { value: item.november.tbc, formula: item.november_formula } : item.november.tbc),
                                fcp: Number(item.type_report_id.fcp) === 3 && item.november.fcp === "" ? "0" : (Number(item.type_report_id.fcp) === 5 || Number(item.type_report_id.fcp) === 6 || Number(item.type_report_id.fcp) === 7 ? { value: item.november.fcp, formula: item.november_formula } : item.november.fcp),
                                tbf: Number(item.type_report_id.tbf) === 3 && item.november.tbf === "" ? "0" : (Number(item.type_report_id.tbf) === 5 || Number(item.type_report_id.tbf) === 6 || Number(item.type_report_id.tbf) === 7 ? { value: item.november.tbf, formula: item.november_formula } : item.november.tbf)
                            },
                            {
                                tbc: Number(item.type_report_id.tbc) === 3 && item.december.tbc === "" ? "0" : (Number(item.type_report_id.tbc) === 5 || Number(item.type_report_id.tbc) === 6 || Number(item.type_report_id.tbc) === 7 ? { value: item.december.tbc, formula: item.december_formula } : item.december.tbc),
                                fcp: Number(item.type_report_id.fcp) === 3 && item.december.fcp === "" ? "0" : (Number(item.type_report_id.fcp) === 5 || Number(item.type_report_id.fcp) === 6 || Number(item.type_report_id.fcp) === 7 ? { value: item.december.fcp, formula: item.december_formula } : item.december.fcp),
                                tbf: Number(item.type_report_id.tbf) === 3 && item.december.tbf === "" ? "0" : (Number(item.type_report_id.tbf) === 5 || Number(item.type_report_id.tbf) === 6 || Number(item.type_report_id.tbf) === 7 ? { value: item.december.tbf, formula: item.december_formula } : item.december.tbf)
                            },
                            item.total_current_year,
                            0,
                            0,
                            item.orders,
                            item.error
                        ]
                    })
                    this.setState({ dataTable, dataLoaded: true, loading: false, buttonError: false, editable: true }, () => {
                        this.state.dataTable.map(item => {
                            if (item[25].length > 0) {
                                console.log('masuk')
                                this.setState({ buttonError: true, errorPreview: true, editable: true })
                            }
                        })
                        console.log(this.state.dataTable);
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            }
        })
    }

    uploadTP(type) {
        let data = []
        if (this.state.defaultCurrencyUpload?.id == 2) {
            this.state.dataTable.map(i => {
                data.push({
                    item_report_id: i[4],
                    january: {
                        tbf: String(Number(i[9].tbf))
                    },
                    february: {
                        tbf: String(Number(i[10].tbf))
                    },
                    march: {
                        tbf: String(Number(i[11].tbf))
                    },
                    april: {
                        tbf: String(Number(i[12].tbf))
                    },
                    may: {
                        tbf: String(Number(i[13].tbf))
                    },
                    june: {
                        tbf: String(Number(i[14].tbf))
                    },
                    july: {
                        tbf: String(Number(i[15].tbf))
                    },
                    august: {
                        tbf: String(Number(i[16].tbf))
                    },
                    september: {
                        tbf: String(Number(i[17].tbf))
                    },
                    october: {
                        tbf: String(Number(i[18].tbf))
                    },
                    november: {
                        tbc: String(Number(i[19].tbc)),
                        fcp: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[19].fcp)) : String(Number(i[19].fcp)),
                        tbf: String(Number(i[19].tbf))
                    },
                    december: {
                        tbc: String(Number(i[20].tbc)),
                        fcp: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(Number(i[20].fcp)) : String(Number(i[20].fcp)),
                        tbf: String(Number(i[20].tbf))
                    },
                    total_current_year: String(Number(i[21]))
                })
            })
        } else {
            this.state.dataTable.map(i => {
                data.push({
                    item_report_id: i[4],
                    january: {
                        // tbc: String(Number(i[9].tbc).toFixed(1)),
                        // fcp: String(Number(i[9].fcp).toFixed(1)),
                        tbf: String(fixNumber(Number(i[9].tbf), 1))
                    },
                    february: {
                        // tbc: String(Number(i[10].tbc).toFixed(1)),
                        // fcp: String(Number(i[10].fcp).toFixed(1)),
                        tbf: String(fixNumber(Number(i[10].tbf), 1))
                    },
                    march: {
                        // tbc: String(fixNumber(Number(i[11].tbc), 1)),
                        // fcp: String(fixNumber(Number(i[11].fcp), 1)),
                        tbf: String(fixNumber(Number(i[11].tbf), 1))
                    },
                    april: {
                        // tbc: String(fixNumber(Number(i[12].tbc), 1)),
                        // fcp: String(fixNumber(Number(i[12].fcp), 1)),
                        tbf: String(fixNumber(Number(i[12].tbf), 1))
                    },
                    may: {
                        // tbc: String(fixNumber(Number(i[13].tbc), 1)),
                        // fcp: String(fixNumber(Number(i[13].fcp), 1)),
                        tbf: String(fixNumber(Number(i[13].tbf), 1))
                    },
                    june: {
                        // tbc: String(fixNumber(Number(i[14].tbc), 1)),
                        // fcp: String(fixNumber(Number(i[14].fcp), 1)),
                        tbf: String(fixNumber(Number(i[14].tbf), 1))
                    },
                    july: {
                        // tbc: String(fixNumber(Number(i[15].tbc), 1)),
                        // fcp: String(fixNumber(Number(i[15].fcp), 1)),
                        tbf: String(fixNumber(Number(i[15].tbf), 1))
                    },
                    august: {
                        // tbc: String(fixNumber(Number(i[16].tbc), 1)),
                        // fcp: String(fixNumber(Number(i[16].fcp), 1)),
                        tbf: String(fixNumber(Number(i[16].tbf), 1))
                    },
                    september: {
                        // tbc: String(fixNumber(Number(i[17].tbc), 1)),
                        // fcp: String(fixNumber(Number(i[17].fcp), 1)),
                        tbf: String(fixNumber(Number(i[17].tbf), 1))
                    },
                    october: {
                        // tbc: String(fixNumber(Number(i[18].tbc), 1)),
                        // fcp: String(fixNumber(Number(i[18].fcp), 1)),
                        tbf: String(fixNumber(Number(i[18].tbf), 1))
                    },
                    november: {
                        tbc: String(fixNumber(Number(i[19].tbc), 1)),
                        fcp: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[19].fcp), 2)) : String(fixNumber(Number(i[19].fcp), 1)),
                        tbf: String(fixNumber(Number(i[19].tbf), 1))
                    },
                    december: {
                        tbc: String(fixNumber(Number(i[20].tbc), 1)),
                        fcp: String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(fixNumber(Number(i[20].fcp), 2)) : String(fixNumber(Number(i[20].fcp), 1)),
                        tbf: String(fixNumber(Number(i[20].tbf), 1))
                    },
                    total_current_year: String(fixNumber(Number(i[21]), 1))
                })
            })
        }

        let body = {
            outlook_pa_id: this.props.outlook_pa_id,
            company_id: this.props.company.company_id,
            periode: this.props.periode,
            report_id: this.props.report_id,
            currency_id: this.state.defaultCurrencyUpload?.id,
            tax_planning: data,
            status: type
        }
        // console.log(data);
        api.create('UPLOAD').uploadOLPA(body).then(response => {
            // console.log(response);
            if (response.data) {
                if (response.data.status === "success") {
                    this.props.onClickClose()
                    this.props.getReport()
                } else {
                    if (response.data?.message == "Please Set Up Rate Currency First") {
                        this.setState({ visibleAlertSave: true })
                    } else {
                        // this.setState({ alert: true, messageAlert: response.data.status, tipeAlert: 'error', loading: false })
                        this.setState({ visibleAlertSave: true, alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    handleValidate() {
        let data = []
        let errorContrl = this.state.buttonError
        let editAble = this.state.editAble
        // console.log(this.state.dataTable)
        this.state.dataTable.map(i => {
            // console.log(i[0])
            data.push({
                item_report_id: i[4],
                january: {
                    tbc: i[1] === 3 && i[9].tbc === "" ? "0" : String(i[9].tbc),
                    fcp: i[2] === 3 && i[9].fcp === "" ? "0" : String(i[9].fcp),
                    tbf: i[3] === 3 && i[9].tbf === "" ? "0" : String(i[9].tbf)
                },
                february: {
                    tbc: i[1] === 3 && i[10].tbc === "" ? "0" : String(i[10].tbc),
                    fcp: i[2] === 3 && i[10].fcp === "" ? "0" : String(i[10].fcp),
                    tbf: i[3] === 3 && i[10].tbf === "" ? "0" : String(i[10].tbf)
                },
                march: {
                    tbc: i[1] === 3 && i[11].tbc === "" ? "0" : String(i[11].tbc),
                    fcp: i[2] === 3 && i[11].fcp === "" ? "0" : String(i[11].fcp),
                    tbf: i[3] === 3 && i[11].tbf === "" ? "0" : String(i[11].tbf)
                },
                april: {
                    tbc: i[1] === 3 && i[12].tbc === "" ? "0" : String(i[12].tbc),
                    fcp: i[2] === 3 && i[12].fcp === "" ? "0" : String(i[12].fcp),
                    tbf: i[3] === 3 && i[12].tbf === "" ? "0" : String(i[12].tbf)
                },
                may: {
                    tbc: i[1] === 3 && i[13].tbc === "" ? "0" : String(i[13].tbc),
                    fcp: i[2] === 3 && i[13].fcp === "" ? "0" : String(i[13].fcp),
                    tbf: i[3] === 3 && i[13].tbf === "" ? "0" : String(i[13].tbf)
                },
                june: {
                    tbc: i[1] === 3 && i[14].tbc === "" ? "0" : String(i[14].tbc),
                    fcp: i[2] === 3 && i[14].fcp === "" ? "0" : String(i[14].fcp),
                    tbf: i[3] === 3 && i[14].tbc === "" ? "0" : String(i[14].tbf)
                },
                july: {
                    tbc: i[1] === 3 && i[15].tbc === "" ? "0" : String(i[15].tbc),
                    fcp: i[2] === 3 && i[15].fcp === "" ? "0" : String(i[15].fcp),
                    tbf: i[3] === 3 && i[15].tbf === "" ? "0" : String(i[15].tbf)
                },
                august: {
                    tbc: i[1] === 3 && i[16].tbc === "" ? "0" : String(i[16].tbc),
                    fcp: i[2] === 3 && i[16].fcp === "" ? "0" : String(i[16].fcp),
                    tbf: i[3] === 3 && i[16].tbf === "" ? "0" : String(i[16].tbf)
                },
                september: {
                    tbc: i[1] === 3 && i[17].tbc === "" ? "0" : String(i[17].tbc),
                    fcp: i[2] === 3 && i[17].fcp === "" ? "0" : String(i[17].fcp),
                    tbf: i[3] === 3 && i[17].tbf === "" ? "0" : String(i[17].tbf)
                },
                october: {
                    tbc: i[1] === 3 && i[18].tbc === "" ? "0" : String(i[18].tbc),
                    fcp: i[2] === 3 && i[18].fcp === "" ? "0" : String(i[18].fcp),
                    tbf: i[3] === 3 && i[18].tbf === "" ? "0" : String(i[18].tbf)
                },
                november: {
                    tbc: i[1] === 3 && i[19].tbc === "" ? "0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[19].tbc.value) : String(i[19].tbc),
                    fcp: i[2] === 3 && i[19].fcp === "" ? "0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[19].fcp.value) : String(i[19].fcp),
                    tbf: i[3] === 3 && i[19].tbf === "" ? "0" : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(i[19].tbf) : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[19].tbf.value) : String(i[19].tbf)
                },
                december: {
                    tbc: i[1] === 3 && i[20].tbc === "" ? "0" : i[1] === 5 || i[1] === 6 || i[1] === 7 ? String(i[20].tbc.value) : String(i[20].tbc),
                    fcp: i[2] === 3 && i[20].fcp === "" ? "0" : i[2] === 5 || i[2] === 6 || i[2] === 7 ? String(i[20].fcp.value) : String(i[20].fcp),
                    tbf: i[3] === 3 && i[20].tbf === "" ? "0" : String(i[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? String(i[20].tbf) : i[3] === 5 || i[3] === 6 || i[3] === 7 ? String(i[20].tbf.value) : String(i[20].tbf)
                },
                total_current_year: i[2] === 3 && i[21] === "" ? "0" : String(i[21]),
                // total_next_year: {
                //     tbc: i[1] === 3 && i[22].tbc === "" ? "0" : String(i[22].tbc),
                //     fcp: i[2] === 3 && i[22].fcp === "" ? "0" : String(i[22].fcp),
                //     tbf: i[3] === 3 && i[22].tbf === "" ? "0" : String(i[22].tbf)
                // },
                // total_more_year: {
                //     tbc: i[1] === 3 && i[23].tbc === "" ? "0" : String(i[23].tbc),
                //     fcp: i[2] === 3 && i[23].fcp === "" ? "0" : String(i[23].fcp),
                //     tbf: i[3] === 3 && i[23].tbf === "" ? "0" : String(i[23].tbf)
                // }

            })

            if (String(i[8]) == "Control (should be nil)") {
                this.setState({ loading: true })
                if ((Number(i[19].tbf.value) < Number(this.state.minValue) || Number(i[19].tbf.value) > Number(this.state.maxValue)) || (Number(i[20].tbf.value) < Number(this.state.minValue) || Number(i[20].tbf.value) > Number(this.state.maxValue)) || (Number(i[21]) < Number(this.state.minValue) || Number(i[21]) > Number(this.state.maxValue))) {
                    errorContrl = true
                    editAble = true
                }
                else {
                    errorContrl = false
                    editAble = false
                }
            }
        })
        // console.log(JSON.stringify(data))
        // let payload = {
        //     "outlook_pa_id": this.props.outlook_pa_id,
        //     "company_id": this.props.company.company_id,
        //     "periode": this.props.periode,
        //     "report_id": this.props.report_id,
        //     "tax_planning": data,
        //     "status": "submitted"
        // }
        // api.create().validateSubmitReportOLPA(payload).then((response) => {
        //     console.log(payload)
        //     console.log(response)
        //     if (response.data) {
        //         if (response.data.status === "success") {
        // if (response.data.data.result && errorContrl === false && editAble === false ) {
        if (errorContrl === false && editAble === false) {
            this.setState({ loading: false, buttonError: false, editable: false, saveDraft: false })
        } else {
            this.setState({ loading: false, buttonError: true, editable: true, saveDraft: false })
            console.log("masuk button error")
        }
        //     } else {
        //         this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
        //             if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
        //                 setTimeout(() => {
        //                     localStorage.removeItem(Constant.TOKEN)
        //                     window.location.reload();
        //                 }, 1000);
        //             }
        //         })
        //     }
        // } else {
        //     this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
        // }
        // })
    }

    downloadTemplate = async () => {
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/outlook_pa/download_template?report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&currency_id=${this.props.defaultCurrency.id}`
        )
        res = await res.blob()
        // console.log(res)
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Template Outlook Performance Appraisal Tax Planning.xlsx';
            a.click();
        }
    }

    async downloadAllData() {
        let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/outlook_pa/export_outlook_pa?outlook_pa_id=${this.props.outlook_pa_id}&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}`
        let sub_null = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/outlook_pa/export_outlook_pa?outlook_pa_id=&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}`
        console.log(url);
        let res = await fetch(
            this.props.outlook_pa_id == null ? sub_null : url
        )
        res = await res.blob()
        this.setState({ loading: false })
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Outlook Performance Appraisal Tax Planning.xlsx';
            a.click();
        }
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    render() {
        let dataTable2 = this.state.dataTable
        let dataFormula = []
        let id = 0
        let double = false

        const handleValueFormula = (value, tableMeta, dex, xntd, forecast, periode) => {
            // console.log(xntd)
            let form = dex === 1 ? tableMeta.rowData[6].tbc : dex === 2 ? tableMeta.rowData[6].fcp : tableMeta.rowData[6].tbf
            let splitFormula = String(form).split('@')
            let baru = []
            let anjay = []
            splitFormula.map((item, index) => {
                let items = String(item).substr(Number(String(item).length) - 1, 1)
                let re = /^[a-zA-Z0-9_]+$/;
                let asd = ''
                if (item !== "") {
                    if (!re.test(items)) {
                        baru.push(String(item).substr(0, Number(String(item).length) - 1))
                        baru.push(String(item).substr(Number(String(item).length) - 1, 1))
                    } else {
                        baru.push(String(item))
                    }
                }
            })

            // console.log(baru);

            // if (forecast !== undefined) {
            //     console.log(splitFormula)
            // }

            if (tableMeta.rowData[8] == "Under payment  /(Over Payment ) Income Tax Art.  29" || forecast !== undefined) {
                // form.replace("(", "")
                // form.replace(")", "")
                let opgab = []
                baru.map((item, index) => {
                    if (item.length > 1 && (item.includes("+") || item.includes("-") || item.includes("*") || item.includes("/"))) {
                        opgab.push(String(item).substr(0, Number(String(item).length) - 1))
                        opgab.push(String(item).substr(Number(String(item).length) - 1, 1))
                    } else {
                        opgab.push(item)
                    }
                })
                if (opgab.length > 0) {
                    baru = opgab
                }
            }

            let totalShldBeNil = 0
            baru.map((item, index) => {
                if (item == '-' || item == '+' || item == '/' || item == '*' || item == '(' || item == ')') {
                    anjay.push(item)
                } else {
                    if (String(item).includes('#')) {
                        let splitform = String(item).split('#')
                        if (splitform[1] == 'TP1' || splitform[1] == 'TP2' || splitform[1] == 'TP3') {
                            let indexID = dataTable2.findIndex((val) => val[24] == splitform[0])
                            if (indexID !== -1) {
                                // console.log(splitform)
                                let data = splitform[1] == 'TP1' ? dataTable2[indexID][tableMeta.columnIndex].tbc : splitform[1] == 'TP2' ? dataTable2[indexID][tableMeta.columnIndex].fcp : dataTable2[indexID][tableMeta.columnIndex].tbf
                                // console.log(data)
                                // if(value == null){
                                //     console.log(tableMeta);
                                // }
                                let valuezz = data.value == undefined ? data : data.value
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            }
                        } else {
                            if (forecast !== undefined) {
                                forecast.map((item, index) => {
                                    if (periode == item.periode) {
                                        totalShldBeNil += Number(item.value)
                                    }
                                })
                                anjay.push(totalShldBeNil)
                            } else if (String(item).includes('[M-1]')) {
                                let tst = String(item).replace('[M-1]', '')
                                let data = tableMeta.columnIndex == 9 ? 20 : tableMeta.columnIndex - 1
                                let dataSub = dex == 1 ? tableMeta.rowData[data].tbc : dex == 2 ? tableMeta.rowData[data].fcp : tableMeta.rowData[data].tbf
                                let period = data == 20 ? Number(this.props.periode) - 1 : this.props.periode
                                let indexID = dataSub.formula.findIndex((val) => val.item_formula == String(`@${tst}`) && val.periode == period)
                                if (indexID !== -1) {
                                    let valuezz = tableMeta.rowData[data].formula[indexID].value
                                    anjay.push(valuezz == "" ? 0 : valuezz)
                                }
                            } else {
                                // console.log(value);
                                // if(value == null){
                                //     console.log(tableMeta);
                                // }
                                let data = dex == 1 ? value.tbc : dex == 2 ? value.fcp : value.tbf
                                console.log(data);
                                if (data.formula) {
                                    let indexID = data.formula.findIndex((val) => val.item_formula == String(`@${item}`) && val.periode == Number(this.props.periode))
                                    if (indexID !== -1) {
                                        let valuezz = data.formula[indexID].value
                                        anjay.push(valuezz == "" ? 0 : valuezz)
                                    }
                                }
                            }
                        }
                    } else {
                        let indexID = dataTable2.findIndex((val) => val[24] == item)
                        if (indexID !== -1) {
                            if (dataTable2[indexID][24] == tableMeta.rowData[24]) {
                                anjay.push(0)
                            } else {
                                let data = dex == 1 ? dataTable2[indexID][tableMeta.columnIndex].tbc : dex == 2 ? dataTable2[indexID][tableMeta.columnIndex].fcp : dataTable2[indexID][tableMeta.columnIndex].tbf
                                let valuezz = data.value == undefined ? data : data.value
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            }

                        }
                    }
                }
            })

            let total = 0
            let total2 = 0
            let opt = ""
            let opt2 = ""
            let prio = false
            let simpen2 = ""
            anjay.map((item, index) => {
                if (item == "+") {
                    if (prio) {
                        opt2 = "tambah"
                    } else {
                        opt = "tambah"
                    }
                } else if (item == "-") {
                    if (prio) {
                        opt2 = "kurang"
                    } else {
                        opt = "kurang"
                    }
                } else if (item == "*") {
                    if (prio) {
                        opt2 = "kali"
                    } else {
                        opt = "kali"
                    }
                } else if (item == "/") {
                    if (prio) {
                        opt2 = "bagi"
                    } else {
                        opt = "bagi"
                    }
                } else if (item == "(") {
                    prio = true
                    simpen2 = "active"
                } else if (item == ")") {
                    prio = false
                }
                else {
                    if (prio) {
                        if (opt2 == "tambah") {
                            total2 = Number(total2) + Number(item)
                        } else if (opt2 == "kurang") {
                            total2 = Number(total2) - Number(item)
                        } else if (opt2 == "kali") {
                            total2 = Number(total2) * Number(item)
                        } else if (opt2 == "bagi") {
                            total2 = Number(total2) / Number(item) == NaN ? 0 : Number(total2) / Number(item)
                        } else {
                            total2 += Number(item)
                        }
                    } else {
                        if (opt == "tambah") {
                            total = Number(total) + Number(item)
                        } else if (opt == "kurang") {
                            total = Number(total) - Number(item)
                        } else if (opt == "kali") {
                            total = Number(total) * Number(item)
                        } else if (opt == "bagi") {
                            total = Number(total) / Number(item) == NaN ? 0 : Number(total) / Number(item)
                        } else {
                            total += Number(item)
                        }
                    }
                }
            })

            if (simpen2 == "active") {
                if (opt == "tambah") {
                    total = Number(total) + Number(total2)
                } else if (opt == "kurang") {
                    total = Number(total) - Number(total2)
                } else if (opt == "kali") {
                    total = Number(total) * Number(total2)
                } else if (opt == "bagi") {
                    total = Number(total) / Number(total2) == NaN ? 0 : Number(total) / Number(total2)
                }
            }

            total = R.equals(total, NaN) ? "0.0" : total
            // console.log(tableMeta.rowData[8])
            // if (xntd !== undefined && tableMeta.rowData[8] == "Under payment  /(Over Payment ) Income Tax Art.  29") {
            //     console.log(tableMeta.rowData[8])
            //     // console.log(splitFormula)
            //     console.log(xntd)
            //     console.log(baru)
            //     console.log(anjay)
            //     console.log(total)
            //     console.log(total2)
            //     console.log(opt)
            // }

            // let dataSub = dex == 1? dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbc : dex == 2? dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].fcp : dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbf
            if (dex == 1) {
                if (dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbc.value == undefined) {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbc = this.props.defaultCurrency.id == 1 ? fixNumber(Number(total), 1) : Number(total)
                } else {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbc.value = this.props.defaultCurrency.id == 1 ? fixNumber(Number(total), 1) : Number(total)
                }
            } else if (dex == 2) {
                if (dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].fcp.value == undefined) {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].fcp = this.props.defaultCurrency.id == 1 ? fixNumber(Number(total), 1) : Number(total)
                } else {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].fcp.value = this.props.defaultCurrency.id == 1 ? fixNumber(Number(total), 1) : Number(total)
                }
            } else if (dex == 3) {
                if (tableMeta.rowData[8] == "Corporate Income Tax") {
                    if (total < 0) {
                        total = 0
                        dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbf = this.props.defaultCurrency.id == 1 ? fixNumber(Number(total), 2) : Number(total)
                    } else {
                        dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbf = this.props.defaultCurrency.id == 1 ? fixNumber(Number(total), 2) : Number(total)
                    }
                } else if (dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbf.value == undefined) {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbf = this.props.defaultCurrency.id == 1 ? fixNumber(Number(total), 1) : Number(total)
                } else {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbf.value = this.props.defaultCurrency.id == 1 ? fixNumber(Number(total), 1) : Number(total)
                }
            } else {
                if (dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].value == undefined) {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = this.props.defaultCurrency.id == 1 ? fixNumber(Number(total), 1) : Number(total)
                } else {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].value = this.props.defaultCurrency.id == 1 ? fixNumber(Number(total), 1) : Number(total)
                }
            }

            return tableMeta.rowData[8] == "Corporate Income Tax" ? this.props.defaultCurrency.id == 1 ? fixNumber(Number(total), 2) : Number(total) : this.props.defaultCurrency.id == 1 ? fixNumber(Number(total), 1) : Number(total)
        }

        const handleChange = (value, tableMeta, indexChilds) => {
            let val = String(value).split(",").join("")
            // let data = this.state.dataTable2
            let indexParent = dataTable2.findIndex((val) => val[4] === dataTable2[tableMeta.rowIndex][5])
            // ini buat input untuk perhitungan parent nya
            if (indexParent > 0) {
                if (indexChilds == 1) {
                    let a = dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].fcp = Number(val)
                    let jagain = dataTable2[indexParent][tableMeta.columnIndex].fcp
                    a = dataTable2[indexParent][tableMeta.columnIndex].fcp = jagain === undefined ? (0 + Number(val)) : (Number(jagain) + Number(val))
                }
            } else {
                if (indexChilds == 0) {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbc = Number(val)
                }
                else if (indexChilds == 1) {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].fcp = Number(val)
                }
                else if (indexChilds == 2) {
                    dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbf = Number(val)
                }
            }
        }

        const handleTotal = (tableMeta, dex, periode) => {
            let total = 0
            let totalfcp = 0
            if (String(tableMeta.rowData[8]).toLowerCase() === "fiscal correction positive / (negative) year to date") {
                dataTable2[tableMeta.rowIndex - 2].map((item, index) => {
                    if (index >= 9 && index <= 20) {
                        if (dataTable2[tableMeta.rowIndex - 2][2] === 5 || dataTable2[tableMeta.rowIndex - 2][2] === 6 || dataTable2[tableMeta.rowIndex - 2][2] === 7) {
                            let valItem = item.fcp.value == undefined || item.fcp.value == "" || item.fcp.value == "undefined" ? 0.0 : item.fcp.value
                            total += Number(valItem)
                        } else {
                            let valItem = item.fcp == undefined || item.fcp == "" || item.fcp == "undefined" ? 0.0 : item.fcp
                            total += Number(valItem)
                        }
                    }
                })
            } else {
                dataTable2[tableMeta.rowIndex].map((item, index) => {
                    if (index >= 9 && index <= 20) {
                        if (String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX") {
                            let valItem = item.tbf == undefined || item.tbf == "" || item.tbf == "undefined" ? 0.0 : item.tbf
                            total += Number(valItem)
                        }
                        else if (tableMeta.rowData[3] === 5 || tableMeta.rowData[3] === 6 || tableMeta.rowData[3] === 7) {
                            let valItem = item.tbf.value == undefined || item.tbf.value == "" || item.tbf.value == "undefined" ? 0.0 : item.tbf.value
                            total += Number(valItem)
                        } else {
                            let valItem = item.tbf == undefined || item.tbf == "" || item.tbf == "undefined" ? 0.0 : item.tbf
                            total += Number(valItem)
                        }
                    }
                })
            }
            dataTable2[tableMeta.rowIndex][21] = String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? this.props.defaultCurrency.id == 1 ? fixNumber(Number(total), 2) : Number(total) : this.props.defaultCurrency.id == 1 ? fixNumber(Number(total), 1) : Number(total)
            return total
        }

        const handleParent = (tableMeta, type) => {
            let total = 0
            dataTable2.map((item, index) => {
                if (item[5] == tableMeta.rowData[4]) {
                    total += Number(type == 1 ?
                        item[tableMeta.columnIndex].tbc.value == undefined ? Number(item[tableMeta.columnIndex].tbc == "" || item[tableMeta.columnIndex].tbc == "0.0" ? 0 : item[tableMeta.columnIndex].tbc) : Number(item[tableMeta.columnIndex].tbc.value == "" || item[tableMeta.columnIndex].tbc.value == "0.0" ? 0 : item[tableMeta.columnIndex].tbc.value)
                        :
                        (type == 2 ?
                            item[tableMeta.columnIndex].fcp.value == undefined ? Number(item[tableMeta.columnIndex].fcp == "" || item[tableMeta.columnIndex].fcp == "0.0" ? 0 : item[tableMeta.columnIndex].fcp) : Number(item[tableMeta.columnIndex].fcp.value == "" || item[tableMeta.columnIndex].fcp.value == "0.0" ? 0 : item[tableMeta.columnIndex].fcp.value)
                            :
                            item[tableMeta.columnIndex].tbf.value == undefined ? Number(item[tableMeta.columnIndex].tbf == "" || item[tableMeta.columnIndex].tbf == "0.0" ? 0 : item[tableMeta.columnIndex].tbf) : Number(item[tableMeta.columnIndex].tbf.value == "" || item[tableMeta.columnIndex].tbf.value == "0.0" ? 0 : item[tableMeta.columnIndex].tbf.value)
                        )
                    )
                }
            })

            if (type == 1) {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbc = total
            } else if (type == 2) {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].fcp = total
            } else {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex].tbf = total
            }
            return total
        }

        const columns = [{
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "Account",
            options: {
                customHeadRender: (columnMeta) => (
                    <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 102, backgroundColor: '#1c71b8', width: 300 }}>
                        <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                    </TableCell>
                ),
                setCellProps: () => ({ style }),
                customBodyRender: (val, tableMeta) => {
                    return (
                        <div style={{ width: 300 }}>
                            {tableMeta.rowData[30] ?
                                tableMeta.rowData[30].length > 0 ?
                                    <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                        <LightTooltip title={"Report Items Not Registered"} arrow>
                                            <span style={{ fontSize: 12, color: 'red' }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                        </LightTooltip>
                                    </div>
                                    :
                                    tableMeta.rowData[7] == 0 ?
                                        <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                        :
                                        <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[7]) }}>
                                            <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                        </div>
                                :
                                tableMeta.rowData[7] == 0 ?
                                    <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                    :
                                    <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[7]) }}>
                                        <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                    </div>
                            }
                        </div>
                    )
                }
            }
        }, {
            name: `Jan ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                        <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5, paddingTop: 8 }}>{columnMeta.name}</div>
                        <div className="" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky", paddingBottom: 20 }}>
                            <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                <span>{"Trial Balance (Fiscal) MTD"}</span>
                            </div>
                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    // console.log(value)
                    return (
                        <div>
                            <div className="content-center">
                                <div className="col-1">
                                    <div style={{ textAlign: 'right' }}>
                                        {tableMeta.rowData[3] === 4 || tableMeta.rowData[3] === 1 ?
                                            null
                                            :
                                            this.state.get_for == 'view' ?
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value.tbf}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(value.tbf) == 0 ? "0.0" : String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(value.tbf), 2) : fixNumber(Number(value.tbf), 1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                                :
                                                tableMeta.rowData[3] === 3 || tableMeta.rowData[3] === 2 || tableMeta.rowData[3] === 6 || tableMeta.rowData[3] === 5 || tableMeta.rowData[3] === 7 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.tbf}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={Number(value.tbf) == 0 ? "0.0" : this.props.defaultCurrency.id == 1 ? (String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(value.tbf), 2) : fixNumber(Number(value.tbf), 1)) : String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(value.tbf) : Number(value.tbf)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    null
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: `Feb ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                        <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5, paddingTop: 8 }}>{columnMeta.name}</div>
                        <div className="" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky", paddingBottom: 20 }}>
                            <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                <span>{"Trial Balance (Fiscal) MTD"}</span>
                            </div>
                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    // console.log(value)
                    return (
                        <div>
                            <div className="content-center">
                                <div className="col-1">
                                    <div style={{ textAlign: 'right' }}>
                                        {tableMeta.rowData[3] === 4 || tableMeta.rowData[3] === 1 ?
                                            null
                                            :
                                            this.state.get_for == 'view' ?
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value.tbf}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(value.tbf) == 0 ? "0.0" : String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(value.tbf), 2) : fixNumber(Number(value.tbf), 1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                                :
                                                tableMeta.rowData[3] === 3 || tableMeta.rowData[3] === 2 || tableMeta.rowData[3] === 6 || tableMeta.rowData[3] === 5 || tableMeta.rowData[3] === 7 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.tbf}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={Number(value.tbf) == 0 ? "0.0" : this.props.defaultCurrency.id == 1 ? (String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(value.tbf), 2) : fixNumber(Number(value.tbf), 1)) : String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(value.tbf) : Number(value.tbf)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    null
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: `Mar ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                        <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5, paddingTop: 8 }}>{columnMeta.name}</div>
                        <div className="" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky", paddingBottom: 20 }}>
                            <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                <span>{"Trial Balance (Fiscal) MTD"}</span>
                            </div>
                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    // console.log(value)
                    return (
                        <div>
                            <div className="content-center">
                                <div className="col-1">
                                    <div style={{ textAlign: 'right' }}>
                                        {tableMeta.rowData[3] === 4 || tableMeta.rowData[3] === 1 ?
                                            null
                                            :
                                            this.state.get_for == 'view' ?
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value.tbf}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(value.tbf) == 0 ? "0.0" : String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(value.tbf), 2) : fixNumber(Number(value.tbf), 1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                                :
                                                tableMeta.rowData[3] === 3 || tableMeta.rowData[3] === 2 || tableMeta.rowData[3] === 6 || tableMeta.rowData[3] === 5 || tableMeta.rowData[3] === 7 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.tbf}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={Number(value.tbf) == 0 ? "0.0" : this.props.defaultCurrency.id == 1 ? (String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(value.tbf), 2) : fixNumber(Number(value.tbf), 1)) : String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(value.tbf) : Number(value.tbf)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    null
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: `Apr ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                        <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5, paddingTop: 8 }}>{columnMeta.name}</div>
                        <div className="" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky", paddingBottom: 20 }}>
                            <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                <span>{"Trial Balance (Fiscal) MTD"}</span>
                            </div>
                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    // console.log(value)
                    return (
                        <div>
                            <div className="content-center">
                                <div className="col-1">
                                    <div style={{ textAlign: 'right' }}>
                                        {tableMeta.rowData[3] === 4 || tableMeta.rowData[3] === 1 ?
                                            null
                                            :
                                            this.state.get_for == 'view' ?
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value.tbf}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(value.tbf) == 0 ? "0.0" : String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(value.tbf), 2) : fixNumber(Number(value.tbf), 1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                                :
                                                tableMeta.rowData[3] === 3 || tableMeta.rowData[3] === 2 || tableMeta.rowData[3] === 6 || tableMeta.rowData[3] === 5 || tableMeta.rowData[3] === 7 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.tbf}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={Number(value.tbf) == 0 ? "0.0" : this.props.defaultCurrency.id == 1 ? (String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(value.tbf), 2) : fixNumber(Number(value.tbf), 1)) : String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(value.tbf) : Number(value.tbf)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    null
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: `May ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                        <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5, paddingTop: 8 }}>{columnMeta.name}</div>
                        <div className="" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky", paddingBottom: 20 }}>
                            <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                <span>{"Trial Balance (Fiscal) MTD"}</span>
                            </div>
                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    // console.log(value)
                    return (
                        <div>
                            <div className="content-center">
                                <div className="col-1">
                                    <div style={{ textAlign: 'right' }}>
                                        {tableMeta.rowData[3] === 4 || tableMeta.rowData[3] === 1 ?
                                            null
                                            :
                                            this.state.get_for == 'view' ?
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value.tbf}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(value.tbf) == 0 ? "0.0" : String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(value.tbf), 2) : fixNumber(Number(value.tbf), 1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                                :
                                                tableMeta.rowData[3] === 3 || tableMeta.rowData[3] === 2 || tableMeta.rowData[3] === 6 || tableMeta.rowData[3] === 5 || tableMeta.rowData[3] === 7 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.tbf}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={Number(value.tbf) == 0 ? "0.0" : this.props.defaultCurrency.id == 1 ? (String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(value.tbf), 2) : fixNumber(Number(value.tbf), 1)) : String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(value.tbf) : Number(value.tbf)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    null
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: `Jun ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                        <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5, paddingTop: 8 }}>{columnMeta.name}</div>
                        <div className="" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky", paddingBottom: 20 }}>
                            <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                <span>{"Trial Balance (Fiscal) MTD"}</span>
                            </div>
                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    // console.log(value)
                    return (
                        <div>
                            <div className="content-center">
                                <div className="col-1">
                                    <div style={{ textAlign: 'right' }}>
                                        {tableMeta.rowData[3] === 4 || tableMeta.rowData[3] === 1 ?
                                            null
                                            :
                                            this.state.get_for == 'view' ?
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value.tbf}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(value.tbf) == 0 ? "0.0" : String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(value.tbf), 2) : fixNumber(Number(value.tbf), 1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                                :
                                                tableMeta.rowData[3] === 3 || tableMeta.rowData[3] === 2 || tableMeta.rowData[3] === 6 || tableMeta.rowData[3] === 5 || tableMeta.rowData[3] === 7 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.tbf}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={Number(value.tbf) == 0 ? "0.0" : this.props.defaultCurrency.id == 1 ? (String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(value.tbf), 2) : fixNumber(Number(value.tbf), 1)) : String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(value.tbf) : Number(value.tbf)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    null
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: `Jul ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                        <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5, paddingTop: 8 }}>{columnMeta.name}</div>
                        <div className="" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky", paddingBottom: 20 }}>
                            <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                <span>{"Trial Balance (Fiscal) MTD"}</span>
                            </div>
                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    // console.log(value)
                    return (
                        <div>
                            <div className="content-center">
                                <div className="col-1">
                                    <div style={{ textAlign: 'right' }}>
                                        {tableMeta.rowData[3] === 4 || tableMeta.rowData[3] === 1 ?
                                            null
                                            :
                                            this.state.get_for == 'view' ?
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value.tbf}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(value.tbf) == 0 ? "0.0" : String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(value.tbf), 2) : fixNumber(Number(value.tbf), 1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                                :
                                                tableMeta.rowData[3] === 3 || tableMeta.rowData[3] === 2 || tableMeta.rowData[3] === 6 || tableMeta.rowData[3] === 5 || tableMeta.rowData[3] === 7 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.tbf}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={Number(value.tbf) == 0 ? "0.0" : this.props.defaultCurrency.id == 1 ? (String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(value.tbf), 2) : fixNumber(Number(value.tbf), 1)) : String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(value.tbf) : Number(value.tbf)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    null
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: `Aug ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                        <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5, paddingTop: 8 }}>{columnMeta.name}</div>
                        <div className="" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky", paddingBottom: 20 }}>
                            <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                <span>{"Trial Balance (Fiscal) MTD"}</span>
                            </div>
                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    // console.log(value)
                    return (
                        <div>
                            <div className="content-center">
                                <div className="col-1">
                                    <div style={{ textAlign: 'right' }}>
                                        {tableMeta.rowData[3] === 4 || tableMeta.rowData[3] === 1 ?
                                            null
                                            :
                                            this.state.get_for == 'view' ?
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value.tbf}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(value.tbf) == 0 ? "0.0" : String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(value.tbf), 2) : fixNumber(Number(value.tbf), 1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                                :
                                                tableMeta.rowData[3] === 3 || tableMeta.rowData[3] === 2 || tableMeta.rowData[3] === 6 || tableMeta.rowData[3] === 5 || tableMeta.rowData[3] === 7 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.tbf}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={Number(value.tbf) == 0 ? "0.0" : this.props.defaultCurrency.id == 1 ? (String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(value.tbf), 2) : fixNumber(Number(value.tbf), 1)) : String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(value.tbf) : Number(value.tbf)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    null
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: `Sep ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                        <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5, paddingTop: 8 }}>{columnMeta.name}</div>
                        <div className="" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky", paddingBottom: 20 }}>
                            <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                <span>{"Trial Balance (Fiscal) MTD"}</span>
                            </div>
                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    // console.log(value)
                    return (
                        <div>
                            <div className="content-center">
                                <div className="col-1">
                                    <div style={{ textAlign: 'right' }}>
                                        {tableMeta.rowData[3] === 4 || tableMeta.rowData[3] === 1 ?
                                            null
                                            :
                                            this.state.get_for == 'view' ?
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value.tbf}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(value.tbf) == 0 ? "0.0" : String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(value.tbf), 2) : fixNumber(Number(value.tbf), 1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                                :
                                                tableMeta.rowData[3] === 3 || tableMeta.rowData[3] === 2 || tableMeta.rowData[3] === 6 || tableMeta.rowData[3] === 5 || tableMeta.rowData[3] === 7 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.tbf}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={Number(value.tbf) == 0 ? "0.0" : this.props.defaultCurrency.id == 1 ? (String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(value.tbf), 2) : fixNumber(Number(value.tbf), 1)) : String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(value.tbf) : Number(value.tbf)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    null
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: `Oct ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                        <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5, paddingTop: 8 }}>{columnMeta.name}</div>
                        <div className="" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky", paddingBottom: 20 }}>
                            <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                <span>{"Trial Balance (Fiscal) MTD"}</span>
                            </div>
                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    // console.log(value)
                    return (
                        <div>
                            <div className="content-center">
                                <div className="col-1">
                                    <div style={{ textAlign: 'right' }}>
                                        {tableMeta.rowData[3] === 4 || tableMeta.rowData[3] === 1 ?
                                            null
                                            :
                                            this.state.get_for == 'view' ?
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value.tbf}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(value.tbf) == 0 ? "0.0" : String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(value.tbf), 2) : fixNumber(Number(value.tbf), 1)}
                                                            />
                                                        }
                                                    />
                                                </div>
                                                :
                                                tableMeta.rowData[3] === 3 || tableMeta.rowData[3] === 2 || tableMeta.rowData[3] === 6 || tableMeta.rowData[3] === 5 || tableMeta.rowData[3] === 7 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.tbf}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={Number(value.tbf) == 0 ? "0.0" : this.props.defaultCurrency.id == 1 ? (String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(value.tbf), 2) : fixNumber(Number(value.tbf), 1)) : String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(value.tbf) : Number(value.tbf)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    null
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: `Nov ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-3x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                <span>{"Trial Balance (Commercial) MTD"}</span>
                            </div>
                            <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                <span>{"Fiscal Correction Positive /(Negative)"}</span>
                            </div>
                            <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                <span>{"Trial Balance (Fiscal) MTD"}</span>
                            </div>
                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    // console.log(value)
                    return (
                        <div>
                            <div className="grid grid-3x content-center">
                                <div className="col-1">
                                    <div style={{ textAlign: 'right' }}>
                                        {tableMeta.rowData[1] === 4 || tableMeta.rowData[1] === 1 ?
                                            null
                                            :
                                            this.state.get_for == 'view' ?
                                                tableMeta.rowData[1] === 5 || tableMeta.rowData[1] === 6 || tableMeta.rowData[1] === 7 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.tbc}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={Number(value.tbc.value) == 0 ? "0.0" : String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(value.tbc.value), 2) : fixNumber(Number(value.tbc.value), 1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.tbc}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={Number(value.tbc.value) == 0 ? "0.0" : String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(value.tbc), 2) : fixNumber(Number(value.tbc), 1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                :
                                                tableMeta.rowData[1] === 3 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.tbc}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    decimalSeparator={"."}
                                                                    style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    // placeholder="input"
                                                                    disabled={this.props.isApprover == true ? true : false}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(value.tbc), 1) : Number(value.tbc) == 0 ? "0.0" : Number(value.tbc)}
                                                                    onBlur={(event) => {
                                                                        // updateValue(event.target.value)
                                                                        handleChange(event.target.value, tableMeta, 0)
                                                                        // console.log(dataTable2)
                                                                    }}
                                                                />
                                                            }
                                                        />
                                                    </div> :
                                                    tableMeta.rowData[1] === 2 ?
                                                        <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleParent(tableMeta, 1)), 1) : Number(handleParent(tableMeta, 1)) == 0 ? "0.0" : Number(handleParent(tableMeta, 1))}
                                                            />
                                                        </span>
                                                        :
                                                        tableMeta.rowData[1] === 6 ?
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) : Number(handleValueFormula(value, tableMeta, 1)) == 0 ? "0.0" : Number(handleValueFormula(value, tableMeta, 1))}
                                                            />
                                                            :
                                                            tableMeta.rowData[1] === 5 ?
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) : Number(handleValueFormula(value, tableMeta, 1)) == 0 ? "0.0" : Number(handleValueFormula(value, tableMeta, 1))}
                                                                />
                                                                :
                                                                tableMeta.rowData[1] === 7 ?
                                                                    this.props.defaultCurrency.id == 1 ?
                                                                        (fixNumber(Number(handleValueFormula(value, tableMeta, 0)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 0)), 1) <= Number(this.state.maxValue)) ?
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{
                                                                                    fontSize: 12,
                                                                                    textAlign: 'right',
                                                                                    borderColor: 'transparent',
                                                                                    margin: 0,
                                                                                    width: 96,
                                                                                    backgroundColor: 'transparent',
                                                                                    color: 'black'
                                                                                }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) : Number(handleValueFormula(value, tableMeta, 1)) == 0 ? "0.0" : Number(handleValueFormula(value, tableMeta, 1))}
                                                                            /> :
                                                                            <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                <NumberFormat
                                                                                    thousandSeparator={true}
                                                                                    style={{
                                                                                        fontSize: 12,
                                                                                        textAlign: 'right',
                                                                                        borderColor: 'transparent',
                                                                                        margin: 0,
                                                                                        width: 96,
                                                                                        backgroundColor: 'transparent',
                                                                                        color: 'red'
                                                                                    }}
                                                                                    type="text"
                                                                                    placeholder=""
                                                                                    disabled={true}
                                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) : Number(handleValueFormula(value, tableMeta, 1)) == 0 ? "0.0" : Number(handleValueFormula(value, tableMeta, 1))}
                                                                                />
                                                                            </LightTooltip>
                                                                        :
                                                                        (Number(handleValueFormula(value, tableMeta, 0)) >= Number(this.state.minValue) && Number(handleValueFormula(value, tableMeta, 0)) <= Number(this.state.maxValue)) ?
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{
                                                                                    fontSize: 12,
                                                                                    textAlign: 'right',
                                                                                    borderColor: 'transparent',
                                                                                    margin: 0,
                                                                                    width: 96,
                                                                                    backgroundColor: 'transparent',
                                                                                    color: 'black'
                                                                                }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) : Number(handleValueFormula(value, tableMeta, 1)) == 0 ? "0.0" : Number(handleValueFormula(value, tableMeta, 1))}
                                                                            /> :
                                                                            <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                <NumberFormat
                                                                                    thousandSeparator={true}
                                                                                    style={{
                                                                                        fontSize: 12,
                                                                                        textAlign: 'right',
                                                                                        borderColor: 'transparent',
                                                                                        margin: 0,
                                                                                        width: 96,
                                                                                        backgroundColor: 'transparent',
                                                                                        color: 'red'
                                                                                    }}
                                                                                    type="text"
                                                                                    placeholder=""
                                                                                    disabled={true}
                                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) : Number(handleValueFormula(value, tableMeta, 1)) == 0 ? "0.0" : Number(handleValueFormula(value, tableMeta, 1))}
                                                                                />
                                                                            </LightTooltip>
                                                                    :
                                                                    null
                                        }
                                    </div>
                                </div>
                                <div className="col-2">
                                    <div style={{ textAlign: 'right' }}>
                                        {tableMeta.rowData[2] === 4 || tableMeta.rowData[2] === 1 ?
                                            null
                                            :
                                            this.state.get_for == 'view' ?
                                                tableMeta.rowData[2] === 5 || tableMeta.rowData[2] === 6 || tableMeta.rowData[2] === 7 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.fcp}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(value.fcp.value), 2) : fixNumber(Number(value.fcp.value), 1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.fcp}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(value.fcp).toFixed(2) : Number(value.fcp).toFixed(1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                :
                                                tableMeta.rowData[2] === 3 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.fcp}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    // placeholder="input"
                                                                    // disabled={this.props.isApprover == true ? true : false}
                                                                    value={this.props.defaultCurrency.id == 1 ? (String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(value.fcp), 2) : fixNumber(Number(value.fcp), 1)) : (String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (Number(value.fcp) == 0 ? "0.0" : Number(value.fcp)) : (Number(value.fcp) == 0 ? "0.0" : Number(value.fcp)))}
                                                                    onBlur={(event) => {
                                                                        handleChange(event.target.value, tableMeta, 1)
                                                                        // console.log(dataTable2)
                                                                    }}
                                                                />
                                                            }
                                                        />
                                                    </div> :
                                                    tableMeta.rowData[2] === 2 ?
                                                        <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleParent(tableMeta, 2)), 1) : Number(handleParent(tableMeta, 2)) == 0 ? "0.0" : Number(handleParent(tableMeta, 2))}
                                                            />
                                                        </span>
                                                        :
                                                        tableMeta.rowData[2] === 6 ?
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) : Number(handleValueFormula(value, tableMeta, 2)) == 0 ? "0.0" : Number(handleValueFormula(value, tableMeta, 2))}
                                                            />
                                                            :
                                                            tableMeta.rowData[2] === 5 ?
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) : Number(handleValueFormula(value, tableMeta, 2)) == 0 ? "0.0" : Number(handleValueFormula(value, tableMeta, 2))}
                                                                />
                                                                :
                                                                tableMeta.rowData[2] === 7 ?
                                                                    this.props.defaultCurrency.id == 1 ?
                                                                        (fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) <= Number(this.state.maxValue)) ?
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{
                                                                                    fontSize: 12,
                                                                                    textAlign: 'right',
                                                                                    borderColor: 'transparent',
                                                                                    margin: 0,
                                                                                    width: 96,
                                                                                    backgroundColor: 'transparent',
                                                                                    color: 'black'
                                                                                }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) : Number(handleValueFormula(value, tableMeta, 2)) == 0 ? "0.0" : Number(handleValueFormula(value, tableMeta, 2))}
                                                                            /> :
                                                                            <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                <NumberFormat
                                                                                    thousandSeparator={true}
                                                                                    style={{
                                                                                        fontSize: 12,
                                                                                        textAlign: 'right',
                                                                                        borderColor: 'transparent',
                                                                                        margin: 0,
                                                                                        width: 96,
                                                                                        backgroundColor: 'transparent',
                                                                                        color: 'red'
                                                                                    }}
                                                                                    type="text"
                                                                                    placeholder=""
                                                                                    disabled={true}
                                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) : Number(handleValueFormula(value, tableMeta, 2)) == 0 ? "0.0" : Number(handleValueFormula(value, tableMeta, 2))}
                                                                                />
                                                                            </LightTooltip>
                                                                        :
                                                                        (Number(handleValueFormula(value, tableMeta, 2)) >= Number(this.state.minValue) && Number(handleValueFormula(value, tableMeta, 2)) <= Number(this.state.maxValue)) ?
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{
                                                                                    fontSize: 12,
                                                                                    textAlign: 'right',
                                                                                    borderColor: 'transparent',
                                                                                    margin: 0,
                                                                                    width: 96,
                                                                                    backgroundColor: 'transparent',
                                                                                    color: 'black'
                                                                                }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) : Number(handleValueFormula(value, tableMeta, 2)) == 0 ? "0.0" : Number(handleValueFormula(value, tableMeta, 2))}
                                                                            /> :
                                                                            <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                <NumberFormat
                                                                                    thousandSeparator={true}
                                                                                    style={{
                                                                                        fontSize: 12,
                                                                                        textAlign: 'right',
                                                                                        borderColor: 'transparent',
                                                                                        margin: 0,
                                                                                        width: 96,
                                                                                        backgroundColor: 'transparent',
                                                                                        color: 'red'
                                                                                    }}
                                                                                    type="text"
                                                                                    placeholder=""
                                                                                    disabled={true}
                                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) : Number(handleValueFormula(value, tableMeta, 2)) == 0 ? "0.0" : Number(handleValueFormula(value, tableMeta, 2))}
                                                                                />
                                                                            </LightTooltip>
                                                                    :
                                                                    null
                                        }
                                    </div>
                                </div>
                                <div className="col-3">
                                    <div style={{ textAlign: 'right' }}>
                                        {tableMeta.rowData[3] === 4 || tableMeta.rowData[3] === 1 ?
                                            null
                                            :
                                            this.state.get_for == 'view' ?
                                                tableMeta.rowData[3] === 5 || tableMeta.rowData[3] === 6 || tableMeta.rowData[3] === 7 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.tbf}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.defaultCurrency.id == 1 ? (String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(value.tbf.value), 2) : fixNumber(Number(value.tbf.value), 1)) : (String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (Number(value.tbf.value) == 0 ? "0.0" : Number(value.tbf.value)) : (Number(value.tbf.value) == 0 ? "0.0" : Number(value.tbf.value)))}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.tbf}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={Number(value.tbf) == 0 ? "0.0" : this.props.defaultCurrency.id == 1 ? (String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(value.tbf), 2) : fixNumber(Number(value.tbf), 1)) : String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(value.tbf) : Number(value.tbf)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                :
                                                tableMeta.rowData[3] === 3 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.tbf}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    // placeholder="input"
                                                                    disabled={this.props.isApprover == true ? true : false}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(value.tbf), 1) : Number(value.tbf) == 0 ? "0.0" : Number(value.tbf)}
                                                                    onBlur={(event) => {
                                                                        // updateValue(event.target.value)
                                                                        handleChange(event.target.value, tableMeta, 2)
                                                                        // console.log(dataTable2)
                                                                    }}
                                                                />
                                                            }
                                                        />
                                                    </div> :
                                                    tableMeta.rowData[3] === 2 ?
                                                        <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleParent(tableMeta, 3)), 1) : Number(handleParent(tableMeta, 3)) == 0 ? "0.0" : Number(handleParent(tableMeta, 3))}
                                                            />
                                                        </span>
                                                        :
                                                        tableMeta.rowData[3] === 6 ?
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(value.tbf) == 0 ? "0.0" : this.props.defaultCurrency.id == 1 ? (String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2) : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1)) : String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(handleValueFormula(value, tableMeta, 3)) : Number(handleValueFormula(value, tableMeta, 3))}
                                                            />
                                                            :
                                                            tableMeta.rowData[3] === 5 ?
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={false}
                                                                    value={Number(value.tbf) == 0 ? "0.0" : this.props.defaultCurrency.id == 1 ? (String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2) : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1)) : String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(handleValueFormula(value, tableMeta, 3)) : Number(handleValueFormula(value, tableMeta, 3))}
                                                                />
                                                                :
                                                                tableMeta.rowData[3] === 7 ?
                                                                    this.props.defaultCurrency.id == 1 ?
                                                                        (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) <= Number(this.state.maxValue)) ?
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{
                                                                                    fontSize: 12,
                                                                                    textAlign: 'right',
                                                                                    borderColor: 'transparent',
                                                                                    margin: 0,
                                                                                    width: 96,
                                                                                    backgroundColor: 'transparent',
                                                                                    color: 'black'
                                                                                }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) : Number(handleValueFormula(value, tableMeta, 3)) == 0 ? "0.0" : Number(handleValueFormula(value, tableMeta, 3))}
                                                                            /> :
                                                                            <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                <NumberFormat
                                                                                    thousandSeparator={true}
                                                                                    style={{
                                                                                        fontSize: 12,
                                                                                        textAlign: 'right',
                                                                                        borderColor: 'transparent',
                                                                                        margin: 0,
                                                                                        width: 96,
                                                                                        backgroundColor: 'transparent',
                                                                                        color: 'red'
                                                                                    }}
                                                                                    type="text"
                                                                                    placeholder=""
                                                                                    disabled={true}
                                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) : Number(handleValueFormula(value, tableMeta, 3)) == 0 ? "0.0" : Number(handleValueFormula(value, tableMeta, 3))}
                                                                                />
                                                                            </LightTooltip>
                                                                        :
                                                                        (Number(handleValueFormula(value, tableMeta, 3)) >= Number(this.state.minValue) && Number(handleValueFormula(value, tableMeta, 3)) <= Number(this.state.maxValue)) ?
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{
                                                                                    fontSize: 12,
                                                                                    textAlign: 'right',
                                                                                    borderColor: 'transparent',
                                                                                    margin: 0,
                                                                                    width: 96,
                                                                                    backgroundColor: 'transparent',
                                                                                    color: 'black'
                                                                                }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) : Number(handleValueFormula(value, tableMeta, 3)) == 0 ? "0.0" : Number(handleValueFormula(value, tableMeta, 3))}
                                                                            /> :
                                                                            <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                <NumberFormat
                                                                                    thousandSeparator={true}
                                                                                    style={{
                                                                                        fontSize: 12,
                                                                                        textAlign: 'right',
                                                                                        borderColor: 'transparent',
                                                                                        margin: 0,
                                                                                        width: 96,
                                                                                        backgroundColor: 'transparent',
                                                                                        color: 'red'
                                                                                    }}
                                                                                    type="text"
                                                                                    placeholder=""
                                                                                    disabled={true}
                                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) : Number(handleValueFormula(value, tableMeta, 3)) == 0 ? "0.0" : Number(handleValueFormula(value, tableMeta, 3))}
                                                                                />
                                                                            </LightTooltip>
                                                                    :
                                                                    null
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: `Dec ${this.props.periode}`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                        {/* <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell> */}
                        <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5 }}>{columnMeta.name}</div>
                        <div className="grid grid-3x" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky" }}>
                            <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                <span>{"Trial Balance (Commercial) MTD"}</span>
                            </div>
                            <div className="column-2" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                <span>{"Fiscal Correction Positive /(Negative)"}</span>
                            </div>
                            <div className="column-3" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                <span>{"Trial Balance (Fiscal) MTD"}</span>
                            </div>
                        </div>
                    </th>
                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    // console.log(value)
                    return (
                        <div>
                            <div className="grid grid-3x content-center">
                                <div className="col-1">
                                    <div style={{ textAlign: 'right' }}>
                                        {tableMeta.rowData[1] === 4 || tableMeta.rowData[1] === 1 ?
                                            null
                                            :
                                            this.state.get_for == 'view' ?
                                                tableMeta.rowData[1] === 5 || tableMeta.rowData[1] === 6 || tableMeta.rowData[1] === 7 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.tbc}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={Number(value.tbc.value) == 0 ? "0.0" : String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(value.tbc.value), 2) : fixNumber(Number(value.tbc.value), 1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.tbc}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={Number(value.tbc.value) == 0 ? "0.0" : String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(value.tbc), 2) : fixNumber(Number(value.tbc), 1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                :
                                                tableMeta.rowData[1] === 3 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.tbc}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    decimalSeparator={"."}
                                                                    style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    // placeholder="input"
                                                                    disabled={this.props.isApprover == true ? true : false}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(value.tbc), 1) : Number(value.tbc) == 0 ? "0.0" : Number(value.tbc)}
                                                                    onBlur={(event) => {
                                                                        // updateValue(event.target.value)
                                                                        handleChange(event.target.value, tableMeta, 0)
                                                                        // console.log(dataTable2)
                                                                    }}
                                                                />
                                                            }
                                                        />
                                                    </div> :
                                                    tableMeta.rowData[1] === 2 ?
                                                        <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleParent(tableMeta, 1)), 1) : Number(handleParent(tableMeta, 1)) == 0 ? "0.0" : Number(handleParent(tableMeta, 1))}
                                                            />
                                                        </span>
                                                        :
                                                        tableMeta.rowData[1] === 6 ?
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) : Number(handleValueFormula(value, tableMeta, 1)) == 0 ? "0.0" : Number(handleValueFormula(value, tableMeta, 1))}
                                                            />
                                                            :
                                                            tableMeta.rowData[1] === 5 ?
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) : Number(handleValueFormula(value, tableMeta, 1)) == 0 ? "0.0" : Number(handleValueFormula(value, tableMeta, 1))}
                                                                />
                                                                :
                                                                tableMeta.rowData[1] === 7 ?
                                                                    this.props.defaultCurrency.id == 1 ?
                                                                        (fixNumber(Number(handleValueFormula(value, tableMeta, 0)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 0)), 1) <= Number(this.state.maxValue)) ?
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{
                                                                                    fontSize: 12,
                                                                                    textAlign: 'right',
                                                                                    borderColor: 'transparent',
                                                                                    margin: 0,
                                                                                    width: 96,
                                                                                    backgroundColor: 'transparent',
                                                                                    color: 'black'
                                                                                }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) : Number(handleValueFormula(value, tableMeta, 1)) == 0 ? "0.0" : Number(handleValueFormula(value, tableMeta, 1))}
                                                                            /> :
                                                                            <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                <NumberFormat
                                                                                    thousandSeparator={true}
                                                                                    style={{
                                                                                        fontSize: 12,
                                                                                        textAlign: 'right',
                                                                                        borderColor: 'transparent',
                                                                                        margin: 0,
                                                                                        width: 96,
                                                                                        backgroundColor: 'transparent',
                                                                                        color: 'red'
                                                                                    }}
                                                                                    type="text"
                                                                                    placeholder=""
                                                                                    disabled={true}
                                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) : Number(handleValueFormula(value, tableMeta, 1)) == 0 ? "0.0" : Number(handleValueFormula(value, tableMeta, 1))}
                                                                                />
                                                                            </LightTooltip>
                                                                        :
                                                                        (Number(handleValueFormula(value, tableMeta, 0)).toFixed(1) >= Number(this.state.minValue) && Number(handleValueFormula(value, tableMeta, 0)).toFixed(1) <= Number(this.state.maxValue)) ?
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{
                                                                                    fontSize: 12,
                                                                                    textAlign: 'right',
                                                                                    borderColor: 'transparent',
                                                                                    margin: 0,
                                                                                    width: 96,
                                                                                    backgroundColor: 'transparent',
                                                                                    color: 'black'
                                                                                }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) : Number(handleValueFormula(value, tableMeta, 1)) == 0 ? "0.0" : Number(handleValueFormula(value, tableMeta, 1))}
                                                                            /> :
                                                                            <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                <NumberFormat
                                                                                    thousandSeparator={true}
                                                                                    style={{
                                                                                        fontSize: 12,
                                                                                        textAlign: 'right',
                                                                                        borderColor: 'transparent',
                                                                                        margin: 0,
                                                                                        width: 96,
                                                                                        backgroundColor: 'transparent',
                                                                                        color: 'red'
                                                                                    }}
                                                                                    type="text"
                                                                                    placeholder=""
                                                                                    disabled={true}
                                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 1)), 1) : Number(handleValueFormula(value, tableMeta, 1)) == 0 ? "0.0" : Number(handleValueFormula(value, tableMeta, 1))}
                                                                                />
                                                                            </LightTooltip>
                                                                    :
                                                                    null
                                        }
                                    </div>
                                </div>
                                <div className="col-2">
                                    <div style={{ textAlign: 'right' }}>
                                        {tableMeta.rowData[2] === 4 || tableMeta.rowData[2] === 1 ?
                                            null
                                            :
                                            this.state.get_for == 'view' ?
                                                tableMeta.rowData[2] === 5 || tableMeta.rowData[2] === 6 || tableMeta.rowData[2] === 7 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.fcp}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(value.fcp.value), 2) : fixNumber(Number(value.fcp.value), 1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.fcp}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(value.fcp).toFixed(2) : Number(value.fcp).toFixed(1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                :
                                                tableMeta.rowData[2] === 3 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.fcp}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    // placeholder="input"
                                                                    // disabled={this.props.isApprover == true ? true : false}
                                                                    value={this.props.defaultCurrency.id == 1 ? (String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(value.fcp).toFixed(2) : Number(value.fcp).toFixed(1)) : (String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (Number(value.fcp) == 0 ? "0.0" : Number(value.fcp)) : (Number(value.fcp) == 0 ? "0.0" : Number(value.fcp)))}
                                                                    onBlur={(event) => {
                                                                        handleChange(event.target.value, tableMeta, 1)
                                                                        // console.log(dataTable2)
                                                                    }}
                                                                />
                                                            }
                                                        />
                                                    </div> :
                                                    tableMeta.rowData[2] === 2 ?
                                                        <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleParent(tableMeta, 2)), 1) : Number(handleParent(tableMeta, 2)) == 0 ? "0.0" : Number(handleParent(tableMeta, 2))}
                                                            />
                                                        </span>
                                                        :
                                                        tableMeta.rowData[2] === 6 ?
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) : Number(handleValueFormula(value, tableMeta, 2)) == 0 ? "0.0" : Number(handleValueFormula(value, tableMeta, 2))}
                                                            />
                                                            :
                                                            tableMeta.rowData[2] === 5 ?
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) : Number(handleValueFormula(value, tableMeta, 2)) == 0 ? "0.0" : Number(handleValueFormula(value, tableMeta, 2))}
                                                                />
                                                                :
                                                                tableMeta.rowData[2] === 7 ?
                                                                    this.props.defaultCurrency.id == 1 ?
                                                                        (fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) <= Number(this.state.maxValue)) ?
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{
                                                                                    fontSize: 12,
                                                                                    textAlign: 'right',
                                                                                    borderColor: 'transparent',
                                                                                    margin: 0,
                                                                                    width: 96,
                                                                                    backgroundColor: 'transparent',
                                                                                    color: 'black'
                                                                                }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) : Number(handleValueFormula(value, tableMeta, 2)) == 0 ? "0.0" : Number(handleValueFormula(value, tableMeta, 2))}
                                                                            /> :
                                                                            <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                <NumberFormat
                                                                                    thousandSeparator={true}
                                                                                    style={{
                                                                                        fontSize: 12,
                                                                                        textAlign: 'right',
                                                                                        borderColor: 'transparent',
                                                                                        margin: 0,
                                                                                        width: 96,
                                                                                        backgroundColor: 'transparent',
                                                                                        color: 'red'
                                                                                    }}
                                                                                    type="text"
                                                                                    placeholder=""
                                                                                    disabled={true}
                                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) : Number(handleValueFormula(value, tableMeta, 2)) == 0 ? "0.0" : Number(handleValueFormula(value, tableMeta, 2))}
                                                                                />
                                                                            </LightTooltip>
                                                                        :
                                                                        (Number(handleValueFormula(value, tableMeta, 2)) >= Number(this.state.minValue) && Number(handleValueFormula(value, tableMeta, 2)) <= Number(this.state.maxValue)) ?
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{
                                                                                    fontSize: 12,
                                                                                    textAlign: 'right',
                                                                                    borderColor: 'transparent',
                                                                                    margin: 0,
                                                                                    width: 96,
                                                                                    backgroundColor: 'transparent',
                                                                                    color: 'black'
                                                                                }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) : Number(handleValueFormula(value, tableMeta, 2)) == 0 ? "0.0" : Number(handleValueFormula(value, tableMeta, 2))}
                                                                            /> :
                                                                            <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                <NumberFormat
                                                                                    thousandSeparator={true}
                                                                                    style={{
                                                                                        fontSize: 12,
                                                                                        textAlign: 'right',
                                                                                        borderColor: 'transparent',
                                                                                        margin: 0,
                                                                                        width: 96,
                                                                                        backgroundColor: 'transparent',
                                                                                        color: 'red'
                                                                                    }}
                                                                                    type="text"
                                                                                    placeholder=""
                                                                                    disabled={true}
                                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 2)), 1) : Number(handleValueFormula(value, tableMeta, 2)) == 0 ? "0.0" : Number(handleValueFormula(value, tableMeta, 2))}
                                                                                />
                                                                            </LightTooltip>
                                                                    :
                                                                    null
                                        }
                                    </div>
                                </div>
                                <div className="col-3">
                                    <div style={{ textAlign: 'right' }}>
                                        {tableMeta.rowData[3] === 4 || tableMeta.rowData[3] === 1 ?
                                            null
                                            :
                                            this.state.get_for == 'view' ?
                                                tableMeta.rowData[3] === 5 || tableMeta.rowData[3] === 6 || tableMeta.rowData[3] === 7 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.tbf}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(value.tbf.value).toFixed(2) : Number(value.tbf.value).toFixed(1)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                    :
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.tbf}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={true}
                                                                    value={Number(value.tbf) == 0 ? "0.0" : this.props.defaultCurrency.id == 1 ? (String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(value.tbf), 2) : fixNumber(Number(value.tbf), 1)) : String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(value.tbf) : Number(value.tbf)}
                                                                />
                                                            }
                                                        />
                                                    </div>
                                                :
                                                tableMeta.rowData[3] === 3 ?
                                                    <div style={{ flex: 1 }}>
                                                        <FormControlLabel
                                                            style={{ margin: 0 }}
                                                            value={value.tbf}
                                                            control={
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ color: "#5198ea", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    // placeholder="input"
                                                                    disabled={this.props.isApprover == true ? true : false}
                                                                    value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(value.tbf), 1) : Number(value.tbf) == 0 ? "0.0" : Number(value.tbf)}
                                                                    onBlur={(event) => {
                                                                        // updateValue(event.target.value)
                                                                        handleChange(event.target.value, tableMeta, 2)
                                                                        // console.log(dataTable2)
                                                                    }}
                                                                />
                                                            }
                                                        />
                                                    </div> :
                                                    tableMeta.rowData[3] === 2 ?
                                                        <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleParent(tableMeta, 3)), 1) : Number(handleParent(tableMeta, 3)) == 0 ? "0.0" : Number(handleParent(tableMeta, 3))}
                                                            />
                                                        </span>
                                                        :
                                                        tableMeta.rowData[3] === 6 ?
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={Number(value.tbf) == 0 ? "0.0" : this.props.defaultCurrency.id == 1 ? (String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2) : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1)) : String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(handleValueFormula(value, tableMeta, 3)) : Number(handleValueFormula(value, tableMeta, 3))}
                                                            />
                                                            :
                                                            tableMeta.rowData[3] === 5 ?
                                                                <NumberFormat
                                                                    thousandSeparator={true}
                                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                    type="text"
                                                                    placeholder=""
                                                                    disabled={false}
                                                                    value={Number(value.tbf) == 0 ? "0.0" : this.props.defaultCurrency.id == 1 ? (String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 2) : fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1)) : String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(handleValueFormula(value, tableMeta, 3)) : Number(handleValueFormula(value, tableMeta, 3))}
                                                                />
                                                                :
                                                                tableMeta.rowData[3] === 7 ?
                                                                    this.props.defaultCurrency.id == 1 ?
                                                                        (fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) >= Number(this.state.minValue) && fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) <= Number(this.state.maxValue)) ?
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{
                                                                                    fontSize: 12,
                                                                                    textAlign: 'right',
                                                                                    borderColor: 'transparent',
                                                                                    margin: 0,
                                                                                    width: 96,
                                                                                    backgroundColor: 'transparent',
                                                                                    color: 'black'
                                                                                }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={Number(value.tbf) == 0 ? "0.0" : this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) : Number(handleValueFormula(value, tableMeta, 3))}
                                                                            /> :
                                                                            <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                <NumberFormat
                                                                                    thousandSeparator={true}
                                                                                    style={{
                                                                                        fontSize: 12,
                                                                                        textAlign: 'right',
                                                                                        borderColor: 'transparent',
                                                                                        margin: 0,
                                                                                        width: 96,
                                                                                        backgroundColor: 'transparent',
                                                                                        color: 'red'
                                                                                    }}
                                                                                    type="text"
                                                                                    placeholder=""
                                                                                    disabled={true}
                                                                                    value={Number(value.tbf) == 0 ? "0.0" : this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) : Number(handleValueFormula(value, tableMeta, 3))}
                                                                                />
                                                                            </LightTooltip>
                                                                        :
                                                                        (Number(handleValueFormula(value, tableMeta, 3)) >= Number(this.state.minValue) && Number(handleValueFormula(value, tableMeta, 3)) <= Number(this.state.maxValue)) ?
                                                                            <NumberFormat
                                                                                thousandSeparator={true}
                                                                                style={{
                                                                                    fontSize: 12,
                                                                                    textAlign: 'right',
                                                                                    borderColor: 'transparent',
                                                                                    margin: 0,
                                                                                    width: 96,
                                                                                    backgroundColor: 'transparent',
                                                                                    color: 'black'
                                                                                }}
                                                                                type="text"
                                                                                placeholder=""
                                                                                disabled={true}
                                                                                value={Number(value.tbf) == 0 ? "0.0" : this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) : Number(handleValueFormula(value, tableMeta, 3))}
                                                                            /> :
                                                                            <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                                <NumberFormat
                                                                                    thousandSeparator={true}
                                                                                    style={{
                                                                                        fontSize: 12,
                                                                                        textAlign: 'right',
                                                                                        borderColor: 'transparent',
                                                                                        margin: 0,
                                                                                        width: 96,
                                                                                        backgroundColor: 'transparent',
                                                                                        color: 'red'
                                                                                    }}
                                                                                    type="text"
                                                                                    placeholder=""
                                                                                    disabled={true}
                                                                                    value={Number(value.tbf) == 0 ? "0.0" : this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleValueFormula(value, tableMeta, 3)), 1) : Number(handleValueFormula(value, tableMeta, 3))}
                                                                                />
                                                                            </LightTooltip>
                                                                    :
                                                                    null
                                        }
                                    </div>
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: `${this.props.periode} Trial Balance (Fiscal)`,
            options: {
                customHeadRender: (columnMeta) => (
                    <th style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 150, borderRight: "1px solid rgb(255, 255, 255)" }} >
                        <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', width: 200, padding: 5, paddingTop: 8 }}>{columnMeta.name}</div>
                        <div className="" style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky", paddingBottom: 20 }}>
                            <div className="column-1" style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                                <span>{"Trial Balance (Fiscal)"}</span>
                            </div>
                        </div>
                    </th>
                    // <div  style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 13, fontWeight: 1, width: 200, borderRight: "1px solid rgb(255, 255, 255)" }} >
                    // <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96 }}>
                    // <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                    // </TableCell> 
                    // <div style={{ borderBottom: "1px #fff solid", textAlign: 'center', fontSize: 12, fontWeight: 'bold', padding: 5, paddingTop: 8 }}>{columnMeta.name}</div>
                    // <div style={{ ...style2, backgroundColor: '#1c71b8', color: '#fff', fontSize: 12, fontWeight: 'bold', position: "sticky", paddingBottom: 20 }}>
                    // <div style={{ placeSelf: 'center', textAlign: 'center', padding: 5 }}>
                    // <span>{"Trial Balance (Fiscal)"}</span>
                    // </div>
                    // </div>
                    // </div>

                ),
                setCellProps: () => ({ style2 }),
                customBodyRender: (value, tableMeta, updateValue) => {
                    return (
                        <div>
                            <div className="content-center">
                                <div style={{ textAlign: 'right' }}>
                                    {tableMeta.rowData[3] === 4 || tableMeta.rowData[3] === 1 ?
                                        null
                                        :
                                        this.state.get_for == 'view' ?
                                            <div style={{ flex: 1 }}>
                                                <FormControlLabel
                                                    style={{ margin: 0 }}
                                                    value={tableMeta.rowData[21]}
                                                    control={
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={Number(tableMeta.rowData[21]) == 0 ? "0.0" : String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? fixNumber(Number(tableMeta.rowData[21]), 1) : fixNumber(Number(tableMeta.rowData[21]), 1)}
                                                        />
                                                    }
                                                />
                                            </div>
                                            :
                                            tableMeta.rowData[3] === 3 ?
                                                <div style={{ flex: 1 }}>
                                                    <FormControlLabel
                                                        style={{ margin: 0 }}
                                                        value={value}
                                                        control={
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                // placeholder="input"
                                                                disabled={this.props.isApprover == true ? true : false}
                                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleTotal(tableMeta, 3)), 1) : Number(handleTotal(tableMeta, 3)) == 0 ? "0.0" : Number(handleTotal(tableMeta, 3))}
                                                            />
                                                        }
                                                    />
                                                </div> :
                                                tableMeta.rowData[3] === 2 ?
                                                    <span style={{ fontSize: 12, textAlign: 'right' }}>
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(handleTotal(tableMeta, 2)), 1) : Number(handleTotal(tableMeta, 2)) == 0 ? "0.0" : Number(handleTotal(tableMeta, 2))}
                                                        />
                                                    </span>
                                                    :
                                                    tableMeta.rowData[3] === 6 ?
                                                        <NumberFormat
                                                            thousandSeparator={true}
                                                            style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                            type="text"
                                                            placeholder=""
                                                            disabled={true}
                                                            value={this.props.defaultCurrency.id == 1 ? (String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(handleTotal(tableMeta, 6)).toFixed(2) : Number(handleTotal(tableMeta, 6)).toFixed(1)) : (String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (Number(handleTotal(tableMeta, 6)) == 0 ? "0.0" : Number(handleTotal(tableMeta, 6))) : (Number(handleTotal(tableMeta, 6)) == 0 ? "0.0" : Number(handleTotal(tableMeta, 6))))}
                                                        />
                                                        :
                                                        tableMeta.rowData[3] === 5 ?
                                                            <NumberFormat
                                                                thousandSeparator={true}
                                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                type="text"
                                                                placeholder=""
                                                                disabled={true}
                                                                value={this.props.defaultCurrency.id == 1 ? (String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? Number(handleTotal(tableMeta, 5)).toFixed(2) : Number(handleTotal(tableMeta, 5)).toFixed(1)) : (String(tableMeta.rowData[8]).toLocaleUpperCase() == "CORPORATE INCOME TAX" ? (Number(handleTotal(tableMeta, 5)) == 0 ? "0.0" : Number(handleTotal(tableMeta, 5))) : (Number(handleTotal(tableMeta, 5)) == 0 ? "0.0" : Number(handleTotal(tableMeta, 5))))}
                                                            />
                                                            :
                                                            tableMeta.rowData[3] === 7 ? null
                                                                // (Number(handleTotal(tableMeta, 1)) >= Number(this.state.minValue) && Number(handleTotal(tableMeta, 1)) <= Number(this.state.maxValue)) ?
                                                                //     <NumberFormat
                                                                //         thousandSeparator={true}
                                                                //         style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                                //         type="text"
                                                                //         placeholder=""
                                                                //         disabled={true}
                                                                //         value={Number(handleTotal(tableMeta, 7)).toFixed(1)}
                                                                //     /> :
                                                                //     <LightTooltip title={this.state.minValue === null ? `Value Should be 0` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                                                //         <NumberFormat
                                                                //             thousandSeparator={true}
                                                                //             style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent', color: 'red' }}
                                                                //             type="text"
                                                                //             placeholder=""
                                                                //             disabled={true}
                                                                //             value={Number(handleTotal(tableMeta, 7)).toFixed(1)}
                                                                //         />
                                                                //     </LightTooltip> 
                                                                :
                                                                null
                                        // tableMeta.rowData[3] === 7 ?
                                        //     (Number(handleValueFormula(value, tableMeta, 7)).toFixed(1) >= Number(this.state.minValue) && Number(handleValueFormula(value, tableMeta, 3)).toFixed(1) <= Number(this.state.maxValue)) ?
                                        //         <NumberFormat
                                        //             thousandSeparator={true}
                                        //             style={{
                                        //                 fontSize: 12,
                                        //                 textAlign: 'right',
                                        //                 borderColor: 'transparent',
                                        //                 margin: 0,
                                        //                 width: 96,
                                        //                 backgroundColor: 'transparent',
                                        //                 color: 'black'
                                        //             }}
                                        //             type="text"
                                        //             placeholder=""
                                        //             disabled={true}
                                        //             value={Number(handleValueFormula(value, tableMeta, 7)).toFixed(1)}
                                        //         /> :
                                        //         <LightTooltip title={this.state.minValue === null ? `Value Should be ${tableMeta.rowData[25].tbf}` : `Value Should be (${this.state.minValue}) up to (${this.state.maxValue})`} arrow>
                                        //             <NumberFormat
                                        //                 thousandSeparator={true}
                                        //                 style={{
                                        //                     fontSize: 12,
                                        //                     textAlign: 'right',
                                        //                     borderColor: 'transparent',
                                        //                     margin: 0,
                                        //                     width: 96,
                                        //                     backgroundColor: 'transparent',
                                        //                     color: 'red'
                                        //                 }}
                                        //                 type="text"
                                        //                 placeholder=""
                                        //                 disabled={true}
                                        //                 value={Number(handleValueFormula(value, tableMeta, 7)).toFixed(1)}
                                        //             />
                                        //         </LightTooltip>
                                        //     :
                                        //     null
                                    }
                                </div>
                            </div>
                        </div>
                    )
                }
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }, {
            name: "",
            options: {
                display: false
            }
        }
        ]
        const loadingComponent = (
            <div style={{ position: 'absolute', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)' }}>
                <PropagateLoader
                    // css={override}
                    size={20}
                    color={"#274B80"}
                    loading={this.state.loading}
                />
            </div>
        );

        return (
            <div style={{ height: this.props.height, backgroundColor: '#f8f8f8', marginBottom: 100, minHeight: 1000 }}>
                <div className={"main-color"} style={{ height: 78, flex: 1, display: 'flex', alignItems: 'center', paddingLeft: 20 }}>
                    <Typography style={{ fontSize: '16px', color: 'white' }}>Outlook Performance Appraisal Submission</Typography>
                </div>
                <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                    <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                        {this.state.messageAlert}
                    </Alert>
                </Snackbar>
                {/* {this.state.loading && loadingComponent} */}
                <div style={{ flex: 1, padding: 20, width: '100%' }}>
                    {this.state.visibleTP === true ?
                        <Paper style={{ paddingTop: 10, paddingBottom: 20 }}>
                            <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                                <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Outlook Performance Appraisal - Tax Planning</Typography>
                            </div>
                            <div style={{ padding: 20 }}>
                                <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                                    <div>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {this.props.periode} (rev.{this.props.revision})</Typography>
                                        {this.props.defaultCurrency.id === 1 ?
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                            :
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in USD thousand</Typography>
                                        }
                                    </div>
                                    <div style={{ width: '50%' }}>
                                        {this.props.isApprover === true || this.state.get_for == 'view' ?
                                            null
                                            // <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                            //     <a data-tip={'Download'} data-for="download">
                                            //         <button
                                            //             style={{
                                            //                 backgroundColor: 'transparent',
                                            //                 cursor: 'pointer',
                                            //                 borderColor: 'transparent',
                                            //                 margin: 5
                                            //             }}
                                            //             onClick={() =>
                                            //                 this.setState({ loading: true }, () => {
                                            //                     setTimeout(() => {
                                            //                         this.downloadAllData()
                                            //                     }, 100);
                                            //                 })}
                                            //         >
                                            //             <img src={Images.download} />
                                            //         </button>
                                            //     </a>
                                            //     <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" />
                                            // </div> 
                                            :
                                            <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                                <a data-tip={'Download Template'} data-for="template">
                                                    <button
                                                        style={{
                                                            backgroundColor: 'transparent',
                                                            cursor: 'pointer',
                                                            borderColor: 'transparent',
                                                            margin: 5
                                                        }}
                                                        onClick={() => this.downloadTemplate()}
                                                    >
                                                        <img src={Images.template} />
                                                    </button>
                                                </a>
                                                <ReactTooltip border={true} id="template" place="bottom" type="light" effect="solid" />
                                                <a data-tip={'Upload'} data-for="upload">
                                                    <button
                                                        style={{
                                                            backgroundColor: 'transparent',
                                                            cursor: 'pointer',
                                                            borderColor: 'transparent',
                                                            margin: 5
                                                        }}
                                                        onClick={() => this.setState({ visibleUpload: true })}
                                                    >
                                                        <img src={Images.upload} />
                                                    </button>
                                                </a>
                                                <ReactTooltip border={true} id="upload" place="bottom" type="light" effect="solid" />
                                                {/* <a data-tip={'Download'} data-for="download">
                                            <button
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: 'pointer',
                                                    borderColor: 'transparent',
                                                    margin: 5
                                                }}
                                                onClick={() =>
                                                    this.setState({ loading: true }, () => {
                                                        setTimeout(() => {
                                                            this.downloadAllData()
                                                        }, 100);
                                                    })}
                                            >
                                                <img src={Images.download} />
                                            </button>
                                        </a>
                                        <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" /> */}
                                            </div>
                                        }
                                    </div>
                                </div>

                                <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                    {this.state.loading && loadingComponent}
                                    <MuiThemeProvider theme={getMuiTheme()}>
                                        <MUIDataTable
                                            data={dataTable2}
                                            columns={columns}
                                            options={options}
                                        />
                                    </MuiThemeProvider>
                                </div>
                                <div style={{ display: 'flex' }}>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 20 }}>Last Updated by : </Typography>
                                    <div style={{ marginLeft: 10, overflowY: 'scroll', height: this.state.updateBy.length < 2 ? 25 : 75, marginTop: 10 }}>
                                        {
                                            this.state.updateBy.length > 0 ? this.state.updateBy.reverse().map((item, index) => {
                                                return (
                                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>{item.latest_update}</Typography>
                                                )
                                            }) :
                                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>-</Typography>
                                        }
                                    </div>
                                </div>
                                <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 5 }}>Notes : {this.state.notesUpdate}</Typography>
                            </div>
                            <div className="grid grid-2x" style={{ marginTop: 20 }}>
                                <div className="col-1">
                                    <button
                                        type="button"
                                        onClick={() => this.setState({ loading: true }, () => {
                                            setTimeout(() => {
                                                this.props.onClickClose()
                                            }, 100);
                                        })}
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none'
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                        </div>
                                    </button>
                                </div>
                                {this.props.isApprover === true ?
                                    <div className="col-2">
                                    </div> :
                                    <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%' }}>
                                        {this.state.get_for == 'view' && this.state.viewOnly &&
                                            <button
                                                className="button"
                                                type="button"
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: 'pointer',
                                                    borderColor: 'transparent',
                                                    outline: 'none',
                                                    marginRight: 20
                                                }}
                                                onClick={() => {
                                                    this.setState({ loading: true }, () => {
                                                        this.handleGetFor('edit')
                                                    })
                                                }}
                                            >
                                                <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                    <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Edit</Typography>
                                                </div>
                                            </button>
                                        }
                                        {this.state.get_for == 'edit' &&
                                            <button
                                                className="button"
                                                type="button"
                                                style={{
                                                    backgroundColor: 'transparent',
                                                    cursor: 'pointer',
                                                    borderColor: 'transparent',
                                                    outline: 'none',
                                                    marginRight: 20
                                                }}
                                                onClick={() => {
                                                    // this.forceUpdate()
                                                    this.setState({ loading: true, buttonDraft: false }, () => {
                                                        setTimeout(() => {
                                                            // this.setState({ loading: false, buttonError: false, editable: true })
                                                            this.handleValidate()
                                                        }, 100);
                                                    })
                                                }}
                                            >
                                                <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                    <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                                </div>
                                            </button>
                                        }
                                        {this.state.get_for == 'edit' && <button
                                            className="button"
                                            type="button"
                                            onClick={() =>
                                                this.state.saveDraft === true ?
                                                    this.setState({ alert: true, messageAlert: 'Data is not complete !', tipeAlert: 'error' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                            setTimeout(() => {
                                                                this.backToMasterBudget('draft')
                                                            }, 100);
                                                        })
                                            }
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                            </div>
                                        </button>}
                                        {this.state.get_for == 'edit' && <button
                                            type="button"
                                            // disabled={this.state.buttonError}
                                            onClick={() =>
                                                this.state.buttonError ?
                                                    this.setState({ alert: true, messageAlert: 'Data Incomplete', tipeAlert: 'error' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1 }, () => {
                                                            setTimeout(() => {
                                                                this.backToMasterBudget('submitted')
                                                            }, 100);
                                                        })
                                            }
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none'
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', marginRight: 10 }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                            </div>
                                        </button>}
                                    </div>
                                }
                            </div>
                        </Paper>
                        :
                        <Paper style={{ paddingTop: 10, paddingBottom: 20 }}>
                            <div>
                                <div style={{ padding: 25 }}>
                                    <div>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {this.props.periode} (rev.{this.props.revision})</Typography>
                                        {this.props.defaultCurrency.id === 1 ?
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                            :
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in USD thousand</Typography>
                                        }
                                    </div>
                                    {this.state.dataLoaded && (
                                        <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                            {this.state.loading && loadingComponent}
                                            <MuiThemeProvider theme={getMuiTheme()}>
                                                <MUIDataTable
                                                    data={dataTable2}
                                                    columns={columns}
                                                    options={options}
                                                />
                                            </MuiThemeProvider>
                                        </div>
                                    )}
                                </div>
                                <div className="grid grid-2x" style={{ marginTop: 20 }}>
                                    <div className="col-1">
                                        <button
                                            type="button"
                                            onClick={() => this.setState({ loading: true, visibleTP: true }, () => {
                                                setTimeout(() => {
                                                    this.getItemHierarki()
                                                }, 100);
                                            })}
                                            style={{ marginRight: 20 }}
                                        >
                                            <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                            </div>
                                        </button>
                                    </div>
                                    <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%' }}>
                                        <button
                                            className="button"
                                            type="button"
                                            // disabled={this.state.buttonError}
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() => {
                                                this.setState({ loading: true, buttonDraft: false }, () => {
                                                    setTimeout(() => {
                                                        // this.setState({ loading: false, buttonError: this.state.errorPreview === true ? true : false, editable: false })
                                                        this.handleValidate()
                                                    }, 100);
                                                })
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                            </div>
                                        </button>
                                        <button
                                            type="button"
                                            // disabled={this.state.buttonError}
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: this.state.editable !== true ? 'pointer' : 'default',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() => this.state.editable === true ?
                                                null
                                                :
                                                this.state.handleDoubleClick == 1 ? null :
                                                    this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                        setTimeout(() => {
                                                            this.uploadTP('draft')
                                                        }, 100);
                                                    })}
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                            </div>
                                        </button>
                                        <button
                                            type="button"
                                            // disabled={this.state.buttonError}
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: this.state.editable !== true ? 'pointer' : 'default',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                            }}
                                            onClick={() =>
                                                this.state.editable === true ?
                                                    this.setState({ alert: true, messageAlert: 'Data Incomplete', tipeAlert: 'error' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                            setTimeout(() => {
                                                                this.uploadTP('submitted')
                                                            }, 100);
                                                        })}
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                            </div>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </Paper>
                    }
                </div>
                {this.state.visibleUpload && (
                    <div className="test app-popup-show">
                        <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                            <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                    <div className="popup-title">
                                        <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Upload File</span>
                                    </div>
                                </div>
                                <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        className="btn btn-circle btn-white"
                                        onClick={() => this.setState({ visibleUpload: false })}
                                    >
                                        <img src={Images.close} />
                                    </button>
                                </div>
                            </div>
                            <div style={{ padding: '25px 30px' }}>
                                <UploadFile
                                    type={this.state.uploadStatus}
                                    percentage={this.state.percentage}
                                    result={this.state.result}
                                    acceptedFiles={["xlsx"]}
                                    onHandle={(dt) => {
                                        this.fileHandler(dt)
                                        this.setState({ uploadStatus: 'idle', percentage: '0' })
                                    }}
                                    onUpload={() => {
                                        String(this.state.judul).includes("OUTLOOK") && String(this.state.judul).includes("PA") && String(this.state.judul).includes("TAX") && String(this.state.judul).includes("PLANNING") ?
                                            this.checkUpload() :
                                            this.setState({ alert: true, messageAlert: "Invalid Template", tipeAlert: 'warning' })
                                    }}
                                />
                            </div>
                            <div style={{ padding: '0px 30px 29px', fontSize: 17, color: 'red' }}><b>Warning:</b> Valid currency for uploading data in <b>{this.props.defaultCurrency.id == 1 ? "IDR mn" : "thousand USD"}</b></div>
                        </div>
                    </div>
                )}

                {this.state.visibleAlertSave && (
                    <div className="test app-popup-show">
                        <div className="popup-content border-radius" style={{ background: '#FFF27D', borderRadius: 10, width: 715, height: 238 }}>
                            <div style={{ margin: 30 }}>
                                <div style={{ display: 'flex', marginTop: 76, marginBottom: 43 }}>
                                    <div style={{ alignSelf: 'center', marginRight: 25 }}>
                                        <img src={Images.warning} />
                                    </div>
                                    <div style={{ justifyContent: 'center', fontSize: 20, color: '#1D2995', marginTop: 10 }}>
                                        <b>Rate Currency USD</b> pada periode yang dipilih <b>belum</b> diatur.<br /> Silahkan menghubungi Superadmin
                                    </div>
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'flex-end' }}>
                                    <button
                                        className="button"
                                        type="button"
                                        style={{
                                            background: '#F6F7F9',
                                            cursor: 'pointer',
                                            border: '1px solid #3549609e',
                                            outline: 'none',
                                            marginRight: 20,
                                            borderRadius: 9
                                        }}
                                        onClick={() => this.setState({ visibleAlertSave: false, loading: false })}
                                    >
                                        <div style={{ backgroundColor: '#fff', width: 105, height: 30, borderRadius: 9, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #3549609e' }}>
                                            <Typography style={{ fontSize: '15px', color: '#354960', textAlign: 'center' }}>Close</Typography>
                                        </div>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                )}
            </div>
        );
    }
}
