import React, { Component } from 'react';
import PropagateLoader from 'react-spinners/PropagateLoader';

class OverlayLoader extends Component {
  render() {
    const {
      isLoading,
      loaderSize = 20,
      loaderColor = '#274B80',
      overlayColor = 'rgba(255,255,255,0.8)',
      customStyles = {},
    } = this.props;

    if (!isLoading) return null;

    const defaultStyle = {
      position: 'absolute',
      zIndex: 110,
      top: 0,
      left: 0,
      width: '100%',
      height: '100%',
      display: 'flex',
      justifyContent: 'center',
      alignItems: 'center',
      background: overlayColor,
    };

    const finalStyle = { ...defaultStyle, ...customStyles };

    return (
      <div style={finalStyle}>
        <PropagateLoader
          size={loaderSize}
          color={loaderColor}
          loading={isLoading}
        />
      </div>
    );
  }
}

export default OverlayLoader;