import React, { Component } from 'react';
import { TextField, Divider, Typography, Checkbox, withStyles, Collapse, Snackbar } from '@material-ui/core';
import api from '../../../api';
import AddIcon from '@material-ui/icons/Add';
import RemoveIcon from '@material-ui/icons/Remove';
import { DatePicker } from "@material-ui/pickers";
import format from "date-fns/format";
import localeID from "date-fns/locale/id"
import * as R from 'ramda'
import Images from '../../../assets/Images';
import MuiAlert from '@material-ui/lab/Alert';
import Constant from '../../../library/Constant';

const CustomCheckbox = withStyles({
    root: {
        color: '#51c6ea',
        '&$checked': {
            color: '#51c6ea',
        },
        padding: 5
    },
    checked: {},
})((props) => <Checkbox color="default" {...props} />);

const Alert = withStyles({
})((props) => <MuiAlert elevation={6} variant="filled" {...props} />);

export default class AddRole extends Component {

    constructor(props) {
        super(props)
        this.state = {
            paramsId: this.props.data,
            tempData: null,
            menuData: null,
            privileges: [],
            checked: false,
            selectedIndex: 0,
            roleName: '',
            startDate: null,
            endDate: null,
            date: new Date(),
            errorRoleName: false,
            errorStartDate: false,
            errorEndDate: false,
            msgErrorRN: '',
            msgErrorSD: '',
            msgErrorED: '',
            application: [],
            setting: [],
            alert: false,
            tipeAlert: '',
            messageAlert: ''
        }
    }

    handleChecked() {
        this.setState({ checked: !this.state.checked })
    }

    componentDidMount() {
        this.getMenu()
        if (this.props.type === 'edit') {
            //
        } else {
            let date = format(new Date, 'yyyy-MM-dd')
            // console.log(date);
            this.setState({
                startDate: date,
                endDate: date
            })
        }
    }

    handleChange(e, type) {
        let data = this.state
        let isDate = type !== '' ? true : false
        if (isDate && type === 'start_date') {
            this.setState({
                ...data, startDate: format(e, 'yyyy-MM-dd'), endDate: null,
                errorRoleName: false,
                errorStartDate: false,
                errorEndDate: false,
                msgErrorRN: '',
                msgErrorSD: '',
                msgErrorED: '',
            })
        } else if (isDate && type === 'end_date') {
            this.setState({
                ...data, endDate: format(e, 'yyyy-MM-dd'),
                errorRoleName: false,
                errorStartDate: false,
                errorEndDate: false,
                msgErrorRN: '',
                msgErrorSD: '',
                msgErrorED: '',
            })
        } else {
            this.setState({
                ...data, [e.target.name]: e.target.value,
                errorRoleName: false,
                errorStartDate: false,
                errorEndDate: false,
                msgErrorRN: '',
                msgErrorSD: '',
                msgErrorED: '',
            })
        }

    }

    validasi() {
        if (R.isEmpty(this.state.roleName)) {
            this.setState({ errorRoleName: true, msgErrorRN: 'Role Cannot be Empty' })
        } else if (R.isNil(this.state.startDate)) {
            this.setState({ errorStartDate: true, msgErrorSD: 'Valid From Cannot be Empty' })
        } else if (R.isNil(this.state.endDate)) {
            this.setState({ errorEndDate: true, msgErrorED: 'Valid To Cannot be Empty' })
        } else if (this.state.privileges.length < 1) {
            this.setState({ alert: true, messageAlert: 'You Must Choose the Access Rights', tipeAlert: 'warning' })
        } else {
            this.addRole()
        }
    }

    addRole() {
        // let startDate = format(this.state.tempData.start_date, 'yyyy-MM-dd')
        // let endDate = format(this.state.tempData.end_date, 'yyyy-MM-dd')
        let payload = {
            "role_name": this.state.roleName,
            "start_date": this.state.startDate,
            "end_date": this.state.endDate,
            "privileges": this.state.privileges
        }
        // console.log(payload)
        api.create().addRole(payload).then((response) => {
            // console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'success' })
                        setTimeout(() => {
                            this.props.onClickClose()
                            // this.props.refresh()
                            window.location.reload();
                        }, 750);
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    parseChildren(val) {
        let data = Object.assign([], val)
        data = data.sort((a, b) => a.menu_id - b.menu_id).map((i) => {
            return {
                menu_id: i.menu_id,
                label: i.menu_name,
                sub_menu: this.parseChildren(i.sub_menu),
                collapse: false,
                reference: i.reference
            }
        })
        return data
    }

    getMenu() {
        api.create().getMenu().then((response) => {
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        let app = null
                        let set = null
                        response.data.data.map((item) => {
                            if (item.menu_name === "Application") {
                                app = this.parseChildren(item.sub_menu)
                                return app
                            } else {
                                set = this.parseChildren(item.sub_menu)
                                return set
                            }
                        })
                        // console.log(app)
                        this.setState({ application: app, setting: set, isLoad: true }, () => console.log(this.state.application))
                        // this.setState({ menuData: response.data.data })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    handleItemChecked(item) {
        let indexID = this.state.privileges.findIndex((val) => val.menu_id === item.menu_id)
        return indexID === -1 ? false : true
    }

    handleItemClick(item) {
        let indexID = this.state.privileges.findIndex((val) => val.menu_id === item.menu_id)
        let privileges = this.state.privileges
        if (indexID === -1) {
            privileges.push({
                menu_id: item.menu_id,
                button_id: [1, 2, 3, 4, 5]
            })
            if (item.sub_menu.length > 0) {
                item.sub_menu.map((items,indexs) => {
                   let indexIDs = this.state.privileges.findIndex((val) => val.menu_id === items.menu_id)
                   if (indexIDs === -1) {
                       privileges.push({
                           menu_id: items.menu_id,
                           button_id: [1,2,3,4,5]
                       })
                   }
                })
            }
            if (item.reference !== null && item.reference !== 13 && item.reference !== 1) {
                let indexIDapp = this.state.application.findIndex((val) => val.menu_id === item.reference)
                let indexIDset = this.state.setting.findIndex((val) => val.menu_id === item.reference)
                let indexIDref = this.state.privileges.findIndex((val) => val.menu_id === item.reference)
                let indexIDs = indexIDapp == -1? indexIDset : indexIDapp
                let total = 0
                let array = indexIDapp == -1? this.state.setting : this.state.application

                array[indexIDs].sub_menu.map((items,indexs) => {
                    let indexIDsub = this.state.privileges.findIndex((val) => val.menu_id === items.menu_id)
                    if (indexIDsub !== -1) {
                        total += 1
                    }
                })
                if (indexIDref == -1) {
                    privileges.push({
                        menu_id: item.reference,
                        button_id: [1,2,3,4,5]
                    })
                } else {
                    if (total < 1) {
                        privileges.splice(indexIDref, 1)
                    }
                }
            }
        } else {
            privileges.splice(indexID, 1)
            if (item.sub_menu.length > 0) {
                item.sub_menu.map((items,indexs) => {
                    let indexIDs = this.state.privileges.findIndex((val) => val.menu_id === items.menu_id)
                    privileges.splice(indexIDs, 1)
                })
            }
            if (item.reference !== null && item.reference !== 13 && item.reference !== 1) {
                let indexIDapp = this.state.application.findIndex((val) => val.menu_id === item.reference)
                let indexIDset = this.state.setting.findIndex((val) => val.menu_id === item.reference)
                let indexIDref = this.state.privileges.findIndex((val) => val.menu_id === item.reference)
                let indexIDs = indexIDapp == -1? indexIDset : indexIDapp
                let total = 0
                let array = indexIDapp == -1? this.state.setting : this.state.application

                array[indexIDs].sub_menu.map((items,indexs) => {
                    let indexIDsub = this.state.privileges.findIndex((val) => val.menu_id === items.menu_id)
                    if (indexIDsub !== -1) {
                        total += 1
                    }
                })

                if (indexIDref == -1) {
                    privileges.push({
                        menu_id: item.reference,
                        button_id: [1,2,3,4,5]
                    })
                } else {
                    if (total < 1) {
                        privileges.splice(indexIDref, 1)
                    }
                }
            }
        }
        this.setState({ privileges }, () => {
            // console.log(this.state.privileges)
        })
    }

    handleSubItemChecked(item, index) {
        let indexID = this.state.privileges.findIndex((val) => val.menu_id === item.menu_id)
        let value = false
        if (indexID === -1) {
            value = false
        } else {
            let indexButtonID = this.state.privileges[indexID].button_id.findIndex((val) => val === index)
            if (indexButtonID === -1) {
                value = false
            } else {
                value = true
            }
        }
        return indexID === -1 ? value : value
    }

    handleSubItemClick(item, index) {
        let indexID = this.state.privileges.findIndex((val) => val.menu_id === item.menu_id)
        let indexButtonID = this.state.privileges[indexID].button_id.findIndex((val) => val === index)
        let privileges = this.state.privileges
        let button_id = privileges[indexID].button_id
        
        if (indexButtonID === -1) {
            button_id.push(index)
            if (item.sub_menu.length > 0) {
                item.sub_menu.map((items,indexs) => {
                    let subIndexID = privileges.findIndex((val) => val.menu_id === items.menu_id)
                    if (subIndexID === -1) {
                        // console.log('masuk pa eko', subIndexID)
                        privileges.push({
                            menu_id: items.menu_id,
                            button_id: [index]
                        })
                    } else {
                        let subIndexButtonID = privileges[subIndexID].button_id.findIndex((val) => val === index)
                        let subButton_id = privileges[subIndexID].button_id
                        if(subIndexButtonID === -1) {
                            subButton_id.push(index)
                        }
                    }
                })
            }
            if (item.reference !== null && item.reference !== 13 && item.reference !== 1) { 
                let refIndexID = privileges.findIndex((val) => val.menu_id === item.reference)
                if (refIndexID !== -1) {
                    let refIndexButtonID = privileges[refIndexID].button_id.findIndex((val) => val === index)
                    let refButton_id = privileges[refIndexID].button_id
                    if (refIndexButtonID === -1) {
                        refButton_id.push(index)
                    }
                    privileges[refIndexID].button_id = refButton_id
                }
            }
        } else {
            button_id.splice(indexButtonID, 1)
            if (item.sub_menu.length > 0) {
                item.sub_menu.map((items,indexs) => {
                    let subIndexID = privileges.findIndex((val) => val.menu_id === items.menu_id)
                    if (subIndexID !== -1) {
                        let subIndexButtonID = privileges[subIndexID].button_id.findIndex((val) => val === index)
                        let subButton_id = privileges[subIndexID].button_id
                        if (subIndexButtonID !== -1) {
                            subButton_id.splice(subIndexButtonID, 1)
                            privileges[subIndexID].button_id = subButton_id
                            if (privileges[subIndexID].button_id.length < 1) {
                                privileges.splice(subIndexID, 1)
                            }
                        }
                    }
                })
            }
            if (item.reference !== null && item.reference !== 13 && item.reference !== 1) { 
                let refIndexID = privileges.findIndex((val) => val.menu_id === item.reference)
                if (refIndexID !== -1) {
                    let refIndexButtonID = privileges[refIndexID].button_id.findIndex((val) => val === index)
                    let refButton_id = privileges[refIndexID].button_id
                    let indexIDapp = this.state.application.findIndex((val) => val.menu_id === item.reference)
                    let indexIDset = this.state.setting.findIndex((val) => val.menu_id === item.reference)
                    let indexIDs = indexIDapp == -1? indexIDset : indexIDapp
                    let array = indexIDapp == -1? this.state.setting : this.state.application
                    let splicer = 0
                    array[indexIDs].sub_menu.map((refItem, refIndex) => {
                        let subIndexID = privileges.findIndex((val) => val.menu_id === refItem.menu_id)
                        if (subIndexID !== -1) {
                            let subIndexButtonID = privileges[subIndexID].button_id.findIndex((val) => val === index)
                            if (subIndexButtonID !== -1) {
                                splicer += 1
                            }                  
                        }
                    })
                    if (refIndexButtonID !== -1 && splicer < 1) {
                        refButton_id.splice(refIndexButtonID, 1)
                    }
                    privileges[refIndexID].button_id = refButton_id
                }
            }
        }
        privileges[indexID].button_id = button_id.sort((a,b) => a-b)
        if (button_id.length === 0) {
            privileges.splice(indexID, 1)
        }
        this.setState({ privileges: privileges.sort((a,b) => a.menu_id-b.menu_id) })
    }

    handleDate(item) {
        let value = format(item, 'dd MMMM yyyy')
        return value
    }

    handleCollapse(item) {
        let arr = this.state.application
        let index = arr.findIndex((val) => val.label === item.label)
        arr[index].collapse = !arr[index].collapse
        this.setState({ ...this.state.application, application: arr })
    }

    handleCollapseSetting(item) {
        let arr = this.state.setting
        let index = arr.findIndex((val) => val.label === item.label)
        arr[index].collapse = !arr[index].collapse
        this.setState({ ...this.state.setting, setting: arr })
    }

    closeAlert() {
      this.setState({ alert: false })
    }
    
    render() {
        return (
            <div className="test app-popup-show">
                <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                    <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                        {this.state.messageAlert}
                    </Alert>
                </Snackbar>
                <div className="popup-content-middle background-white border-radius" style={{ borderRadius: 8 }}>
                    <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                        <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                            <div className="popup-title">
                                <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Create Data</span>
                            </div>
                        </div>
                        <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                            <button
                                type="button"
                                className="btn btn-circle btn-white"
                                onClick={() => this.props.onClickClose()}
                            >
                                <img src={Images.close} />
                            </button>
                        </div>
                    </div>

                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ padding: 20 }}>
                        <div className="column-1">
                            <div className="margin-bottom-20px">
                                <TextField
                                    style={{ width: '100%' }}
                                    id="id"
                                    label="ID"
                                    disabled
                                    // id="outlined-read-only-input"
                                    variant="filled"
                                    value={'-'}
                                    onChange={(e) => null}
                                    inputProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                            color: '#7e8085',
                                        }
                                    }}
                                >
                                    {/* {periode.map((option) => (
                                        <MenuItem key={option.value} value={option.value}>
                                            {option.label}
                                        </MenuItem>
                                    ))} */}
                                </TextField>
                            </div>
                        </div>

                        <div className="column-2">
                            <div className="margin-bottom-20px">
                                <TextField
                                    style={{ width: '100%', marginTop: 7 }}
                                    id="userRole"
                                    name="roleName"
                                    label="User Role"
                                    value={this.state.roleName}
                                    error={this.state.errorRoleName}
                                    helperText={this.state.msgErrorRN}
                                    onChange={(e) => this.handleChange(e, '')}
                                    inputProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                            color: '#7e8085',
                                        }
                                    }}
                                // defaultValue="Default Value"
                                // helperText="Some important text"
                                />
                            </div>
                        </div>
                    </div>

                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1">
                            <div className="margin-bottom-20px">
                                <DatePicker
                                    margin="normal"
                                    id="startDate"
                                    label="Valid From"
                                    format="dd-MM-yyyy"
                                    value={this.state.startDate}
                                    error={this.state.errorStartDate}
                                    helperText={this.state.msgErrorSD}
                                    onChange={(e) => this.handleChange(e, 'start_date')}
                                    KeyboardButtonProps={{
                                        'aria-label': 'change date',
                                    }}
                                    inputProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085',
                                            fontFamily: 'Nunito Sans, sans-serif',
                                        }
                                    }}

                                    style={{ padding: 0, margin: 0, width: '100%' }}
                                />
                            </div>
                        </div>

                        <div className="column-2">
                            <div className="margin-bottom-20px">
                                <DatePicker
                                    margin="normal"
                                    id="endDate"
                                    label="Valid To"
                                    format="dd-MM-yyyy"
                                    value={this.state.endDate}
                                    error={this.state.errorEndDate}
                                    helperText={this.state.msgErrorED}
                                    onChange={(e) => this.handleChange(e, 'end_date')}
                                    minDate={this.state.startDate}
                                    KeyboardButtonProps={{
                                        'aria-label': 'change date',
                                    }}
                                    inputProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085',
                                            fontFamily: 'Nunito Sans, sans-serif',
                                        }
                                    }}

                                    style={{ padding: 0, margin: 0, width: '100%' }}
                                />
                            </div>
                        </div>
                    </div>

                    <div className="grid grid-2x grid-mobile-none gap-15px" style={{ paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1">
                            <div className="margin-bottom-20px">
                                <TextField
                                    style={{ width: '100%' }}
                                    id="status"
                                    label="Status"
                                    disabled
                                    // id="outlined-read-only-input"
                                    variant="filled"
                                    value={'Active'}

                                    inputProps={{
                                        style: {
                                            fontSize: 11,
                                            fontFamily: 'Nunito Sans, sans-serif',
                                        }
                                    }}
                                    InputLabelProps={{
                                        style: {
                                            fontSize: 11,
                                            color: '#7e8085',
                                            fontFamily: 'Nunito Sans, sans-serif',
                                        }
                                    }}
                                >
                                    {/* {periode.map((option) => (
                                        <MenuItem key={option.value} value={option.value}>
                                            {option.label}
                                        </MenuItem>
                                    ))} */}
                                </TextField>
                            </div>
                        </div>
                    </div>
                    {/* <div style={{ flexDirection: 'column', display: 'flex', paddingLeft: 20, paddingRight: 20 }}>
                        <Typography style={{ fontSize: 12 }}>{`Dibuat: `}</Typography>
                        <Typography style={{fontSize: 12}}>{`Diubah: `}</Typography>
                    </div> */}
                    <Divider style={{ margin: 20 }} />
                    <div style={{ paddingLeft: 20, paddingRight: 20 }}>
                        <h5>Access Rights</h5>
                        <div className="grid grid-2x grid-mobile-none gap-15px padding-top-5px padding-bottom-5px padding-left-10px padding-right-10px " style={{ backgroundColor: '#4b4b4b' }}>
                            <div className="column-1">
                                <Typography style={{ fontSize: 12, color: 'white' }}>Authorization Module</Typography>
                            </div>
                            <div className="column-2 grid grid-5x content-center grid-mobile-none gap-15px">
                                <div className="column-1">
                                    <Typography style={{ fontSize: 12, color: 'white' }}>View</Typography>
                                </div>
                                <div className="column-2">
                                    <Typography style={{ fontSize: 12, color: 'white' }}>Create</Typography>
                                </div>
                                <div className="column 3">
                                    <Typography style={{ fontSize: 12, color: 'white' }}>Edit</Typography>
                                </div>
                                <div className="column 4">
                                    <Typography style={{ fontSize: 12, color: 'white' }}>Delete</Typography>
                                </div>
                                <div className="column 5">
                                    <Typography style={{ fontSize: 12, color: 'white' }}>Download</Typography>
                                </div>
                            </div>
                        </div>

                        <div style={{ height: '25vh', overflow: 'scroll' }}>
                            {this.state.application.map((item, index) => {
                                return (
                                    <div>
                                        <div className="grid grid-2x grid-mobile-none gap-15px padding-left-10px padding-right-10px">
                                            <div className="column-1" style={{ display: 'flex', flexDirection: 'row', alignItems: 'center', justifyContent: 'flex-start', paddingLeft: 8 }}>
                                                {item.sub_menu.length > 0 && <span onClick={() => this.handleCollapse(item)} style={{ marginRight: 2, marginLeft: -22 }}>
                                                    {item.collapse ? <RemoveIcon color={'action'} fontSize={'small'} /> : <AddIcon color={'action'} fontSize={'small'} />}
                                                </span>}
                                                <span>
                                                    <CustomCheckbox
                                                        checked={this.handleItemChecked(item)}
                                                        onChange={() => this.handleItemClick(item)}
                                                    />
                                                </span>
                                                <Typography style={{ fontSize: 12, marginLeft: 5 }}>{item.label}</Typography>
                                            </div>
                                            <div className="column-2 grid grid-5x content-center grid-mobile-none gap-15px margin-left-10px">
                                                <div className="column-1">
                                                    <CustomCheckbox
                                                        disabled={!this.handleItemChecked(item)}
                                                        checked={this.handleSubItemChecked(item, 1)}
                                                        onChange={() => this.handleSubItemClick(item, 1)}
                                                    />
                                                </div>
                                                <div className="column-2">
                                                    <CustomCheckbox
                                                        // disabled
                                                        disabled={!this.handleItemChecked(item)}
                                                        checked={this.handleSubItemChecked(item, 2)}
                                                        onChange={() => this.handleSubItemClick(item, 2)}
                                                    />
                                                </div>
                                                <div className="column 3">
                                                    <CustomCheckbox
                                                        // disabled
                                                        disabled={!this.handleItemChecked(item)}
                                                        checked={this.handleSubItemChecked(item, 3)}
                                                        onChange={() => this.handleSubItemClick(item, 3)}
                                                    />
                                                </div>
                                                <div className="column 4">
                                                    <CustomCheckbox
                                                        // disabled
                                                        disabled={!this.handleItemChecked(item)}
                                                        checked={this.handleSubItemChecked(item, 4)}
                                                        onChange={() => this.handleSubItemClick(item, 4)}
                                                    />
                                                </div>
                                                <div className="column 5">
                                                    <CustomCheckbox
                                                        // disabled
                                                        disabled={!this.handleItemChecked(item)}
                                                        checked={this.handleSubItemChecked(item, 5)}
                                                        onChange={() => this.handleSubItemClick(item, 5)}
                                                    />
                                                </div>
                                            </div>
                                        </div>
                                        {item.sub_menu.length > 0 && item.sub_menu.map((items, indexs) => {
                                            return (
                                                <Collapse in={item.collapse} timeout="auto" unmountOnExit>
                                                    <div className="grid grid-2x grid-mobile-none gap-15px padding-left-10px padding-right-10px">
                                                        <div className="column-1" style={{ display: 'flex', flexDirection: 'row', alignItems: 'center', paddingLeft: 30 }}>
                                                            <CustomCheckbox
                                                                checked={this.handleItemChecked(items)}
                                                                onChange={() => this.handleItemClick(items)}
                                                            />
                                                            <Typography style={{ fontSize: 12, maxWidth: '100%', marginLeft: 5 }}>{items.label}</Typography>
                                                        </div>
                                                        <div className="column-2 grid grid-5x content-center grid-mobile-none gap-15px margin-left-10px">
                                                            <div className="column-1">
                                                                <CustomCheckbox
                                                                    disabled={!this.handleItemChecked(items)}
                                                                    checked={this.handleSubItemChecked(items, 1)}
                                                                    onChange={() => this.handleSubItemClick(items, 1)}
                                                                />
                                                            </div>
                                                            <div className="column-2">
                                                                <CustomCheckbox
                                                                    disabled={!this.handleItemChecked(items)}
                                                                    checked={this.handleSubItemChecked(items, 2)}
                                                                    onChange={() => this.handleSubItemClick(items, 2)}
                                                                />
                                                            </div>
                                                            <div className="column 3">
                                                                <CustomCheckbox
                                                                    disabled={!this.handleItemChecked(items)}
                                                                    checked={this.handleSubItemChecked(items, 3)}
                                                                    onChange={() => this.handleSubItemClick(items, 3)}
                                                                />
                                                            </div>
                                                            <div className="column 4">
                                                                <CustomCheckbox
                                                                    disabled={!this.handleItemChecked(items)}
                                                                    checked={this.handleSubItemChecked(items, 4)}
                                                                    onChange={() => this.handleSubItemClick(items, 4)}
                                                                />
                                                            </div>
                                                            <div className="column 5">
                                                                <CustomCheckbox
                                                                    disabled={!this.handleItemChecked(items)}
                                                                    checked={this.handleSubItemChecked(items, 5)}
                                                                    onChange={() => this.handleSubItemClick(items, 5)}
                                                                />
                                                            </div>
                                                        </div>
                                                    </div>
                                                </Collapse>
                                            )
                                        })}
                                    </div>
                                )
                            })}
                            {this.state.setting.map((item, index) => {
                                return (
                                    <div>
                                        {item.menu_id !== 23 && <div className="grid grid-2x grid-mobile-none gap-15px padding-left-10px padding-right-10px">
                                            <div className="column-1" style={{ display: 'flex', flexDirection: 'row', alignItems: 'center', justifyContent: 'flex-start', paddingLeft: 8 }}>
                                                {item.sub_menu.length > 0 && <span onClick={() => this.handleCollapseSetting(item)} style={{ marginRight: 2, marginLeft: -22 }}>
                                                    {item.collapse ? <RemoveIcon color={'action'} fontSize={'small'} /> : <AddIcon color={'action'} fontSize={'small'} />}
                                                </span>}
                                                <span>
                                                    <CustomCheckbox
                                                        checked={this.handleItemChecked(item)}
                                                        onChange={() => this.handleItemClick(item)}
                                                    />
                                                </span>
                                                <Typography style={{ fontSize: 12, marginLeft: 5 }}>{item.label}</Typography>
                                            </div>
                                            <div className="column-2 grid grid-5x content-center grid-mobile-none gap-15px margin-left-10px">
                                                <div className="column-1">
                                                    <CustomCheckbox
                                                        disabled={!this.handleItemChecked(item)}
                                                        checked={this.handleSubItemChecked(item, 1)}
                                                        onChange={() => this.handleSubItemClick(item, 1)}
                                                    />
                                                </div>
                                                <div className="column-2">
                                                    <CustomCheckbox
                                                        // disabled
                                                        disabled={!this.handleItemChecked(item)}
                                                        checked={this.handleSubItemChecked(item, 2)}
                                                        onChange={() => this.handleSubItemClick(item, 2)}
                                                    />
                                                </div>
                                                <div className="column 3">
                                                    <CustomCheckbox
                                                        // disabled
                                                        disabled={!this.handleItemChecked(item)}
                                                        checked={this.handleSubItemChecked(item, 3)}
                                                        onChange={() => this.handleSubItemClick(item, 3)}
                                                    />
                                                </div>
                                                <div className="column 4">
                                                    <CustomCheckbox
                                                        // disabled
                                                        disabled={!this.handleItemChecked(item)}
                                                        checked={this.handleSubItemChecked(item, 4)}
                                                        onChange={() => this.handleSubItemClick(item, 4)}
                                                    />
                                                </div>
                                                <div className="column 5">
                                                    <CustomCheckbox
                                                        // disabled
                                                        disabled={!this.handleItemChecked(item)}
                                                        checked={this.handleSubItemChecked(item, 5)}
                                                        onChange={() => this.handleSubItemClick(item, 5)}
                                                    />
                                                </div>
                                            </div>
                                        </div>}
                                        {item.sub_menu.length > 0 && item.sub_menu.map((items, indexs) => {
                                            return (
                                                <Collapse in={item.collapse} timeout="auto" unmountOnExit>
                                                    <div className="grid grid-2x grid-mobile-none gap-15px padding-left-10px padding-right-10px">
                                                        <div className="column-1" style={{ display: 'flex', flexDirection: 'row', alignItems: 'center', paddingLeft: 30 }}>
                                                            <CustomCheckbox
                                                                checked={this.handleItemChecked(items)}
                                                                onChange={() => this.handleItemClick(items)}
                                                            />
                                                            <Typography style={{ fontSize: 12, maxWidth: '100%', marginLeft: 5 }}>{items.label}</Typography>
                                                        </div>
                                                        <div className="column-2 grid grid-5x content-center grid-mobile-none gap-15px margin-left-10px">
                                                            <div className="column-1">
                                                                <CustomCheckbox
                                                                    disabled={!this.handleItemChecked(items)}
                                                                    checked={this.handleSubItemChecked(items, 1)}
                                                                    onChange={() => this.handleSubItemClick(items, 1)}
                                                                />
                                                            </div>
                                                            <div className="column-2">
                                                                <CustomCheckbox
                                                                    disabled={!this.handleItemChecked(items)}
                                                                    checked={this.handleSubItemChecked(items, 2)}
                                                                    onChange={() => this.handleSubItemClick(items, 2)}
                                                                />
                                                            </div>
                                                            <div className="column 3">
                                                                <CustomCheckbox
                                                                    disabled={!this.handleItemChecked(items)}
                                                                    checked={this.handleSubItemChecked(items, 3)}
                                                                    onChange={() => this.handleSubItemClick(items, 3)}
                                                                />
                                                            </div>
                                                            <div className="column 4">
                                                                <CustomCheckbox
                                                                    disabled={!this.handleItemChecked(items)}
                                                                    checked={this.handleSubItemChecked(items, 4)}
                                                                    onChange={() => this.handleSubItemClick(items, 4)}
                                                                />
                                                            </div>
                                                            <div className="column 5">
                                                                <CustomCheckbox
                                                                    disabled={!this.handleItemChecked(items)}
                                                                    checked={this.handleSubItemChecked(items, 5)}
                                                                    onChange={() => this.handleSubItemClick(items, 5)}
                                                                />
                                                            </div>
                                                        </div>
                                                    </div>
                                                </Collapse>
                                            )
                                        })}
                                    </div>
                                )
                            })}
                        </div>

                    </div>
                    <div className="border-top grid grid-2x" style={{ height: 56, backgroundColor: '#f5f5f5', paddingLeft: 20, paddingRight: 20 }}>
                        <div className="column-1" style={{ alignSelf: 'center' }}>
                            <button
                                type="button"
                                onClick={() => this.props.onClickClose()}
                            >
                                <div style={{ width: 102, height: 30, border: 'solid 1px #354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                    <span style={{ color: '#354960', fontSize: 11 }}>Cancel</span>
                                </div>
                            </button>

                        </div>
                        <div className="column-2" style={{ display: 'flex', justifyContent: 'flex-end', alignItems: 'center' }}>
                            <button
                                type="button"
                                onClick={() => this.validasi()}
                            >
                                <div style={{ width: 102, height: 30, backgroundColor: '#354960', borderRadius: 5, alignItems: 'center', display: 'flex', justifyContent: 'center' }}>
                                    <span style={{ color: '#fff', fontSize: 11 }}>Save</span>
                                </div>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        );
    }
}
