import { Typography, Paper, createMuiTheme, ThemeProvider, MuiThemeProvider, TableCell, FormControlLabel, TextField, Input, withStyles, makeStyles, Snackbar } from '@material-ui/core';
import MUIDataTable from 'mui-datatables';
import React, { Component } from 'react'
import ReactTooltip from 'react-tooltip';
import Images from '../../assets/Images';
import api from '../../api';
import { fixNumber, titleCase } from '../../library/Utils';
import Tooltip from '@material-ui/core/Tooltip';
import NumberFormat from 'react-number-format';
import Constant from '../../library/Constant';
import { Alert, Autocomplete } from '@material-ui/lab';
import UploadFile from '../../library/Upload';
import { ExcelRenderer } from 'react-excel-renderer';
import { PropagateLoader } from 'react-spinners';
import * as R from 'ramda'

const LightTooltip = withStyles((theme) => ({
    tooltip: {
        backgroundColor: theme.palette.common.white,
        color: 'rgba(0, 0, 0, 0.87)',
        boxShadow: theme.shadows[1],
        fontSize: 11,
    },
}))(Tooltip);

var ct = require("../../library/CustomTable");
const getMuiTheme = () => createMuiTheme(ct.customTable3());

const options = ct.customOptionsFixedColumn();

const style = {
    position: "sticky",
    left: 0,
    background: "white",
    zIndex: 101,
};
const style2 = {
    position: "sticky",
    background: "white",
    zIndex: 100,
    top: 0
};

const theme = createMuiTheme({
    overrides: {
        // Style sheet name ⚛️
        MuiInputBase: {
            input: {
                color: '#5198ea'
            }
        }
    },
});

export default class CorporateAnnualTargetMR extends Component {
    constructor(props) {
        super(props)
        this.state = {
            dataTables: [],
            loading: true,
            kpiTypeList: [],
            maxAchList: [],
            formulaYtdList: {
                options: [{ value: 'SUM' }, { value: 'AVG' }, { value: 'LAST' }],
                getOptionLabel: (option) => titleCase(option.value),
            },
            visibleCATMR: true,
            updateBy: [],
            notes: "",
            judulColumn: null,
            get_for: "view",
            parameterScore: [],
            parameterPerfom: [],
            totalScore: 0,
            perfomanceScore: '',
            buttonError: true,
            viewOnly: true,
            aa: 0,
            perfomanceScoreColor: '#fff',
            defaultCurrencyUpload: this.props.defaultCurrency,
            visibleAlertSave: false,
        }
        this.fileHandler = this.fileHandler.bind(this);
    }

    componentDidMount() {
        // this.getItemHierarki()
        this.getLatestUpdate()
        this.getKPIType()
        this.getMaxAch()
        this.getParameterGroup()
        this.getParameterGroupPerfom()
        this.handleViewOnly()
    }

    handleGetFor(type) {
        this.setState({ get_for: type }, () => {
            this.getLatestUpdate()
            this.getKPIType()
            this.getMaxAch()
        })
    }

    handleViewOnly() {
        let checkApprover = false
        let checkLastStatus = false
        let checkStatus = false
        let checkPrevRev = false
        if (this.props.isApprover) {
            checkApprover = true
        } else {
            checkApprover = false
        }

        if (this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') {
            checkLastStatus = true
        } else {
            checkLastStatus = false
        }

        if (this.props.prevRevision) {
            checkPrevRev = true
        } else {
            checkPrevRev = false
        }

        if (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') {
            checkStatus = true
        } else {
            checkStatus = false
        }

        this.setState({ viewOnly: !checkApprover && checkLastStatus && checkStatus && checkPrevRev })
        // this.setState({ viewOnly: true })
    }

    getParameterGroup() {
        this.setState({ loading: true }, () => {
            api.create().getParameterByGroupName({
                "group_name": 'ACHIEVEMENT_KPI'
            }).then((response) => {
                console.log(response.data)
                if (response.data) {
                    this.setState({ parameterScore: response.data.data, loading: false })
                }
            })
        })
    }

    getParameterGroupPerfom() {
        this.setState({ loading: true }, () => {
            api.create().getParameterByGroupName({
                "group_name": "PERFORMANCE_KPI"
            }).then((response) => {
                console.log(response.data)
                if (response.data) {
                    this.setState({ parameterPerfom: response.data.data, loading: false })
                }
            })
        })
    }

    getLatestUpdate() {
        let payload = {
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "monthly_report_id": this.props.monthlyReportId,
            "months": this.props.month.month_id
        }
        // console.log(payload)
        api.create().getLastestUpdateMR(payload).then(response => {
            // console.log(JSON.stringify(response))
            if (response.data) {
                if (response.data.status === "success") {
                    this.setState({
                        updateBy: response.data.data.detail === null ? [] : response.data.data.detail,
                        notes: response.data.data.notes_update === null ? "" : response.data.data.notes_update
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, typeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                // console.log('brrrrrrrr')
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    getItemHierarki() {
        let payload = {
            "report_id": this.props.report_id,
            "revision": Number(this.props.revision),
            "periode": this.props.periode,
            "company_id": this.props.company.company_id,
            "monthly_report_id": this.props.monthlyReportId,
            "months": this.props.month.month_id,
            "currency_id": this.props.defaultCurrency.id,
            "get_for": this.state.get_for
        }

        api.create().getHierarkiMontlyReportCAT(payload).then(response => {
            let dataTable = []
            console.log(payload);
            console.log(response);
            if (response.data) {
                if (response.data.status === 'success') {
                    let res = response.data.data
                    const handlePushChild = (item, index, length) => {
                        let indexIDzz = dataTable.findIndex((val) => val[1] === item.id)
                        if (indexIDzz === -1) {
                            let parentTrue = item.parent_name == 'INTERNAL BUSINESS PROCESS PERSPECTIVE' || item.parent_name == 'CUSTOMER PERSPECTIVE'
                            let weight = String(item.weight).includes('%') ? String(item.weight).substr(0, String(item.weight).length - 1) : String(item.weight)
                            let weightTB = String(item.corporate_annual_target.weight).includes('%') ? String(item.corporate_annual_target.weight).substr(0, String(item.corporate_annual_target.weight).length - 1) : String(item.corporate_annual_target.weight)
                            // console.log(weight)
                            dataTable.push([
                                item.type_report_id,
                                item.id,
                                item.parent,
                                item.formula,
                                item.level,
                                item.description,
                                // item.corporate_annual_target.weight == "" ? Number(0).toFixed(1) : Number(weight).toFixed(1),
                                parentTrue ? weight : weightTB,
                                parentTrue ? item.corporate_annual_target.uom : item.uom,
                                parentTrue ? item.corporate_annual_target.jenis_kpi == "" ? null : item.corporate_annual_target.jenis_kpi : item.jenis_kpi == "" ? null : item.kpi_type,
                                // parentTrue ? item.corporate_annual_target.kpi_type == "" ? null : { value: item.corporate_annual_target.kpi_type } : item.kpi_type == "" ? null : { value: item.kpi_type },
                                parentTrue ? item.corporate_annual_target.max_ach == "" ? null : titleCase(item.corporate_annual_target.max_ach) : item.max_ach == "" ? null : titleCase(item.max_ach),
                                // parentTrue ? item.corporate_annual_target.max_ach == "" ? null : { value: titleCase(item.corporate_annual_target.max_ach) } : item.max_ach == "" ? null : { value: titleCase(item.max_ach) },
                                item.corporate_annual_target.formula_ytd == "" ? null : item.corporate_annual_target.formula_ytd,
                                // parentTrue ? item.corporate_annual_target.formula == "" ? null : { value: item.corporate_annual_target.formula } : item.formula_ytd == "" ? null : { value: item.formula_ytd },
                                item.corporate_annual_target.actual_monthly == "" ? item.corporate_annual_target.actual_monthly : String(item.corporate_annual_target.actual_monthly).indexOf(".") == -1 ? Number(item.corporate_annual_target.actual_monthly) : Number(item.corporate_annual_target.actual_monthly),
                                item.corporate_annual_target.target_monthly === null ? "0" : item.corporate_annual_target.target_monthly,
                                item.corporate_annual_target.achivement_monthly === null ? "0" : item.corporate_annual_target.achivement_monthly,
                                item.corporate_annual_target.score === null ? "0" : item.corporate_annual_target.score,
                                item.corporate_annual_target.score_x_weight === null ? "0" : item.corporate_annual_target.score_x_weight,
                                item.corporate_annual_target.notes === null ? "" : item.corporate_annual_target.notes,
                                item.corporate_annual_target.actual_formula === null ? [] : item.corporate_annual_target.actual_formula,
                                item.order
                            ])
                            // let index = dataTable.findIndex((val) => val[5] == item.description)
                            // console.log(index, length - 1)
                            if (index == length - 1 && item.parent_name == "LEARNING & GROWTH PERSPECTIVE") {
                                dataTable.push([
                                    4,
                                    0,
                                    null,
                                    "",
                                    0,
                                    "",
                                    0.0,
                                    "",
                                    null,
                                    null,
                                    "",
                                    "",
                                    0.0,
                                    "",
                                    "",
                                    "",
                                    "",
                                    [],
                                    item.order + 1
                                ])
                            }
                        }
                        if (item.children !== null) {
                            if (item.children.length > 0) {
                                item.children.map((items, indexs) => {
                                    // console.log(indexs, item.children.length)
                                    handlePushChild(items, indexs, item.children.length)
                                })
                            }
                        }
                    }
                    res.map((item, index) => {
                        dataTable.push([
                            item.type_report_id,
                            item.id,
                            item.parent,
                            item.formula,
                            item.level,
                            item.description,
                            item.weight == '' ? Number(0) : Number(Number(item.weight) * 100),
                            item.uom,
                            item.kpi_type == "" ? null : item.kpi_type,
                            // item.kpi_type == "" ? null : { value: item.kpi_type },
                            item.max_ach == "" ? null : titleCase(item.max_ach),
                            // item.max_ach == "" ? null : { value: titleCase(item.max_ach) },
                            item.corporate_annual_target.formula == "" ? null : item.corporate_annual_target.formula_ytd,
                            // item.formula == "" ? null : { value: item.formula_ytd },
                            item.corporate_annual_target.actual_monthly == "" ? item.corporate_annual_target.actual_monthly : String(item.corporate_annual_target.actual_monthly).indexOf(".") == -1 ? Number(item.corporate_annual_target.actual_monthly) : Number(item.corporate_annual_target.actual_monthly),
                            item.corporate_annual_target.target_monthly === null ? "0" : item.corporate_annual_target.target_monthly,
                            item.corporate_annual_target.achivement_monthly === null ? "0" : item.corporate_annual_target.achivement_monthly,
                            item.corporate_annual_target.score === null ? "0" : item.corporate_annual_target.score,
                            item.corporate_annual_target.score_x_weight === null ? "0" : item.corporate_annual_target.score_x_weight,
                            item.corporate_annual_target.notes === null ? "" : item.corporate_annual_target.notes,
                            item.corporate_annual_target.actual_formula === null ? [] : item.corporate_annual_target.actual_formula,
                            item.order
                        ])
                        if (item.children !== null) {
                            if (item.children.length > 0) {
                                item.children.map((items, indexs) => {
                                    handlePushChild(items, indexs, item.children.length)
                                })
                            }
                        }
                    })
                    // console.log(dataTable);
                    this.setState({ dataTable, loading: false, saveDraft: true }, () => {
                        this.handleCalculate(dataTable)
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            } else {
                // console.log('terrrr')
                // 
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false, saveDraft: true })
            }
            console.log(dataTable);
        })
    }

    downloadTemplate = async () => {
        console.log(`${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/cat/monthly_report/download_template?report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&months=${this.props.month.month_id}&&currency_id=${this.props.defaultCurrency.id}`)
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/cat/monthly_report/download_template?report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&months=${this.props.month.month_id}&&currency_id=${this.props.defaultCurrency.id}`
        )
        console.log(res);
        res = await res.blob()
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Template Monthly Report Corporate Annual Target.xlsx'
            a.click();
        }
    }

    async downloadAllData() {
        let url = `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/cat/monthly_report/export_monthly_report?monthly_report_id=${this.props.monthlyReportId}&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}&&months=${this.props.month.month_id}`
        console.log(url);
        let res = await fetch(
            `${process.env.REACT_APP_URL_MAIN_BE}/public/transaction/cat/monthly_report/export_monthly_report?monthly_report_id=${this.props.monthlyReportId === null ? "" : this.props.monthlyReportId}&&report_id=${this.props.report_id}&&company_id=${this.props.company.company_id}&&year=${this.props.periode}&&revision=${this.props.revision}&&months=${this.props.month.month_id}`
        )
        res = await res.blob()
        this.setState({ loading: false })
        if (res.size > 0) {
            let url = window.URL.createObjectURL(res);
            let a = document.createElement('a');
            a.href = url;
            a.download = 'Monthly Report Corporate Annual Target - Performance.xlsx';
            a.click();
        }
    }

    fileHandler = (event) => {
        let fileObj = event
        ExcelRenderer(fileObj, (err, resp) => {
            if (err) {
                console.log(err);
            }
            else {
                let isi = resp.rows.slice(3)
                console.log(isi);
                let payload = []
                let reg = /^[-+]?(?:[0-9]+,)*[0-9]+(?:\.[0-9]+)?$/;
                isi.map((i, index) => {
                    if (i.length > 0) {
                        payload.push({
                            item_report_id: i[1] === undefined ? "" : String(i[1]).trim(),
                            item_report: i[2] === undefined ? "" : String(i[2]).trim(),
                            weight: i[3] === undefined ? "" : (String(i[3])) === false ? "0" : String(i[3]).trim(),
                            uom: i[4] === undefined ? "" : (String(i[4])) === false ? "0" : String(i[4]).trim(),
                            jenis_kpi: i[5] === undefined ? "" : (String(i[5])) === false ? "0" : String(i[5]).trim(),
                            max_ach: i[6] === undefined ? "" : (String(i[6])) === false ? "0" : String(i[6]).trim(),
                            actual_monthly: i[7] === undefined ? "0.0" : (String(i[7])) === false ? "0" : String(i[7]).trim(),
                            notes: i[8] === undefined ? "" : (String(i[8])) === false ? "0" : String(i[8]).trim(),
                        })
                    }
                })
                let body = {
                    company_id: this.props.company.company_id,
                    periode: this.props.periode,
                    report_id: this.props.report_id,
                    months: this.props.month.month_id,
                    corporate_annual_target: payload,
                    status: "submitted"
                }
                console.log(body)
                this.setState({ payload: body, judul: resp.rows[1][0], judulColumn: resp.rows[0][0] })
            }
        });
    }

    checkUpload() {
        this.setState({ loading: true })
        let payload = {
            ...this.state.payload,
            currency_id: this.state.defaultCurrencyUpload?.id
        }
        api.create().checkUploadMonthlyReportCAT(payload).then(response => {
            // console.log(JSON.stringify(this.state.payload));
            console.log(this.state.payload)
            console.log(response)
            if (response.data) {
                if (response.data.status === 'success') {
                    this.setState({ visibleUpload: false, loading: true, visibleCATMR: false })
                    let dataTable = response.data.data.map((item, index) => {
                        return [
                            item.type_report_id,
                            item.item_report_id,
                            item.parent,
                            item.formula,
                            item.level,
                            item.item_report,
                            item.parent == null ? (String(item.weight).includes("%") ? Number(String(item.weight).trim().substr(0, String(item.weight).trim().length - 1)) : Number(item.weight) * 100) : (String(item.weight).includes("%") ? String(item.weight).trim().substr(0, String(item.weight).trim().length - 1) : item.weight),
                            item.uom,
                            item.jenis_kpi,
                            item.max_ach,
                            item.formula_ytd,
                            item.actual_monthly,
                            item.target_monthly,
                            item.achivement_monthly,
                            item.score,
                            item.score_x_weight,
                            item.notes,
                            item.actual_formula === null ? [] : item.actual_formula,
                            item.order,
                            item.error
                        ]
                    })
                    console.log(dataTable)
                    this.setState({ dataTable, dataLoaded: true, loading: false, buttonError: false, editable: true }, () => {
                        this.handleCalculate(dataTable)
                        this.state.dataTable.map(item => {
                            if (item[16].length > 0) {
                                console.log('masuk')
                                this.setState({ buttonError: true, errorPreview: true, editable: true })
                            }
                        })
                        console.log(this.state.dataTable);
                    })
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                        if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                            setTimeout(() => {
                                localStorage.removeItem(Constant.TOKEN)
                                window.location.reload();
                            }, 1000);
                        }
                    })
                }
            }
        })
    }

    uploadCATMR(type) {
        let data = []
        if (this.props.defaultCurrency.id == 2) {
            this.state.dataTable.map(i => {
                data.push({
                    item_report_id: i[1],
                    item_report: String(i[5]),
                    weight: String(i[6]),
                    uom: String(i[7]),
                    jenis_kpi: i[8] == null ? "" : i[8],
                    max_ach: i[9] == null ? "" : i[9],
                    formula_ytd: i[10] == null ? "" : i[10],
                    actual_monthly: String(Number(i[11])),
                    target_monthly: String(Number(i[12])),
                    achivement_monthly: String(Number(i[13])),
                    score: String(Number(i[14])),
                    score_x_weight: String(Number(i[15])),
                    notes: String(i[16])
                })
            })
        } else {
            this.state.dataTable.map(i => {
                data.push({
                    item_report_id: i[1],
                    item_report: String(i[5]),
                    weight: String(i[6]),
                    uom: String(i[7]),
                    jenis_kpi: i[8] == null ? "" : i[8],
                    max_ach: i[9] == null ? "" : i[9],
                    formula_ytd: i[10] == null ? "" : i[10],
                    actual_monthly: String(fixNumber(Number(i[11]), 1)),
                    target_monthly: String(fixNumber(Number(i[12]), 1)),
                    achivement_monthly: String(fixNumber(Number(i[13]), 1)),
                    score: String(fixNumber(Number(i[14]), 0)),
                    score_x_weight: String(fixNumber(Number(i[15]), 2)),
                    notes: String(i[16])
                })
            })
        }

        let body = {
            // "monthly_report_id": this.props.monthlyReportId,
            "monthly_report_id": this.props.monthlyReportId,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "status": type,
            "months": this.props.month.month_id,
            "currency_id": this.props.defaultCurrency.id,
            "corporate_annual_target": data,
            "total_score": this.state.totalScore,
            "performance": this.state.perfomanceScore
        }
        console.log(JSON.stringify(body));
        api.create('UPLOAD').uploadMonthlyReportCAT(body).then(response => {
            console.log(body);
            console.log(response);
            if (response.data) {
                if (response.data.status === "success") {
                    this.props.saveToMonthlyReport()
                    // this.props.onClickClose()
                    // this.props.getReport()
                } else {
                    if (response.data?.message == "Please Set Up Rate Currency First") {
                        this.setState({ visibleAlertSave: true })
                    } else {
                        this.setState({ visibleAlertSave: true, alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error', loading: false })
            }
        })
    }

    getKPIType() {
        let body = {
            group: 'CAT',
            company_id: this.props.company.company_id,
            type: 'KPI_TYPE',
            currency_id: this.props.defaultCurrency.id,
        }
        api.create().getAllSettingByType(body).then(response => {
            console.log(response)
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        let data = response.data.data
                        // // // console.log(data)
                        let inputKPI = []

                        data.map((item) => {
                            inputKPI.push({
                                value: item.value
                            })
                        })
                        let defaultProps = {
                            options: inputKPI,
                            getOptionLabel: (option) => titleCase(option.value),
                        };
                        // // // console.log(defaultProps)
                        this.setState({ kpiTypeList: defaultProps })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }
        })
    }

    getMaxAch() {
        let body = {
            group: 'CAT',
            company_id: this.props.company.company_id,
            type: 'MAX_ACHIEVEMENT',
            currency_id: this.props.defaultCurrency.id,
        }
        api.create().getAllSettingByType(body).then(response => {
            console.log(response);
            if (response.data) {
                if (response.ok) {
                    if (response.data.status === 'success') {
                        let data = response.data.data
                        let inputMaxAch = data.map((item) => {
                            return {
                                value: item.value
                            }
                        })
                        let defaultProps = {
                            options: inputMaxAch,
                            getOptionLabel: (option) => titleCase(option.value),
                        };
                        // setTimeout(() => {
                        this.setState({ maxAchList: defaultProps }, () => {
                            this.getItemHierarki()
                        })
                        // }, 300);
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning' }, () => {
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                        })
                        // alert(response.data.message)
                    }
                } else {
                    this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'error' })
                }
            } else {
                this.setState({ alert: true, messageAlert: response.problem, tipeAlert: 'error' })
            }

        })
    }

    backToMonthlyReport(type) {
        this.setState({ loading: true })
        console.log(this.state.dataTable);
        let data = []
        if (this.props.defaultCurrency.id == 2) {
            this.state.dataTable.map(i => {
                data.push({
                    "item_report_id": i[1],
                    "weight": i[6],
                    "uom": i[7],
                    "jenis_kpi": i[8] == null ? "" : i[8],
                    "max_ach": i[9] == null ? "" : i[9],
                    "formula_ytd": i[10] == null ? "" : i[10],
                    "actual_monthly": i[11] == null || i[11] == "" ? 0.0 : String(Number(i[11])),
                    "target_monthly": i[12] == null || i[12] == "" ? 0.0 : String(Number(i[12])),
                    "achivement_monthly": String(Number(i[13])),
                    "score": String(Number(i[14])),
                    "score_x_weight": String(Number(i[15])),
                    "notes": i[16]
                })
            })
        } else {
            this.state.dataTable.map(i => {
                data.push({
                    "item_report_id": i[1],
                    "weight": i[6],
                    "uom": i[7],
                    "jenis_kpi": i[8] == null ? "" : i[8],
                    "max_ach": i[9] == null ? "" : i[9],
                    "formula_ytd": i[10] == null ? "" : i[10],
                    "actual_monthly": i[11] == null || i[11] == "" ? 0.0 : String(fixNumber(Number(i[11]), 1)),
                    "target_monthly": i[12] == null || i[12] == "" ? 0.0 : String(fixNumber(Number(i[12]), 1)),
                    "achivement_monthly": String(fixNumber(Number(i[13]), 1)),
                    "score": String(fixNumber(Number(i[14]), 0)),
                    "score_x_weight": String(fixNumber(Number(i[15]), 2)),
                    "notes": i[16]
                })
            })
        }

        let payload = {
            "monthly_report_id": this.props.monthlyReportId,
            "company_id": this.props.company.company_id,
            "periode": this.props.periode,
            "report_id": this.props.report_id,
            "status": type,
            "months": this.props.month.month_id,
            "currency_id": this.props.defaultCurrency.id,
            "corporate_annual_target": data,
            "total_score": this.state.totalScore,
            "performance": this.state.perfomanceScore
        }
        // console.log(JSON.stringify(payload));
        console.log(payload);

        api.create('UPLOAD').createMonthlyReportCAT(payload).then(response => {
            console.log(response);
            if (response.data) {
                if (response.data.status === "success") {
                    this.props.saveToMonthlyReport()
                } else {
                    if (response.data?.message == "Please Set Up Rate Currency First") {
                        this.setState({ visibleAlertSave: true })
                    } else {
                        this.setState({ alert: true, messageAlert: response.data.message, tipeAlert: 'warning', loading: false }, () => {
                            document.body.style.overflow = 'unset';
                            if (response.data.message.includes("Someone Logged In") || response.data.message.includes("Token Expired")) {
                                setTimeout(() => {
                                    localStorage.removeItem(Constant.TOKEN)
                                    window.location.reload();
                                }, 1000);
                            }
                            this.props.saveToMonthlyReport()
                        })
                    }
                }
                // else {
                //     this.setState({ loading: false }, () => {
                //         this.props.saveToMonthlyReport()
                //     })
                // }
            } else {
                this.setState({ loading: false }, () => {
                    // this.getSubmission()
                    document.body.style.overflow = 'unset';
                })
            }
        })
    }

    closeAlert() {
        this.setState({ alert: false })
    }

    handleCalculate(datatable2) {
        // console.log(datatable2)
        this.setState({ loading: true }, () => {
            let total = 0
            let perfomanceScore = ''
            let totalWeight = 0
            // console.log(datatable2)
            let datatable3 = datatable2.map((item, index) => {
                // console.log(item[6])
                //total weight
                if (item[0] !== 1 && item[0] !== 4) {
                    if (item[12] == '' || String(item[12]) == '0' || String(item[12]) == '0.0') {
                        totalWeight += Number(0)
                    } else {
                        totalWeight += Number(item[6])
                    }
                }

                //ach
                let totalAch = 0
                if (item[8] == 'HIB') {
                    let actual = item[11] == "" ? 0 : Number(item[11])
                    let target = item[12] == "" ? 0 : Number(item[12])
                    // if (item[5] == "Striping Ratio (SR) YTD") {
                    //     console.log(actual)
                    //     console.log(target)
                    //     console.log(actual/target)
                    // }
                    if (target < 0) {
                        if (actual > target) {
                            totalAch = (actual / target) - 1
                        } else {
                            totalAch = (actual / target)
                        }
                    } else if (target == 0) {
                        if (target >= actual) {
                            totalAch = 1.26
                        } else {
                            totalAch = 0
                        }
                    } else {
                        if (actual == target) {
                            totalAch = (actual / target)
                        } else {
                            totalAch = 2 - (actual / target)
                        }
                    }
                    // if (item[5] == "Striping Ratio (SR) YTD") {
                    //     console.log(actual)
                    //     console.log(target)
                    //     console.log(actual/target)
                    // }
                } else {
                    let actual = item[11] == "" ? 0 : Number(item[11])
                    let target = item[12] == "" ? 0 : Number(item[12])
                    if (target < 0) {
                        if (actual >= target) {
                            totalAch = ((target - actual) / target) + 1
                        } else {
                            totalAch = (target - actual) / target
                        }
                    } else if (target == 0) {
                        if (target <= actual) {
                            totalAch = 1.26
                        } else {
                            totalAch = 0
                        }
                    } else {
                        // if (actual <= target) {
                        totalAch = (actual / target)
                        // } else {
                        //     totalAch = 1 - (actual / target)
                        // }
                    }
                }
                totalAch = String(totalAch) == 'NaN' || String(totalAch) == 'Infinity' || String(totalAch) == '-Infinity' ? 0 : totalAch
                totalAch = this.props.lastStatus == 'APPROVED' ? item[13] : Number(totalAch) * 100

                //score
                let listParameter = this.state.parameterScore
                let parameterKpi = item[8]
                let parameterAch = String(item[9]).includes('%') ? `MAX${String(item[9]).substr(0, String(item[9]).length - 1)}` : String(item[9])
                let parameterMix = `${parameterKpi}_${parameterAch}`
                let listParameterFilter = listParameter.filter((val) => val.setting_type == String(parameterMix).toLocaleUpperCase())
                let listParameterFilterCompany = listParameterFilter.filter((val) => val.company_id == this.props.company.company_id)
                let totalScore = 0
                let achx100 = item[9] == '100%' && (item[8] == 'HIB' || item[8] == 'HIG') ? (Number(totalAch) / 100 > 1 ? 1 : Number(totalAch) / 100) : Number(totalAch) / 100
                // if (item[5] == "Max Quality drop from Bor-Barge") {
                // console.log(listParameterFilter)
                //     console.log(listParameterFilterCompany)
                //     // console.log(Number(item.min_value))
                // console.log(Number(item.max_value))
                // }
                if (listParameterFilterCompany.length == 0) {
                    listParameterFilter.map((items, index) => {
                        if (Number(achx100) >= Number(items.min_value) && Number(achx100) <= Number(items.max_value)) {
                            totalScore = Number(items.value)
                        }
                    })
                } else {
                    listParameterFilterCompany.map((items, index) => {
                        if (Number(achx100) >= Number(items.min_value) && Number(achx100) <= Number(items.max_value)) {
                            totalScore = Number(items.value)
                        }
                    })
                }
                let totalScorez = this.props.lastStatus == 'APPROVED' ? item[14] : this.props.defaultCurrency.id == 1 ? fixNumber(Number(totalScore), 0) : Number(totalScore)
                // if (item[5] == "Max Quality drop from Bor-Barge") {
                //     console.log(totalScorez)
                // }
                //Score X Weight
                let totalSW = 0
                let handlePercent = ''
                if (String(item[6]).includes('%')) {
                    handlePercent = String(item[6]).substr(0, String(item[6]).length - 1)
                } else {
                    handlePercent = String(item[6])
                }
                if (item[12] == '' || String(item[12]) == '0' || String(item[12]) == '0.0') {
                    totalSW = 0
                } else {
                    totalSW = (Number(totalScorez) * Number(handlePercent) / 100)
                }
                totalSW = this.props.lastStatus == 'APPROVED' ? item[15] : this.props.defaultCurrency.id == 1 ? fixNumber(Number(totalSW), 2) : Number(totalSW)
                if (item[0] !== 1 && item[0] !== 4) {
                    total += Number(totalSW)
                }
                // console.log(item[5])
                // console.log(totalAch);
                // console.log(achx100);
                // console.log(listParameterFilter);
                // console.log(listParameterFilterCompany);
                // console.log(totalScorez)
                // console.log(totalSW)
                // console.log(item[12])
                // console.log(item[5])
                // console.log(total)
                return [
                    item[0],
                    item[1],
                    item[2],
                    item[3],
                    item[4],
                    item[5],
                    item[6],
                    item[7],
                    item[8],
                    item[9],
                    item[10],
                    item[11],
                    item[12],
                    totalAch,
                    totalScorez,
                    totalSW,
                    item[16],
                    item[17],
                    item[18],
                    //     item[19],
                    // ]
                ]
            })
            // console.log(totalWeight)
            // console.log(total)
            // console.log(datatable3);
            let totalWeightz = Number(totalWeight) / 100
            let totalz = this.props.defaultCurrency.id == 1 ? (Number(fixNumber(fixNumber(Number(total), 2) / Number(totalWeightz)), 2)) : Number(Number(total) / Number(totalWeightz))
            console.log(totalz)
            let lastTotal = R.equals(totalz, NaN) ? 0.0 : totalz

            if (R.equals(totalz, NaN) || R.equals(totalz, "NaN")) {
                lastTotal = 0.0
            } else {
                lastTotal = totalz
            }

            console.log(fixNumber(Number(Number(total), 2) / fixNumber(Number(totalWeightz)), 2))
            let indexPerform = this.state.parameterPerfom.findIndex((val) => val.company_id == this.props.company.company_id)
            let listPerfomanceDefault = []
            if (indexPerform == -1) {
                listPerfomanceDefault = this.state.parameterPerfom.filter((val) => String(val.company_name).toLocaleLowerCase() == "default")
            } else {
                listPerfomanceDefault = this.state.parameterPerfom.filter((val) => val.company_id == this.props.company.company_id)
            }
            let performanceScore = ''
            let perfomanceScoreColor = '#fff'
            if (listPerfomanceDefault.length > 0) {
                listPerfomanceDefault.map((item, index) => {
                    // console.log(Number(lastTotal))
                    // console.log(Number(item.min_value))
                    // console.log(Number(item.max_value))
                    if (Number(lastTotal) >= Number(item.min_value) && Number(lastTotal) <= Number(item.max_value)) {
                        console.log('masuk')
                        perfomanceScore = item.description
                        perfomanceScoreColor = item.value
                    }
                })
            }
            // console.log(Number(lastTotal))
            console.log(this.state.parameterPerfom)
            console.log(listPerfomanceDefault)
            console.log(perfomanceScore)
            console.log(perfomanceScoreColor)
            console.log(datatable3)
            // if (lastTotal >= 1.00 && lastTotal <= 2.00) {
            //     perfomanceScore = 'K'
            // } else if (lastTotal >= 2.01 && lastTotal <= 2.75) {
            //     perfomanceScore = 'C'
            // } else if (lastTotal >= 2.76 && lastTotal <= 3.00) {
            //     perfomanceScore = 'B-'
            // } else if (lastTotal >= 3.01 && lastTotal <= 3.75) {
            //     perfomanceScore = 'B'
            // } else if (lastTotal >= 3.76 && lastTotal <= 4.00) {
            //     perfomanceScore = 'B+'
            // } else if (lastTotal >= 4.01 && lastTotal <= 4.75) {
            //     perfomanceScore = 'BS'
            // } else if (lastTotal >= 4.76 && lastTotal <= 5.00) {
            //     perfomanceScore = 'IST'
            // }
            setTimeout(() => {
                this.setState({ totalScore: lastTotal, perfomanceScore, loading: false, perfomanceScoreColor }, () => {
                    this.setState({ loading: true })
                    setTimeout(() => {
                        this.setState({ loading: false })
                    }, 500);
                })
            }, 500);
        })

    }

    handleBackgroundPerf(total) {
        // console.log(total)
        let color = 'white'
        if (total >= 1.00 && total <= 2.00) {
            color = 'red'
        } else if (total >= 2.01 && total <= 2.75) {
            color = 'yellow'
        } else if (total >= 2.76 && total <= 3.00) {
            color = 'lightgreen'
        } else if (total >= 3.01 && total <= 3.75) {
            color = 'yellowgreen'
        } else if (total >= 3.76 && total <= 4.00) {
            color = 'forestgreen'
        } else if (total >= 4.01 && total <= 4.75) {
            color = 'deepskyblue'
        } else if (total >= 4.76 && total <= 5.00) {
            color = 'dodgerblue'
        }
        return color
    }

    render() {
        let dataTable2 = this.state.dataTable
        let dataDelete = this.state.dataDelete
        const handleChange = (value, tableMeta, type) => {
            let val = String(value).split(",").join("")
            if (type == 'text') {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = value
            } else {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(val)
            }
        }

        const handleValueFormula = (value, tableMeta, column, periode, forecast) => {
            // loading = true
            let splitFormula = String(tableMeta.rowData[3]).split(/([()@])/)
            let baru = []
            let anjay = []

            splitFormula.map((item, index) => {
                let items = String(item).substr(Number(String(item).length) - 1, 1)
                let subForm = String(item).substr(0, Number(String(item).length) - 1)
                let re = /^[a-zA-Z0-9_]+$/;
                if (item !== "") {
                    if (!re.test(items)) {
                        baru.push(subForm)
                        baru.push(items)
                    } else {
                        baru.push(String(item))
                    }
                }
            })
            // console.log(splitFormula)
            // console.log(baru)
            baru.map((item, index) => {
                if (item == '-' || item == '+' || item == '/' || item == '*' || item == '(' || item == ')') {
                    anjay.push(item)
                } else if (item == '' || item == '@') {

                    // } else if (item == "CurrMonth") {
                    //     anjay.push(String(column))
                    // } else if (item.includes('[CM]SUM')) {
                    //     let columnStart = 13
                    //     let indexX = String(item).indexOf('[')
                    //     let formulaAwal = String(item).substr(0, indexX)
                    //     let columnEnd = 24
                    //     let month = column - 1
                    //     let total = 0
                    //     // // // console.log(formulaAwal)
                    //     if (forecast == undefined) {
                    //         dataTable2[tableMeta.rowIndex].map((itemz, indexz) => {
                    //             if (indexz >= columnStart && indexz <= columnStart + month) {
                    //                 let indexID = value.formula.findIndex((val) => val.item_formula == String(`@${formulaAwal}`) && val.periode == Number(this.props.periode))
                    //                 if (indexID !== -1) {
                    //                     let valuezz = Number(value.formula[indexID].value)
                    //                     total += valuezz
                    //                 }
                    //             }
                    //         })
                    //     } else {

                    //     }

                    //     anjay.push(String(total))
                    // } else if (item.includes('[CM]AVG')) {
                    //     if (forecast == undefined) {
                    //         anjay.push('/')
                    //         anjay.push(column)
                    //     }
                }
                else if (item.includes('X')) {
                    let indexX = String(item).indexOf('X')
                    if (indexX == 0) {
                        anjay.push(String(item).substr(1, String(item).length))
                    } else {
                        let formulaAwal = String(item).substr(0, indexX - 1)
                        let operatorX = String(item).substr(indexX - 1, 1)
                        let nilaiX = String(item).substr(indexX + 1, String(item).length)

                        if (forecast == undefined) {
                            // console.log(formulaAwal)
                            // console.log(tableMeta.rowData[17])
                            let convertID = -1
                            if (tableMeta.rowData[10] == 'FORMULA') {
                                let indexIDReport = dataTable2.findIndex((val) => val[1] == formulaAwal)
                                convertID = dataTable2[indexIDReport][18]
                                let indexID = dataTable2.findIndex((val) => val[18] == (convertID == -1 ? item : convertID))
                                let valuezz = dataTable2[indexID][column].value == undefined ? dataTable2[indexID][column] : dataTable2[indexID][column].value
                                anjay.push(valuezz == "" ? 0 : valuezz)
                            } else {
                                let indexID = tableMeta.rowData[17].findIndex((val) => val.item_formula == String(`@${formulaAwal}`) && val.periode == Number(this.props.periode))
                                if (indexID !== -1) {
                                    let valuezz = tableMeta.rowData[17][indexID].value
                                    anjay.push(valuezz == "" ? 0 : valuezz)
                                }
                            }
                        } else {
                            // // // console.log(dataTable2[tableMeta.rowIndex][30])
                            let array = dataTable2[tableMeta.rowIndex][18].filter((val) => val.periode == Number(column))
                            let valuezz = array[0].value
                            // // // console.log(valuezz)
                            anjay.push(valuezz == "" ? 0 : valuezz)
                            // let indexID = dataTable2[tableMeta.rowIndex][30].findIndex((val) => val.periode == Number(this.props.periode))
                            // if (indexID !== -1) {
                            //     let valuezz = value.formula[indexID].value
                            //     anjay.push(valuezz == "" ? 0 : valuezz)
                            // }
                        }

                        anjay.push(operatorX)
                        anjay.push(nilaiX)
                    }
                } else {
                    if (String(item).includes('#')) {
                        if (forecast == undefined) {
                            let indexID = tableMeta.rowData[17].findIndex((val) => val.item_formula == String(`@${item}`) && val.periode == Number(this.props.periode))
                            if (indexID !== -1) {
                                let valuezz = tableMeta.rowData[17][indexID].value
                                anjay.push(valuezz == "" || valuezz == null ? "0" : valuezz)
                            }
                        }

                    } else {
                        let convertID = -1
                        if (tableMeta.rowData[10] == 'FORMULA') {
                            let indexIDReport = dataTable2.findIndex((val) => val[1] == item)
                            convertID = dataTable2[indexIDReport][18]
                        }
                        let indexID = dataTable2.findIndex((val) => val[18] == (convertID == -1 ? item : convertID))
                        if (indexID !== -1) {
                            let valuezz = dataTable2[indexID][column].value == undefined ? dataTable2[indexID][column] : dataTable2[indexID][column].value
                            if (item == dataTable2[tableMeta.rowIndex][18]) {
                                anjay.push(0)
                            } else {
                                anjay.push(valuezz == "" ? "0" : valuezz)
                            }
                        } else {
                            if (item === '(-1)') {
                                anjay.push(-1)
                            }
                        }
                    }
                }
            })

            // if (tableMeta.rowData[10] == 'FORMULA') {
            //     // let indexIDReport = dataTable2.findIndex((val) => val[1] == item)
            //     // convertID = dataTable2[indexIDReport][18]
            //     console.log(baru)
            //     console.log(anjay)
            // }

            let anjay2 = []
            let kurung = false
            let item1 = []
            let brpKurung = 0
            anjay.map((item, index) => {
                if (item == "(") {
                    kurung = true
                    // brpKurung += 1
                } else if (item == ")") {
                    // brpKurung -= 1
                    // if (brpKurung == 0) {
                    kurung = false
                    anjay2.push(item1)
                    item1 = []
                    // }
                } else {
                    if (kurung) {
                        item1.push(item)
                    } else {
                        anjay2.push(item)
                    }
                }
            })

            let total = 0
            let opt = ""
            let totalPrio = 0
            let optPrio = ""
            let prio = false
            anjay2.map((item, index) => {
                if (Array.isArray(item)) {
                    prio = true
                    item.map((items, indexs) => {
                        if (items == "+") {
                            optPrio = "tambah"
                        } else if (items == "-") {
                            optPrio = "kurang"
                        } else if (items == "*") {
                            optPrio = "kali"
                        } else if (items == "/") {
                            optPrio = "bagi"
                        } else {
                            if (optPrio == "tambah") {
                                totalPrio = Number(totalPrio) + Number(items)
                            } else if (optPrio == "kurang") {
                                totalPrio = Number(totalPrio) - Number(items)
                            } else if (optPrio == "kali") {
                                totalPrio = Number(totalPrio) * Number(items)
                            } else if (optPrio == "bagi") {
                                totalPrio = Number(totalPrio) / Number(items) == NaN ? 0 : Number(totalPrio) / Number(items)
                            } else {
                                totalPrio += Number(items)
                            }
                        }
                    })

                    if (index == anjay2.length - 1) {
                        if (opt == "tambah") {
                            total = Number(total) + Number(totalPrio)
                        } else if (opt == "kurang") {
                            total = Number(total) - Number(totalPrio)
                        } else if (opt == "kali") {
                            total = Number(total) * Number(totalPrio)
                        } else if (opt == "bagi") {
                            total = Number(total) / Number(totalPrio) == NaN ? 0 : Number(total) / Number(totalPrio)
                        } else {
                            total += Number(totalPrio)
                        }
                    }
                } else {
                    if (item == "+") {
                        opt = "tambah"
                        if (prio) {
                            total = Number(Number(totalPrio) + Number(total))
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else if (item == "-") {
                        opt = "kurang"
                        if (prio) {
                            total = Number(Number(totalPrio) + Number(total))
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else if (item == "*") {
                        opt = "kali"
                        if (prio) {
                            total = Number(Number(totalPrio) + Number(total))
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else if (item == "/") {
                        opt = "bagi"
                        if (prio) {
                            total = Number(Number(totalPrio) + Number(total))
                            prio = false
                            totalPrio = 0
                            optPrio = ""
                        }
                    } else {
                        if (opt == "tambah") {
                            total = Number(total) + Number(item)
                        } else if (opt == "kurang") {
                            total = Number(total) - Number(item)
                        } else if (opt == "kali") {
                            total = Number(total) * Number(item)
                        } else if (opt == "bagi") {
                            total = Number(total) / Number(item) == NaN ? 0 : Number(total) / Number(item)
                        } else {
                            total += Number(item)
                        }
                    }
                }
            })

            total = R.equals(total, NaN) ? "0.0" : total
            // if (dataTable2[tableMeta.rowIndex][5] == "ROIC") {
            //     dataTable2[tableMeta.rowIndex][column] = 0
            // } else {
            dataTable2[tableMeta.rowIndex][column] = this.props.defaultCurrency.i == 1 ? fixNumber(Number(total), 1) : Number(total)
            // }

            return this.props.defaultCurrency.i == 1 ? fixNumber(Number(total), 1) : Number(total)
        }

        const handleChangeText = (value, tableMeta) => {
            // // console.log(value)
            dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = value
            // this.setState({dataTable: dataTable2})
        }

        const handleAction = (idParent, typeReport, tableMeta) => {
            if (this.props.isApprover) {
                return false
            } else {
                // if ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted')) {
                if (idParent !== null) {
                    // console.log(tableMeta)
                    let indexsss = dataTable2.findIndex((val) => val[1] == idParent)
                    if (dataTable2[indexsss][5] == 'CUSTOMER PERSPECTIVE' || dataTable2[indexsss][5] == 'INTERNAL BUSINESS PROCESS PERSPECTIVE') {
                        return true
                    } else {
                        if (typeReport == 3) {
                            return true
                        } else {
                            return false
                        }
                    }
                } else {
                    if (typeReport == null || typeReport == 3) {
                        return true
                    } else if (tableMeta !== undefined && tableMeta.rowData[0] == 1) {
                        let indexID = dataTable2.findIndex((val) => val[2] == tableMeta.rowData[1])
                        if (indexID !== -1) {
                            return false
                        } else {
                            return true
                        }
                    } else {
                        return false
                    }
                }
                // } else {
                //     return false
                // }
            }

        }

        const handleTambah = (data, rowIndex) => {
            // console.log(dataTable2)
            let newData = []
            dataTable2.map((item, index) => {
                newData.push(item)
                if (index == rowIndex) {
                    newData.push([
                        null,
                        "",
                        item[2] == null || item[2] == "" ? item[1] : item[2],
                        item[3],
                        item[4],
                        "",
                        "",
                        "",
                        "",
                        null,
                        null,
                        null,
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        "",
                        ""
                    ])

                }
            })
            dataTable2 = newData
            this.setState({ dataTable: dataTable2 }, () => {
                setTimeout(() => {
                    this.setState({ loading: false })
                    // console.log(dataTable2)
                }, 500)
            })
        }

        const handleDelete = (index) => {
            if (dataTable2[index][1] !== "") {
                dataDelete.push(dataTable2[index][1])
            }
            dataTable2.splice(index, 1)
            this.setState({ dataTable: dataTable2, dataDelete }, () => {
                setTimeout(() => {
                    this.setState({ loading: false })
                }, 100)
            })
        }

        const handleAchiement = (tableMeta) => {
            let total = 0
            // if (tableMeta.rowData[8] == 'HIB') {
            //     let actual = tableMeta.rowData[11] == "" ? 0 : Number(tableMeta.rowData[11])
            //     let target = tableMeta.rowData[12] == "" ? 0 : Number(tableMeta.rowData[12])
            //     total = 2 - (actual / target)
            // } else {
            //     let actual = tableMeta.rowData[11] == "" ? 0 : Number(tableMeta.rowData[11])
            //     let target = tableMeta.rowData[12] == "" ? 0 : Number(tableMeta.rowData[12])
            //     total = actual / target
            // }
            if (tableMeta.rowData[8] == 'HIB') {
                let actual = tableMeta.rowData[11] == "" ? 0 : Number(tableMeta.rowData[11])
                let target = tableMeta.rowData[12] == "" ? 0 : Number(tableMeta.rowData[12])
                if (target < 0) {
                    if (actual > target) {
                        total = (actual / target) - 1
                    } else {
                        total = (actual / target)
                    }
                } else if (target == 0) {
                    if (target >= actual) {
                        total = 1.26
                    } else {
                        total = 0
                    }
                } else {
                    if (actual == target) {
                        total = (actual / target)
                    } else {
                        total = 2 - (actual / target)
                    }
                }
            } else {
                let actual = tableMeta.rowData[11] == "" ? 0 : Number(tableMeta.rowData[11])
                let target = tableMeta.rowData[12] == "" ? 0 : Number(tableMeta.rowData[12])
                if (target < 0) {
                    if (actual >= target) {
                        total = ((target - actual) / target) + 1
                    } else {
                        total = (target - actual) / target
                    }
                } else if (target == 0) {
                    if (target <= actual) {
                        total = 1.26
                    } else {
                        total = 0
                    }
                } else {
                    // if (actual <= target) {
                    total = (actual / target)
                    // } else {
                    //     total = 1 - (actual / target)
                    // }
                }
            }
            total = String(total) == 'NaN' || String(total) == 'Infinity' || String(total) == '-Infinity' ? 0 : total
            dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = Number(total) * 100
            return Number(total) * 100
        }

        const handleScore = (tableMeta) => {
            let listParameter = this.state.parameterScore
            let parameterKpi = tableMeta.rowData[8]
            let parameterAch = String(tableMeta.rowData[9]).includes('%') ? `MAX${String(tableMeta.rowData[9]).substr(0, String(tableMeta.rowData[9]).length - 1)}` : String(tableMeta.rowData[9])
            let parameterMix = `${parameterKpi}_${parameterAch}`
            let listParameterFilter = listParameter.filter((val) => val.setting_type == String(parameterMix).toLocaleUpperCase() && String(val.company_name).toLocaleLowerCase() === "default")
            let listParameterFilterCompany = listParameterFilter.filter((val) => val.company_id == this.props.company.company_id)
            let totalScore = 0
            let achx100 = tableMeta.rowData[9] == '100%' && (tableMeta.rowData[8] == 'HIB' || tableMeta.rowData[8] == 'HIG') ? (Number(tableMeta.rowData[13]) / 100 > 1 ? 1 : Number(tableMeta.rowData[13]) / 100) : Number(tableMeta.rowData[13]) / 100
            if (listParameterFilterCompany.length == 0) {
                listParameterFilter.map((item, index) => {
                    if (Number(achx100) >= Number(item.min_value) && Number(achx100) <= Number(item.max_value)) {
                        totalScore = Number(item.value)
                    }
                })
            } else {
                listParameterFilterCompany.map((item, index) => {
                    if (Number(achx100) >= Number(item.min_value) && Number(achx100) <= Number(item.max_value)) {
                        totalScore = Number(item.value)
                    }
                })
            }
            if (Number(tableMeta.rowData[12]) == Number(0)) {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = this.props.defaultCurrency.id == 1 ? fixNumber(Number(0), 0) : Number(0)
                return this.props.defaultCurrency.id == 1 ? fixNumber(Number(0), 0) : Number(0)
            } else {
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = this.props.defaultCurrency.id == 1 ? fixNumber(Number(totalScore), 0) : Number(totalScore)
                return this.props.defaultCurrency.id == 1 ? fixNumber(Number(totalScore), 0) : Number(totalScore)
            }
        }

        let someXXX = this.state.aa
        const handleTotal = (tableMeta) => {
            let total = 0
            let handlePercent = ''
            // if (tableMeta.rowData[5] == 'Trading profit (NPBT buah luar & plasma)') {
            //     console.log(dataTable2[tableMeta.rowIndex])
            // }
            if (tableMeta.rowData[0] == 4) {
                let totalScore = 0
                dataTable2.map((item, index) => {
                    if (item[0] !== 4 && item[0] !== 1) {
                        totalScore += Number(item[15])
                    }
                })
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = this.props.defaultCurrency.id == 1 ? fixNumber(Number(totalScore), 2) : Number(totalScore)
                if (tableMeta.rowIndex == dataTable2.length - 1) {
                    someXXX = this.props.defaultCurrency.id == 1 ? fixNumber(Number(totalScore), 2) : Number(totalScore)
                    // console.log(someXXX)
                }
                return null
            } else {
                if (String(dataTable2[tableMeta.rowIndex][6]).includes('%')) {
                    // handlePercent = String(dataTable2[tableMeta.rowIndex][6])
                    handlePercent = String(dataTable2[tableMeta.rowIndex][6]).substr(0, String(dataTable2[tableMeta.rowIndex][6]).length - 1)
                } else {
                    handlePercent = String(dataTable2[tableMeta.rowIndex][6])
                }
                // console.log(handlePercent)
                if (dataTable2[tableMeta.rowIndex][12] == '' || String(dataTable2[tableMeta.rowIndex][12]) == '0' || String(dataTable2[tableMeta.rowIndex][12]) == '0.0') {
                    total = 0
                } else {
                    total = Number(dataTable2[tableMeta.rowIndex][14]) * Number(handlePercent) / 100
                    // console.log(total)
                }
                dataTable2[tableMeta.rowIndex][tableMeta.columnIndex] = this.props.defaultCurrency.id == 1 ? fixNumber(Number(total), 2) : Number(total)
                return total
            }

        }

        let columns = [
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },
            {
                name: "Key Performance Indicator",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell key={columnMeta.index} style={{ ...style, top: 0, zIndex: 102, backgroundColor: '#1c71b8', width: 300 }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'left' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style }),
                    customBodyRender: (val, tableMeta) => {
                        return (
                            handleAction(tableMeta.rowData[2], tableMeta.rowData[0], tableMeta) && (tableMeta.rowData[1] == "" || String(this.props.status).toLocaleLowerCase() == 'draft' || String(this.props.status).toLocaleLowerCase() == 'submitted' || String(this.props.status).toLocaleLowerCase() == 'revision') ?
                                <div style={{ textAlign: 'left', paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                    {!this.state.loading && <FormControlLabel
                                        style={{ margin: 0 }}
                                        control={
                                            <Input
                                                disableUnderline={true}
                                                style={{ color: tableMeta.rowData[1] == "" ? "#5198ea" : "black", fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, backgroundColor: 'transparent' }}
                                                type="text"
                                                placeholder=""
                                                defaultValue={val}
                                                // disabled={!handleAction(tableMeta.rowData[2])}
                                                onBlur={(event) => {
                                                    // // console.log(event.target.value)
                                                    handleChangeText(event.target.value, tableMeta)
                                                    // console.log(dataTable2)
                                                }}
                                            />
                                        }
                                    />}
                                </div>
                                :
                                <div style={{ width: 300 }}>
                                    {tableMeta.rowData[19] ?
                                        tableMeta.rowData[19].length > 0 ?
                                            <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                                <LightTooltip title={"Report Items Not Registered"} arrow>
                                                    <span style={{ fontSize: 12, color: 'red' }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                                </LightTooltip>
                                            </div>
                                            :
                                            tableMeta.rowData[4] == 0 ?
                                                <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                                :
                                                tableMeta.rowData[1] == null ?
                                                    <div style={{ paddingLeft: 20 }}>
                                                        <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                                    </div>
                                                    :
                                                    <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                                        <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                                    </div>
                                        :
                                        tableMeta.rowData[4] == 0 ?
                                            <span style={{ fontSize: 12, fontWeight: 'bold' }}>{String(tableMeta.rowData[0] === 4 ? "" : val).toUpperCase()}</span>
                                            :
                                            tableMeta.rowData[1] == null ?
                                                <div style={{ paddingLeft: 20 }}>
                                                    <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                                </div>
                                                :
                                                <div style={{ paddingLeft: 20 * Number(tableMeta.rowData[4]) }}>
                                                    <span style={{ fontSize: 12 }}>{tableMeta.rowData[0] === 4 ? "" : val}</span>
                                                </div>
                                    }
                                </div>
                        )
                    }
                }
            }, {
                name: "Weight",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 60, borderLeft: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    setCellProps: () => ({ style2 }),
                    customBodyRender: (value, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'center' }}>
                                {tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null :
                                    <FormControlLabel
                                        style={{ margin: 0 }}
                                        value={value}
                                        control={
                                            <NumberFormat
                                                thousandSeparator={true}
                                                style={{ color: "black", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                type="text"
                                                placeholder=""
                                                suffix={"%"}
                                                value={fixNumber(Number(value), 1)}
                                                disabled={true}
                                                // disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                decimalScale={1}
                                            />
                                        }
                                    />
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: "UOM",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', borderLeft: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    customBodyRender: (value, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'center' }}>
                                <div style={{ textAlign: 'center', width: 60 }}>
                                    {value}
                                </div>
                            </div>
                        )
                    }
                }
            }, {
                name: "KPI Type",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 96, borderLeft: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    customBodyRender: (val, tableMeta) => {
                        return (
                            <div style={{ textAlign: 'center', width: 60 }}>
                                {tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null :
                                    val
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: "Max Ach.",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 60, borderLeft: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    customBodyRender: (val, tableMeta) => {
                        return (
                            <div style={{ textAlign: 'center', width: 60 }}>
                                {tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null :
                                    val
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: "Formula YTD",
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 60, borderLeft: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    customBodyRender: (val, tableMeta, updateValue) => {
                        return (
                            <div style={{ textAlign: 'center', width: 60 }}>
                                {tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null :
                                    val
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: `Actual ${this.props.month.month_value} ${Number(this.props.periode)}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 75, borderLeft: '1px #fff solid' }}>
                            <Typography style={{ color: '#fff', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    customBodyRender: (value, tableMeta) => {
                        return (
                            <div style={{ width: 75, textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null
                                    :
                                    this.state.get_for == 'view' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ color: "black", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            value={fixNumber(Number(value), 1) == 0 ? "0.0" : fixNumber(Number(value), 1)}
                                            // disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                            disabled={true}
                                            decimalScale={1}
                                        />
                                        :
                                        <div style={{ flex: 1, textAlign: 'right' }}>
                                            <FormControlLabel
                                                style={{ margin: 0 }}
                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(value), 1) : Number(value)}
                                                control={
                                                    <NumberFormat
                                                        thousandSeparator={true}
                                                        style={{ color: this.state.get_for == 'view' ? "black" : handleAction(tableMeta.rowData[2], tableMeta.rowData[0], tableMeta) ? "#5198ea" : 'black', fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        value={this.props.defaultCurrency.id == 1 ? (tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 ? fixNumber(Number(handleValueFormula(value, tableMeta, tableMeta.columnIndex)), 1) : fixNumber(Number(value), 1)) : (tableMeta.rowData[0] === 5 || tableMeta.rowData[0] === 6 ? (Number(handleValueFormula(value, tableMeta, tableMeta.columnIndex)) == 0 ? "0.0" : Number(handleValueFormula(value, tableMeta, tableMeta.columnIndex))) : Number(value) == 0 ? "0.0" : Number(value))}
                                                        // disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                        disabled={this.state.get_for == 'view' ? true : !handleAction(tableMeta.rowData[2], tableMeta.rowData[0], tableMeta)}
                                                        decimalScale={1}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta)
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                }
                                            />
                                        </div>
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: `Target ${this.props.month.month_value} ${Number(this.props.periode)}`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 75, borderLeft: '1px #fff solid' }}>
                            <Typography style={{ color: '#fff', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    customBodyRender: (value, tableMeta) => {
                        return (
                            <div style={{ width: 75, textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null :
                                    <FormControlLabel
                                        style={{ margin: 0 }}
                                        value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(value), 1) : Number(value) == 0 ? "0.0" : Number(value)}
                                        control={
                                            <NumberFormat
                                                thousandSeparator={true}
                                                style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                type="text"
                                                placeholder=""
                                                value={this.props.defaultCurrency.id == 1 ? fixNumber(Number(value), 1) : Number(value) == 0 ? "0.0" : Number(value)}
                                                decimalScale={1}
                                                disabled={true}
                                            />
                                        }
                                    />
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: `Achivement ${this.props.month.month_value} ${Number(this.props.periode)} (%)`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 75, borderLeft: '1px #fff solid' }}>
                            <Typography style={{ color: '#fff', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    customBodyRender: (value, tableMeta) => {
                        return (
                            <div style={{ width: 75, textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null :
                                    this.state.get_for == 'view' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ color: "black", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            value={fixNumber(Number(value), 1)}
                                            // disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                            disabled={true}
                                            suffix={"%"}
                                            decimalScale={1}
                                        />
                                        :
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={fixNumber(Number(value), 1)}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    suffix={"%"}
                                                    value={fixNumber(handleAchiement(tableMeta), 1)}
                                                    decimalScale={1}
                                                    disabled={true}
                                                />
                                            }
                                        />
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: `Score (Scale 1-5)`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 70, borderLeft: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    customBodyRender: (value, tableMeta) => {
                        return (
                            <div style={{ width: 70, textAlign: 'right' }}>
                                {tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null :
                                    this.state.get_for == 'view' ?
                                        <NumberFormat
                                            thousandSeparator={true}
                                            style={{ color: "black", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                            type="text"
                                            placeholder=""
                                            value={fixNumber(Number(value), 0)}
                                            // disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                            disabled={true}
                                            decimalScale={0}
                                        />
                                        :
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            value={fixNumber(Number(value), 0)}
                                            control={
                                                <NumberFormat
                                                    thousandSeparator={true}
                                                    style={{ fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                    type="text"
                                                    placeholder=""
                                                    value={handleScore(tableMeta)}
                                                    decimalScale={0}
                                                    disabled={true}
                                                // onBlur={(event) => {
                                                //     // updateValue(event.target.value)
                                                //     handleChange(event.target.value, tableMeta)
                                                //     // // console.log(dataTable2)
                                                // }}
                                                />
                                            }
                                        />
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: `Score x Weight`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#1c71b8', width: 75, borderLeft: '1px #fff solid' }}>
                            <Typography style={{ color: 'white', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    customBodyRender: (value, tableMeta) => {
                        return (
                            <div style={{ width: 75 }}>
                                {tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 ?
                                    null :
                                    tableMeta.rowData[0] === 4 ?
                                        handleTotal(tableMeta)
                                        :
                                        this.state.get_for == 'view' ?
                                            <NumberFormat
                                                thousandSeparator={true}
                                                style={{ color: "black", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                type="text"
                                                placeholder=""
                                                value={fixNumber(Number(value), 2)}
                                                // disabled={this.props.isApprover ? true : ((this.props.lastStatus == 'SUBMIT' || this.props.lastStatus == 'REVISION') && this.props.prevRevision === false && (this.props.status === 'revision' || this.props.status === 'not-yet' || this.props.status === 'draft' || this.props.status === 'submitted') ? false : true)}
                                                disabled={true}
                                                decimalScale={2}
                                            />
                                            :
                                            <NumberFormat
                                                thousandSeparator={true}
                                                style={{ color: "black", fontSize: 12, textAlign: 'right', borderColor: 'transparent', margin: 0, width: 96, backgroundColor: 'transparent' }}
                                                type="text"
                                                placeholder=""
                                                value={fixNumber(handleTotal(tableMeta), 2)}
                                                decimalScale={2}
                                                disabled={true}
                                            />
                                }
                            </div>
                        )
                    }
                }
            }, {
                name: `Notes`,
                options: {
                    customHeadRender: (columnMeta) => (
                        <TableCell style={{ ...style2, top: 0, zIndex: 99, backgroundColor: '#37b5e6', width: 75, borderLeft: '1px #fff solid' }}>
                            <Typography style={{ color: '#fff', fontSize: 12, fontWeight: 'bold', textAlign: 'center' }}>{columnMeta.name}</Typography>
                        </TableCell>
                    ),
                    customBodyRender: (value, tableMeta) => {
                        return (
                            <div style={{ width: 150 }}>
                                {tableMeta.rowData[0] === 1 || tableMeta.rowData[0] === 2 || tableMeta.rowData[0] === 4 ?
                                    null
                                    :
                                    this.state.get_for == 'view' ?
                                        value
                                        :
                                        <FormControlLabel
                                            style={{ margin: 0 }}
                                            control={
                                                <ThemeProvider theme={theme}>
                                                    <Input
                                                        disableUnderline={true}
                                                        style={{ color: this.state.get_for == 'view' ? "black" : "#5198ea", fontSize: 12, textAlign: 'left', borderColor: 'transparent', margin: 0, width: 150, backgroundColor: 'transparent' }}
                                                        type="text"
                                                        placeholder=""
                                                        multiline={true}
                                                        defaultValue={value}
                                                        disabled={this.state.get_for == 'view'}
                                                        onBlur={(event) => {
                                                            // updateValue(event.target.value)
                                                            handleChange(event.target.value, tableMeta, 'text')
                                                            // // console.log(dataTable2)
                                                        }}
                                                    />
                                                </ThemeProvider>
                                            }
                                        />
                                }
                            </div>
                        )
                    }
                }
            },
            {
                name: "",
                options: {
                    display: false
                }
            },

        ]

        const loadingComponent = (
            <div style={{ position: 'absolute', zIndex: 110, top: 0, left: 0, width: '100%', height: '100%', display: 'flex', justifyContent: 'center', alignItems: 'center', background: 'rgba(255,255,255,0.8)' }}>
                <PropagateLoader
                    // css={override}
                    size={20}
                    color={"#274B80"}
                    loading={this.state.loading}
                />
            </div>
        );

        return (
            <div style={{ height: this.props.height, backgroundColor: '#f8f8f8', marginBottom: 100, minHeight: 1000 }}>
                {this.state.loading && loadingComponent}
                <div className={"main-color"} style={{ height: 78, flex: 1, display: 'flex', alignItems: 'center', paddingLeft: 20 }}>
                    <Typography style={{ fontSize: '16px', color: 'white' }}>Monthly Report</Typography>
                </div>
                <Snackbar open={this.state.alert} autoHideDuration={6000} onClose={() => this.closeAlert()}>
                    <Alert onClose={() => this.closeAlert()} severity={this.state.tipeAlert}>
                        {this.state.messageAlert}
                    </Alert>
                </Snackbar>
                <div style={{ flex: 1, padding: 20, width: '100%' }}>
                    {this.state.visibleCATMR ?
                        <Paper style={{ paddingTop: 10, paddingBottom: 20 }}>
                            <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                                <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Monthly Report - Corporate Annual Target - Performance</Typography>
                            </div>
                            <div style={{ padding: 20 }}>
                                <div style={{ display: 'flex', justifyContent: 'space-between' }}>
                                    <div>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {String(this.props.month.month_value).toLocaleUpperCase()} {this.props.periode} (rev.{this.props.revision})</Typography>
                                        {this.props.defaultCurrency.id === 1 ?
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                            :
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in USD thousand</Typography>
                                        }
                                    </div>
                                    <div style={{ width: '50%' }}>
                                        <div style={{ justifyContent: 'flex-end', display: 'flex', flexFlow: 'wrap' }}>
                                            {this.state.get_for == 'edit' && <a data-tip={'Download Template'} data-for="template">
                                                <button
                                                    style={{
                                                        backgroundColor: 'transparent',
                                                        cursor: 'pointer',
                                                        borderColor: 'transparent',
                                                        margin: 5
                                                    }}
                                                    onClick={() => this.downloadTemplate()}
                                                >
                                                    <img src={Images.template} />
                                                </button>
                                            </a>}
                                            <ReactTooltip border={true} id="template" place="bottom" type="light" effect="solid" />
                                            {this.state.get_for == 'edit' && <a data-tip={'Upload'} data-for="upload">
                                                <button
                                                    style={{
                                                        backgroundColor: 'transparent',
                                                        cursor: 'pointer',
                                                        borderColor: 'transparent',
                                                        margin: 5
                                                    }}
                                                    onClick={() => this.setState({ visibleUpload: true })}
                                                >
                                                    <img src={Images.upload} />
                                                </button>
                                            </a>}
                                            <ReactTooltip border={true} id="upload" place="bottom" type="light" effect="solid" />
                                            {/* <a data-tip={'Download'} data-for="download">
                                                <button
                                                    style={{
                                                        backgroundColor: 'transparent',
                                                        cursor: 'pointer',
                                                        borderColor: 'transparent',
                                                        margin: 5
                                                    }}
                                                    onClick={() =>
                                                        this.setState({ loading: true }, () => {
                                                            setTimeout(() => {
                                                                this.downloadAllData()
                                                            }, 100);
                                                        })}
                                                >
                                                    <img src={Images.download} />
                                                </button>
                                            </a>
                                            <ReactTooltip border={true} id="download" place="bottom" type="light" effect="solid" /> */}
                                        </div>
                                    </div>
                                </div>

                                <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                    {!this.state.loading && (
                                        <MuiThemeProvider theme={getMuiTheme()}>
                                            <MUIDataTable
                                                data={dataTable2}
                                                columns={columns}
                                                options={options}
                                            />
                                        </MuiThemeProvider>
                                    )}
                                    {this.state.get_for == 'view' && this.state.viewOnly && <div style={{ color: '#000', marginTop: 10, fontSize: 12 }}>(*) There may be discrepancies in amount due to rounding</div>}
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 15, paddingRight: 15, marginTop: 5 }}>
                                    <div>
                                        <div style={{ display: 'flex' }}>
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 20 }}>Last Updated by : </Typography>
                                            <div style={{ marginLeft: 10, overflowY: 'scroll', height: this.state.updateBy.length < 2 ? 25 : 75, marginTop: 10 }}>
                                                {
                                                    this.state.updateBy.length > 0 ? this.state.updateBy.reverse().map((item, index) => {
                                                        return (
                                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>{item.latest_update}</Typography>
                                                        )
                                                    }) :
                                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>-</Typography>

                                                }
                                            </div>
                                        </div>
                                    </div>
                                    <div style={{ display: 'flex', flexDirection: 'row' }}>
                                        <div style={{ padding: 5 }}>
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>TOTAL SCORE</Typography>
                                        </div>
                                        <div style={{ border: '1px solid black', padding: 5, minWidth: 200, display: 'flex', justifyContent: 'flex-end' }}>
                                            {!this.state.loading && (
                                                <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.state.totalScore}</Typography>
                                            )}
                                        </div>
                                    </div>
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 15, paddingRight: 15 }}>
                                    <div>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10 }}>Notes : {this.state.notes}</Typography>
                                    </div>
                                    <div style={{ display: 'flex', flexDirection: 'row' }}>
                                        <div style={{ padding: 5 }}>
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>PERFOMANCE</Typography>
                                        </div>
                                        <div style={{ borderStyle: 'solid', backgroundColor: this.state.perfomanceScoreColor, borderWidth: '0px 1px 1px 1px', padding: 5, minWidth: 200, display: 'flex', justifyContent: 'flex-end' }}>
                                            {!this.state.loading && (
                                                <Typography style={{ fontSize: '11px', color: 'black', fontWeight: 'bold' }}>{this.state.perfomanceScore}</Typography>
                                            )}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div className="grid grid-2x" style={{ marginTop: 20 }}>
                                <div className="col-1">
                                    <button
                                        type="button"
                                        onClick={() => this.setState({ loading: true }, () => {
                                            setTimeout(() => {
                                                this.props.onClickClose()
                                            }, 100);
                                        })}
                                        style={{
                                            backgroundColor: 'transparent',
                                            cursor: 'pointer',
                                            borderColor: 'transparent',
                                            outline: 'none'
                                        }}
                                    >
                                        <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', marginLeft: 5 }}>
                                            <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                        </div>
                                    </button>
                                </div>
                                {this.props.isApprover === true ?
                                    <div className="col-2"></div>
                                    :
                                    <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%' }}>
                                        {this.state.get_for == 'view' && this.state.viewOnly && <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() => {
                                                this.setState({ loading: true }, () => {
                                                    this.handleGetFor('edit')
                                                })
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Edit</Typography>
                                            </div>
                                        </button>}
                                        {this.state.get_for == 'edit' && <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() => {
                                                this.setState({ loading: true, dataTable: dataTable2, saveDraft: false, buttonError: false }, () => {
                                                    setTimeout(() => {
                                                        // this.handleValidate()
                                                        this.handleCalculate(dataTable2)
                                                    }, 100);
                                                })
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                            </div>
                                        </button>}
                                        {this.state.get_for === 'edit' && <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() =>
                                                this.state.saveDraft === true ?
                                                    this.setState({ alert: true, messageAlert: 'Data Incomplete', tipeAlert: 'error' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                            this.backToMonthlyReport('draft')
                                                        })
                                            }
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                            </div>
                                        </button>}
                                        {this.state.get_for === 'edit' && <button
                                            type="button"
                                            // disabled={this.state.buttonError}
                                            onClick={() =>
                                                this.state.buttonError ?
                                                    this.setState({ alert: true, messageAlert: 'Data Incomplete', tipeAlert: 'error' })
                                                    :
                                                    this.state.handleDoubleClick == 1 ? null :
                                                        this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                            this.backToMonthlyReport('submitted')
                                                        })}
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', marginRight: 10 }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                            </div>
                                        </button>}
                                    </div>
                                }
                            </div>
                        </Paper> :
                        <Paper style={{ paddingTop: 10 }}>
                            <div style={{ borderBottom: 'solid 1px #c4c4c4' }} >
                                <Typography style={{ fontSize: '12px', color: '#4b4b4b', margin: 10 }}>Monthly Report - Corporate Annual Target - Performance</Typography>
                            </div>
                            <div style={{ padding: 20 }}>
                                <div>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.props.company.company_name}</Typography>
                                    <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>Period : {String(this.props.month.month_value).toLocaleUpperCase()} {this.props.periode} (rev.{this.props.revision})</Typography>
                                    {this.props.defaultCurrency.id === 1 ?
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in IDR mn</Typography>
                                        :
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>in USD thousand</Typography>
                                    }
                                </div>
                                <div style={{ marginTop: 20, width: this.props.width - (this.props.open === true ? 400 : 150) }}>
                                    {!this.state.loading && (
                                        <MuiThemeProvider theme={getMuiTheme()}>
                                            <MUIDataTable
                                                data={dataTable2}
                                                columns={columns}
                                                options={options}
                                            />
                                        </MuiThemeProvider>
                                    )}
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 15, paddingRight: 15, marginTop: 5 }}>
                                    <div>
                                        <div style={{ display: 'flex' }}>
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 20 }}>Last Updated by : </Typography>
                                            <div style={{ marginLeft: 10, overflowY: 'scroll', height: this.state.updateBy.length < 2 ? 25 : 75, marginTop: 10 }}>
                                                {
                                                    this.state.updateBy.length > 0 ? this.state.updateBy.reverse().map((item, index) => {
                                                        return (
                                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>{item.latest_update}</Typography>
                                                        )
                                                    }) :
                                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10, marginRight: 5 }}>-</Typography>

                                                }
                                            </div>
                                        </div>
                                    </div>
                                    <div style={{ display: 'flex', flexDirection: 'row' }}>
                                        <div style={{ padding: 5 }}>
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>TOTAL SCORE</Typography>
                                        </div>
                                        <div style={{ border: '1px solid black', padding: 5, minWidth: 200, display: 'flex', justifyContent: 'flex-end' }}>
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>{this.state.totalScore}</Typography>
                                        </div>
                                    </div>
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'space-between', maxWidth: '100%', paddingLeft: 15, paddingRight: 15 }}>
                                    <div>
                                        <Typography style={{ fontSize: '11px', color: '#4b4b4b', marginTop: 10 }}>Notes : {this.state.notes}</Typography>
                                    </div>
                                    <div style={{ display: 'flex', flexDirection: 'row' }}>
                                        <div style={{ padding: 5 }}>
                                            <Typography style={{ fontSize: '11px', color: '#4b4b4b' }}>PERFOMANCE</Typography>
                                        </div>
                                        <div style={{ borderStyle: 'solid', backgroundColor: this.state.perfomanceScoreColor, borderWidth: '0px 1px 1px 1px', padding: 5, minWidth: 200, display: 'flex', justifyContent: 'flex-end' }}>
                                            <Typography style={{ fontSize: '11px', color: 'black', fontWeight: 'bold' }}>{this.state.perfomanceScore}</Typography>
                                        </div>
                                    </div>
                                </div>
                                <div className="grid grid-2x" style={{ marginTop: 10, padding: 20, paddingLeft: 0, paddingRight: 0 }}>
                                    <div className="col-1" style={{ paddingLeft: 0 }}>
                                        <button
                                            type="button"
                                            onClick={() => this.setState({ loading: true, visibleCATMR: true }, () => {
                                                setTimeout(() => {
                                                    this.getItemHierarki()
                                                }, 100);
                                            })}
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none'
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#019ce5', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Back</Typography>
                                            </div>
                                        </button>
                                    </div>
                                    <div className="col-2" style={{ display: 'flex', justifyContent: 'flex-end', maxWidth: '100%', paddingRight: 5 }}>
                                        <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() => {
                                                this.setState({ loading: true, dataTable: dataTable2, saveDraft: false, buttonError: false }, () => {
                                                    setTimeout(() => {
                                                        // this.handleValidate()
                                                        this.handleCalculate(dataTable2)
                                                    }, 100);
                                                })
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#fff', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #354960' }}>
                                                <Typography style={{ fontSize: '11px', color: '#354960', textAlign: 'center' }}>Calculate</Typography>
                                            </div>
                                        </button>
                                        <button
                                            className="button"
                                            type="button"
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                                marginRight: 20
                                            }}
                                            onClick={() =>
                                                this.state.saveDraft === true ?
                                                    this.setState({ alert: true, messageAlert: 'Data Incomplete', tipeAlert: 'error' })
                                                    :
                                                    this.state.handleDoubleClick === 1 ? null :
                                                        this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                            this.uploadCATMR('draft')
                                                        })
                                            }
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save as Draft</Typography>
                                            </div>
                                        </button>
                                        <button
                                            type="button"
                                            // disabled={this.state.buttonError}
                                            onClick={() =>
                                                this.state.buttonError ?
                                                    this.setState({ alert: true, messageAlert: 'Data Incomplete', tipeAlert: 'error' })
                                                    :
                                                    this.state.handleDoubleClick === 1 ? null :
                                                        this.setState({ handleDoubleClick: 1, loading: true }, () => {
                                                            this.uploadCATMR('submitted')
                                                        })}
                                            style={{
                                                backgroundColor: 'transparent',
                                                cursor: 'pointer',
                                                borderColor: 'transparent',
                                                outline: 'none',
                                            }}
                                        >
                                            <div style={{ backgroundColor: '#354960', width: 105, height: 25, borderRadius: 3, justifyContent: 'center', display: 'flex', alignItems: 'center' }}>
                                                <Typography style={{ fontSize: '11px', color: '#fff', textAlign: 'center' }}>Save & Complete</Typography>
                                            </div>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </Paper>
                    }
                </div>
                {this.state.visibleUpload && (
                    <div className="test app-popup-show">
                        <div className="popup-content background-white border-radius" style={{ borderRadius: 8 }}>
                            <div className="popup-panel grid grid-2x main-color" style={{ height: 64, borderTopRightRadius: 8, borderTopLeftRadius: 8 }}>
                                <div className="col-1" style={{ maxWidth: "inherit", display: 'flex', alignItems: 'center' }}>
                                    <div className="popup-title">
                                        <span style={{ color: '#fff', fontSize: 16, fontWeight: 'bold' }}>Upload File</span>
                                    </div>
                                </div>
                                <div className="col-2 content-right" style={{ maxWidth: "inherit", alignSelf: 'center' }}>
                                    <button
                                        type="button"
                                        className="btn btn-circle btn-white"
                                        onClick={() => this.setState({ visibleUpload: false })}
                                    >
                                        <img src={Images.close} />
                                    </button>
                                </div>
                            </div>
                            <div style={{ padding: '25px 30px' }}>
                                <UploadFile
                                    type={this.state.uploadStatus}
                                    percentage={this.state.percentage}
                                    result={this.state.result}
                                    acceptedFiles={["xlsx"]}
                                    onHandle={(dt) => {
                                        this.fileHandler(dt)
                                        this.setState({ uploadStatus: 'idle', percentage: '0' })
                                    }}
                                    onUpload={() => {
                                        String(this.state.judulColumn).includes("TEMPLATE") && String(this.state.judulColumn).includes("UPLOAD") && String(this.state.judul).includes("PERFORMANCE") && String(this.state.judul).includes("CAT") && String(this.state.judul).includes("MONTHLY") && String(this.state.judul).includes("REPORT") ?
                                            this.checkUpload() :
                                            this.setState({ alert: true, messageAlert: "Invalid Template", tipeAlert: 'warning' })
                                    }}
                                />
                            </div>
                            <div style={{ padding: '0px 30px 29px', fontSize: 17, color: 'red' }}><b>Warning:</b> Valid currency for uploading data in <b>{this.props.defaultCurrency.id == 1 ? "IDR mn" : "thousand USD"}</b></div>
                        </div>
                    </div>
                )}

                {this.state.visibleAlertSave && (
                    <div className="test app-popup-show">
                        <div className="popup-content border-radius" style={{ background: '#FFF27D', borderRadius: 10, width: 715, height: 238 }}>
                            <div style={{ margin: 30 }}>
                                <div style={{ display: 'flex', marginTop: 76, marginBottom: 43 }}>
                                    <div style={{ alignSelf: 'center', marginRight: 25 }}>
                                        <img src={Images.warning} />
                                    </div>
                                    <div style={{ justifyContent: 'center', fontSize: 20, color: '#1D2995', marginTop: 10 }}>
                                        <b>Rate Currency USD</b> pada periode yang dipilih <b>belum</b> diatur.<br /> Silahkan menghubungi Superadmin
                                    </div>
                                </div>
                                <div style={{ display: 'flex', justifyContent: 'flex-end' }}>
                                    <button
                                        className="button"
                                        type="button"
                                        style={{
                                            background: '#F6F7F9',
                                            cursor: 'pointer',
                                            border: '1px solid #3549609e',
                                            outline: 'none',
                                            marginRight: 20,
                                            borderRadius: 9
                                        }}
                                        onClick={() => this.setState({ visibleAlertSave: false, handleDoubleClick: 0, loading: false })}
                                    >
                                        <div style={{ backgroundColor: '#fff', width: 105, height: 30, borderRadius: 9, justifyContent: 'center', display: 'flex', alignItems: 'center', border: 'solid 1px #3549609e' }}>
                                            <Typography style={{ fontSize: '15px', color: '#354960', textAlign: 'center' }}>Close</Typography>
                                        </div>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                )}
            </div>
        )
    }
}