package com.eksad.masterdata.service;

import com.eksad.masterdata.domain.MstWo;
import com.eksad.masterdata.domain.TrxBizpar;
import com.eksad.masterdata.repository.BizparRepository;
import com.eksad.masterdata.repository.WoRepository;
import jakarta.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service
@Transactional
public class WOService {

    @Autowired
    WoRepository woRepository;

    @Autowired
    BizparRepository bizparRepository;

    public MstWo createNewWo() {

        TrxBizpar trxBizpar=bizparRepository.findByBizparName("wo_seq");
        Long latestId=trxBizpar.getBizparNumvalue();
        latestId++;
        MstWo mstWo=new MstWo();
        mstWo.setWoId(latestId);
        mstWo.setNopol("B 1234 WOP");
        mstWo.setCreateDt(new Date());
        woRepository.save(mstWo);

        //set new latest id
        trxBizpar.setBizparNumvalue(latestId);
        bizparRepository.save(trxBizpar);
        return mstWo;
    }

    public MstWo createNewWoLock() {

        TrxBizpar trxBizpar=bizparRepository.findByBizparNameWithLock("wo_seq");
        Long latestId=trxBizpar.getBizparNumvalue();
        latestId++;
        MstWo mstWo=new MstWo();
        mstWo.setWoId(latestId);
        mstWo.setNopol("B 1234 WOP");
        mstWo.setCreateDt(new Date());
        woRepository.save(mstWo);

        //set new latest id
        trxBizpar.setBizparNumvalue(latestId);
        bizparRepository.save(trxBizpar);
        return mstWo;
    }
}
