package com.eksad.masterdata.service;

import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Random;

@Service
public class ProcessHelperService {

    private String lastTransactionId="";
    private long preId = (new Random().nextInt(1000));

    public String createProcessId() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");
        String transactionId;
        LocalDateTime now = LocalDateTime.now();
        String formatDateTime = now.format(formatter);
        ++preId;
        if (preId >= 1000) {
            preId = 1;
        }
        //random between 1000 to 9000
        Random currentRandom = new Random();
        int currentRandomData=(currentRandom.nextInt(8001) + 1000);
        transactionId = String.format("%s%s.%s", formatDateTime,
                preId,currentRandomData);
        if (transactionId.equalsIgnoreCase(lastTransactionId)) {
            currentRandomData=(currentRandom.nextInt(8001) + 1000);
            transactionId = String.format("%s%s.%s", formatDateTime,
                    preId,currentRandomData);
        }
        lastTransactionId=transactionId;
        return transactionId;
    }
}
