package com.eksad.masterdata.service;

import com.eksad.masterdata.common.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;

@Service
public class KafkaProducerService {

    @Autowired
    private KafkaTemplate<String, String> kafkaTemplate;

    public void sendMessage(String message) {
        kafkaTemplate.send(Constants.topicStep1, message);
        System.out.println(String.format("done sending for new incoming task [%s bytes] %n%n",message.length()));
    }
}
