package com.eksad.masterdata.repository;

import com.eksad.masterdata.domain.TrxBizpar;
import jakarta.persistence.LockModeType;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;

public interface BizparRepository extends CrudRepository<TrxBizpar,String> {

    TrxBizpar findByBizparName(String bizparName);

    @Lock(LockModeType.PESSIMISTIC_WRITE)
    @Query("SELECT b FROM TrxBizpar b where b.bizparName = :bizparName")
    TrxBizpar findByBizparNameWithLock(@Param("bizparName") String bizparName);
}
