package com.eksad.masterdata.controller;

import com.eksad.masterdata.domain.MstWo;
import com.eksad.masterdata.service.KafkaProducerService;
import com.eksad.masterdata.service.ProcessHelperService;
import com.eksad.masterdata.service.WOService;
import io.vertx.core.json.JsonObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/masterdata")
public class SampleClaimH2Controller {

    @Autowired
    ProcessHelperService processHelperService;

    @Autowired
    WOService woService;

    @Autowired
    KafkaProducerService kafkaProducerService;

    @GetMapping("/test")
    public ResponseEntity<String> test(){
        System.out.println("test admin");
        return ResponseEntity.ok("this is admin");
    }

    @GetMapping("/create")
    public ResponseEntity<MstWo> create(){
        MstWo response=woService.createNewWo();
        return ResponseEntity.ok(response);
    }

    @GetMapping("/createLock")
    public ResponseEntity<MstWo> createLock(){
        MstWo response=woService.createNewWoLock();
        return ResponseEntity.ok(response);
    }

    @PostMapping("/mqSend")
    public ResponseEntity<String> mqSend(@RequestBody String request){
        //to simplyfy tracing request lets generate transactionId
        JsonObject jsonRequest=new JsonObject(request)
                .put("transactionId",processHelperService.createProcessId());
        kafkaProducerService.sendMessage(jsonRequest.encode());
        JsonObject jsonResponse=new JsonObject()
                .put("status","SUCCESS")
                .put("message","message send successfully");
        return ResponseEntity.ok(jsonResponse.encode());
    }
}
